/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.form.impl;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.CommonClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.form.ControlGroupView;
import de.justsoftware.onx.common.presentation.client.ui.form.DynamicAttributeInputView;
import de.justsoftware.onx.common.presentation.client.ui.form.impl.EditDynamicAttributePresenter;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EditDynamicAttributePresenter<T extends DynamicAttributePresenterConfig>
implements DynamicAttributeInputView.Presenter<String> {
    private final ArrayList<DynamicAttributeInputView<String>> _viewList = Lists.newArrayList();
    private final EntityConstants _entityConstants;
    private final ControlGroupView _controlGroupView;
    private final T _config;
    private final InputViewProvider _inputViewProvider;
    @CheckForNull
    private final DynamicAttributesChangedHandler _changeHandler;

    public EditDynamicAttributePresenter(T config, EntityConstants entityConstants, @Nullable DynamicAttributesChangedHandler changeHandler, InputViewProvider inputViewProvider, CommonClientFactory clientFactory) {
        this._config = config;
        this._changeHandler = changeHandler;
        this._inputViewProvider = inputViewProvider;
        this._entityConstants = entityConstants;
        this._controlGroupView = clientFactory.createControlGroupView();
        long numberOfInputs = Math.max(1L, this._config.getMultiplicity().getMin());
        int i = 0;
        while ((long)i < numberOfInputs) {
            this.addInputView();
            ++i;
        }
        this.setValues((List)config.getInitialValues());
    }

    private void addInputView() {
        Optional view = this._inputViewProvider.createView((DynamicAttributeInputView.Presenter)this);
        if (view.isPresent()) {
            this._viewList.add((DynamicAttributeInputView)view.get());
            this._controlGroupView.addControls(((DynamicAttributeInputView)view.get()).getAsControls());
        }
    }

    private void updateViews() {
        int numberOfViews = this._viewList.size();
        this._controlGroupView.setLabel(this._config.getLabel());
        this._controlGroupView.setMandatoryText(this._config.isMandatory() ? this._entityConstants.mandatory() : null);
        boolean showAdd = !this._config.getMultiplicity().hasMaximum() || (Long)Preconditions.checkNotNull((Object)this._config.getMultiplicity().getMax()) > (long)numberOfViews;
        for (int i = 0; i < numberOfViews; ++i) {
            DynamicAttributeInputView view = (DynamicAttributeInputView)this._viewList.get(i);
            view.setAddSignVisible(showAdd);
        }
    }

    public void setValues(List<String> values) {
        int max = values.size();
        for (int j = this._viewList.size(); j < max; ++j) {
            this.addInputView();
        }
        Iterator<String> valueIt = values.iterator();
        Iterator viewListIt = this._viewList.iterator();
        while (valueIt.hasNext() && viewListIt.hasNext()) {
            ((DynamicAttributeInputView)viewListIt.next()).setValue((Object)valueIt.next());
        }
        this.updateViews();
    }

    public void appendToWidget(HasWidgets parentWidget) {
        parentWidget.add((Widget)this._controlGroupView.getControlGroup());
    }

    @Nonnull
    public List<String> getValue() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DynamicAttributeInputView view : this._viewList) {
            String value = (String)view.getValue();
            if (!ClientStringUtil.hasText((String)value)) continue;
            builder.add((Object)value.trim());
        }
        return builder.build();
    }

    public void setErrorMessage(@Nullable String errorMessage) {
        for (DynamicAttributeInputView view : this._viewList) {
            if (ClientStringUtil.hasText((String)errorMessage)) {
                this._controlGroupView.setInError(true);
                view.setErrorMessage(errorMessage);
                continue;
            }
            this._controlGroupView.setInError(false);
            view.clearErrorMessage();
        }
    }

    public void setErrorMessage(String errorMessage, int inputIndex) {
        if (this._viewList.size() > inputIndex) {
            this._controlGroupView.setInError(true);
            ((DynamicAttributeInputView)this._viewList.get(inputIndex)).setErrorMessage(errorMessage);
        } else {
            LoggingUtil.error((Object)this, (String)("no input for index " + inputIndex));
        }
    }

    public void addRequest(DynamicAttributeInputView<String> view) {
        if (!this._config.getMultiplicity().hasMaximum() || (Long)Preconditions.checkNotNull((Object)this._config.getMultiplicity().getMax()) > (long)this._viewList.size()) {
            this.addInputView();
            this.updateViews();
        }
    }

    public void deleteRequest(DynamicAttributeInputView<String> view) {
        view.setValue(null);
        if ((long)this._viewList.size() > Math.max(1L, this._config.getMultiplicity().getMin())) {
            view.removeFromParent();
            this._viewList.remove(view);
            this.updateViews();
            this.valueChanged();
        }
    }

    public void valueChanged() {
        if (this._changeHandler != null) {
            this._changeHandler.valuesChanged();
        }
    }

    @Nonnull
    public T getConfig() {
        return (T)this._config;
    }
}

