/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.editor.impl;

import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.components.CheckboxListInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.InlineEditReadOnlyEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.InlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.InlinePersonSuggestView;
import de.justsoftware.onx.common.presentation.client.ui.components.MultipleOptionsInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.SingleValueInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.SingleValueInlineEditViewImpl;
import de.justsoftware.onx.common.presentation.client.ui.editor.ButtonBarView;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorPreloader;
import de.justsoftware.onx.common.presentation.client.ui.editor.InlineEditorView;
import de.justsoftware.onx.common.presentation.client.ui.editor.JustEditorPluginHandler;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockManager;
import de.justsoftware.onx.common.presentation.client.ui.editor.impl.ButtonBarViewImpl;
import de.justsoftware.onx.common.presentation.client.ui.editor.impl.EditorPreloaderImpl;
import de.justsoftware.onx.common.presentation.client.ui.editor.impl.EmptyInlineEditorPresenter;
import de.justsoftware.onx.common.presentation.client.ui.editor.impl.EmptyJustEditorPluginHandler;
import de.justsoftware.onx.common.presentation.client.ui.editor.impl.InlineEditorViewImpl;
import de.justsoftware.onx.common.presentation.client.ui.editor.impl.JustEditorPluginHandlerImpl;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EditorClientFactoryImpl
implements EditorClientFactory {
    private LockManager _lockManager;
    private final ClientFactory _clientFactory;
    private EditorPreloader _editorPreloader;

    public EditorClientFactoryImpl(ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
    }

    public InlineEditorView getInlineEditorView(InlineEditorView.Presenter presenter, GlobalId parentId, boolean editable, boolean notificationsOptionEnabled) {
        return new InlineEditorViewImpl(this._clientFactory.eventManager(), this.getEditorPluginHandler(parentId), presenter, editable, notificationsOptionEnabled);
    }

    public JustEditorPluginHandler getEditorPluginHandler(GlobalId parentId) {
        return new JustEditorPluginHandlerImpl(this._clientFactory, parentId);
    }

    public EditorPreloader getEditorPreloader() {
        if (this._editorPreloader == null) {
            this._editorPreloader = new EditorPreloaderImpl((InlineEditorView)new InlineEditorViewImpl(this._clientFactory.eventManager(), (JustEditorPluginHandler)EmptyJustEditorPluginHandler.INSTANCE, (InlineEditorView.Presenter)EmptyInlineEditorPresenter.INSTANCE, false, false));
        }
        return this._editorPreloader;
    }

    public LockManager lockManager() {
        if (this._lockManager == null) {
            this._lockManager = new LockManager(this._clientFactory.clientLogger());
        }
        return this._lockManager;
    }

    public ButtonBarView getButtonBarView(ButtonBarView.Presenter presenter) {
        return new ButtonBarViewImpl(presenter);
    }

    public SingleValueInlineEditView<String> getEntityTitleInlineEditView(InlineEditView.Presenter presenter) {
        return new SingleValueInlineEditViewImpl(presenter, true);
    }

    public SingleValueInlineEditView<String> getReadOnlyView() {
        return new InlineEditReadOnlyEditView();
    }

    public SingleValueInlineEditView<PersonSuggest> getTaskAssignmentView(InlineEditView.Presenter presenter, String unassignedLabel) {
        return new InlinePersonSuggestView(presenter, unassignedLabel);
    }

    public SingleValueInlineEditView<String> getMultiWikiSectionHeadingView(InlineEditView.Presenter presenter) {
        return new SingleValueInlineEditViewImpl(presenter, false);
    }

    public MultipleOptionsInlineEditView getMultiWikiSectionVisibilitiesView(InlineEditView.Presenter presenter) {
        return new CheckboxListInlineEditView(presenter, false);
    }

    public MultipleOptionsInlineEditView getMultiOptionsReadOnlyView() {
        return new InlineEditReadOnlyEditView();
    }
}

