/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasBlurHandlers;
import com.google.gwt.event.dom.client.HasFocusHandlers;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TextBoxWithIcons
extends Composite
implements Focusable,
HasFocusHandlers,
HasBlurHandlers {
    private final FlowPanel _panel = new FlowPanel();
    private final TextBox _textBox;
    private final Icon _rightIcon;
    private final Icon _leftIcon;

    public TextBoxWithIcons() {
        this._panel.addStyleName("text-box-with-icon");
        this._textBox = new TextBox();
        this._leftIcon = new Icon();
        this._leftIcon.addStyleName("left-icon");
        this._leftIcon.sinkEvents(1);
        this._panel.add((Widget)this._leftIcon);
        this._panel.add((Widget)this._textBox);
        this._rightIcon = new Icon();
        this._rightIcon.addStyleName("right-icon");
        this._rightIcon.sinkEvents(1);
        this._panel.add((Widget)this._rightIcon);
        this.initWidget((Widget)this._panel);
    }

    public TextBoxWithIcons(@Nullable IconType left, @Nullable IconType right) {
        this();
        if (left != null) {
            this.setLeftIconType(left);
        }
        if (right != null) {
            this.setRightIconType(right);
        }
    }

    @Nonnull
    public String getText() {
        return this._textBox.getText();
    }

    @Nonnull
    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this._textBox.addKeyUpHandler(handler);
    }

    @Nonnull
    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this._textBox.addKeyDownHandler(handler);
    }

    public void setText(String text) {
        this._textBox.setText(text);
    }

    public void setPlaceholder(String placeholder) {
        this._textBox.setPlaceholder(placeholder);
    }

    public void setLeftIconType(IconType type) {
        this._leftIcon.setIcon(type);
        this.setLeftIconVisible(true);
    }

    public void setRightIconType(IconType type) {
        this._rightIcon.setIcon(type);
        this.setRightIconVisible(true);
    }

    public void setLeftIconSize(IconSize size) {
        this._leftIcon.setIconSize(size);
    }

    public void setRightIconSize(IconSize size) {
        this._rightIcon.setIconSize(size);
    }

    public void setLeftIconVisible(boolean visible) {
        this._panel.setStyleName("left-visible", visible);
    }

    public void setRightIconVisible(boolean visible) {
        this._panel.setStyleName("right-visible", visible);
    }

    @Nonnull
    public HandlerRegistration addLeftIconClickHandler(ClickHandler clickHandler) {
        return this._leftIcon.addHandler((EventHandler)clickHandler, (GwtEvent.Type)ClickEvent.getType());
    }

    @Nonnull
    public HandlerRegistration addRightIconClickHandler(ClickHandler clickHandler) {
        return this._rightIcon.addHandler((EventHandler)clickHandler, (GwtEvent.Type)ClickEvent.getType());
    }

    public int getTabIndex() {
        return this._textBox.getTabIndex();
    }

    public void setAccessKey(char key) {
        this._textBox.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this._textBox.setFocus(focused);
    }

    public void setTabIndex(int index) {
        this._textBox.setTabIndex(index);
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this._textBox.addFocusHandler(handler);
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this._textBox.addBlurHandler(handler);
    }
}

