/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.server.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Charsets;
import de.justsoftware.onx.calendar.business.CalendarFeedService;
import de.justsoftware.toolbox.http.ContentDispositionUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ParametersAreNonnullByDefault
public class CalendarFeedController {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarFeedController.class);
    private final CalendarFeedService _calendarFeedService;

    @Autowired
    public CalendarFeedController(CalendarFeedService calendarFeedService) {
        this._calendarFeedService = calendarFeedService;
    }

    @RequestMapping(value={"/ical"}, method={RequestMethod.GET})
    @ResponseBody
    public void getICS(HttpServletResponse response, @RequestParam(value="cal") String token) {
        try {
            String ics = this._calendarFeedService.getICS(token);
            response.setContentType("application/octet-stream");
            ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)(token + ".ics"));
            IOUtils.write((String)ics, (OutputStream)response.getOutputStream(), (Charset)Charsets.UTF_8);
        }
        catch (PermissionDeniedException e) {
            this.sendError(response, 403);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.sendError(response, 500);
        }
    }

    private void sendError(HttpServletResponse response, int code) {
        try {
            response.sendError(code);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

