/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.presentation.server;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.server.model.LoginPage;
import de.justsoftware.onx.tenantinvitation.business.impl.TenantInvitationService;
import de.justsoftware.onx.tenantinvitation.model.TenantInvitation;
import java.io.IOException;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@ParametersAreNonnullByDefault
public class RegistrationController {
    private final TenantInvitationService _tenantInvitationService;

    @Autowired
    public RegistrationController(TenantInvitationService tenantInvitationService) {
        this._tenantInvitationService = tenantInvitationService;
    }

    @RequestMapping(value={"/registerTenant/{tenantInviteCode}"}, produces={"text/html"})
    public void registerForTenant(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="tenantInviteCode") String tenantInviteCode) throws IOException {
        TenantInvitation tenantInvitation = this._tenantInvitationService.checkTenantInvitationCode(tenantInviteCode);
        ImmutableMap additionalAttributes = ImmutableMap.of((Object)"invitationHash", (Object)StringUtils.trimToEmpty((String)tenantInviteCode), (Object)"tenantId", (Object)tenantInvitation.getTenantId().asString());
        response.sendRedirect(LoginPage.REGISTRATION.getUrl((Map)additionalAttributes));
    }

    @ExceptionHandler(value={PermissionDeniedException.class})
    void onPermissionDenied(PermissionDeniedException permissionDeniedException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(LoginPage.REGISTRATION_INVALID_HASH.getUrl());
    }
}

