/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.security.model.JustConnectUserAuthenticationToken;
import de.justsoftware.onx.security.service.JustAuthenticationProvider;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service(value="jwtTokenAuthenticationProvider")
public class JwtTokenAuthenticationProvider
implements JustAuthenticationProvider {
    @Autowired
    private PersonReadWriteDataService _personReadWriteDataService;
    @Autowired
    private UserDetailsChecker _userDetailsChecker;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof JwtAuthenticationToken)) {
            return null;
        }
        JwtAuthenticationToken authenticationToken = (JwtAuthenticationToken)authentication;
        ProfileId id = ProfileId.parse((String)authenticationToken.getPrincipal());
        if (id == null) {
            throw new InvalidTokenException("Got JWT token without profileId");
        }
        DBPerson person = this._personReadWriteDataService.getPersonById(id.asPersonId());
        if (person == null) {
            throw new InvalidTokenException("Got token for profile " + id + ", but could not load corresponding person from db");
        }
        JustConnectUser justConnectUser = SecurityUtils.getJustConnectUser((DBPerson)person);
        this._userDetailsChecker.check((UserDetails)justConnectUser);
        return new JustConnectUserAuthenticationToken(justConnectUser, authenticationToken.getExpirationTime(), authenticationToken.getCustomJwtClaims());
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

