/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;

@ParametersAreNonnullByDefault
public class AuthenticationUtils {
    public static void handleAuthenticationFailure(HttpServletResponse response) {
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
    }

    @CheckForNull
    public static AuthenticationException getAuthenticationException(HttpServletRequest request) {
        AuthenticationException authError = (AuthenticationException)request.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (authError != null) {
            return authError;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (AuthenticationException)session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
    }
}

