/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server;

import com.freiheit.toro.server.CachingUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class CacheFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("POST".equalsIgnoreCase(httpRequest.getMethod())) {
            CachingUtil.setNoCache((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        } else {
            String requestURI = httpRequest.getRequestURI();
            if (requestURI.contains("nocache")) {
                CachingUtil.setNoCache((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            } else if (requestURI.contains(".cache.")) {
                CachingUtil.setCache((HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (long)CachingUtil.CACHING_DURATION_ONE_YEAR);
            }
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

