/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.client.mediator;

import com.freiheit.toro.client.event.EventListener;
import com.freiheit.toro.client.event.GlobalEventManager;
import com.freiheit.toro.client.event.HistoryChangedEvent;
import com.freiheit.toro.client.event.HistoryWidgetCreatedEvent;
import com.freiheit.toro.client.mediator.ContentWithAnchorsAddedEvent;
import com.freiheit.toro.client.mediator.HistoryHandlerForToken;
import com.freiheit.toro.client.mediator.HistoryInterceptor;
import com.freiheit.toro.client.mediator.HistoryItemHandler;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.client.mediator.HistoryTokenAndHandler;
import com.freiheit.toro.client.mediator.HistoryTokenState;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.client.ui.FourOhFourWidget;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.web.bindery.event.shared.HandlerRegistration;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.TokenUtilClient;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.ui.FoldUtil;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentOverlay;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.presentation.client.ui.JustEntityAppWidget;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.container.presentation.client.ui.WidgetPartOfEntityHistoryItemHandler;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class HistoryManager
implements ValueChangeHandler<String> {
    private static final int INVISIBLE_ANCHOR_LINEHEIGHT = 30;
    private final ClientFactory _clientFactory;
    private String _currentTitle;
    private CoreApp _currentApp;
    private String _previousTitle;
    private String _currentOriginalToken;
    private String _previousOriginalToken;
    private ContentOverlay _overlay = null;
    private final SimplePanel _panel = new SimplePanel();
    private PageTitleCallback _currentPageTitleCallback = null;
    private final HistoryHandlerForToken _historyHandlerForToken;
    private HistoryInterceptor _historyInterceptor = null;
    private HistoryTokenState _currentState = null;
    private final ContentWithAnchorsAddedEventListener _contentWithAnchorsAddedEventListener = new ContentWithAnchorsAddedEventListener(this);
    private final ArrayList<ConfirmHistoryChangeCallback> _confirmHistoryChangeCallbacks = Lists.newArrayList();

    public HistoryManager(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._historyHandlerForToken = new HistoryHandlerForToken(clientFactory);
        this._panel.addStyleName("history-manager-panel");
        clientFactory.eventManager().registerListener(ContentWithAnchorsAddedEvent.class, (EventListener)this._contentWithAnchorsAddedEventListener);
        Window.addWindowClosingHandler((Window.ClosingHandler)new HistoryManagerWindowClosingHandler(this));
    }

    public SimplePanel getPanel() {
        return this._panel;
    }

    public void setWidget(IsWidget widget, @Nullable HistoryTokenState state) {
        this.getPanel().setWidget(widget);
        this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryWidgetCreatedEvent.INSTANCE);
        this.scrollToTokenStateHash(state);
    }

    @Nonnull
    protected String createHistoryItemInternal(@Nonnull HistoryToken tokenId, @CheckForNull Object[] params, @CheckForNull Object[] defaultParams) {
        return this.createHistoryItemInternal(tokenId, this.historyItemHandlerForToken(tokenId).getParamTypes(), params, defaultParams);
    }

    private void checkParamsType(@Nonnull HistoryToken tokenId, @Nonnull String tokenTypes, @CheckForNull Object[] params) throws IllegalArgumentException {
        if (params == null) {
            return;
        }
        if (params.length > tokenTypes.length()) {
            throw new IllegalArgumentException("Expected no more than " + tokenTypes.length() + " parameters, but got " + params.length + " while creating HistoryItem for ID " + tokenId);
        }
        block5: for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null) continue;
            switch (tokenTypes.charAt(i)) {
                case 'L': {
                    if (param instanceof Long || param instanceof LongId) continue block5;
                    throw new IllegalArgumentException("Parameter at index " + i + " has to be a long");
                }
                case 'B': {
                    if (param instanceof Boolean) continue block5;
                    throw new IllegalArgumentException("Parameter at index " + i + " has to be a Boolean");
                }
                case 'S': {
                    if (param instanceof String) continue block5;
                    throw new IllegalArgumentException("Parameter at index " + i + " has to be a String");
                }
                default: {
                    throw new IllegalArgumentException("Unknown type identifier: " + tokenTypes.charAt(i));
                }
            }
        }
    }

    @Nonnull
    protected String createHistoryItemInternal(@Nonnull HistoryToken tokenId, @Nonnull String tokenTypes, @Nullable Object[] params, @Nullable Object[] defaultParams) {
        this.checkParamsType(tokenId, tokenTypes, params);
        return TokenUtilClient.createTokenWithDefaultParams((HistoryToken)tokenId, (String)tokenTypes, (Object[])params, (Object[])defaultParams);
    }

    public void forceNewItem(String historyItem) {
        if (historyItem.equals(History.getToken())) {
            History.onHistoryChanged((String)historyItem);
        } else {
            this.newItem(historyItem);
        }
    }

    public void newItem(String historyItem) {
        History.newItem((String)historyItem);
    }

    @Nonnull
    public String createHistoryItem(@Nonnull HistoryToken token, Object ... params) {
        return this.createHistoryItemInternal(token, params);
    }

    @Nonnull
    private String createHistoryItemInternal(@Nonnull HistoryToken token, @Nonnull Object[] params) {
        return this.createHistoryItemInternal(token, params, null);
    }

    public Hyperlink createLink(@Nonnull String text, boolean asHtml, @Nonnull HistoryToken token, Object ... params) {
        return this.createLinkInternal(text, asHtml, token, params);
    }

    private Hyperlink createLinkInternal(@Nonnull String text, boolean asHtml, @Nonnull HistoryToken token, @Nonnull Object[] params) {
        return new Hyperlink(text, asHtml, this.createHistoryItemInternal(token, params));
    }

    public Hyperlink createLink(@Nonnull String text, @Nonnull HistoryToken token, Object ... params) {
        return this.createLinkInternal(text, token, params);
    }

    public Hyperlink createLinkInternal(@Nonnull String text, @Nonnull HistoryToken token, @Nonnull Object[] params) {
        return this.createLinkInternal(text, false, token, params);
    }

    @Deprecated
    public ClickHandler createNewItemHandler(@Nonnull String historyItem) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Deprecated
    public ClickHandler createNewItemHandler(@Nonnull HistoryToken token, Object ... param) {
        return this.createNewItemHandler(this.createHistoryItemInternal(token, param));
    }

    private void setCurrentTitle(@Nonnull String title) {
        this._previousTitle = this._currentTitle;
        this._currentTitle = title;
        this._clientFactory.pageTitleService().setPageTitle(this._currentTitle);
    }

    public void ignoreNextHistoryChange() {
        HistoryInterceptor last = this._historyInterceptor;
        this._historyInterceptor = new /* Unavailable Anonymous Inner Class!! */;
    }

    @CheckForNull
    private String createHistoryChangeQuestion() {
        for (ConfirmHistoryChangeCallback callback : this._confirmHistoryChangeCallbacks) {
            if (!callback.confirmNeeded()) continue;
            return this._clientFactory.localizedMessages().basicConstants().confirmProceedWithUnsavedChanges();
        }
        return null;
    }

    public HandlerRegistration confirmNextHistoryChange(ConfirmHistoryChangeCallback callback) {
        this._confirmHistoryChangeCallbacks.add(callback);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void cleanupConfirmHistoryChangeListener() {
        this._confirmHistoryChangeCallbacks.clear();
    }

    private ConfirmPopup createConfirmLeavePagePopup(String historyToken, String question) {
        BasicConstants basicConstants = this._clientFactory.localizedMessages().basicConstants();
        4 onLeave = new /* Unavailable Anonymous Inner Class!! */;
        5 onStay = new /* Unavailable Anonymous Inner Class!! */;
        return ConfirmPopup.makeConfirmPopup((String)question, (ClickHandler)onLeave, (ClickHandler)onStay, (String)basicConstants.leavePage(), (String)basicConstants.stayOnPage());
    }

    @Nonnull
    private String rewriteProfileUrl(@Nonnull String historyToken) {
        if (historyToken.equals("/profile")) {
            PersonId loggedInPersonId = this._clientFactory.getLoginInfo().getLoggedInPersonId();
            if (loggedInPersonId == null) {
                LoggingUtil.error((Object)this, (String)"Tried to resolve the profile link for a user that is not logged in.This should never happen because we should be redirected to '/toro/login' before getting here.");
                return historyToken;
            }
            return ReactProfileComponent.token((PersonId)loggedInPersonId);
        }
        if (RegExp.compile((String)"^/!?profile\\.", (String)"im").test(historyToken)) {
            return ReactProfileComponent.convertToNewProfileToken((String)historyToken.replaceFirst("^/!?profile\\.", ""));
        }
        return historyToken;
    }

    public void onHistoryChanged(String historyToken) {
        boolean tokenHasNotChanged;
        this._previousOriginalToken = this._currentOriginalToken;
        this._currentOriginalToken = this.rewriteProfileUrl(historyToken);
        String fixedToken = HistoryManager.fixEscapedExclamationMarks((String)this._currentOriginalToken);
        History.replaceItem((String)fixedToken, (boolean)false);
        String tokenWithoutQueryParameters = HistoryManager.removeQueryParameters((String)fixedToken);
        boolean tokenHasQueryParameters = this._currentOriginalToken.indexOf(63) != -1;
        boolean previousTokenHasQueryParameters = this._previousOriginalToken != null && this._previousOriginalToken.indexOf(63) != -1;
        boolean bl = tokenHasNotChanged = this._currentState != null && tokenWithoutQueryParameters.equals(this._currentState.getHistoryItem());
        if ((tokenHasQueryParameters || previousTokenHasQueryParameters) && tokenHasNotChanged) {
            return;
        }
        try {
            this.handleNewHistoryToken(tokenWithoutQueryParameters);
        }
        catch (RuntimeException e) {
            LoggingUtil.error((Object)this, (String)"Fehler im HistoryItemHandler, zeige 404", (Throwable)e);
            try {
                this.setWidget((IsWidget)new FourOhFourWidget(this._clientFactory, (Throwable)e), null);
            }
            catch (RuntimeException e2) {
                LoggingUtil.error((Object)this, (String)"OHA! Auch das 404 wirft eine Exception. Wir machen gar nichts und verschlucken die Exception", (Throwable)e2);
            }
            this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryChangedEvent.INSTANCE);
        }
    }

    @VisibleForTesting
    static String removeQueryParameters(String historyToken) {
        int indexOfQuestionMark = historyToken.indexOf(63);
        boolean hasQueryParameters = indexOfQuestionMark != -1;
        String tokenWithoutQueryParameters = hasQueryParameters ? historyToken.substring(0, indexOfQuestionMark) : historyToken;
        return tokenWithoutQueryParameters;
    }

    @VisibleForTesting
    static String fixEscapedExclamationMarks(String historyToken) {
        boolean tokenStartsWithAnEscapedExclamationMark = historyToken.startsWith("%21");
        boolean tokenStartsWithAnEscapedExclamationMarkAndASlash = historyToken.startsWith("/%21");
        if (tokenStartsWithAnEscapedExclamationMark) {
            return "!" + historyToken.substring(3);
        }
        if (tokenStartsWithAnEscapedExclamationMarkAndASlash) {
            return "/!" + historyToken.substring(4);
        }
        return historyToken;
    }

    @Nonnull
    private static String removeLeadingSlash(@Nonnull String historyToken) {
        if (historyToken.startsWith("/")) {
            return historyToken.substring(1);
        }
        return historyToken;
    }

    private void handleNewHistoryToken(String historyToken) {
        boolean isLocalAnchor;
        boolean bl = isLocalAnchor = historyToken.startsWith(".") || historyToken.startsWith("/.");
        if (!isLocalAnchor) {
            this.onHistoryChangedCall(historyToken);
        } else if (this._currentState != null) {
            String historyItem = this._currentState.getHistoryItem();
            String token = HistoryManager.appendOrReplaceHash((String)historyItem, (String)HistoryManager.removeLeadingSlash((String)historyToken));
            History.replaceItem((String)token, (boolean)false);
            this.onHistoryChangedCall(token);
        } else {
            this.scrollToAnchor(HistoryManager.removeLeadingSlash((String)historyToken));
            this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryChangedEvent.INSTANCE);
        }
    }

    private boolean scrollToAnchor(String name) {
        NodeList nodeList = Document.get().getElementsByTagName("a");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            AnchorElement anchor = AnchorElement.as((Element)((Element)nodeList.getItem(i)));
            if (!name.equals(anchor.getName())) continue;
            FoldUtil.openParents((Element)anchor);
            JustEntityAppWidget.scrollElementIntoViewTopAligned((Element)anchor);
            int extraOffset = anchor.getClientHeight() == 0 ? 30 : 0;
            GlobalEventManager.getInstance().fireAdjustEntityScrollPosition(extraOffset);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static String appendOrReplaceHash(String historyItem, String hash) {
        int hashIndex = historyItem.indexOf(35);
        String token = hashIndex > -1 ? historyItem.substring(0, hashIndex) : historyItem;
        return token + "#" + hash;
    }

    private void onHistoryChangedCall(String historyToken) {
        String question = this.createHistoryChangeQuestion();
        if (!StringUtil.isBlank((String)question)) {
            this.createConfirmLeavePagePopup(historyToken, question).show();
            return;
        }
        this.cleanupConfirmHistoryChangeListener();
        this.newHistoryTokenState(historyToken, this._currentState, newHistoryTokenState -> {
            boolean renderPage;
            this._currentState = newHistoryTokenState;
            boolean bl = renderPage = this._historyInterceptor == null || this._historyInterceptor.onHistoryChanged(historyToken);
            if (renderPage) {
                if (newHistoryTokenState == null) {
                    this.show404Page();
                } else {
                    this.onHistoryChangedImpl(newHistoryTokenState);
                }
            }
            this._clientFactory.eventManager().handleEvent((ClientEvent)HistoryChangedEvent.INSTANCE);
        });
    }

    @CheckForNull
    public HistoryTokenState getCurrentHistoryTokenState() {
        return this._currentState;
    }

    public void newHistoryTokenState(@Nonnull String historyItem, @Nullable HistoryTokenState previousState, Consumer<HistoryTokenState> callback) {
        try {
            HistoryTokenAndHandler tokenAndHandler = this.getTokenAndHandlerForHistoryItem(historyItem);
            if (tokenAndHandler == null) {
                callback.accept(null);
                return;
            }
            HistoryItemHandler handler = tokenAndHandler.getHandler();
            TokenUtil.TokenIdAndParams tokenIdAndParams = tokenAndHandler.getToken();
            callback.accept(new HistoryTokenState(historyItem, tokenIdAndParams, handler, CoreApp.SOCIAL, previousState));
        }
        catch (RuntimeException e) {
            callback.accept(null);
        }
    }

    @CheckForNull
    public HistoryTokenAndHandler getTokenAndHandlerForHistoryItem(@Nonnull String historyItem) {
        try {
            HistoryTokenParser parsed = TokenUtilClient.INSTANCE.parse(historyItem);
            HistoryToken tokenId = parsed.getToken();
            if (tokenId == null) {
                return null;
            }
            HistoryItemHandler handler = this.historyItemHandlerForToken(tokenId);
            TokenUtil.TokenIdAndParams tokenIdAndParams = parsed.resolveTypedParams(handler.getParamTypes(), handler.getDefaultParams());
            return new HistoryTokenAndHandler(tokenIdAndParams, handler);
        }
        catch (TokenUtil.TokenParseException | RuntimeException e) {
            return null;
        }
    }

    private void onHistoryChangedImpl(HistoryTokenState state) {
        if (HistoryManager.onlyHashChanged((HistoryTokenState)state)) {
            state.getHandler().needsReloadWhenHashChanged(state, (HistoryItemHandler.NeedsReloadWhenHashChangedCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.fullyLoad(state);
        }
    }

    void fullyLoad(HistoryTokenState state) {
        this.handleIfEntityChange(state, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    private native void trackUrlChange();

    private void scrollToTokenStateHash(@Nullable HistoryTokenState state) {
        if (state == null) {
            return;
        }
        String hash = state.getTokenIdAndParams().getHash();
        if (ClientStringUtil.hasText((String)hash)) {
            this._contentWithAnchorsAddedEventListener.newHash(hash);
        }
    }

    private static boolean onlyHashChanged(HistoryTokenState state) {
        TokenUtil.TokenIdAndParams previous = state.getPreviousTokenIdAndParams();
        TokenUtil.TokenIdAndParams current = state.getTokenIdAndParams();
        return HistoryManager.onlyHashChanged((TokenUtil.TokenIdAndParams)current, (TokenUtil.TokenIdAndParams)previous);
    }

    @VisibleForTesting
    static boolean onlyHashChanged(TokenUtil.TokenIdAndParams current, TokenUtil.TokenIdAndParams previous) {
        if (previous == null) {
            return false;
        }
        return Objects.equals(previous.getTokenId(), current.getTokenId()) && Objects.equals(previous.getParams(), current.getParams()) && !Objects.equals(previous.getHash(), current.getHash());
    }

    private void show404Page() {
        this.setWidget((IsWidget)new FourOhFourWidget(this._clientFactory), null);
        String pageTitle = I18nMediator.BASIC_CONSTANTS.pageTitle404();
        this.setCurrentTitle(pageTitle);
        this.trackUrlChange();
    }

    private void handleIfEntityChange(HistoryTokenState state, AsyncCallback<Void> callback) {
        HistoryItemHandler handler = state.getHandler();
        if (handler instanceof WidgetPartOfEntityHistoryItemHandler) {
            ((WidgetPartOfEntityHistoryItemHandler)handler).onEntityChanged(state.getTokenIdAndParams().getParams(), callback);
        } else {
            callback.onSuccess(null);
        }
    }

    @CheckForNull
    public IsWidget getCurrentWidget() {
        return this.getPanel().getWidget();
    }

    public CoreApp getCurrentApp() {
        return this._currentApp;
    }

    public void refreshCurrentToken() {
        History.fireCurrentHistoryState();
    }

    @Nonnull
    private HistoryItemHandler historyItemHandlerForToken(HistoryToken token) {
        return (HistoryItemHandler)this._historyHandlerForToken.get((Object)token);
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.onHistoryChanged((String)event.getValue());
    }

    @Nonnull
    private native void replaceMostRecentHashForDeprecatedLink(String var1, String var2);

    public void restoreMostRecentHashForDeprecatedLink() {
        this.replaceMostRecentHashForDeprecatedLink(CoreApp.SOCIAL.getAppId().getId(), this._previousOriginalToken);
    }
}

