/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.account.presentation.ui;

import com.freiheit.toro.account.presentation.client.LoginController;
import com.freiheit.toro.account.presentation.client.LoginControllerAsync;
import com.freiheit.toro.account.presentation.ui.LoginEvent;
import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.account.presentation.ui.LogoutEvent;
import com.freiheit.toro.account.shared.model.LoginInfoBean;
import com.freiheit.toro.client.Toro;
import com.freiheit.toro.client.model.DeactivatableDialogBoxType;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.authorization.presentation.client.LoginManager;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.settings.PersonSettings;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoginManagerImpl
implements LoginManager {
    private static final LoginManagerImpl INSTANCE = new LoginManagerImpl();
    public static final String COOKIE_PATH = "/toro";
    private final LoginControllerAsync _loginServiceProxy = this.createProxy();
    private final LinkedList<LoggedInCallback> _loggedInCallbacks = new LinkedList();
    private final Map<DeactivatableDialogBoxType, Boolean> _dialogBoxDeactivatingMap = Maps.newHashMap();
    private PersonTeaserModel _user;
    private Set<Action> _may = Sets.newHashSet();
    private PersonSettings _userSettings;

    private LoginManagerImpl() {
    }

    private LoginControllerAsync createProxy() {
        LoginControllerAsync loginServiceProxy = (LoginControllerAsync)GWT.create(LoginController.class);
        UrlUtil.setRemoteServiceUrl((Object)loginServiceProxy, (String)"/login");
        return loginServiceProxy;
    }

    public static LoginManagerImpl getInstance() {
        return INSTANCE;
    }

    public boolean may(Action action) {
        return this._may.contains(action);
    }

    public void flushSession() {
        this._user = null;
        this._userSettings = null;
        this._may = new HashSet();
        this._dialogBoxDeactivatingMap.clear();
        Toro.addMenuWidgetToRootPanel();
    }

    public static void redirectToHome() {
        Window.Location.assign((String)Window.Location.createUrlBuilder().setHash(null).buildString());
    }

    public void logout(@Nonnull EventManager eventManager) {
        LoginManagerImpl.fireLogoutEvent((EventManager)eventManager);
        this._loginServiceProxy.logout((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void fireLogoutEvent(@Nonnull EventManager eventManager) {
        eventManager.handleEvent((ClientEvent)LogoutEvent.INSTANCE);
    }

    public void isLoggedIn(LoginManager.LoginCallback cb) {
        if (this._user != null) {
            cb.isLoggedIn((PersonId)this._user.getId());
        } else {
            this._loginServiceProxy.checkForSession((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void registerLoggedInCallback(@Nonnull LoggedInCallback loggedInCallback) {
        if (this._user == null) {
            this._loggedInCallbacks.add(loggedInCallback);
        } else {
            loggedInCallback.onLoggedIn();
        }
    }

    public PersonTeaserModel getUser() {
        return this._user;
    }

    @CheckForNull
    public PersonSettings getUserSettings() {
        return this._userSettings;
    }

    public void setLanguage(String locale, AsyncCallback<Void> callback) {
        this._loginServiceProxy.setLanguage(locale, callback);
    }

    public void checkForSession(AsyncCallback<LoginInfoBean> callback, @Nonnull EventManager eventManager) {
        this._loginServiceProxy.checkForSession((AsyncCallback)new OnLoginOrCheckForSession(this, callback, LoginEvent.LOGIN_BY_EXISTING_SESSION, eventManager));
    }

    public PersonId getPersonId() {
        PersonTeaserModel user = this.getUser();
        return user == null ? null : (PersonId)user.getId();
    }

    public boolean isDialogBoxTypeDeactivated(DeactivatableDialogBoxType type) {
        Boolean value = (Boolean)this._dialogBoxDeactivatingMap.get(type);
        return value != null && value != false;
    }

    public void setDialogBoxTypeDeactivated(DeactivatableDialogBoxType type, boolean value) {
        this._dialogBoxDeactivatingMap.put(type, value);
    }

    public void updateUserSettings(@Nullable PersonSettings settings) {
        this._userSettings = settings;
    }
}

