/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.training;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.searchltr.config.SearchLTRConfigProperties;
import de.justsoftware.searchltr.config.ZookeeperService;
import de.justsoftware.searchltr.persistence.DBSearchResult;
import de.justsoftware.searchltr.persistence.SearchResultRepository;
import de.justsoftware.searchltr.solr.LTRLinearModelWeightsParams;
import de.justsoftware.searchltr.solr.LTRModel;
import de.justsoftware.searchltr.solr.LTRModelFeature;
import de.justsoftware.searchltr.solr.Solrs;
import de.justsoftware.searchltr.training.TrainingService;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 12\u00020\u0001:\u00011B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0012J\u0016\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0012J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u001e\u001a\u00020\u000bH\u0012J\u0016\u0010\u001f\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0012J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0012J\b\u0010#\u001a\u00020\u0018H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J,\u0010%\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0012J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001cH\u0012J6\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0012J\u001e\u0010/\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0012J,\u00100\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lde/justsoftware/searchltr/training/TrainingService;", "", "searchResultRepository", "Lde/justsoftware/searchltr/persistence/SearchResultRepository;", "searchLTRConfigProperties", "Lde/justsoftware/searchltr/config/SearchLTRConfigProperties;", "zookeeperService", "Lde/justsoftware/searchltr/config/ZookeeperService;", "solr", "Lde/justsoftware/searchltr/solr/Solrs;", "outputPath", "", "(Lde/justsoftware/searchltr/persistence/SearchResultRepository;Lde/justsoftware/searchltr/config/SearchLTRConfigProperties;Lde/justsoftware/searchltr/config/ZookeeperService;Lde/justsoftware/searchltr/solr/Solrs;Ljava/lang/String;)V", "trainingModelFile", "trainingSamplesFile", "trainingThread", "Ljava/lang/Thread;", "calculateRelativeRelevances", "", "", "results", "", "Lde/justsoftware/searchltr/persistence/DBSearchResult;", "calculateRelevances", "", "calculateRelevancesForQuery", "queryResults", "createSolrLTRModel", "Lde/justsoftware/searchltr/solr/LTRModel;", "featureNames", "upcomingFeatureStoreName", "generateTrainingFile", "isTraining", "", "performTraining", "prepareTraining", "train", "updateSearchResultsRelevanceAndProcessed", "relavances", "uploadSolrLTRModel", "model", "writeTrainingSample", "out", "Ljava/io/PrintWriter;", "sign", "result1", "result2", "writeTrainingSamples", "writeTrainingSamplesByQueryId", "Companion", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nTrainingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrainingService.kt\nde/justsoftware/searchltr/training/TrainingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 LoggerUtils.kt\nde/justsoftware/searchltr/util/LoggerUtilsKt\n*L\n1#1,307:1\n1549#2:308\n1620#2,3:309\n1855#2,2:313\n1864#2,3:315\n1477#2:318\n1502#2,3:319\n1505#2,3:329\n1855#2,2:332\n378#2,7:334\n1179#2,2:341\n1253#2,4:343\n1855#2,2:347\n1#3:312\n372#4,7:322\n9#5:349\n8#5,3:350\n*S KotlinDebug\n*F\n+ 1 TrainingService.kt\nde/justsoftware/searchltr/training/TrainingService\n*L\n115#1:308\n115#1:309,3\n151#1:313,2\n201#1:315,3\n225#1:318\n225#1:319,3\n225#1:329,3\n227#1:332,2\n250#1:334,7\n262#1:341,2\n262#1:343,4\n279#1:347,2\n225#1:322,7\n302#1:349\n302#1:350,3\n*E\n"})
public class TrainingService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SearchResultRepository searchResultRepository;
    @NotNull
    private final SearchLTRConfigProperties searchLTRConfigProperties;
    @NotNull
    private final ZookeeperService zookeeperService;
    @NotNull
    private final Solrs solr;
    @NotNull
    private final String outputPath;
    @NotNull
    private final String trainingSamplesFile;
    @NotNull
    private final String trainingModelFile;
    @Nullable
    private Thread trainingThread;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ObjectMapper mapper;
    private static final DateTimeFormatter DATE_FORMATTER;

    public TrainingService(@NotNull SearchResultRepository searchResultRepository, @NotNull SearchLTRConfigProperties searchLTRConfigProperties, @NotNull ZookeeperService zookeeperService, @NotNull Solrs solr, @Value(value="${search-ltr.training.outputPath}") @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter((Object)searchResultRepository, (String)"searchResultRepository");
        Intrinsics.checkNotNullParameter((Object)searchLTRConfigProperties, (String)"searchLTRConfigProperties");
        Intrinsics.checkNotNullParameter((Object)zookeeperService, (String)"zookeeperService");
        Intrinsics.checkNotNullParameter((Object)solr, (String)"solr");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.searchResultRepository = searchResultRepository;
        this.searchLTRConfigProperties = searchLTRConfigProperties;
        this.zookeeperService = zookeeperService;
        this.solr = solr;
        this.outputPath = outputPath;
        this.trainingSamplesFile = this.outputPath + "/trainingSamples.txt";
        this.trainingModelFile = this.outputPath + "/trainingModel.txt";
    }

    public void train() {
        if (this.isTraining()) {
            throw new IllegalStateException("Training is already in progress".toString());
        }
        this.trainingThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)31, null);
    }

    public void prepareTraining() {
        Instant instant = Instant.now().minusMillis(31536000000L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minusMillis(...)");
        this.searchResultRepository.deleteBySearchTimeBefore(instant);
        this.calculateRelevances();
    }

    private void uploadSolrLTRModel(LTRModel model) {
        block0: {
            LOG.info("Uploading Solr LTR model: " + model.getName());
            LOG.debug(mapper.writeValueAsString((Object)model));
            this.solr.uploadLTRModel(model);
            String modelNameBeforeUpdate = this.searchLTRConfigProperties.getModelName();
            LOG.info("Persisting new trained model name " + model.getName() + " into Zookeeper");
            this.zookeeperService.storeModelName(model.getName());
            String string = modelNameBeforeUpdate;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            LOG.info("Deleting old Solr LTR model: " + modelNameBeforeUpdate);
            this.solr.deleteLTRModel(modelNameBeforeUpdate);
        }
    }

    /*
     * WARNING - void declaration
     */
    private LTRModel createSolrLTRModel(List<String> featureNames, String upcomingFeatureStoreName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = DATE_FORMATTER.format(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String timeString = string;
        String solrModelName = "justSearchModel_" + timeString;
        LOG.info("Generating Solr LTR model: " + solrModelName);
        Ref.IntRef i = new Ref.IntRef();
        Ref.BooleanRef readingWeights = new Ref.BooleanRef();
        Map featureWeights = new LinkedHashMap();
        FilesKt.forEachLine$default((File)new File(this.trainingModelFile), null, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        Iterable iterable = featureWeights.keySet();
        boolean $i$f$map = false;
        void var11_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LTRModelFeature((String)it));
        }
        List modelFeatures = (List)destination$iv$iv;
        LTRLinearModelWeightsParams params = new LTRLinearModelWeightsParams(featureWeights);
        return new LTRModel(upcomingFeatureStoreName, solrModelName, modelFeatures, params);
    }

    private void performTraining() {
        LOG.info("Generating trained model: " + this.trainingModelFile);
        String[] stringArray = new String[]{"./bin/train", "-q", this.trainingSamplesFile, this.trainingModelFile};
        new ProcessBuilder(stringArray).start().waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTrainingFile(List<String> featureNames) {
        LOG.info("Generating training file: " + this.trainingSamplesFile);
        File folder = new File(this.outputPath);
        folder.mkdirs();
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IOException("Could not create training directory.");
        }
        File file = new File(this.trainingSamplesFile);
        Object object = file;
        Object object2 = Charsets.UTF_8;
        File file2 = object;
        int n = 8192;
        Object object3 = file2;
        object = new PrintWriter((object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter out = (PrintWriter)object;
            boolean bl = false;
            this.writeTrainingSamples(out, featureNames);
            file2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private void writeTrainingSamples(PrintWriter out, List<String> featureNames) {
        Page relevantResults;
        String[] stringArray = new String[]{"queryId", "resultPosition"};
        PageRequest page = PageRequest.of((int)0, (int)1000, (Sort)Sort.by((String[])stringArray));
        ArrayList<DBSearchResult> queryResults = null;
        queryResults = new ArrayList<DBSearchResult>();
        UUID currentQueryId = null;
        do {
            PageRequest pageRequest = page;
            Intrinsics.checkNotNull((Object)pageRequest);
            relevantResults = this.searchResultRepository.findByProcessedTrueAndRelevanceNotNull((Pageable)pageRequest);
            Iterable $this$forEach$iv = (Iterable)relevantResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DBSearchResult searchResult = (DBSearchResult)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(currentQueryId, (Object)searchResult.getQueryId())) {
                    this.writeTrainingSamplesByQueryId(out, (List)queryResults, featureNames);
                    currentQueryId = searchResult.getQueryId();
                    queryResults = new ArrayList();
                    continue;
                }
                queryResults.add(searchResult);
            }
            page = page.next();
        } while (relevantResults.hasNext());
        this.writeTrainingSamplesByQueryId(out, (List)queryResults, featureNames);
    }

    private void writeTrainingSamplesByQueryId(PrintWriter out, List<DBSearchResult> results, List<String> featureNames) {
        if (results.isEmpty()) {
            return;
        }
        int n = results.size();
        for (int r1 = 0; r1 < n; ++r1) {
            int n2 = results.size();
            for (int r2 = r1 + 1; r2 < n2; ++r2) {
                DBSearchResult result1 = results.get(r1);
                DBSearchResult result2 = results.get(r2);
                Float f = result1.getRelevance();
                Intrinsics.checkNotNull((Object)f);
                float f2 = f.floatValue();
                Float f3 = result2.getRelevance();
                Intrinsics.checkNotNull((Object)f3);
                if (f2 > f3.floatValue()) {
                    this.writeTrainingSample(out, "+1", result1, result2, featureNames);
                    this.writeTrainingSample(out, "-1", result2, result1, featureNames);
                    continue;
                }
                Float f4 = result1.getRelevance();
                Intrinsics.checkNotNull((Object)f4);
                float f5 = f4.floatValue();
                Float f6 = result2.getRelevance();
                Intrinsics.checkNotNull((Object)f6);
                if (!(f5 < f6.floatValue())) continue;
                this.writeTrainingSample(out, "+1", result2, result1, featureNames);
                this.writeTrainingSample(out, "-1", result1, result2, featureNames);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeTrainingSample(PrintWriter out, String sign, DBSearchResult result1, DBSearchResult result2, List<String> featureNames) {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator(',');
        DecimalFormat decimalFormat = new DecimalFormat("#.########", otherSymbols);
        Object featuresString = null;
        featuresString = "";
        Iterable $this$forEachIndexed$iv = featureNames;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void name;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (!result1.getFeatures().containsKey(name) && !result2.getFeatures().containsKey(name)) continue;
            Object v = result1.getFeatures().get(name);
            Intrinsics.checkNotNull(v);
            float f1 = ((Number)v).floatValue();
            Object v2 = result2.getFeatures().get(name);
            Intrinsics.checkNotNull(v2);
            float f2 = ((Number)v2).floatValue();
            if (f1 - f2 == 0.0f) continue;
            featuresString = featuresString + " " + (index + 1) + ":" + decimalFormat.format(Float.valueOf(f1 - f2));
        }
        if (!Intrinsics.areEqual((Object)featuresString, (Object)"")) {
            out.println(sign + featuresString + " # qid=" + result1.getQueryId() + " r1=" + result1.getResultId() + " r2=" + result2.getResultId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calculateRelevances() {
        Page unprocessedQueryIds;
        LOG.info("Calculate and update document relevances in database");
        Instant minAgeTimestamp = Instant.now().minusSeconds(3600L);
        do {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNull((Object)minAgeTimestamp);
            Pageable pageable = Pageable.ofSize((int)100);
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"ofSize(...)");
            unprocessedQueryIds = this.searchResultRepository.findUnprocessedQueryId(minAgeTimestamp, pageable);
            if (!unprocessedQueryIds.hasContent()) continue;
            Iterable $this$groupBy$iv = this.searchResultRepository.findByQueryIds((Iterable)unprocessedQueryIds);
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DBSearchResult p0 = (DBSearchResult)element$iv$iv;
                boolean bl = false;
                UUID key$iv$iv = p0.getQueryId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = destination$iv$iv.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List p0 = (List)element$iv;
                boolean bl = false;
                this.calculateRelevancesForQuery(p0);
            }
        } while (unprocessedQueryIds.hasNext());
    }

    private void calculateRelevancesForQuery(List<DBSearchResult> queryResults) {
        if (queryResults.isEmpty()) {
            return;
        }
        Map relavances = this.calculateRelativeRelevances(queryResults);
        this.updateSearchResultsRelevanceAndProcessed(queryResults, relavances);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Float> calculateRelativeRelevances(List<DBSearchResult> results) {
        void $this$associateTo$iv$iv;
        int n;
        block3: {
            if (results.size() < 2) {
                LOG.debug("Skip calculating relevances for query " + results.get(0).getQueryId() + ", not enough comparable documents (" + results.size() + "), calculating relative relevances not possible");
                return MapsKt.emptyMap();
            }
            List<DBSearchResult> $this$indexOfLast$iv = results;
            boolean $i$f$indexOfLast = false;
            ListIterator<DBSearchResult> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                DBSearchResult result = iterator$iv.previous();
                boolean bl = false;
                if (!result.getClicked()) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = -1;
        }
        int lastClickedResult = n;
        int assumedMinNumberViewed = Math.min(3, results.size());
        int numberOfComparableResults = Math.max(assumedMinNumberViewed, lastClickedResult + 1);
        List<DBSearchResult> comparableResults = results.subList(0, numberOfComparableResults);
        LOG.debug("Calculating relevances from clicks for " + comparableResults.size() + " results of query " + results.get(0).getQueryId());
        Iterable $this$associate$iv = comparableResults;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            DBSearchResult it = (DBSearchResult)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getResultId(), (Object)Float.valueOf(it.getClicked() ? 1.0f + (float)it.getResultPosition() : 0.0f));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private void updateSearchResultsRelevanceAndProcessed(List<DBSearchResult> queryResults, Map<String, Float> relavances) {
        ArrayList<DBSearchResult> relevantResults = new ArrayList<DBSearchResult>();
        ArrayList<DBSearchResult> irrelevantResults = new ArrayList<DBSearchResult>();
        Iterable $this$forEach$iv = queryResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DBSearchResult it = (DBSearchResult)element$iv;
            boolean bl = false;
            Float calculatedRelevance = relavances.get(it.getResultId());
            if (calculatedRelevance != null) {
                it.setProcessed(true);
                it.setRelevance(calculatedRelevance);
                relevantResults.add(it);
                continue;
            }
            irrelevantResults.add(it);
        }
        if (!((Collection)relevantResults).isEmpty()) {
            this.searchResultRepository.saveAllAndFlush((Iterable)relevantResults);
        }
        if (!((Collection)irrelevantResults).isEmpty()) {
            this.searchResultRepository.deleteAll((Iterable)irrelevantResults);
        }
    }

    public boolean isTraining() {
        Thread thread = this.trainingThread;
        return thread != null ? thread.isAlive() : false;
    }

    public static final /* synthetic */ SearchLTRConfigProperties access$getSearchLTRConfigProperties$p(TrainingService $this) {
        return $this.searchLTRConfigProperties;
    }

    public static final /* synthetic */ Solrs access$getSolr$p(TrainingService $this) {
        return $this.solr;
    }

    public static final /* synthetic */ void access$generateTrainingFile(TrainingService $this, List featureNames) {
        $this.generateTrainingFile(featureNames);
    }

    public static final /* synthetic */ void access$performTraining(TrainingService $this) {
        $this.performTraining();
    }

    public static final /* synthetic */ LTRModel access$createSolrLTRModel(TrainingService $this, List featureNames, String upcomingFeatureStoreName) {
        return $this.createSolrLTRModel(featureNames, upcomingFeatureStoreName);
    }

    public static final /* synthetic */ void access$uploadSolrLTRModel(TrainingService $this, LTRModel model) {
        $this.uploadSolrLTRModel(model);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        mapper = new ObjectMapper();
        DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    }
}

