/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.service;

import de.justsoftware.mobile.gateway.wiki.generated.fragment.SubscriptionFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiArticleFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiChapterFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiFragment;
import de.justsoftware.mobile.gateway.wiki.model.SubscribedWikiItem;
import de.justsoftware.mobile.gateway.wiki.model.Subscription;
import de.justsoftware.mobile.gateway.wiki.model.Wiki;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticle;
import de.justsoftware.mobile.gateway.wiki.model.WikiChapter;
import de.justsoftware.mobile.gateway.wiki.model.WikiTeaser;
import de.justsoftware.mobile.gateway.wiki.service.WikiApiGatewayService;
import de.justsoftware.mobile.gateway.wiki.service.WikiService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/mobile/gateway/wiki/service/WikiService;", "", "wikiApiGatewayService", "Lde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService;", "(Lde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService;)V", "getSubscribedWikiItems", "", "Lde/justsoftware/mobile/gateway/wiki/model/SubscribedWikiItem;", "offset", "", "limit", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/model/Wiki;", "wikiId", "", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticle;", "articleId", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/model/WikiChapter;", "chapterId", "getWikiTeasers", "Lde/justsoftware/mobile/gateway/wiki/model/WikiTeaser;", "page", "size", "onlySubscribed", "", "subscribe", "Lde/justsoftware/mobile/gateway/wiki/model/Subscription;", "unsubscribe", "Companion", "mobile-gateway"})
public class WikiService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WikiApiGatewayService wikiApiGatewayService;

    public WikiService(@NotNull WikiApiGatewayService wikiApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)wikiApiGatewayService, (String)"wikiApiGatewayService");
        this.wikiApiGatewayService = wikiApiGatewayService;
    }

    @NotNull
    public List<WikiTeaser> getWikiTeasers(int page, int size, boolean onlySubscribed) {
        return WikiTeaser.Companion.toWikiTeasers(this.wikiApiGatewayService.getWikiTeasers(page, size, onlySubscribed));
    }

    @NotNull
    public List<SubscribedWikiItem> getSubscribedWikiItems(int offset, int limit) {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @Nullable
    public Wiki getWiki(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        WikiFragment wikiFragment = this.wikiApiGatewayService.getWiki(wikiId);
        return wikiFragment != null ? Wiki.Companion.toWiki(wikiFragment) : null;
    }

    @Nullable
    public Subscription subscribe(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        SubscriptionFragment subscriptionFragment = this.wikiApiGatewayService.subscribe(wikiId);
        return subscriptionFragment != null ? Subscription.Companion.toSubscription(subscriptionFragment) : null;
    }

    @Nullable
    public Subscription unsubscribe(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        SubscriptionFragment subscriptionFragment = this.wikiApiGatewayService.unsubscribe(wikiId);
        return subscriptionFragment != null ? Subscription.Companion.toSubscription(subscriptionFragment) : null;
    }

    @Nullable
    public WikiChapter getWikiChapter(@NotNull String chapterId) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        WikiChapterFragment wikiChapterFragment = this.wikiApiGatewayService.getWikiChapter(chapterId);
        return wikiChapterFragment != null ? WikiChapter.Companion.toWikiChapter(wikiChapterFragment) : null;
    }

    @Nullable
    public WikiArticle getWikiArticle(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        WikiArticleFragment wikiArticleFragment = this.wikiApiGatewayService.getWikiArticle(articleId);
        return wikiArticleFragment != null ? WikiArticle.Companion.toWikiArticle(wikiArticleFragment) : null;
    }

    public static final /* synthetic */ WikiApiGatewayService access$getWikiApiGatewayService$p(WikiService $this) {
        return $this.wikiApiGatewayService;
    }
}

