/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.authorization.model.UnauthorizedException;
import de.justsoftware.mobile.gateway.common.configuration.AuthorizationContextResolver;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/AuthorizationContextResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "toroBaseUrl", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "rest", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/web/client/RestTemplate;)V", "loadCurrentPersonInfo", "", "authentication", "Lorg/springframework/security/oauth2/server/resource/authentication/BearerTokenAuthentication;", "resolveArgument", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "parameter", "Lorg/springframework/core/MethodParameter;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "supportsParameter", "", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/mobile/gateway/common/configuration/AuthorizationContextResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n468#2:112\n414#2:113\n453#2:118\n403#2:119\n1238#3,4:114\n1238#3,4:120\n*S KotlinDebug\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/mobile/gateway/common/configuration/AuthorizationContextResolver\n*L\n78#1:112\n78#1:113\n79#1:118\n79#1:119\n78#1:114,4\n79#1:120,4\n*E\n"})
public final class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final RestTemplate rest;
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationContextResolver.class);

    public AuthorizationContextResolver(@NotNull String toroBaseUrl, @NotNull ObjectMapper objectMapper, @NotNull RestTemplate rest) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.toroBaseUrl = toroBaseUrl;
        this.objectMapper = objectMapper;
        this.rest = rest;
    }

    public /* synthetic */ AuthorizationContextResolver(String string, ObjectMapper objectMapper, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, objectMapper, restTemplate);
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return Intrinsics.areEqual(AuthorizationContext.class, (Object)parameter.getParameterType());
    }

    @NotNull
    public AuthorizationContext resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        AuthorizationContext authorizationContext;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request.");
        }
        Authentication authentication2 = authentication;
        if ((authentication = authentication2) instanceof JwtAuthenticationToken) {
            authorizationContext = Companion.access$toAuthorizationContext((Companion)Companion, (JwtAuthenticationToken)((JwtAuthenticationToken)authentication2));
        } else if (authentication instanceof BearerTokenAuthentication) {
            authorizationContext = Companion.access$toAuthorizationContext((Companion)Companion, (Map)this.loadCurrentPersonInfo((BearerTokenAuthentication)authentication2));
        } else {
            LOG.warn("We received an unknown authentication type: " + authentication2.getClass().getName());
            throw new UnauthorizedException(null, 1, null);
        }
        return authorizationContext;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> loadCurrentPersonInfo(BearerTokenAuthentication authentication) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Object it;
        Map map;
        void $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + ((OAuth2AccessToken)authentication.getToken()).getTokenValue());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.rest.exchange(this.toroBaseUrl + "/api/v1/person/current", HttpMethod.GET, request, String.class, new Object[0]);
        boolean bl = false;
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.warn("Failed to retrieve person info from toro internal API: " + response.getStatusCode());
            throw new UnauthorizedException(null, 1, null);
        }
        Object object2 = this.objectMapper.readValue((String)response.getBody(), Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"readValue(...)");
        Map map2 = (Map)object2;
        boolean $i$f$mapKeys = false;
        void var8_8 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object = String.valueOf(it.getKey());
            Map map3 = map;
            boolean bl3 = false;
            it = it$iv$iv.getValue();
            map3.put(object, it);
        }
        $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl4 = false;
            object = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl5 = false;
            String string = String.valueOf(it2.getValue());
            map.put(k, string);
        }
        return destination$iv$iv;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }
}

