/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.app.service;

import de.justsoftware.mobile.gateway.app.model.ApiApp;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0003H\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/mobile/gateway/app/service/ToroApiGatewayService;", "", "toroBaseUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "availableAppsUri", "Ljava/net/URI;", "homeScreenAppIdsUri", "getAvailableApps", "", "Lde/justsoftware/mobile/gateway/app/model/ApiApp;", "getHomeScreenAppIds", "", "getResolvedDesktopUrl", "token", "resolvedDesktopHistoryTokenUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nToroApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToroApiGatewayService.kt\nde/justsoftware/mobile/gateway/app/service/ToroApiGatewayService\n+ 2 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt\n+ 3 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt$buildUri$1\n+ 4 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n7#2,5:40\n7#2,5:46\n11#2:62\n9#3:45\n9#3:51\n27#4:52\n27#4:53\n27#4:61\n2730#5,7:54\n*S KotlinDebug\n*F\n+ 1 ToroApiGatewayService.kt\nde/justsoftware/mobile/gateway/app/service/ToroApiGatewayService\n*L\n17#1:40,5\n19#1:46,5\n35#1:62\n17#1:45\n19#1:51\n21#1:52\n25#1:53\n32#1:61\n26#1:54,7\n*E\n"})
public class ToroApiGatewayService {
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI availableAppsUri;
    @NotNull
    private final URI homeScreenAppIdsUri;

    public ToroApiGatewayService(@Value(value="${just.toro.internal.baseurl}") @NotNull String toroBaseUrl, @NotNull WebClient webClient) {
        UriComponentsBuilder uriComponentsBuilder;
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.toroBaseUrl = toroBaseUrl;
        this.webClient = webClient;
        String baseUrl$iv = this.toroBaseUrl + "/context/api/v1/appConfig/availableApps?client=MOBILE";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(...)");
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder = uriComponentsBuilder2;
        ToroApiGatewayService toroApiGatewayService = this;
        boolean bl = false;
        UriComponentsBuilder $this$null = uriComponentsBuilder3;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        toroApiGatewayService.availableAppsUri = uRI;
        baseUrl$iv = this.toroBaseUrl + "/context/api/v1/homeScreen/homeScreenApps?client=MOBILE";
        $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder4 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder4, (String)"fromHttpUrl(...)");
        $this$null = uriComponentsBuilder = uriComponentsBuilder4;
        toroApiGatewayService = this;
        bl = false;
        URI uRI2 = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"toUri(...)");
        toroApiGatewayService.homeScreenAppIdsUri = uRI2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ApiApp> getAvailableApps() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.availableAppsUri;
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getHomeScreenAppIds() {
        Object v0;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.homeScreenAppIdsUri;
        boolean $i$f$get = false;
        Iterable $this$reduceOrNull$iv = (Iterable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void ids;
                List list = (List)iterator$iv.next();
                List acc = (List)accumulator$iv;
                boolean bl = false;
                accumulator$iv = CollectionsKt.plus((Collection)acc, (Iterable)((Iterable)ids));
            }
            v0 = accumulator$iv;
        }
        List list = v0;
        Set set = list != null ? CollectionsKt.toSet((Iterable)list) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getResolvedDesktopUrl(@NotNull String token) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        WebClient webClient = this.webClient;
        URI uri$iv = this.resolvedDesktopHistoryTokenUri(token);
        boolean $i$f$get = false;
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI resolvedDesktopHistoryTokenUri(String token) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.toroBaseUrl + "/api/v1/token/resolve";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(...)");
        UriComponentsBuilder $this$resolvedDesktopHistoryTokenUri_u24lambda_u241 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        Object[] objectArray = new Object[]{token};
        $this$resolvedDesktopHistoryTokenUri_u24lambda_u241.queryParam("token", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }
}

