/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.common.messages.PatchOpType;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.types.GroupResource;
import com.unboundid.scim2.common.types.Member;
import de.justsoftware.justimport.auth.AuthorizationContext;
import de.justsoftware.justimport.business.model.ScimUserGroupMember;
import de.justsoftware.justimport.business.usergroup.ScimGroupsService;
import de.justsoftware.justimport.business.usergroup.UserGroupImportPublisher;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.exceptions.LoopBreakingException;
import de.justsoftware.justimport.persistence.ProfileRepository;
import de.justsoftware.justimport.persistence.UserGroupMemberRepository;
import de.justsoftware.justimport.persistence.UserGroupRepository;
import de.justsoftware.justimport.persistence.model.DbProfile;
import de.justsoftware.justimport.persistence.model.DbUserGroup;
import de.justsoftware.justimport.persistence.model.DbUserGroupMember;
import de.justsoftware.justimport.persistence.model.DbUserGroupMemberId;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import de.justsoftware.justimport.util.FilterUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ScimGroupsService {
    private static final Logger LOG = LoggerFactory.getLogger(ScimGroupsService.class);
    private final ProfileRepository _profileRepo;
    private final UserGroupRepository _groupRepo;
    private final UserGroupMemberRepository _groupMemberRepo;
    private final UserGroupImportPublisher _userGroupPublisher;
    private final ObjectMapper _mapper;

    @Autowired
    public ScimGroupsService(ProfileRepository profileRepo, UserGroupRepository groupRepo, UserGroupMemberRepository groupMemberRepo, UserGroupImportPublisher userGroupImportPublisher, ObjectMapper mapper) {
        this._profileRepo = profileRepo;
        this._groupRepo = groupRepo;
        this._groupMemberRepo = groupMemberRepo;
        this._userGroupPublisher = userGroupImportPublisher;
        this._mapper = mapper;
    }

    @Nonnull
    public List<GroupResource> find(SearchRequest searchRequest, AuthorizationContext authCtx) throws ScimException {
        TenantId tenantId = authCtx.tenantId();
        String filterValue = FilterUtils.getFilterValue((SearchRequest)searchRequest);
        if (filterValue == null) {
            return List.of();
        }
        Optional dbGroup = this._groupRepo.findByTenantIdAndNameIgnoreCase(tenantId, filterValue);
        if (dbGroup.isEmpty()) {
            return List.of();
        }
        List members = this._groupMemberRepo.findAllById_UserGroupId(((DbUserGroup)dbGroup.get()).getId());
        return List.of(this.toGroupResource((DbUserGroup)dbGroup.get(), members));
    }

    @Nonnull
    public GroupResource byId(UserGroupId groupId, AuthorizationContext authCtx) throws ResourceNotFoundException {
        TenantId tenantId = authCtx.tenantId();
        Optional group = this._groupRepo.findByIdAndTenantId((UUID)groupId.getId(), tenantId);
        if (group.isEmpty()) {
            throw ScimGroupsService.groupNotFound((UUID)((UUID)groupId.getId()));
        }
        List members = this._groupMemberRepo.findAllById_UserGroupId(((DbUserGroup)group.get()).getId());
        return this.toGroupResource((DbUserGroup)group.get(), members);
    }

    @Nonnull
    @Transactional
    public GroupResource create(GroupResource group, AuthorizationContext authCtx) throws ResourceConflictException {
        TenantId tenantId = authCtx.tenantId();
        DbUserGroup dbGroup = this.toNewDbGroup(group, tenantId);
        String name = group.getDisplayName();
        if (this._groupRepo.findByTenantIdAndNameIgnoreCase(tenantId, name).isPresent()) {
            throw new ResourceConflictException("Group with this name already exists");
        }
        List memberIds = ScimGroupsService.getMemberIds((GroupResource)group);
        DbUserGroup persistedGroup = (DbUserGroup)this._groupRepo.save((Object)dbGroup);
        this._userGroupPublisher.publishImportedUserGroup(dbGroup);
        List persistedMembers = this.saveMembers(dbGroup.getGroupId(), memberIds);
        this.publishAllUserGroupMembers(dbGroup.getGroupId(), memberIds);
        return this.toGroupResource(persistedGroup, persistedMembers);
    }

    @Transactional
    public void delete(UserGroupId groupId, AuthorizationContext authCtx) throws ScimException {
        TenantId tenantId = authCtx.tenantId();
        Optional group = this._groupRepo.findByIdAndTenantId((UUID)groupId.getId(), tenantId);
        if (group.isEmpty()) {
            throw ScimGroupsService.groupNotFound((UUID)((UUID)groupId.getId()));
        }
        List removedMembers = this._groupMemberRepo.deleteAllById_UserGroupId((UUID)groupId.getId());
        this._groupRepo.deleteById((Object)((UUID)groupId.getId()));
        Collection memberIds = this.findMemberProfileIds((Collection)removedMembers).values();
        this._userGroupPublisher.publishDeletedUserGroup(groupId);
        this._userGroupPublisher.publishRemovedUserGroupMembers(groupId, memberIds);
    }

    @Nonnull
    @Transactional
    public GroupResource patch(UserGroupId groupId, PatchRequest patch, AuthorizationContext authCtx) throws ScimException, JsonProcessingException {
        Optional dbGroup = this._groupRepo.findByIdAndTenantId((UUID)groupId.getId(), authCtx.tenantId());
        if (dbGroup.isEmpty()) {
            throw ScimGroupsService.groupNotFound((UUID)((UUID)groupId.getId()));
        }
        List members = this._groupMemberRepo.findAllById_UserGroupId((UUID)groupId.getId());
        GroupResource groupResource = this.toGroupResource((DbUserGroup)dbGroup.get(), members);
        GenericScimResource genericScimResource = groupResource.asGenericScimResource();
        patch.apply(genericScimResource);
        GroupResource patchedGroupResource = (GroupResource)this._mapper.readValue(genericScimResource.getObjectNode().toString(), GroupResource.class);
        DbUserGroup persistedGroup = (DbUserGroup)this._groupRepo.save((Object)this.toDbGroup(groupId, ((DbUserGroup)dbGroup.get()).getTenantId(), patchedGroupResource));
        this._userGroupPublisher.publishImportedUserGroup(persistedGroup);
        List patchedMembers = this.patchAndPublishUserGroupMembers(groupId, patch);
        return this.toGroupResource(persistedGroup, patchedMembers);
    }

    @Nonnull
    @Transactional
    public GroupResource replace(UserGroupId groupId, GroupResource group, AuthorizationContext authCtx) throws ResourceNotFoundException {
        Optional existingGroup = this._groupRepo.findByIdAndTenantId((UUID)groupId.getId(), authCtx.tenantId());
        if (existingGroup.isEmpty()) {
            throw ScimGroupsService.groupNotFound((UUID)((UUID)groupId.getId()));
        }
        DbUserGroup dbGroup = this.toDbGroup(groupId, ((DbUserGroup)existingGroup.get()).getTenantId(), group);
        List memberUids = ScimGroupsService.getMemberIds((GroupResource)group);
        DbUserGroup persistedGroup = (DbUserGroup)this._groupRepo.save((Object)dbGroup);
        List persistedMembers = this.replaceAndPublishUserGroupMembers(groupId, memberUids);
        this._userGroupPublisher.publishImportedUserGroup(dbGroup);
        return this.toGroupResource(persistedGroup, persistedMembers);
    }

    @Nonnull
    private List<DbUserGroupMember> patchAndPublishUserGroupMembers(UserGroupId groupId, PatchRequest patch) throws ScimException {
        Multimap changedMembers = this.getMemberIdsFromPatchOperations(patch);
        Map profileIds = this.findMemberProfileIdsByUid(changedMembers.values());
        Sets.SetView missingProfileIds = Sets.difference(Set.copyOf(changedMembers.values()), profileIds.keySet());
        if (!missingProfileIds.isEmpty()) {
            throw new ResourceNotFoundException(String.format("Some members that should be added to group %s do not exist. Missing profiles: %s", groupId, missingProfileIds));
        }
        ChangedMembers addedAndRemovedMembers = this.groupMemberChangesByPatchOpType(groupId, changedMembers);
        this.addAndPublishUserGroupMembers(groupId, (Collection)addedAndRemovedMembers.added, profileIds);
        this.removeAndPublishUserGroupMembers(groupId, (Collection)addedAndRemovedMembers.removed, profileIds);
        return this._groupMemberRepo.findAllById_UserGroupId((UUID)groupId.getId());
    }

    @Nonnull
    private ChangedMembers groupMemberChangesByPatchOpType(UserGroupId groupId, Multimap<PatchOpType, UUID> changedMembers) {
        Set membersToAdd = changedMembers.get((Object)PatchOpType.ADD).stream().map(uid -> new DbUserGroupMemberId(uid, groupId)).collect(Collectors.toSet());
        Set membersToRemove = changedMembers.get((Object)PatchOpType.REMOVE).stream().map(uid -> new DbUserGroupMemberId(uid, groupId)).collect(Collectors.toSet());
        return new ChangedMembers(membersToAdd, membersToRemove);
    }

    private void addAndPublishUserGroupMembers(UserGroupId groupId, Collection<DbUserGroupMemberId> memberIdsToAdd, Map<UUID, ProfileId> profileIds) {
        Set membersToAdd = memberIdsToAdd.stream().map(id -> new DbUserGroupMember(id, Instant.now(), ImportMethod.SCIM)).collect(Collectors.toSet());
        List<ProfileId> memberProfileIds = membersToAdd.stream().map(member -> (ProfileId)profileIds.get(member.getProfileId())).toList();
        LOG.info("Adding {} members to user group {}", (Object)membersToAdd.size(), (Object)groupId);
        if (!membersToAdd.isEmpty()) {
            List persistedMembers = this._groupMemberRepo.saveAll(membersToAdd);
            LOG.info("Members added to group {}: {}", (Object)groupId, (Object)persistedMembers);
            this._userGroupPublisher.publishAddedUserGroupMembers(groupId, memberProfileIds);
        }
    }

    private void removeAndPublishUserGroupMembers(UserGroupId groupId, Collection<DbUserGroupMemberId> membersToRemove, Map<UUID, ProfileId> profileIds) {
        List<ProfileId> removedMemberProfileIds = membersToRemove.stream().map(memberId -> (ProfileId)profileIds.get(memberId.getProfileId())).toList();
        LOG.info("Removing {} members from user group {}", (Object)membersToRemove.size(), (Object)groupId);
        if (!membersToRemove.isEmpty()) {
            this._groupMemberRepo.deleteAllById(membersToRemove);
            LOG.info("Members removed from group {}: {}", (Object)groupId, membersToRemove);
            this._userGroupPublisher.publishRemovedUserGroupMembers(groupId, removedMemberProfileIds);
        }
    }

    @Nonnull
    private Map<UUID, ProfileId> findMemberProfileIds(Collection<DbUserGroupMember> members) {
        Collection memberIds = members.stream().map(DbUserGroupMember::getProfileId).collect(Collectors.toList());
        return this.findMemberProfileIdsByUid(memberIds);
    }

    @Nonnull
    private Map<UUID, ProfileId> findMemberProfileIdsByUid(Collection<UUID> memberIds) {
        return this._profileRepo.findAllById(memberIds).stream().collect(Collectors.toMap(DbProfile::getUuid, profile -> ProfileId.fromLongId((Long)profile.getId())));
    }

    @Nonnull
    private Multimap<PatchOpType, UUID> getMemberIdsFromPatchOperations(PatchRequest patchRequest) throws ScimException {
        try {
            return (Multimap)patchRequest.getOperations().stream().filter(arg_0 -> this.isOperationOnMembers(arg_0)).collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(PatchOperation::getOpType, arg_0 -> this.getMembersStream(arg_0)));
        }
        catch (LoopBreakingException e) {
            throw e.getCause();
        }
    }

    private boolean isOperationOnMembers(PatchOperation patchOperation) throws LoopBreakingException {
        try {
            return patchOperation.getPath().withoutFilters().equals((Object)Path.fromString((String)"members"));
        }
        catch (BadRequestException e) {
            throw new LoopBreakingException((ScimException)e);
        }
    }

    @Nonnull
    private Stream<UUID> getMembersStream(PatchOperation patchOperation) {
        return (this.hasValueFilter(patchOperation.getPath()) ? this.getMemberIdsFromValueFilter(patchOperation.getPath()) : this.getMemberIds(patchOperation)).stream();
    }

    @Nonnull
    private List<UUID> getMemberIds(PatchOperation patchOperation) throws LoopBreakingException {
        try {
            return ((List)MoreObjects.firstNonNull((Object)patchOperation.getValues(ScimUserGroupMember.class), List.of())).stream().map(ScimUserGroupMember::uuid).toList();
        }
        catch (JsonProcessingException e) {
            throw new LoopBreakingException((ScimException)((Object)new BadRequestException(new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value()), (Throwable)e)));
        }
        catch (ScimException e) {
            throw new LoopBreakingException(e);
        }
    }

    @Nonnull
    private static List<UUID> getMemberIds(GroupResource group) {
        List members = group.getMembers();
        return members == null ? List.of() : members.stream().map(member -> UUID.fromString(member.getValue())).toList();
    }

    @Nonnull
    private List<UUID> getMemberIdsFromValueFilter(Path path) throws LoopBreakingException {
        Filter valueFilter = path.getElement(0).getValueFilter();
        try {
            String filterValue = FilterUtils.getFilterValue((Filter)valueFilter);
            return filterValue == null ? List.of() : List.of(UUID.fromString(filterValue));
        }
        catch (NotImplementedException e) {
            throw new LoopBreakingException((ScimException)((Object)e));
        }
    }

    @Nonnull
    private List<DbUserGroupMember> replaceAndPublishUserGroupMembers(UserGroupId groupId, @Nullable List<UUID> memberIds) {
        List deleted = this._groupMemberRepo.deleteAllById_UserGroupId((UUID)groupId.getId());
        if (memberIds == null) {
            Collection deletedProfileIds = this.findMemberProfileIds((Collection)deleted).values();
            this._userGroupPublisher.publishRemovedUserGroupMembers(groupId, deletedProfileIds);
            return List.of();
        }
        List persistedMembers = this.saveMembers(groupId, memberIds);
        this.publishAllUserGroupMembers(groupId, memberIds);
        return persistedMembers;
    }

    @Nonnull
    private List<DbUserGroupMember> saveMembers(UserGroupId groupId, List<UUID> memberIds) {
        List<DbUserGroupMember> members = memberIds.stream().map(uid -> new DbUserGroupMember(new DbUserGroupMemberId(uid, (UUID)groupId.getId()), Instant.now(), ImportMethod.SCIM)).toList();
        return this._groupMemberRepo.saveAll(members);
    }

    private void publishAllUserGroupMembers(UserGroupId groupId, List<UUID> memberIds) {
        Set memberProfileIds = this._profileRepo.findAllById(memberIds).stream().map(profile -> ProfileId.fromLongId((Long)profile.getId())).collect(Collectors.toSet());
        this.publishAllUserGroupMembers(groupId, memberProfileIds);
    }

    private void publishAllUserGroupMembers(UserGroupId groupId, Collection<ProfileId> memberIds) {
        this._userGroupPublisher.publishAddedUserGroupMembers(groupId, memberIds);
    }

    @Nonnull
    private DbUserGroup toNewDbGroup(GroupResource group, TenantId tenantId) {
        return this.toDbGroup(UserGroupId.random(), (UUID)tenantId.getId(), group);
    }

    @Nonnull
    private DbUserGroup toDbGroup(UserGroupId groupId, UUID tenantId, GroupResource group) {
        return new DbUserGroup((UUID)groupId.getId(), group.getDisplayName(), tenantId, false, Instant.now(), ImportMethod.SCIM);
    }

    @Nonnull
    private GroupResource toGroupResource(DbUserGroup group, @Nullable List<DbUserGroupMember> members) {
        GroupResource resource = new GroupResource();
        resource.setDisplayName(group.getName());
        resource.setId(group.getId().toString());
        if (members != null) {
            resource.setMembers(members.stream().map(member -> new Member().setValue(member.getProfileId().toString())).toList());
        }
        return resource;
    }

    @Nonnull
    private static ResourceNotFoundException groupNotFound(UUID id) {
        return new ResourceNotFoundException(String.format("Group with id %s not found", id));
    }

    private boolean hasValueFilter(@Nullable Path path) {
        return path != null && path.size() > 0 && path.getElement(0) != null && path.getElement(0).getValueFilter() != null;
    }
}

