/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.profile;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.Group;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.UserResource;
import de.justsoftware.justimport.auth.AuthorizationContext;
import de.justsoftware.justimport.business.ToroApiService;
import de.justsoftware.justimport.business.model.ToroProfile;
import de.justsoftware.justimport.business.usergroup.UserGroupImportPublisher;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.persistence.ProfileRepository;
import de.justsoftware.justimport.persistence.UserGroupMemberRepository;
import de.justsoftware.justimport.persistence.model.DbProfile;
import de.justsoftware.justimport.persistence.model.DbUserGroupMember;
import de.justsoftware.justimport.persistence.model.DbUserGroupMemberId;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import de.justsoftware.justimport.util.PatchRequestUtils;
import de.justsoftware.justimport.util.ResourceUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ScimUsersService {
    private static final Logger LOG = LoggerFactory.getLogger(ScimUsersService.class);
    private final ProfileRepository _profileRepo;
    private final UserGroupMemberRepository _groupMemberRepo;
    private final ToroApiService _toroApiService;
    private final UserGroupImportPublisher _userGroupPublisher;
    private final ObjectMapper _mapper;

    @Autowired
    public ScimUsersService(ProfileRepository profileRepo, UserGroupMemberRepository groupMemberRepo, ToroApiService toroApiService, UserGroupImportPublisher userGroupPublisher, ObjectMapper mapper) {
        this._profileRepo = profileRepo;
        this._groupMemberRepo = groupMemberRepo;
        this._toroApiService = toroApiService;
        this._userGroupPublisher = userGroupPublisher;
        this._mapper = mapper;
    }

    @Nonnull
    public List<UserResource> find(SearchRequest searchRequest, AuthorizationContext authCtx) throws NotImplementedException, BadRequestException {
        TenantId tenantId = authCtx.tenantId();
        String filterValue = this.getFilterValue(searchRequest);
        if (filterValue == null) {
            return List.of();
        }
        Optional profile = this._profileRepo.findByTenantIdAndEmailIgnoreCase(tenantId, filterValue);
        if (profile.isEmpty()) {
            return List.of();
        }
        List memberships = this._groupMemberRepo.findAllById_ProfileId(((DbProfile)profile.get()).getUuid());
        return List.of(ScimUsersService.toUserResource((DbProfile)((DbProfile)profile.get()), (List)memberships));
    }

    @Nonnull
    @Transactional
    public UserResource create(UserResource user, AuthorizationContext authCtx) throws ResourceConflictException, PreconditionFailedException, ServerErrorException {
        TenantId tenantId = authCtx.tenantId();
        ResourceUtils.validateUserResource((UserResource)user);
        String email = user.getUserName();
        if (this._profileRepo.findByTenantIdAndEmailIgnoreCase(tenantId, email).isPresent()) {
            throw new ResourceConflictException("User with this email already exists");
        }
        LOG.debug("Attempting to create user in toro: {}", (Object)user);
        ToroProfile toroProfile = this._toroApiService.createProfile(email, user.getName().getGivenName(), user.getName().getFamilyName(), user.getName().getHonorificPrefix(), user.getName().getHonorificSuffix(), tenantId, user.getActive().booleanValue());
        DbProfile dbProfile = DbProfile.toDbProfile((ToroProfile)toroProfile);
        List memberships = ScimUsersService.getGroupsMemberships((UUID)dbProfile.getUuid(), (UserResource)user);
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)dbProfile);
        List persistedMemberships = memberships == null ? List.of() : this._groupMemberRepo.saveAll((Iterable)memberships);
        return ScimUsersService.toUserResource((DbProfile)persistedProfile, (List)persistedMemberships);
    }

    @Nonnull
    public UserResource byId(UUID profileUid, AuthorizationContext authCtx) throws ResourceNotFoundException {
        TenantId tenantId = authCtx.tenantId();
        Optional dbProfile = this._profileRepo.findByTenantIdAndUuid(tenantId, profileUid);
        if (dbProfile.isEmpty()) {
            throw ScimUsersService.userNotFound((UUID)profileUid);
        }
        List memberships = this._groupMemberRepo.findAllById_ProfileId(profileUid);
        return ScimUsersService.toUserResource((DbProfile)((DbProfile)dbProfile.get()), (List)memberships);
    }

    @Nonnull
    @Transactional
    public UserResource patch(UUID profileId, PatchRequest patch, AuthorizationContext authCtx) throws ScimException, JsonProcessingException {
        TenantId tenantId = authCtx.tenantId();
        Optional dbProfile = this._profileRepo.findByTenantIdAndUuid(tenantId, profileId);
        if (dbProfile.isEmpty()) {
            throw ScimUsersService.userNotFound((UUID)profileId);
        }
        PatchRequest fixedPatchRequest = PatchRequestUtils.fixPatchRequest((PatchRequest)patch);
        List memberships = this._groupMemberRepo.findAllById_ProfileId(profileId);
        UserResource user = ScimUsersService.toUserResource((DbProfile)((DbProfile)dbProfile.get()), (List)memberships);
        GenericScimResource genericScimResource = user.asGenericScimResource();
        fixedPatchRequest.apply(genericScimResource);
        UserResource patchedUser = (UserResource)this._mapper.readValue(genericScimResource.getObjectNode().toString(), UserResource.class);
        ResourceUtils.validateUserResource((UserResource)patchedUser);
        ToroProfile toroProfile = this._toroApiService.replaceProfile(ProfileId.fromLongId((Long)((DbProfile)dbProfile.get()).getId()), patchedUser.getUserName(), patchedUser.getName().getGivenName(), patchedUser.getName().getFamilyName(), patchedUser.getName().getHonorificPrefix(), patchedUser.getName().getHonorificSuffix(), tenantId, patchedUser.getActive().booleanValue());
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)DbProfile.toDbProfile((ToroProfile)toroProfile));
        List originalMemberships = this._groupMemberRepo.findAllById_ProfileId(persistedProfile.getUuid());
        List patchedMemberships = ScimUsersService.getGroupsMemberships((UUID)persistedProfile.getUuid(), (UserResource)patchedUser);
        this.patchAndPublishMemberships(persistedProfile.getProfileId(), (Collection)originalMemberships, (Collection)patchedMemberships);
        return ScimUsersService.toUserResource((DbProfile)persistedProfile, (List)patchedMemberships);
    }

    @Nonnull
    @Transactional
    public UserResource replace(UUID profileUid, UserResource user, AuthorizationContext authCtx) throws ResourceNotFoundException, PreconditionFailedException {
        TenantId tenantId = authCtx.tenantId();
        ResourceUtils.validateUserResource((UserResource)user);
        Optional foundProfile = this._profileRepo.findByTenantIdAndUuid(tenantId, profileUid);
        if (foundProfile.isEmpty()) {
            throw ScimUsersService.userNotFound((UUID)profileUid);
        }
        DbProfile dbProfile = DbProfile.toDbProfile((Long)((DbProfile)foundProfile.get()).getId(), (UUID)profileUid, (UserResource)user);
        List originalMemberships = this._groupMemberRepo.findAllById_ProfileId(profileUid);
        List updatedMemberships = ScimUsersService.getGroupsMemberships((UUID)dbProfile.getUuid(), (UserResource)user);
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)dbProfile);
        this.patchAndPublishMemberships(persistedProfile.getProfileId(), (Collection)originalMemberships, (Collection)updatedMemberships);
        this._toroApiService.replaceProfile(ProfileId.fromLongId((Long)persistedProfile.getId()), persistedProfile.getEmail(), persistedProfile.getFirstName(), persistedProfile.getLastName(), persistedProfile.getHonorificPrefix(), persistedProfile.getHonorificSuffix(), tenantId, persistedProfile.isActive());
        return ScimUsersService.toUserResource((DbProfile)persistedProfile, (List)updatedMemberships);
    }

    @Transactional
    public void delete(UUID profileUid, AuthorizationContext authCtx) throws ResourceNotFoundException {
        TenantId tenantId = authCtx.tenantId();
        Optional profile = this._profileRepo.findByTenantIdAndUuid(tenantId, profileUid);
        if (profile.isEmpty()) {
            throw ScimUsersService.userNotFound((UUID)profileUid);
        }
        List<UserGroupId> groupIdsMemberWasRemovedFrom = this._groupMemberRepo.deleteAllById_ProfileId(profileUid).stream().map(it -> new UserGroupId(it.getUserGroupId())).toList();
        this._profileRepo.deleteByTenantIdAndUuid(tenantId, profileUid);
        ProfileId profileId = ProfileId.fromLongId((Long)((DbProfile)profile.get()).getId());
        this._toroApiService.deleteProfile(profileId, tenantId);
        this._userGroupPublisher.publishRemovedUserGroupMembers(groupIdsMemberWasRemovedFrom, profileId);
    }

    private void patchAndPublishMemberships(ProfileId profileId, Collection<DbUserGroupMember> originalMemberships, @Nullable Collection<DbUserGroupMember> updatedMemberships) {
        if (updatedMemberships == null) {
            return;
        }
        List<DbUserGroupMemberId> removedMemberships = CollectionUtils.removeAll(originalMemberships, updatedMemberships).stream().map(DbUserGroupMember::getId).toList();
        Collection addedMemberships = CollectionUtils.removeAll(updatedMemberships, originalMemberships);
        this._groupMemberRepo.deleteAllById(removedMemberships);
        this._groupMemberRepo.saveAll((Iterable)addedMemberships);
        this.publishRemovedUserGroupMemberships(profileId, removedMemberships);
        this.publishAddedUserGroupMemberships(profileId, addedMemberships);
    }

    @CheckForNull
    private String getFilterValue(SearchRequest searchRequest) throws NotImplementedException, BadRequestException {
        String stringFilter = searchRequest.getFilter();
        if (stringFilter == null || stringFilter.isEmpty()) {
            return null;
        }
        String filterValue = null;
        Filter filter = Filter.fromString((String)stringFilter);
        if (filter != null && filter.getFilterType() == FilterType.EQUAL) {
            ValueNode comparisonValue = filter.getComparisonValue();
            if (comparisonValue.textValue().isEmpty()) {
                throw new NotImplementedException("Only equals filter supported");
            }
            filterValue = comparisonValue.textValue();
        }
        return filterValue;
    }

    @CheckForNull
    private static List<DbUserGroupMember> getGroupsMemberships(UUID profileUid, UserResource user) {
        List groups = user.getGroups();
        return groups == null ? null : groups.stream().map(group -> new DbUserGroupMember(new DbUserGroupMemberId(profileUid, UUID.fromString(group.getValue())), Instant.now(), ImportMethod.SCIM)).toList();
    }

    @Nonnull
    private static UserResource toUserResource(DbProfile profile, @Nullable List<DbUserGroupMember> memberships) {
        Name name = new Name();
        name.setGivenName(profile.getFirstName());
        name.setFamilyName(profile.getLastName());
        name.setHonorificPrefix(profile.getHonorificPrefix());
        name.setHonorificSuffix(profile.getHonorificSuffix());
        Email email = new Email();
        email.setValue(profile.getEmail());
        email.setType("work");
        email.setPrimary(Boolean.valueOf(true));
        UserResource user = new UserResource();
        user.setId(profile.getUuid().toString());
        user.setName(name);
        user.setActive(Boolean.valueOf(profile.isActive()));
        user.setEmails(List.of(email));
        user.setUserName(profile.getEmail());
        if (memberships != null) {
            user.setGroups(memberships.stream().map(membership -> new Group().setValue(membership.getUserGroupId().toString())).toList());
        }
        return user;
    }

    @Nonnull
    private static ResourceNotFoundException userNotFound(UUID id) {
        return new ResourceNotFoundException(String.format("User with id %s not found", id));
    }

    private void publishAddedUserGroupMemberships(ProfileId profileId, Collection<DbUserGroupMember> addedMemberships) {
        this._userGroupPublisher.publishAddedUserGroupMembers(addedMemberships.stream().map(member -> new UserGroupId(member.getUserGroupId())).toList(), profileId);
    }

    private void publishRemovedUserGroupMemberships(ProfileId profileId, List<DbUserGroupMemberId> removedMemberships) {
        this._userGroupPublisher.publishRemovedUserGroupMembers(removedMemberships.stream().map(memberId -> new UserGroupId(memberId.getUserGroupId())).toList(), profileId);
    }
}

