/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.migrationwiki;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.justsoftware.drive.business.migrationwiki.model.DocumentMigrationResult;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class WikiMigrationResultPublisher {
    public static final String WIKI_MIGRATION_RESULT_TOPIC = "just.drive.wiki-drive-file-migration.results";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(WikiMigrationResultPublisher.class);
    private final Producer<String, String> _kafkaProducer;

    @Autowired
    public WikiMigrationResultPublisher(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> kafkaProducer) {
        this._kafkaProducer = kafkaProducer;
    }

    private void logErrorCallback(RecordMetadata metadata, Exception exception) {
        if (exception != null) {
            LOG.error("Could not publish share to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    public void publishWikiDocumentMigrationResult(DocumentMigrationResult result) {
        if (this._kafkaProducer == null) {
            return;
        }
        String resultKey = result.getKafkaKey();
        ObjectNode jsonNode = OBJECT_MAPPER.createObjectNode();
        jsonNode.set("oldDocument", (JsonNode)TextNode.valueOf((String)((UUID)result.getOriginalDocument().getId()).toString()));
        jsonNode.set("newDocument", (JsonNode)TextNode.valueOf((String)((UUID)result.getCopiedDocument().getId()).toString()));
        jsonNode.set("newTarget", (JsonNode)TextNode.valueOf((String)((String)result.getNewParent().getId())));
        try {
            this._kafkaProducer.send(new ProducerRecord(WIKI_MIGRATION_RESULT_TOPIC, (Object)resultKey, (Object)OBJECT_MAPPER.writeValueAsString((Object)jsonNode)), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
        }
        catch (JsonProcessingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException();
        }
    }
}

