/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.document.DocumentPublisher;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.business.item.impl.ItemPurgeServiceImpl;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.authorization.ItemActionDAO;
import de.justsoftware.drive.persistence.authorization.ItemReadRoleDAO;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ItemWriteServiceImpl
implements ItemWriteService {
    private final ItemDAO _itemDao;
    private final ItemActionDAO _itemActionDAO;
    private final ItemReadRoleDAO _itemReadRoleDAO;
    private final SharePermissionDAO _sharePermissionDAO;
    private final DocumentPublisher _documentPublisher;
    private final ItemPurgeServiceImpl _itemPurgeService;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public ItemWriteServiceImpl(ItemDAO itemDao, ItemActionDAO itemActionDAO, ItemReadRoleDAO itemReadRoleDAO, SharePermissionDAO sharePermissionDAO, DocumentPublisher documentPublisher, ItemPurgeServiceImpl itemPurgeService, TransactionSupport transactionSupport) {
        this._itemDao = itemDao;
        this._itemActionDAO = itemActionDAO;
        this._itemReadRoleDAO = itemReadRoleDAO;
        this._sharePermissionDAO = sharePermissionDAO;
        this._documentPublisher = documentPublisher;
        this._itemPurgeService = itemPurgeService;
        this._transactionSupport = transactionSupport;
    }

    public void setParents(Map<ItemId, Optional<ItemId>> parents) {
        this._itemDao.setParents(parents);
    }

    public void setNames(Map<ItemId, String> names) {
        this._itemDao.setNames(names);
    }

    public void setTenantId(ItemId itemId, TenantId tenantId) {
        this._itemDao.setTenantId(itemId, tenantId);
    }

    public void markAsDeleted(Set<ItemId> itemIds) {
        ImmutableMap oldItems = this._itemDao.getItems(itemIds);
        this._itemDao.markAsDeleted(itemIds);
        this._itemActionDAO.deleteItemActions(itemIds);
        this._itemReadRoleDAO.deleteReadRoles(itemIds);
        this._sharePermissionDAO.deleteShares(itemIds);
        this._documentPublisher.publishItems((Set)itemIds.stream().filter(id -> !ItemBO.isItemDeleted((ItemBO)((ItemBO)oldItems.get(id)))).collect(ImmutableSet.toImmutableSet()));
    }

    public void storeItem(Map<ItemId, ItemCreateModel> items) {
        ImmutableMap oldItems = this._itemDao.getItems(items.keySet());
        this._itemDao.storeItems(items);
        this._transactionSupport.doAfterTransaction(() -> this._documentPublisher.publishItems((Set)items.keySet().stream().filter(id -> ItemBO.isItemDeleted((ItemBO)((ItemBO)oldItems.get(id)))).collect(ImmutableSet.toImmutableSet())));
    }

    public Set<ItemId> purge(Set<ItemId> items) {
        return this._itemPurgeService.purge(items);
    }
}

