/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.item.ItemDAO;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ItemReadServiceImpl
implements ItemReadService {
    private final ItemDAO _itemDAO;

    @Autowired
    public ItemReadServiceImpl(ItemDAO itemDAO) {
        this._itemDAO = itemDAO;
    }

    public ImmutableMap<ItemId, ItemBO> getItems(Set<ItemId> itemIds) {
        return this._itemDAO.getItems(itemIds);
    }

    public int forAllItemsWithDocuments(int chunkSize, Consumer<List<ItemId>> consumer) {
        return this._itemDAO.forAllItemsWithDocuments(chunkSize, consumer);
    }

    public int forAllShares(Consumer<ItemBO> shareConsumer) {
        return this._itemDAO.forAllShares(shareConsumer);
    }

    public Set<ItemId> getDeletedItems(Duration deletedForMoreThan) {
        return this._itemDAO.getDeletedItems(deletedForMoreThan);
    }
}

