/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.context;

import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.search.SolrClientFactory;
import de.justsoftware.jdoc.rest.service.client.DocumentManager;
import de.justsoftware.jdoc.service.RESTDocumentManagerImpl;
import de.justsoftware.jdoc.service.RestTemplateFactory;
import java.time.Clock;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class DriveBusinessConfiguration {
    @Autowired
    private SolrClientFactory _solrClientFactory;

    @Bean
    @Nonnull
    public Clock clock() {
        return Clock.systemDefaultZone();
    }

    @Bean
    @Nonnull
    public EventBus eventBus() {
        return new EventBus("just-drive-event-bus");
    }

    @Bean
    @Nonnull
    public DocumentManager judoDocumentManager(@Value(value="${just.drive.judo.url}") String judoUrl, RestTemplateFactory restTemplateFactory) {
        return new RESTDocumentManagerImpl(judoUrl, restTemplateFactory);
    }

    @Bean
    @Nonnull
    public RestTemplateFactory restTemplateFactory() {
        return new RestTemplateFactory();
    }

    @Bean(destroyMethod="close")
    @Nonnull
    public SolrClient readSolrClient(@Value(value="${just.drive.solr.readUrl}") String solrUrl) {
        return this._solrClientFactory.createSolrClient(solrUrl);
    }
}

