/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.tasks.processes.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.jdoc.services.monitoring.MonitoredService;
import de.justsoftware.jdoc.services.monitoring.model.HeartbeatStatus;
import de.justsoftware.jdoc.services.tasks.processes.NativeProcessManager;
import de.justsoftware.jdoc.services.tasks.processes.model.CommandlineApplicationCall;
import de.justsoftware.jdoc.services.tasks.processes.model.NativeProcessData;
import de.justsoftware.jdoc.services.tasks.processes.model.NativeProcessId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NativeProcessManagerImpl
implements NativeProcessManager,
MonitoredService {
    private static final Logger LOG = LoggerFactory.getLogger(NativeProcessManagerImpl.class);
    private static final ShutdownHookProcessDestroyer PROCESS_SHUTDOWN_HOOK = new ShutdownHookProcessDestroyer();
    private static final CommandlineApplicationCall KILL = new CommandlineApplicationCall("kill", new String[]{"-15"});
    private static final String LIST_ALL_PROCESSES = "ps -eo pid,ppid,command |  tr -s ' ' | sed 's/ /|/;s/ /|/;s/ /|/;' | sed '/^|/! s/^/|/'";
    private static final String LIST_CMD_SEPERATOR = "\\|";
    private static final String LIST_CMD_PID_COL = "pid";
    private static final String LIST_CMD_PPID_COL = "ppid";
    private static final String LIST_CMD_COMMAND_COL = "command";
    private HeartbeatStatus _serviceStatus = HeartbeatStatus.OK;

    public boolean killProcess(NativeProcessId pid, ImmutableSet<NativeProcessId> childProcessIds) {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CommandLine cmdLine = new CommandLine(KILL.getCommand());
        cmdLine.addArguments(KILL.getArgumentsArray());
        for (NativeProcessId childPid : childProcessIds) {
            cmdLine.addArguments("" + childPid.getNativePid());
        }
        cmdLine.addArguments("" + pid.getNativePid());
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(1);
        DefaultExecuteResultHandler derh = new DefaultExecuteResultHandler();
        executor.setProcessDestroyer((ProcessDestroyer)PROCESS_SHUTDOWN_HOOK);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)out, (OutputStream)err));
        try {
            LOG.debug("Kill process '{}' with signal 15.", (Object)pid.getNativePid());
            executor.execute(cmdLine, (ExecuteResultHandler)derh);
            derh.waitFor();
            this._serviceStatus = HeartbeatStatus.OK;
            return true;
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Error sending kill signal to process '" + pid.getNativePid() + "'.", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
            return false;
        }
    }

    public List<NativeProcessData> getProcessList() {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CommandLine cmdLine = new CommandLine("/bin/sh");
        cmdLine.addArguments("-c");
        cmdLine.addArguments("\"ps -eo pid,ppid,command |  tr -s ' ' | sed 's/ /|/;s/ /|/;s/ /|/;' | sed '/^|/! s/^/|/'\"", false);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(1);
        DefaultExecuteResultHandler derh = new DefaultExecuteResultHandler();
        executor.setProcessDestroyer((ProcessDestroyer)PROCESS_SHUTDOWN_HOOK);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)out, (OutputStream)err));
        try {
            LOG.debug("execute ps -eo pid,ppid,command |  tr -s ' ' | sed 's/ /|/;s/ /|/;s/ /|/;' | sed '/^|/! s/^/|/'");
            executor.execute(cmdLine, (ExecuteResultHandler)derh);
            derh.waitFor();
            this._serviceStatus = HeartbeatStatus.OK;
        }
        catch (IOException | InterruptedException e) {
            LOG.error("error on ps -eo pid,ppid,command |  tr -s ' ' | sed 's/ /|/;s/ /|/;s/ /|/;' | sed '/^|/! s/^/|/'", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        return this.parseProcessList(out);
    }

    @Nonnull
    protected List<NativeProcessData> parseProcessList(ByteArrayOutputStream out) {
        String filteredText = out.toString(Charset.defaultCharset()).replace('\r', '\n');
        ArrayList<NativeProcessData> result = new ArrayList<NativeProcessData>();
        String[] lines = filteredText.split("\n");
        boolean header = true;
        int pidCol = 0;
        int parentPidCol = 0;
        int cmdCol = 0;
        int expectedColCount = 0;
        for (String line : lines) {
            String[] columns;
            if (header) {
                columns = line.split(LIST_CMD_SEPERATOR);
                int idx = 0;
                for (String column : columns) {
                    String headerName = column.toLowerCase(Locale.US).trim();
                    if (headerName.equals(LIST_CMD_PPID_COL.toLowerCase(Locale.US).trim())) {
                        parentPidCol = idx;
                        header = false;
                    } else if (headerName.equals(LIST_CMD_PID_COL.toLowerCase(Locale.US).trim())) {
                        pidCol = idx;
                        header = false;
                    } else if (headerName.equals(LIST_CMD_COMMAND_COL.toLowerCase(Locale.US).trim())) {
                        cmdCol = idx;
                        header = false;
                    }
                    ++idx;
                }
                if (header) continue;
                expectedColCount = idx;
                continue;
            }
            columns = this.readProcessListLine(line, expectedColCount, cmdCol);
            if (columns.length == expectedColCount) {
                NativeProcessData data = this.getNativeProcessdata(columns, pidCol, parentPidCol, cmdCol);
                if (data != null) {
                    result.add(data);
                    continue;
                }
                LOG.error("could not parse pids from process : " + line);
                this._serviceStatus = HeartbeatStatus.ERROR;
                continue;
            }
            LOG.error("could not parse process from list : " + line);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        return result;
    }

    @Nonnull
    private String[] readProcessListLine(String line, int expectedColCount, int cmdCol) {
        String[] columns = line.split(LIST_CMD_SEPERATOR);
        int extraCommandCols = columns.length - expectedColCount;
        if (extraCommandCols <= 0) {
            return columns;
        }
        String[] adjustedColumns = new String[expectedColCount];
        for (int idx = 0; idx < adjustedColumns.length; ++idx) {
            if (idx < cmdCol) {
                adjustedColumns[idx] = columns[idx];
                continue;
            }
            if (idx == cmdCol) {
                adjustedColumns[idx] = columns[idx];
                for (int i = 1; i < extraCommandCols; ++i) {
                    int n = idx;
                    adjustedColumns[n] = adjustedColumns[n] + LIST_CMD_SEPERATOR + columns[idx + i];
                }
                continue;
            }
            adjustedColumns[idx] = columns[idx + extraCommandCols];
        }
        return adjustedColumns;
    }

    @CheckForNull
    private NativeProcessData getNativeProcessdata(String[] columns, int pidCol, int parentPidCol, int cmdCol) {
        NativeProcessId pid = this.getNativeProcessId(columns[pidCol]);
        NativeProcessId parentPid = this.getNativeProcessId(columns[parentPidCol]);
        return pid != null && parentPid != null ? new NativeProcessData(pid, parentPid, columns[cmdCol]) : null;
    }

    @CheckForNull
    private NativeProcessId getNativeProcessId(String stringValue) {
        try {
            long parsedProcessId = Long.parseLong(stringValue.replaceAll(" ", ""));
            return new NativeProcessId(parsedProcessId);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public HeartbeatStatus getStatus() {
        return this._serviceStatus;
    }

    public String getName() {
        return "process manager";
    }
}

