/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.presentation.rest;

import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentInfo;
import de.justsoftware.jdoc.presentation.util.ExternalMessageFactory;
import de.justsoftware.jdoc.presentation.util.ExternalMessageReader;
import de.justsoftware.jdoc.rest.exceptions.DocumentRepositoryAPIException;
import de.justsoftware.jdoc.rest.model.ExternalServiceInfo;
import de.justsoftware.jdoc.rest.model.message.DocumentStatusResponse;
import de.justsoftware.jdoc.rest.service.server.DocumentApiController;
import de.justsoftware.jdoc.rest.service.shared.JustDocumentsApiService;
import de.justsoftware.jdoc.services.TempFileService;
import de.justsoftware.jdoc.services.business.DocumentService;
import de.justsoftware.jdoc.services.exceptions.DocumentNotFoundException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DocumentApiControllerImpl
implements DocumentApiController,
JustDocumentsApiService {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentApiControllerImpl.class);
    @Autowired
    private DocumentService _service;
    @Autowired
    private TempFileService _tempFileService;

    public DocumentStatusResponse status(@RequestParam(value="documentId") String documentIdString) throws DocumentRepositoryAPIException {
        return ExternalMessageFactory.createDocumentStatusResponse((DocumentInfo)this._service.getDocumentInfo(ExternalMessageReader.getDocumentId((String)"documentId", (String)documentIdString)));
    }

    public void deletePreviewSources() {
        LOG.info("Deleting all preview sources.");
        this._tempFileService.cleanUpAllSources();
    }

    public void deleteAll(List<DocumentId> documentIdString) {
        for (DocumentId documentId : documentIdString) {
            try {
                LOG.info("Delete document with id '{}'.", (Object)documentId);
                this._service.deleteDocument(documentId);
            }
            catch (DocumentNotFoundException e) {
                LOG.info("Can't find document '{}' to delete.", (Object)documentId);
            }
            catch (DocumentReadWriteException e) {
                LOG.error("Error deleting document '" + documentId + "'.", (Throwable)e);
            }
        }
    }

    public ExternalServiceInfo getServiceInfo() {
        return ExternalMessageFactory.createServiceInfo((String)"Document Manager", (boolean)true, (String)"2.0", (String)"/api/v1/document");
    }
}

