/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.persistence.ChatMessageAttachmentSpecifications;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J:\u0010\n\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00040\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J \u0010\f\u001a\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\r2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\rH\u0002J\u0016\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\rH\u0002J\u0016\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\rH\u0002\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageAttachmentSpecifications;", "", "()V", "attachmentMimeTypePath", "Ljakarta/persistence/criteria/Path;", "", "kotlin.jvm.PlatformType", "root", "Ljakarta/persistence/criteria/Root;", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "chatIdPath", "Ljava/util/UUID;", "withAttachmentType", "Lorg/springframework/data/jpa/domain/Specification;", "filter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "withChatId", "chatId", "withImageAttachment", "withMediaAttachment", "withVideoAttachment", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageAttachmentSpecifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageAttachmentSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageAttachmentSpecifications\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1855#3,2:60\n*S KotlinDebug\n*F\n+ 1 ChatMessageAttachmentSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageAttachmentSpecifications\n*L\n47#1:60,2\n*E\n"})
public final class ChatMessageAttachmentSpecifications {
    @NotNull
    public static final ChatMessageAttachmentSpecifications INSTANCE = new ChatMessageAttachmentSpecifications();

    private ChatMessageAttachmentSpecifications() {
    }

    @NotNull
    public final Specification<DbChatMessageAttachment> withChatId(@NotNull UUID chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return (arg_0, arg_1, arg_2) -> ChatMessageAttachmentSpecifications.withChatId$lambda$0(chatId, arg_0, arg_1, arg_2);
    }

    @Nullable
    public final Specification<DbChatMessageAttachment> withAttachmentType(@Nullable AttachmentFilter filter) {
        AttachmentFilter attachmentFilter = filter;
        return switch (attachmentFilter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[attachmentFilter.ordinal()]) {
            case 1 -> this.withImageAttachment();
            case 2 -> this.withVideoAttachment();
            case 3 -> this.withMediaAttachment();
            case 4 -> Specification.not((Specification)this.withMediaAttachment());
            case 5 -> null;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Specification<DbChatMessageAttachment> withImageAttachment() {
        return ChatMessageAttachmentSpecifications::withImageAttachment$lambda$1;
    }

    private final Specification<DbChatMessageAttachment> withVideoAttachment() {
        return ChatMessageAttachmentSpecifications::withVideoAttachment$lambda$2;
    }

    private final Specification<DbChatMessageAttachment> withMediaAttachment() {
        return ChatMessageAttachmentSpecifications::withMediaAttachment$lambda$4;
    }

    private final Path<String> attachmentMimeTypePath(Root<DbChatMessageAttachment> root) {
        return root.get("mimeType");
    }

    private final Path<UUID> chatIdPath(Root<DbChatMessageAttachment> root) {
        return root.join("chatMessage").get("chatId");
    }

    private static final Predicate withChatId$lambda$0(UUID $chatId, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        Path chatIdPath = INSTANCE.chatIdPath(root);
        Order[] orderArray = new Order[]{criteriaBuilder.desc((Expression)root.get("createdAt"))};
        criteriaQuery.orderBy(orderArray);
        return criteriaBuilder.equal((Expression)chatIdPath, (Object)$chatId);
    }

    private static final Predicate withImageAttachment$lambda$1(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        return INSTANCE.attachmentMimeTypePath(root).in((Collection)ChatMessageService.Companion.getIMAGE_FORMATS());
    }

    private static final Predicate withVideoAttachment$lambda$2(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        return criteriaBuilder.like((Expression)INSTANCE.attachmentMimeTypePath(root), "video/%");
    }

    private static final Predicate withMediaAttachment$lambda$4(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        CriteriaBuilder.In in;
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        CriteriaBuilder.In $this$withMediaAttachment_u24lambda_u244_u24lambda_u243 = in = criteriaBuilder.in((Expression)mimeTypePath);
        boolean bl = false;
        Iterable $this$forEach$iv = ChatMessageService.Companion.getIMAGE_FORMATS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl2 = false;
            $this$withMediaAttachment_u24lambda_u244_u24lambda_u243.value((Object)p0);
        }
        CriteriaBuilder.In imagePredicate = in;
        Predicate videoPredicate = criteriaBuilder.like((Expression)mimeTypePath, "video/%");
        Predicate[] predicateArray = new Predicate[]{imagePredicate, videoPredicate};
        return criteriaBuilder.or(predicateArray);
    }
}

