/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.kafka.KafkaConfiguration;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.KafkaProfileSerde;
import de.justsoftware.chat.kafka.KafkaPubSubOperationSerde;
import de.justsoftware.chat.kafka.KafkaUserGroupSerde;
import de.justsoftware.chat.kafka.model.KafkaProfile;
import de.justsoftware.chat.kafka.model.KafkaPubSubOperation;
import de.justsoftware.chat.kafka.model.KafkaUserGroup;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@DependsOn(value={"liquibase"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b2\b\b\u0001\u0010\t\u001a\u00020\u00052\b\b\u0001\u0010\n\u001a\u00020\u0005H\u0017J(\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b2\b\b\u0001\u0010\t\u001a\u00020\u00052\b\b\u0001\u0010\n\u001a\u00020\u0005H\u0017J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rH\u0017J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0012Ja\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\b\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00132\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0012\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u000fH\u0012J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001a0\bH\u0017J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\bH\u0017J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\bH\u0017J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/chat/kafka/KafkaConfiguration;", "", "bootstrapServers", "", "defaultMaxChunkSize", "", "(Ljava/lang/String;I)V", "chatCoreSearchUpdateIndexConsumerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "maxChunkSize", "maxTimeout", "commonCoreSearchUpdateIndexConsumerFactory", "createStringProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "defaultConsumerConfig", "Ljava/util/Properties;", "groupId", "defaultKafkaListenerContainerFactory", "K", "V", "keyDeserializer", "Lorg/apache/kafka/common/serialization/Deserializer;", "valueDeserializer", "(Ljava/lang/String;Lorg/apache/kafka/common/serialization/Deserializer;Lorg/apache/kafka/common/serialization/Deserializer;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "defaultProducerConfig", "profileConsumerFactory", "Lde/justsoftware/chat/kafka/model/KafkaProfile;", "pubSubOperationConsumerFactory", "Lde/justsoftware/chat/kafka/model/KafkaPubSubOperation;", "userGroupConsumerFactory", "Lde/justsoftware/chat/kafka/model/KafkaUserGroup;", "userGroupMembersConsumerFactory", "ClosingKafkaProducer", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nKafkaConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaConfiguration.kt\nde/justsoftware/chat/kafka/KafkaConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TimeUtils.kt\nde/justsoftware/chat/util/TimeUtilsKt\n*L\n1#1,155:1\n1#2:156\n17#3:157\n16#3:158\n*S KotlinDebug\n*F\n+ 1 KafkaConfiguration.kt\nde/justsoftware/chat/kafka/KafkaConfiguration\n*L\n129#1:157\n129#1:158\n*E\n"})
public class KafkaConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    private final int defaultMaxChunkSize;
    @NotNull
    public static final String KAFKA_STRING_PRODUCER = "KAFKA_STRING_PRODUCER";

    public KafkaConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers, @Value(value="${kafka.consumer-max-chunk-size:100}") int defaultMaxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
        this.defaultMaxChunkSize = defaultMaxChunkSize;
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, String> commonCoreSearchUpdateIndexConsumerFactory(@Value(value="${kafka.update-search-index.common.chunk-size:100}") int maxChunkSize, @Value(value="${kafka.update-search-index.common.timeout:500}") int maxTimeout) {
        return this.defaultKafkaListenerContainerFactory("just.chat-service.search.common.updateIndexConsumer", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), Integer.valueOf(maxChunkSize), Integer.valueOf(maxTimeout));
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, String> chatCoreSearchUpdateIndexConsumerFactory(@Value(value="${kafka.update-search-index.chat.chunk-size:10}") int maxChunkSize, @Value(value="${kafka.update-search-index.chat.timeout:500}") int maxTimeout) {
        return this.defaultKafkaListenerContainerFactory("just.chat-service.search.chat.updateIndexConsumer", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), Integer.valueOf(maxChunkSize), Integer.valueOf(maxTimeout));
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, KafkaPubSubOperation> pubSubOperationConsumerFactory() {
        return KafkaConfiguration.defaultKafkaListenerContainerFactory$default((KafkaConfiguration)this, (String)"just.chat-service.pubSubOperationConsumer", (Deserializer)((Deserializer)new StringDeserializer()), (Deserializer)((Deserializer)new KafkaPubSubOperationSerde((ObjectMapper)KafkaObjectMapper.INSTANCE)), (Integer)1, null, (int)16, null);
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, KafkaProfile> profileConsumerFactory() {
        return KafkaConfiguration.defaultKafkaListenerContainerFactory$default((KafkaConfiguration)this, (String)"just.chat-service.profileConsumer", (Deserializer)((Deserializer)new StringDeserializer()), (Deserializer)((Deserializer)new KafkaProfileSerde((ObjectMapper)KafkaObjectMapper.INSTANCE)), null, null, (int)24, null);
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, KafkaUserGroup> userGroupConsumerFactory() {
        return KafkaConfiguration.defaultKafkaListenerContainerFactory$default((KafkaConfiguration)this, (String)"just.chat-service.userGroupConsumer", (Deserializer)((Deserializer)new StringDeserializer()), (Deserializer)((Deserializer)new KafkaUserGroupSerde((ObjectMapper)KafkaObjectMapper.INSTANCE)), null, null, (int)24, null);
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, String> userGroupMembersConsumerFactory() {
        return KafkaConfiguration.defaultKafkaListenerContainerFactory$default((KafkaConfiguration)this, (String)"just.chat-service.userGroupMembersConsumer", (Deserializer)((Deserializer)new StringDeserializer()), (Deserializer)((Deserializer)new StringDeserializer()), null, null, (int)24, null);
    }

    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, String> createStringProducer() {
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(this.defaultProducerConfig()), arg_0 -> KafkaConfiguration.createStringProducer$lambda$0(this, arg_0));
    }

    private Properties defaultConsumerConfig(String groupId) {
        Properties properties;
        block0: {
            String string;
            Properties $this$defaultConsumerConfig_u24lambda_u242 = properties = new Properties();
            boolean bl = false;
            $this$defaultConsumerConfig_u24lambda_u242.put("bootstrap.servers", this.bootstrapServers);
            $this$defaultConsumerConfig_u24lambda_u242.put("enable.auto.commit", "false");
            $this$defaultConsumerConfig_u24lambda_u242.put("auto.offset.reset", "earliest");
            $this$defaultConsumerConfig_u24lambda_u242.put("max.poll.records", (Object)this.defaultMaxChunkSize);
            String string2 = groupId;
            if (string2 == null) break block0;
            String $this$defaultConsumerConfig_u24lambda_u242_u24lambda_u241 = string = string2;
            boolean bl2 = false;
            $this$defaultConsumerConfig_u24lambda_u242.put("group.id", groupId);
        }
        return properties;
    }

    private Properties defaultProducerConfig() {
        Properties properties;
        Properties $this$defaultProducerConfig_u24lambda_u243 = properties = new Properties();
        boolean bl = false;
        $this$defaultProducerConfig_u24lambda_u243.put("bootstrap.servers", this.bootstrapServers);
        $this$defaultProducerConfig_u24lambda_u243.put("acks", "all");
        $this$defaultProducerConfig_u24lambda_u243.put("retries", (Object)0);
        $this$defaultProducerConfig_u24lambda_u243.put("batch.size", (Object)16384);
        $this$defaultProducerConfig_u24lambda_u243.put("linger.ms", (Object)1);
        $this$defaultProducerConfig_u24lambda_u243.put("buffer.memory", (Object)0x2000000);
        return properties;
    }

    private <K, V> ConcurrentKafkaListenerContainerFactory<K, V> defaultKafkaListenerContainerFactory(String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Integer maxChunkSize, Integer maxTimeout) {
        ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory;
        ConcurrentKafkaListenerContainerFactory $this$defaultKafkaListenerContainerFactory_u24lambda_u246 = concurrentKafkaListenerContainerFactory = new ConcurrentKafkaListenerContainerFactory();
        boolean bl = false;
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
        int $this$hours$iv = 1;
        boolean $i$f$getHours = false;
        long $this$hours$iv$iv = $this$hours$iv;
        boolean $i$f$getHours2 = false;
        Duration duration = Duration.ofHours($this$hours$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(this)");
        exponentialBackOff.setMaxElapsedTime(duration.toMillis());
        Properties properties = this.defaultConsumerConfig(groupId);
        Intrinsics.checkNotNull((Object)properties, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any?>");
        Map config = TypeIntrinsics.asMutableMap((Object)properties);
        Integer n = maxChunkSize;
        if (n != null) {
            Integer n2 = n;
            int $this$defaultKafkaListenerContainerFactory_u24lambda_u246_u24lambda_u244 = ((Number)n2).intValue();
            boolean bl2 = false;
            config.put("max.poll.records", maxChunkSize);
        }
        Integer n3 = maxTimeout;
        if (n3 != null) {
            Integer n4 = n3;
            int $this$defaultKafkaListenerContainerFactory_u24lambda_u246_u24lambda_u245 = ((Number)n4).intValue();
            boolean bl3 = false;
            config.put("fetch.max.wait.ms", maxTimeout);
        }
        $this$defaultKafkaListenerContainerFactory_u24lambda_u246.setBatchListener(Boolean.valueOf(true));
        $this$defaultKafkaListenerContainerFactory_u24lambda_u246.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)exponentialBackOff));
        $this$defaultKafkaListenerContainerFactory_u24lambda_u246.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(config, (Deserializer)new ErrorHandlingDeserializer(keyDeserializer), (Deserializer)new ErrorHandlingDeserializer(valueDeserializer)));
        return concurrentKafkaListenerContainerFactory;
    }

    static /* synthetic */ ConcurrentKafkaListenerContainerFactory defaultKafkaListenerContainerFactory$default(KafkaConfiguration kafkaConfiguration, String string, Deserializer deserializer, Deserializer deserializer2, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: defaultKafkaListenerContainerFactory");
        }
        if ((n3 & 8) != 0) {
            n = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        return kafkaConfiguration.defaultKafkaListenerContainerFactory(string, deserializer, deserializer2, n, n2);
    }

    private static final Consumer createStringProducer$lambda$0(KafkaConfiguration this$0, TopicPartition topicPartition) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)topicPartition, (Properties)this$0.defaultConsumerConfig(null));
    }
}

