/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.config.CommonConfigProperties;
import de.justsoftware.chat.config.JunoClientConfiguration;
import de.justsoftware.chat.mobile.service.JunoRestClientService;
import io.netty.channel.ChannelOption;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.ClientTransport;

@Configuration
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/chat/config/JunoClientConfiguration;", "", "()V", "junoApnsRestClient", "Lde/justsoftware/chat/mobile/service/JunoRestClientService;", "junoBasePathApns", "", "junoHttpClient", "Lreactor/netty/http/client/HttpClient;", "commonConfigProperties", "Lde/justsoftware/chat/config/CommonConfigProperties;", "junoFcmRestClient", "junoBasePathFcm", "Companion", "chat-service"})
public class JunoClientConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long TIMEOUT_SECONDS = 60L;

    @Bean
    @NotNull
    public HttpClient junoHttpClient() {
        ClientTransport clientTransport = ((HttpClient)((HttpClient)HttpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)60000)).responseTimeout(Duration.ofSeconds(60L)).proxyWithSystemProperties()).doOnConnected(arg_0 -> JunoClientConfiguration.junoHttpClient$lambda$0((Function1)junoHttpClient.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"create()\n            .op\u2026t.SECONDS))\n            }");
        return (HttpClient)clientTransport;
    }

    @Bean
    @NotNull
    public JunoRestClientService junoApnsRestClient(@Value(value="${just.juno.baseurl.apns}") @NotNull String junoBasePathApns, @NotNull HttpClient junoHttpClient2, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathApns, (String)"junoBasePathApns");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient2, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathApns + "/v1", junoHttpClient2, commonConfigProperties);
    }

    @Bean
    @NotNull
    public JunoRestClientService junoFcmRestClient(@Value(value="${just.juno.baseurl.fcm}") @NotNull String junoBasePathFcm, @NotNull HttpClient junoHttpClient2, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathFcm, (String)"junoBasePathFcm");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient2, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathFcm + "/v1", junoHttpClient2, commonConfigProperties);
    }

    private static final void junoHttpClient$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

