/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.model.ParticipantDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.ProfileParticipantDto;
import de.justsoftware.chat.application.model.UserGroupDto;
import de.justsoftware.chat.application.model.UserGroupParticipantDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0012J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/chat/application/ChatParticipantApplicationService;", "", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "(Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/UserGroupService;)V", "findParticipantsForChatId", "", "Lde/justsoftware/chat/application/model/ParticipantDto;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "getParticipants", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "leaveChat", "", "setParticipants", "newParticipants", "", "Lde/justsoftware/chat/model/ParticipantId;", "Lde/justsoftware/chat/model/PermissionType;", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatParticipantApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatParticipantApplicationService.kt\nde/justsoftware/chat/application/ChatParticipantApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,90:1\n1194#2,2:91\n1222#2,4:93\n809#2,2:98\n809#2,2:101\n22#3:97\n22#3:100\n16#3:103\n152#4,3:104\n*S KotlinDebug\n*F\n+ 1 ChatParticipantApplicationService.kt\nde/justsoftware/chat/application/ChatParticipantApplicationService\n*L\n70#1:91,2\n70#1:93,4\n71#1:98,2\n72#1:101,2\n71#1:97\n72#1:100\n77#1:103\n77#1:104,3\n*E\n"})
public class ChatParticipantApplicationService {
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;

    public ChatParticipantApplicationService(@NotNull ChatParticipantService chatParticipantService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService) {
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        this.chatParticipantService = chatParticipantService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
    }

    @Transactional
    @NotNull
    public Set<ParticipantDto> getParticipants(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        return this.findParticipantsForChatId(chatId);
    }

    @Transactional
    @NotNull
    public Set<ParticipantDto> setParticipants(@NotNull ChatId chatId, @NotNull Map<ParticipantId, ? extends PermissionType> newParticipants, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(newParticipants, (String)"newParticipants");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageOrTempManageChat(chatId);
        ChatParticipantService.setParticipants$default((ChatParticipantService)this.chatParticipantService, (ChatId)chatId, newParticipants, (ProfileId)authContext.getProfileId(), (boolean)false, (int)8, null);
        return this.findParticipantsForChatId(chatId);
    }

    public void leaveChat(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatParticipantService.leaveChat(chatId, authContext.getProfileId());
    }

    /*
     * WARNING - void declaration
     */
    private Set<ParticipantDto> findParticipantsForChatId(ChatId chatId) {
        void $this$mapTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.chatParticipantService.findByChatId(chatId);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(p0.getParticipantId(), element$iv$iv);
        }
        Map participants = destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv = participants.keySet();
        boolean $i$f$filterIsInstanceToSet = false;
        $this$associateByTo$iv$iv = $this$filterIsInstanceToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv2 = participants.keySet();
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set groupIds = (Set)destination$iv$iv2;
        Map profilePermissions = this.profileService.findByIds(profileIds);
        Map groupPermissions = this.userGroupService.findByIds(groupIds);
        Map $this$mapToSet$iv = participants;
        boolean $i$f$mapToSet = false;
        Map $i$f$filterIsInstanceTo22 = $this$mapToSet$iv;
        Collection destination$iv$iv3 = new LinkedHashSet($this$mapToSet$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ParticipantDto participantDto;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv3;
            boolean bl = false;
            ParticipantId participantId = (ParticipantId)entry.getKey();
            ChatParticipant participant = (ChatParticipant)entry.getValue();
            ParticipantId participantId2 = participantId;
            if (participantId2 instanceof ProfileId) {
                Object v = profilePermissions.get(participantId);
                if (v == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                participantDto = (ParticipantDto)ProfileParticipantDto.Companion.toProfileParticipantDto(ProfileDto.Companion.toProfileDto((Profile)v), participant);
            } else if (participantId2 instanceof UserGroupId) {
                Object v = groupPermissions.get(participantId);
                if (v == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                participantDto = (ParticipantDto)UserGroupParticipantDto.Companion.toUserGroupParticipantDto(UserGroupDto.Companion.toUserGroupDto((UserGroup)v), participant);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object.add(participantDto);
        }
        return (Set)destination$iv$iv3;
    }
}

