/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.ChatMessageApplicationService;
import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.SaveChatMessageDto;
import de.justsoftware.chat.application.model.SavePersonMentionDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatLocalizationService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatMessageReaction;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.PagingUtilsKt;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 12\u00020\u0001:\u00011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"H\u0012J*\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010$\u001a\u00020%H\u0016JF\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lde/justsoftware/chat/application/ChatMessageApplicationService;", "", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatLocalizationService", "Lde/justsoftware/chat/business/ChatLocalizationService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatLocalizationService;Lde/justsoftware/chat/business/ProfileService;Ljava/time/Clock;)V", "createChatMessage", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "saveChatMessageDto", "Lde/justsoftware/chat/application/model/SaveChatMessageDto;", "attachments", "", "Lorg/springframework/web/multipart/MultipartFile;", "savePersonMentionDtos", "Lde/justsoftware/chat/application/model/SavePersonMentionDto;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "deleteChatMessage", "", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "deleteReaction", "findProfileDtos", "", "Lde/justsoftware/chat/model/ProfileId;", "Lde/justsoftware/chat/application/model/ProfileDto;", "profileIds", "", "getChatMessage", "includeCitation", "", "getMessages", "Lorg/springframework/data/domain/Page;", "offsetMessageId", "limit", "", "loadDirection", "Lde/justsoftware/chat/business/LoadDirection;", "includeOffsetMessage", "react", "reaction", "", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageApplicationService.kt\nde/justsoftware/chat/application/ChatMessageApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,204:1\n1549#2:205\n1620#2,3:206\n1611#2:211\n1855#2:212\n1856#2:214\n1612#2:215\n1620#2,3:217\n1611#2:221\n1855#2:222\n1856#2:224\n1612#2:225\n1549#2:229\n1620#2,3:230\n1238#2,4:238\n1#3:209\n1#3:213\n1#3:223\n10#4:210\n7#4:216\n10#4:220\n19#4:226\n96#5,2:227\n98#5,3:233\n442#6:236\n392#6:237\n*S KotlinDebug\n*F\n+ 1 ChatMessageApplicationService.kt\nde/justsoftware/chat/application/ChatMessageApplicationService\n*L\n54#1:205\n54#1:206,3\n107#1:211\n107#1:212\n107#1:214\n107#1:215\n109#1:217,3\n110#1:221\n110#1:222\n110#1:224\n110#1:225\n111#1:229\n111#1:230,3\n189#1:238,4\n107#1:213\n110#1:223\n107#1:210\n109#1:216\n110#1:220\n111#1:226\n111#1:227,2\n111#1:233,3\n189#1:236\n189#1:237\n*E\n"})
public class ChatMessageApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatLocalizationService chatLocalizationService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Set<String> ALLOWED_REACTIONS;

    public ChatMessageApplicationService(@NotNull ChatMessageService chatMessageService, @NotNull ChatLocalizationService chatLocalizationService, @NotNull ProfileService profileService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatLocalizationService, (String)"chatLocalizationService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatMessageService = chatMessageService;
        this.chatLocalizationService = chatLocalizationService;
        this.profileService = profileService;
        this.clock = clock;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ChatMessageDto createChatMessage(@NotNull ChatId chatId, @NotNull SaveChatMessageDto saveChatMessageDto, @NotNull List<? extends MultipartFile> attachments, @NotNull List<SavePersonMentionDto> savePersonMentionDtos, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException, NotFoundException {
        ChatMessageDto chatMessageDto;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)saveChatMessageDto, (String)"saveChatMessageDto");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(savePersonMentionDtos, (String)"savePersonMentionDtos");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteChat(chatId);
        Iterable $this$map$iv = savePersonMentionDtos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SavePersonMentionDto savePersonMentionDto = (SavePersonMentionDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SavePersonMentionDto.Companion.toPersonMention((SavePersonMentionDto)it, this.clock));
        }
        List personMentions = (List)destination$iv$iv;
        ChatMessage chatMessage = this.chatMessageService.create((ChatMessage)SaveChatMessageDto.Companion.toUserMessage(saveChatMessageDto, chatId, authContext.getProfileId(), this.clock, personMentions), attachments);
        ChatMessageId chatMessageId = saveChatMessageDto.getCitedMessageId();
        if (chatMessageId != null) {
            ChatMessageId it = chatMessageId;
            boolean bl = false;
            chatMessageDto = ChatMessageApplicationService.getChatMessage$default((ChatMessageApplicationService)this, (ChatId)chatId, (ChatMessageId)it, (AuthorizationContext)authContext, (boolean)false, (int)8, null);
        } else {
            chatMessageDto = null;
        }
        ChatMessageDto citation = chatMessageDto;
        return ChatMessageDto.Companion.toChatMessageDto$default((ChatMessageDto.Companion)ChatMessageDto.Companion, (ChatMessage)chatMessage, (ProfileDto)ProfileDto.Companion.toProfileDto(this.profileService.getById(chatMessage.getAuthor())), (String)this.chatLocalizationService.localizeMessage(chatMessage, authContext), (ChatMessageDto)citation, null, (int)8, null);
    }

    public void deleteChatMessage(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatMessageService.delete(chatMessageId, authContext.getProfileId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatMessageDto> getMessages(@NotNull ChatId chatId, @Nullable ChatMessageId offsetMessageId, int limit, @NotNull LoadDirection loadDirection, boolean includeOffsetMessage, @NotNull AuthorizationContext authContext) {
        void $this$flatMapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullToSet$iv;
        ChatMessage offsetMessage;
        Object p0;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageId chatMessageId = offsetMessageId;
        if (chatMessageId != null) {
            ChatMessageId chatMessageId2 = chatMessageId;
            ChatMessageService chatMessageService = this.chatMessageService;
            p0 = chatMessageId2;
            boolean bl = false;
            v1 = chatMessageService.getById(p0);
        } else {
            v1 = offsetMessage = null;
        }
        if (offsetMessage != null && !Intrinsics.areEqual((Object)offsetMessage.getChatId(), (Object)chatId)) {
            throw new NotFoundException("Message " + offsetMessageId + " is not found in chat " + chatId);
        }
        ChatMessage chatMessage = offsetMessage;
        Page messages2 = ChatMessageService.getMessages$default((ChatMessageService)this.chatMessageService, (ChatId)chatId, (int)limit, (LoadDirection)loadDirection, (Instant)(chatMessage != null ? chatMessage.getCreatedAt() : null), null, (int)16, null);
        if (includeOffsetMessage && offsetMessage != null) {
            messages2 = PagingUtilsKt.addFirst((Page)messages2, (Object)offsetMessage);
        }
        List list = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"messages.content");
        p0 = list;
        ChatMessageService chatMessageService = this.chatMessageService;
        boolean $i$f$mapNotNullToSet22 = false;
        void var12_14 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatMessageId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatMessage it = (ChatMessage)element$iv$iv;
            boolean bl2 = false;
            UserMessage userMessage = it instanceof UserMessage ? (UserMessage)it : null;
            if ((userMessage != null ? userMessage.getCitedMessageId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map citations = chatMessageService.findByIds((Set)destination$iv$iv);
        List list2 = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"messages.content");
        Iterable $i$f$mapNotNullToSet22 = list2;
        chatMessageService = this.chatMessageService;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map reactions2 = chatMessageService.getReactions((Iterable)((Set)destination$iv$iv2));
        List list3 = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"messages.content");
        Iterable $this$mapNotNullToSet$iv2 = CollectionsKt.plus((Collection)list3, (Iterable)citations.values());
        boolean $i$f$mapNotNullToSet = false;
        destination$iv$iv2 = $this$mapNotNullToSet$iv2;
        Object destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv2));
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator bl = $this$forEach$iv$iv$iv2.iterator();
        while (bl.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = bl.next();
            boolean bl4 = false;
            ChatMessage p02 = (ChatMessage)element$iv$iv;
            boolean bl5 = false;
            if (p02.getAuthor() == null) continue;
            boolean bl6 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Set messageProfileIds = (Set)destination$iv$iv3;
        Map $this$flatMapToSet$iv = reactions2;
        boolean $i$f$flatMapToSet = false;
        destination$iv$iv3 = $this$flatMapToSet$iv;
        Collection destination$iv$iv4 = new LinkedHashSet($this$flatMapToSet$iv.size());
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl7 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable bl5 = $this$map$iv;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p03;
                ChatMessageReaction chatMessageReaction = (ChatMessageReaction)item$iv$iv;
                Collection collection = destination$iv$iv5;
                boolean bl8 = false;
                collection.add(p03.getAuthorId());
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        Set reactionProfileIds = (Set)destination$iv$iv4;
        Map profileDtos = this.findProfileDtos(SetsKt.plus((Set)messageProfileIds, (Iterable)reactionProfileIds));
        Page page = messages2.map(arg_0 -> ChatMessageApplicationService.getMessages$lambda$7((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"fun getMessages(\n       \u2026    )\n            }\n    }");
        return page;
    }

    public static /* synthetic */ Page getMessages$default(ChatMessageApplicationService chatMessageApplicationService, ChatId chatId, ChatMessageId chatMessageId, int n, LoadDirection loadDirection, boolean bl, AuthorizationContext authorizationContext, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 2) != 0) {
            chatMessageId = null;
        }
        if ((n2 & 8) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return chatMessageApplicationService.getMessages(chatId, chatMessageId, n, loadDirection, bl, authorizationContext);
    }

    @NotNull
    public ChatMessageDto getChatMessage(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext, boolean includeCitation) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageDto chatMessageDto = this.chatMessageService.findById(chatMessageId).filter(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$8((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).map(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$9((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).orElseThrow(() -> ChatMessageApplicationService.getChatMessage$lambda$10(chatMessageId, chatId));
        Intrinsics.checkNotNullExpressionValue((Object)chatMessageDto, (String)"fun getChatMessage(\n    \u2026or chat $chatId\") }\n    }");
        return chatMessageDto;
    }

    public static /* synthetic */ ChatMessageDto getChatMessage$default(ChatMessageApplicationService chatMessageApplicationService, ChatId chatId, ChatMessageId chatMessageId, AuthorizationContext authorizationContext, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessage");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return chatMessageApplicationService.getChatMessage(chatId, chatMessageId, authorizationContext, bl);
    }

    @NotNull
    public ChatMessageDto react(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull String reaction, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!ALLOWED_REACTIONS.contains(reaction)) {
            throw new NotAllowedException("Cannot react to messages with the given emoji");
        }
        authContext.checkReadChat(chatId);
        this.chatMessageService.react(chatMessageId, chatId, authContext.getProfileId(), reaction);
        return this.getChatMessage(chatId, chatMessageId, authContext, true);
    }

    @NotNull
    public ChatMessageDto deleteReaction(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatMessageService.deleteReaction(chatMessageId, chatId, authContext.getProfileId());
        return this.getChatMessage(chatId, chatMessageId, authContext, true);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ProfileId, ProfileDto> findProfileDtos(Set<ProfileId> profileIds) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.profileService.findByIds(profileIds);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            ProfileDto profileDto = ProfileDto.Companion.toProfileDto((Profile)it.getValue());
            map3.put(k, profileDto);
        }
        return destination$iv$iv;
    }

    private static final ChatMessageDto getMessages$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessageDto)$tmp0.invoke(p0);
    }

    private static final boolean getChatMessage$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ChatMessageDto getChatMessage$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessageDto)$tmp0.invoke(p0);
    }

    private static final NotFoundException getChatMessage$lambda$10(ChatMessageId $chatMessageId, ChatId $chatId) {
        Intrinsics.checkNotNullParameter((Object)$chatMessageId, (String)"$chatMessageId");
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return new NotFoundException("ChatMessage with id " + $chatMessageId + " does not exist for chat " + $chatId);
    }

    public static final /* synthetic */ ChatLocalizationService access$getChatLocalizationService$p(ChatMessageApplicationService $this) {
        return $this.chatLocalizationService;
    }

    public static final /* synthetic */ ChatMessageService access$getChatMessageService$p(ChatMessageApplicationService $this) {
        return $this.chatMessageService;
    }

    public static final /* synthetic */ Map access$findProfileDtos(ChatMessageApplicationService $this, Set profileIds) {
        return $this.findProfileDtos(profileIds);
    }

    public static final /* synthetic */ Set access$getALLOWED_REACTIONS$cp() {
        return ALLOWED_REACTIONS;
    }

    static {
        Object[] objectArray = new String[]{"\ud83d\udc4d", "\ud83c\udf89", "\ud83d\ude02", "\ud83e\udd29", "\ud83d\ude22", "\ud83d\ude2f", "\u2764\ufe0f", "\ud83d\ude4f"};
        ALLOWED_REACTIONS = SetsKt.setOf((Object[])objectArray);
    }
}

