/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.browserpushservice.config;

import de.justsoftware.browserpushservice.config.SecurityContextHolderArgumentResolver;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.server.WebFilter;

@Configuration
@ParametersAreNonnullByDefault
public class BrowserPushWebConfig
implements WebFluxConfigurer {
    public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
        configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{new SecurityContextHolderArgumentResolver()});
        super.configureArgumentResolvers(configurer);
    }

    @Bean
    @Nonnull
    @Autowired
    public WebFilter contextPathWebFilter(@Value(value="${spring.webflux.base-path}") String basePath) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            if (request.getURI().getPath().startsWith(basePath)) {
                return chain.filter(exchange.mutate().request(request.mutate().contextPath(basePath).build()).build());
            }
            return chain.filter(exchange);
        };
    }
}

