/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.browserpushservice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.justsoftware.browserpushservice.model.SSEMessage;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public enum SSEMessageSerializer {
    INSTANCE;

    private static final ObjectMapper JSON_MAPPER;

    @Nonnull
    public String serialize(SSEMessage message) {
        try {
            return JSON_MAPPER.writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize message", e);
        }
    }

    static {
        JSON_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    }
}

