/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.TrackingSettings;
import de.justsoftware.admin.graphql.generated.types.TrackingSettingsInput;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/TrackingSettingsFetcher;", "", "tenantApplicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "(Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "deactivateTracking", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "editTracking", "input", "Lde/justsoftware/admin/graphql/generated/types/TrackingSettingsInput;", "settings", "Lde/justsoftware/admin/graphql/generated/types/TrackingSettings;", "admin-service"})
public class TrackingSettingsFetcher {
    @NotNull
    private final TenantApplicationService tenantApplicationService;

    public TrackingSettingsFetcher(@NotNull TenantApplicationService tenantApplicationService) {
        Intrinsics.checkNotNullParameter((Object)tenantApplicationService, (String)"tenantApplicationService");
        this.tenantApplicationService = tenantApplicationService;
    }

    @DgsData(parentType="Tenant", field="trackingSettings")
    @Nullable
    public TrackingSettings settings(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        de.justsoftware.admin.domain.tenant.model.TrackingSettings trackingSettings = this.tenantApplicationService.findTrackingSettings(authContext);
        return trackingSettings != null ? ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.TrackingSettings)trackingSettings) : null;
    }

    @DgsMutation(field="upsertTracking")
    @NotNull
    public Tenant editTracking(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TrackingSettingsInput input) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.tenantApplicationService.upsertTrackingSettings(input, authContext);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="deleteTracking")
    @NotNull
    public Tenant deactivateTracking(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.tenantApplicationService.deactivateTracking(authContext);
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }
}

