/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.wiki;

import de.justsoftware.admin.application.web.wiki.WikiSettings;
import de.justsoftware.admin.connector.wiki.WikiAppConnectorException;
import de.justsoftware.admin.id.TenantId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/connector/wiki/WikiAppConnector;", "", "internalUrl", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "getArticleVersionHistoryReadPermission", "Lde/justsoftware/admin/application/web/wiki/WikiSettings$RoleToReadVersionHistory;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "setArticleVersionHistoryReadPermission", "", "role", "admin-service"})
public class WikiAppConnector {
    @NotNull
    private final String internalUrl;
    @NotNull
    private final RestTemplate restTemplate;

    public WikiAppConnector(@Value(value="${just.wiki.internal}") @NotNull String internalUrl, @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)internalUrl, (String)"internalUrl");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.internalUrl = internalUrl;
        this.restTemplate = restTemplate;
    }

    public void setArticleVersionHistoryReadPermission(@NotNull WikiSettings.RoleToReadVersionHistory role, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ResponseEntity it = this.restTemplate.postForEntity(this.internalUrl + "/permissions/article_version_history/" + tenantId + "/" + role, null, Map.class, new Object[0]);
        boolean bl = false;
        if (it.getStatusCode() != HttpStatus.OK) {
            throw new WikiAppConnectorException(it.getStatusCode().toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public WikiSettings.RoleToReadVersionHistory getArticleVersionHistoryReadPermission(@NotNull TenantId tenantId) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        WikiSettings.RoleToReadVersionHistory it = (WikiSettings.RoleToReadVersionHistory)this.restTemplate.getForObject(this.internalUrl + "/permissions/article_version_history/" + tenantId, WikiSettings.RoleToReadVersionHistory.class, new Object[0]);
        boolean bl = false;
        if (it == null) {
            throw new WikiAppConnectorException(null, 1, null);
        }
        return var2_2;
    }
}

