/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.util.TransactionSupport;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.config.ServerConfigService;
import de.justsoftware.admin.domain.appsettings.AppSettingsPermissionService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.deletedtenant.DeletedTenantService;
import de.justsoftware.admin.domain.deletedtenant.model.DeletedTenant;
import de.justsoftware.admin.domain.tenant.TenantInvitationService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.TrackingSettingsService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.domain.tenant.model.TrackingSettings;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.TrackingSettingsInput;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017JL\u0010\"\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0)H\u0012JL\u0010-\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020\u00182\b\b\u0002\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u00020.0)2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0012J\u001a\u00101\u001a\u0004\u0018\u00010\u00182\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020\u001cH\u0016J\u001e\u00104\u001a\b\u0012\u0004\u0012\u0002050)2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u00106\u001a\u0004\u0018\u0001002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00180)2\u0006\u00103\u001a\u00020\u001cH\u0016J\u0010\u00108\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u001cH\u0016J\u0018\u00108\u001a\u00020\u00182\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020\u001cH\u0016J\u001a\u00109\u001a\u0004\u0018\u00010'2\u0006\u0010 \u001a\u00020!2\u0006\u00103\u001a\u00020\u001cH\u0016J\u0018\u0010:\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u00103\u001a\u00020\u001cH\u0016J\"\u0010;\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u00103\u001a\u00020\u001cH\u0017J \u0010>\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010?\u001a\u00020@2\u0006\u00103\u001a\u00020\u001cH\u0017J\"\u0010A\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\b\u0010B\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J4\u0010C\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002050E2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002050E2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J0\u0010G\u001a\u00020\u00182\u0006\u00102\u001a\u00020!2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0018\u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020L2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lde/justsoftware/admin/application/web/TenantApplicationService;", "", "appSettingsPermissionService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;", "deletedTenantService", "Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "tenantInvitationService", "Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "serverConfigService", "Lde/justsoftware/admin/config/ServerConfigService;", "transactionSupport", "Lde/justsoftware/admin/application/util/TransactionSupport;", "trackingSettingsService", "Lde/justsoftware/admin/domain/tenant/TrackingSettingsService;", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/tenant/TenantInvitationService;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/config/ServerConfigService;Lde/justsoftware/admin/application/util/TransactionSupport;Lde/justsoftware/admin/domain/tenant/TrackingSettingsService;)V", "createTenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "name", "", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "deactivateTracking", "", "deleteTenant", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "fetchAndPublishNewTenant", "tenant", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantInvitation", "Lde/justsoftware/admin/domain/tenant/model/TenantInvitation;", "tenantManagers", "", "Lde/justsoftware/admin/id/UserId;", "allAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "fetchAndPublishUpdatedTenant", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "trackingSettings", "Lde/justsoftware/admin/domain/tenant/model/TrackingSettings;", "findOne", "id", "authorizationContext", "findPermissionsBy", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "findTrackingSettings", "getAllTenants", "getOne", "getTenantInvitation", "getTenantSettings", "setLogo", "logoId", "Lde/justsoftware/admin/id/DocumentId;", "setTenantInvitationActive", "isInvitationActive", "", "updateDeeplKey", "deeplKey", "updatePermissions", "adds", "", "removes", "updateTenant", "color", "Lde/justsoftware/admin/model/HexColor;", "upsertTrackingSettings", "input", "Lde/justsoftware/admin/graphql/generated/types/TrackingSettingsInput;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantApplicationService.kt\nde/justsoftware/admin/application/web/TenantApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n1549#2:313\n1620#2,3:314\n1549#2:318\n1620#2,3:319\n1#3:317\n*S KotlinDebug\n*F\n+ 1 TenantApplicationService.kt\nde/justsoftware/admin/application/web/TenantApplicationService\n*L\n105#1:313\n105#1:314,3\n202#1:318\n202#1:319,3\n*E\n"})
public class TenantApplicationService {
    @NotNull
    private final AppSettingsPermissionService appSettingsPermissionService;
    @NotNull
    private final DeletedTenantService deletedTenantService;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final TenantInvitationService tenantInvitationService;
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final ServerConfigService serverConfigService;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final TrackingSettingsService trackingSettingsService;

    public TenantApplicationService(@NotNull AppSettingsPermissionService appSettingsPermissionService, @NotNull DeletedTenantService deletedTenantService, @NotNull TenantService tenantService, @NotNull TenantPermissionService tenantPermissionService, @NotNull TenantInvitationService tenantInvitationService, @NotNull AppSettingsService appSettingsService, @NotNull Publisher publisher, @NotNull ServerConfigService serverConfigService, @NotNull TransactionSupport transactionSupport, @NotNull TrackingSettingsService trackingSettingsService) {
        Intrinsics.checkNotNullParameter((Object)appSettingsPermissionService, (String)"appSettingsPermissionService");
        Intrinsics.checkNotNullParameter((Object)deletedTenantService, (String)"deletedTenantService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)tenantInvitationService, (String)"tenantInvitationService");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)serverConfigService, (String)"serverConfigService");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)trackingSettingsService, (String)"trackingSettingsService");
        this.appSettingsPermissionService = appSettingsPermissionService;
        this.deletedTenantService = deletedTenantService;
        this.tenantService = tenantService;
        this.tenantPermissionService = tenantPermissionService;
        this.tenantInvitationService = tenantInvitationService;
        this.appSettingsService = appSettingsService;
        this.publisher = publisher;
        this.serverConfigService = serverConfigService;
        this.transactionSupport = transactionSupport;
        this.trackingSettingsService = trackingSettingsService;
    }

    @Transactional
    @NotNull
    public Tenant createTenant(@NotNull String name, @NotNull AuthorizationContext authContext) {
        boolean tenantExists;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkSuperAdmin();
        boolean bl = tenantExists = !((Collection)this.tenantService.getTenants()).isEmpty();
        if (tenantExists && !this.serverConfigService.isMultiTenantCreationEnabled()) {
            throw new NotAllowedException("Tenant creation is disabled.");
        }
        Tenant tenant = TenantService.createTenant$default((TenantService)this.tenantService, (String)name, null, (int)2, null);
        ArrayList<UserId> tenantManagers = new ArrayList<UserId>();
        if (!Intrinsics.areEqual((Object)authContext.getProfileId(), (Object)ProfileId.Companion.fromValue(0L))) {
            TenantPermission tenantPermission = this.tenantPermissionService.savePermission(new TenantPermission(tenant.getId(), (UserId)authContext.getProfileId(), Role.MANAGER));
            tenantManagers.add(tenantPermission.getGranteeId());
        }
        List allDefaultAppSettings = this.appSettingsService.createInitialApps(tenant.getId());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteTenant(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        List tenantPermissions = this.tenantPermissionService.findBy(tenantId);
        Iterable iterable = (Iterable)CoreApp.getEntries();
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CoreApp coreApp = (CoreApp)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.appSettingsPermissionService.deletePermissions(tenantId, (CoreApp)it));
        }
        List deletedAppPermissions = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        this.tenantService.deleteTenant(tenantId);
        this.deletedTenantService.create(new DeletedTenant(tenantId, tenant.getName(), authContext.getProfileId()));
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public Tenant updateDeeplKey(@NotNull TenantId tenantId, @Nullable String deeplKey, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        this.tenantService.updateDeeplKey(tenantId, deeplKey);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        TenantApplicationService.fetchAndPublishUpdatedTenant$default((TenantApplicationService)this, (TenantId)tenantId, (Tenant)tenant, null, null, null, null, (int)60, null);
        return tenant;
    }

    @NotNull
    public List<Tenant> getAllTenants(@NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkSuperAdmin();
        return this.tenantService.getTenants();
    }

    @Transactional
    @NotNull
    public Tenant updateTenant(@NotNull TenantId id, @Nullable String name, @Nullable HexColor color, @NotNull AuthorizationContext authContext) {
        String it;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(id);
        String string = name;
        if (string != null) {
            it = string;
            boolean bl = false;
            this.tenantService.updateName(id, it);
        }
        HexColor hexColor = color;
        if (hexColor != null) {
            it = hexColor;
            boolean bl = false;
            this.tenantService.updateHighlightColor(id, (HexColor)it);
        }
        Tenant tenant = this.tenantService.getTenant(id);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    public static /* synthetic */ Tenant updateTenant$default(TenantApplicationService tenantApplicationService, TenantId tenantId, String string, HexColor hexColor, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateTenant");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            hexColor = null;
        }
        return tenantApplicationService.updateTenant(tenantId, string, hexColor, authorizationContext);
    }

    @Nullable
    public Tenant findOne(@NotNull TenantId id, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        return this.tenantService.findTenant(id);
    }

    @NotNull
    public Tenant getOne(@NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        TenantId tenantId = authorizationContext.getNonNullTenantId();
        return this.getOne(tenantId, authorizationContext);
    }

    @NotNull
    public Tenant getOne(@NotNull TenantId id, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(id);
        return this.tenantService.getTenant(id);
    }

    @NotNull
    public List<TenantPermission> findPermissionsBy(@NotNull TenantId tenantId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        return this.tenantPermissionService.findBy(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant updatePermissions(@NotNull TenantId tenantId, @NotNull Set<TenantPermission> adds, @NotNull Set<TenantPermission> removes, @NotNull AuthorizationContext authContext) {
        TenantPermission it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(adds, (String)"adds");
        Intrinsics.checkNotNullParameter(removes, (String)"removes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager(tenantId);
        Iterable $this$map$iv = adds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        $this$map$iv = removes;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TenantPermission)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getGranteeId());
        }
        List affectedGranteeIds = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        authContext.checkAllTenantReader((Collection)affectedGranteeIds, tenantId);
        this.tenantPermissionService.update(tenantId, adds, removes);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.tenantService.getTenant(tenantId);
    }

    @NotNull
    public TenantSettings getTenantSettings(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return this.tenantService.getSettings(tenantId);
    }

    @Transactional
    @NotNull
    public Tenant setLogo(@NotNull TenantId tenantId, @Nullable DocumentId logoId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        TenantSettings tenantSettings = this.tenantService.setLogo(tenantId, logoId, authorizationContext.getProfileId());
        Tenant tenant = this.tenantService.getTenant(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    @Nullable
    public TenantInvitation getTenantInvitation(@NotNull TenantId tenantId, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        return (TenantInvitation)CollectionsKt.firstOrNull((List)this.tenantInvitationService.getTenantInvitations(tenantId));
    }

    @Transactional
    @NotNull
    public Tenant setTenantInvitationActive(@NotNull TenantId tenantId, boolean isInvitationActive, @NotNull AuthorizationContext authorizationContext) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authorizationContext, (String)"authorizationContext");
        authorizationContext.checkTenantManager(tenantId);
        this.tenantInvitationService.setTenantInvitationActive(tenantId, isInvitationActive);
        Tenant tenant = this.tenantService.getTenant(tenantId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return tenant;
    }

    @Nullable
    public TrackingSettings findTrackingSettings(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        return this.trackingSettingsService.findByTenantId(tenantId);
    }

    public void upsertTrackingSettings(@NotNull TrackingSettingsInput input, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        this.trackingSettingsService.upsertSettings(ModelConverterKt.toDomain((TrackingSettingsInput)input, (TenantId)tenantId));
        TenantApplicationService.fetchAndPublishUpdatedTenant$default((TenantApplicationService)this, (TenantId)tenantId, null, null, null, null, null, (int)62, null);
    }

    public void deactivateTracking(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonNullTenantId();
        this.trackingSettingsService.deactivcateTracking(tenantId);
        TenantApplicationService.fetchAndPublishUpdatedTenant$default((TenantApplicationService)this, (TenantId)tenantId, null, null, null, null, null, (int)62, null);
    }

    private void fetchAndPublishNewTenant(TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List<? extends UserId> tenantManagers, List<? extends AppSettings> allAppSettings) {
        this.publisher.publishNewTenant(tenant, tenantSettings, (Collection)allAppSettings, tenantManagers, tenantInvitation);
    }

    static /* synthetic */ void fetchAndPublishNewTenant$default(TenantApplicationService tenantApplicationService, TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndPublishNewTenant");
        }
        if ((n & 2) != 0) {
            tenant = tenantApplicationService.tenantService.getTenant(tenantId);
        }
        if ((n & 4) != 0) {
            tenantSettings = tenantApplicationService.tenantService.getSettings(tenantId);
        }
        if ((n & 8) != 0) {
            tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)tenantApplicationService.tenantInvitationService.getTenantInvitations(tenantId));
        }
        tenantApplicationService.fetchAndPublishNewTenant(tenantId, tenant, tenantSettings, tenantInvitation, list, list2);
    }

    private void fetchAndPublishUpdatedTenant(TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List<CoreAppSettings> allAppSettings, TrackingSettings trackingSettings) {
        this.publisher.publishExistingTenant(tenant, tenantSettings, tenantInvitation, (Collection)allAppSettings, trackingSettings);
    }

    static /* synthetic */ void fetchAndPublishUpdatedTenant$default(TenantApplicationService tenantApplicationService, TenantId tenantId, Tenant tenant, TenantSettings tenantSettings, TenantInvitation tenantInvitation, List list, TrackingSettings trackingSettings, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndPublishUpdatedTenant");
        }
        if ((n & 2) != 0) {
            tenant = tenantApplicationService.tenantService.getTenant(tenantId);
        }
        if ((n & 4) != 0) {
            tenantSettings = tenantApplicationService.tenantService.getSettings(tenantId);
        }
        if ((n & 8) != 0) {
            tenantInvitation = (TenantInvitation)CollectionsKt.firstOrNull((List)tenantApplicationService.tenantInvitationService.getTenantInvitations(tenantId));
        }
        if ((n & 0x10) != 0) {
            list = tenantApplicationService.appSettingsService.getCoreAppsByTenant(tenantId);
        }
        if ((n & 0x20) != 0) {
            trackingSettings = tenantApplicationService.trackingSettingsService.findByTenantId(tenantId);
        }
        tenantApplicationService.fetchAndPublishUpdatedTenant(tenantId, tenant, tenantSettings, tenantInvitation, list, trackingSettings);
    }

    public static final /* synthetic */ Publisher access$getPublisher$p(TenantApplicationService $this) {
        return $this.publisher;
    }
}

