BEGIN;

CREATE SEQUENCE conversation_attachment_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NO MAXVALUE
    CACHE 1;

CREATE TABLE conversation_attachment (
    id BIGINT NOT NULL,
    message_id BIGINT NOT NULL,
    document_id varchar(255) NOT NULL,
    document_version_id varchar(255) NOT NULL,
    filename varchar(255),
    file_size BIGINT DEFAULT 0,
    content_type varchar(255),
    version varchar(255) NOT NULL,
    attachment_type varchar(255) NOT NULL,
    image_height integer,
    image_width integer,
    create_date timestamp DEFAULT now() NOT NULL,
    CONSTRAINT conv_attachment_pk PRIMARY KEY (id),
    CONSTRAINT conv_attachment_msg_fk FOREIGN KEY (message_id) REFERENCES conversation_message(id) ON DELETE CASCADE
);

CREATE TABLE sh_conversation_attachment (
    id BIGINT,
    message_id BIGINT,
    document_id varchar(255),
    document_version_id varchar(255),
    filename varchar(255),
    file_size BIGINT,
    content_type varchar(255),
    version varchar(255),
    attachment_type varchar(255),
    image_height integer,
    image_width integer,
    create_date timestamp,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY(ID)
);

INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('conversation_attachment','sh_conversation_attachment','f');

INSERT INTO conversation_attachment(id, message_id, document_id, document_version_id, version, attachment_type, image_height, image_width, create_date)
SELECT nextval('conversation_attachment_seq'),
       id,
       substring(message from '"documentId":"([^"]*)"'),
       substring(message from '"documentVersionId":"([^"]*)"'),
       '1',
       'NEW_ATTACHMENT',
       CASE
         WHEN substring(message from '"imageHeight":([0-9]+)') is not null
         THEN cast (substring(message from '"imageHeight":([0-9]+)') as integer)
         ELSE null
       END,
       CASE
         WHEN substring(message from '"imageWidth":([0-9]+)') is not null
         THEN cast (substring(message from '"imageWidth":([0-9]+)') as integer)
         ELSE null
       END,
       create_date
FROM conversation_message
WHERE message_type = 'ATTACHMENT_CHAT_MESSAGE';

UPDATE conversation_attachment ca
SET filename = ddi.name, file_size = ddi.file_size, content_type = ddi.mime_type
FROM drive_document_item ddi
WHERE ddi.id = ca.document_id AND ddi.publicity = 'PUBLIC';

UPDATE conversation_attachment ca
SET filename = substring(cm.message from '"filename":"([^"]*)"'),
    file_size = cast(COALESCE(substring(cm.message from '"size":([0-9]+)'), '0') as bigint),
    content_type = COALESCE(cm.attachment_content_type, 'application/octet-stream')
FROM conversation_message cm
WHERE ca.message_id = cm.id
AND ca.filename IS NULL;

CREATE INDEX conv_attachment_msg_fk_idx ON conversation_attachment(message_id);

ALTER TABLE conversation_attachment
    ALTER COLUMN filename SET NOT NULL,
    ALTER COLUMN file_size SET NOT NULL,
    ALTER COLUMN content_type SET NOT NULL;

ALTER TABLE conversation_message
    ALTER COLUMN message DROP NOT NULL,
    DROP COLUMN attachment_content_type;

ALTER TABLE sh_conversation_message DROP COLUMN attachment_content_type;

UPDATE conversation_message
SET message = null
WHERE message_type IN ('ATTACHMENT_CHAT_MESSAGE', 'DELETED_CHAT_MESSAGE');

COMMIT;
