BEGIN;

INSERT INTO entity_privacy (entity_id, privacy_type, authority_name)
SELECT entity_id, 'ENTITY_EDIT', 'ENTITY_MEMBER'
FROM entity_component_open_for ecof
JOIN entity e ON e.id = ecof.entity_id
WHERE ecof.component_type = 'WORKSTREAM' AND ecof.authority_name = 'ENTITY_MEMBER'
AND e.entity_type IN ('NETWORK','GROUP')
AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

INSERT INTO entity_privacy (entity_id, privacy_type, authority_name)
SELECT entity_id, 'ENTITY_EDIT', 'LOGGED_IN'
FROM entity_component_open_for ecof
JOIN entity e ON e.id = ecof.entity_id
WHERE ecof.component_type = 'WORKSTREAM' AND ecof.authority_name = 'LOGGED_IN'
AND e.entity_type IN ('NETWORK','GROUP')
AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

INSERT INTO entity_privacy (entity_id, privacy_type, authority_name)
SELECT entity_id, 'ENTITY_EDIT', 'ENTITY_MEMBER'
FROM entity_component_open_for ecof
JOIN entity e ON e.id = ecof.entity_id
WHERE ecof.component_type = 'WIKI_EDITOR' AND ecof.authority_name = 'ENTITY_MEMBER'
AND e.entity_type = 'WIKI'
AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

INSERT INTO entity_privacy (entity_id, privacy_type, authority_name)
SELECT entity_id, 'ENTITY_EDIT', 'LOGGED_IN'
FROM entity_component_open_for ecof
JOIN entity e ON e.id = ecof.entity_id
WHERE ecof.component_type = 'WIKI_EDITOR' AND ecof.authority_name = 'LOGGED_IN'
AND e.entity_type = 'WIKI'
AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

UPDATE entity_component
SET visible = 't'
WHERE component_type = 'WORKSTREAM'
AND entity_id IN (SELECT id FROM entity WHERE entity_type IN ('NETWORK','GROUP'))
AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

UPDATE entity_component
SET visible = 't'
WHERE component_type IN ('WIKI_EDITOR','HIERARCHY')
AND entity_id IN (SELECT id FROM entity WHERE entity_type = 'WIKI')
AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

COMMIT;