BEGIN;

-- Update APP_CONNECT_BACKGROUND_COLOR of standard theme to NEWS App standard color,
-- if color was standard PAGE app color before (only for standard customer)
UPDATE theme_attribute SET attribute_value = '#CD52B0'
   WHERE theme_id IN (select id from theme WHERE default_theme = 't')
   AND attribute_type = 'APP_CONNECT_BACKGROUND_COLOR'
   AND attribute_value = '#7CB342'
   AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

-- Insert default theme if no default theme exists (only for standard customer)
INSERT INTO theme(id, name, shared, default_theme)
   SELECT nextval('theme_seq'), 'default', 't', 't'
   WHERE NOT EXISTS(
     SELECT 1 FROM theme
     WHERE default_theme = 't'
   )
   AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

-- Insert new APP_CONNECT_BACKGROUND_COLOR as NEWS App standard color, if no color
-- defined in the database  (only for standard customer)
INSERT INTO theme_attribute(theme_id, attribute_type, attribute_value)
   SELECT id AS theme_id, 'APP_CONNECT_BACKGROUND_COLOR' AS attribute_type, '#CD52B0' AS attribute_value FROM theme
   WHERE default_theme = 't'
   AND NOT EXISTS(
     SELECT 1 FROM theme_attribute
     WHERE theme_id = theme.id
     AND attribute_type = 'APP_CONNECT_BACKGROUND_COLOR'
   )
   AND EXISTS(
     SELECT 1 FROM customer_category
     WHERE customertype = 'standard'
   );

COMMIT;
