BEGIN;

ALTER TABLE like_table DROP CONSTRAINT like_pkey;
ALTER TABLE like_table RENAME COLUMN item_id TO old_item_id;
ALTER TABLE like_table ADD item_id VARCHAR(255);
UPDATE like_table SET item_id = item_type || ',' || old_item_id;
ALTER TABLE like_table  ALTER COLUMN item_id SET NOT NULL;
ALTER TABLE like_table DROP COLUMN item_type;
ALTER TABLE like_table DROP COLUMN old_item_id;
ALTER TABLE like_table ADD CONSTRAINT like_pk PRIMARY KEY(item_id, liker_id);
CREATE INDEX like_created_at_idx ON like_table(item_id, created_at);
CREATE INDEX like_recent_idx ON like_table(item_id, recent);

ALTER TABLE sh_like_table DROP CONSTRAINT sh_like_table_pkey;
ALTER TABLE sh_like_table RENAME COLUMN item_id TO old_item_id;
ALTER TABLE sh_like_table ADD item_id VARCHAR(255);
UPDATE sh_like_table SET item_id = item_type || ',' || old_item_id;
ALTER TABLE sh_like_table DROP COLUMN item_type;
ALTER TABLE sh_like_table DROP COLUMN old_item_id;

ALTER TABLE subscriptions DROP CONSTRAINT subscriptions_pkey;
ALTER TABLE subscriptions RENAME COLUMN item_id TO old_item_id;
ALTER TABLE subscriptions ADD item_id VARCHAR(255);
UPDATE subscriptions SET item_id = item_type || ',' || old_item_id;
ALTER TABLE subscriptions  ALTER COLUMN item_id SET NOT NULL;
ALTER TABLE subscriptions DROP COLUMN item_type;
ALTER TABLE subscriptions DROP COLUMN old_item_id;
ALTER TABLE subscriptions ADD CONSTRAINT subscriptions_pk PRIMARY KEY(item_id, subscriber_id);

ALTER TABLE sh_subscriptions RENAME COLUMN item_id TO old_item_id;
ALTER TABLE sh_subscriptions ADD item_id VARCHAR(255);
UPDATE sh_subscriptions SET item_id = item_type || ',' || old_item_id;
ALTER TABLE sh_subscriptions DROP COLUMN item_type;
ALTER TABLE sh_subscriptions DROP COLUMN old_item_id;

ALTER TABLE like_queue DROP CONSTRAINT like_queue_pkey;
ALTER TABLE like_queue RENAME COLUMN item_id TO old_item_id;
ALTER TABLE like_queue ADD item_id VARCHAR(255);
UPDATE like_queue SET item_id = item_type || ',' || old_item_id;
ALTER TABLE like_queue ALTER COLUMN item_id SET NOT NULL;
ALTER TABLE like_queue DROP COLUMN item_type;
ALTER TABLE like_queue DROP COLUMN old_item_id;
ALTER TABLE like_queue ADD CONSTRAINT like_queue_pk PRIMARY KEY(item_id);

ALTER TABLE like_queue RENAME COLUMN parent_id TO old_parent_id;
ALTER TABLE like_queue ADD parent_id VARCHAR(255);
UPDATE like_queue SET parent_id = parent_type || ',' || old_parent_id WHERE old_parent_id IS NOT NULL AND parent_type IS NOT NULL;
ALTER TABLE like_queue DROP COLUMN parent_type;
ALTER TABLE like_queue DROP COLUMN old_parent_id;

ALTER TABLE item_visibility_person RENAME COLUMN item_id TO old_item_id;
ALTER TABLE item_visibility_person ADD item_id VARCHAR(255);
UPDATE item_visibility_person SET item_id = item_type || ',' || old_item_id;
ALTER TABLE item_visibility_person ALTER COLUMN item_id SET NOT NULL;
ALTER TABLE item_visibility_person DROP COLUMN item_type;
ALTER TABLE item_visibility_person DROP COLUMN old_item_id;
CREATE INDEX itm_vis_person_item_idx ON item_visibility_person(item_id);

ALTER TABLE item_visibility_role RENAME COLUMN item_id TO old_item_id;
ALTER TABLE item_visibility_role ADD item_id VARCHAR(255);
UPDATE item_visibility_role SET item_id = item_type || ',' || old_item_id;
ALTER TABLE item_visibility_role ALTER COLUMN item_id SET NOT NULL;
ALTER TABLE item_visibility_role DROP COLUMN item_type;
ALTER TABLE item_visibility_role DROP COLUMN old_item_id;
CREATE INDEX itm_vis_role_item_idx ON item_visibility_role(item_id);

ALTER TABLE entity_parents DROP CONSTRAINT entity_parents_pk;
ALTER TABLE entity_parents RENAME COLUMN entity_id TO old_entity_id;
ALTER TABLE entity_parents RENAME COLUMN parent_id TO old_parent_id;
ALTER TABLE entity_parents ADD entity_id VARCHAR(255);
ALTER TABLE entity_parents ADD parent_id VARCHAR(255);
UPDATE entity_parents SET entity_id = 'ENTITY,' || old_entity_id;
UPDATE entity_parents SET parent_id = 'ENTITY,' || old_parent_id;
ALTER TABLE entity_parents ALTER COLUMN entity_id SET NOT NULL;
ALTER TABLE entity_parents ALTER COLUMN parent_id SET NOT NULL;
ALTER TABLE entity_parents DROP COLUMN old_entity_id;
ALTER TABLE entity_parents DROP COLUMN old_parent_id;
ALTER TABLE entity_parents ADD CONSTRAINT entity_parents_pk PRIMARY KEY(entity_id, parent_id);
CREATE INDEX entity_parents_parent_idx ON entity_parents(parent_id);

ALTER TABLE workstream_entry RENAME COLUMN origin_item_id TO old_origin_item_id;
ALTER TABLE workstream_entry ADD origin_item_id VARCHAR(255);
UPDATE workstream_entry SET origin_item_id = origin_item_type || ',' || old_origin_item_id;
ALTER TABLE workstream_entry ALTER COLUMN origin_item_id SET NOT NULL;
ALTER TABLE workstream_entry DROP COLUMN origin_item_type;
ALTER TABLE workstream_entry DROP COLUMN old_origin_item_id;

ALTER TABLE sh_workstream_entry RENAME COLUMN origin_item_id TO old_origin_item_id;
ALTER TABLE sh_workstream_entry ADD origin_item_id VARCHAR(255);
UPDATE sh_workstream_entry SET origin_item_id = origin_item_type || ',' || old_origin_item_id;
ALTER TABLE sh_workstream_entry DROP COLUMN origin_item_type;
ALTER TABLE sh_workstream_entry DROP COLUMN old_origin_item_id;

ALTER TABLE workstream_entry RENAME COLUMN subject_item_id TO old_subject_item_id;
ALTER TABLE workstream_entry ADD subject_item_id VARCHAR(255);
UPDATE workstream_entry SET subject_item_id = subject_item_type || ',' || old_subject_item_id;
ALTER TABLE workstream_entry ALTER COLUMN subject_item_id SET NOT NULL;
ALTER TABLE workstream_entry DROP COLUMN subject_item_type;
ALTER TABLE workstream_entry DROP COLUMN old_subject_item_id;
CREATE INDEX workstream_entry_subject_idx ON workstream_entry(subject_item_id, origin_item_id, id);

ALTER TABLE sh_workstream_entry RENAME COLUMN subject_item_id TO old_subject_item_id;
ALTER TABLE sh_workstream_entry ADD subject_item_id VARCHAR(255);
UPDATE sh_workstream_entry SET subject_item_id = subject_item_type || ',' || old_subject_item_id;
ALTER TABLE sh_workstream_entry DROP COLUMN subject_item_type;
ALTER TABLE sh_workstream_entry DROP COLUMN old_subject_item_id;

ALTER TABLE workstream_entry RENAME COLUMN author_id TO old_author_id;
ALTER TABLE workstream_entry ADD author_id VARCHAR(255);
UPDATE workstream_entry SET author_id = 'PROFILE,' || old_author_id;
ALTER TABLE workstream_entry DROP COLUMN old_author_id;
ALTER TABLE workstream_entry ALTER COLUMN author_id SET NOT NULL;
CREATE INDEX workstream_entry_author_idx ON workstream_entry(author_id);

ALTER TABLE sh_workstream_entry RENAME COLUMN author_id TO old_author_id;
ALTER TABLE sh_workstream_entry ADD author_id VARCHAR(255);
UPDATE sh_workstream_entry SET author_id = 'PROFILE,' || old_author_id;
ALTER TABLE sh_workstream_entry DROP COLUMN old_author_id;

COMMIT;
