BEGIN;

CREATE SEQUENCE profile_cfg_section_seq;
CREATE SEQUENCE profile_cfg_section_attribute_seq;

CREATE TABLE profile_cfg_section (
    id bigint NOT NULL,
    type varchar(255) NOT NULL,
    name varchar(255) NOT NULL,
    order_index integer NOT NULL,
    create_date timestamp NOT NULL DEFAULT now(),
    CONSTRAINT profile_cfg_section_pk PRIMARY KEY (id)
);

CREATE TABLE profile_cfg_section_attribute (
    id bigint NOT NULL,
    section_id bigint NOT NULL,
    type varchar(255) NOT NULL,
    name varchar(255) NOT NULL,
    order_index integer NOT NULL,
    create_date timestamp NOT NULL DEFAULT now(),
    CONSTRAINT profile_cfg_section_attribute_pk PRIMARY KEY (id),
    CONSTRAINT profile_cfg_section_attribute_section_fk FOREIGN KEY (section_id) REFERENCES profile_cfg_section (id) ON DELETE CASCADE
);

COMMIT;
