BEGIN;

-- create data table for this fix
CREATE TABLE temp_fix_entity_version (
    entity_id bigint NOT NULL,
    version_id bigint NOT NULL,
    latest_version char(1) DEFAULT ('f') NOT NULL,
    expired_version char(1) NOT NULL
);

-- find versions to be fixed
INSERT INTO temp_fix_entity_version (entity_id, version_id, expired_version)
SELECT  entity_id,
        id AS version_id,
        CASE WHEN expiration_date < now() THEN 'f'
        ELSE 't'
        END AS expired_version
FROM entity_version
WHERE version_status IN ('PUBLISHED', 'ARCHIVED')
AND entity_id IN (
    SELECT pub.entity_id
    FROM entity_version pub
    JOIN entity_version arch ON (pub.entity_id = arch.entity_id)
    WHERE pub.version_status = 'PUBLISHED'
    AND  arch.version_status = 'ARCHIVED'
    AND  pub.major_version < arch.major_version
);

-- find the latest version and remember it
UPDATE temp_fix_entity_version
SET latest_version = 't'
WHERE version_id IN (
    SELECT MAX(version_id)
    FROM temp_fix_entity_version
    GROUP BY entity_id
);

-- set all versions to archived which are not our latest one
UPDATE entity_version
SET version_status = 'ARCHIVED'
WHERE id IN (
    SELECT version_id
    FROM temp_fix_entity_version
    WHERE latest_version = 'f'
);

-- set all latest versions to published which are not also expired yet
UPDATE entity_version
SET version_status = 'PUBLISHED'
WHERE id IN (
    SELECT version_id
    FROM temp_fix_entity_version
    WHERE   latest_version = 't'
    AND     expired_version = 'f'
);

-- remove temp table
DROP TABLE temp_fix_entity_version;

COMMIT;
