BEGIN;

CREATE SEQUENCE conversation_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NO MAXVALUE
    CACHE 1;
    
CREATE SEQUENCE conversation_message_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NO MAXVALUE
    CACHE 1;
    
CREATE TABLE conversation (
    id BIGINT NOT NULL,
    type varchar(255) NOT NULL, 
    create_date timestamp DEFAULT now() NOT NULL,
    CONSTRAINT conversation_pk PRIMARY KEY (id)
);

CREATE TABLE conversation_participant (
    conversation_id BIGINT NOT NULL,
    participant_id BIGINT NOT NULL,
    create_date timestamp DEFAULT now() NOT NULL,
    modify_date timestamp DEFAULT now() NOT NULL,
    unread_count BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT conv_participant_pk UNIQUE (conversation_id, participant_id),
    CONSTRAINT conv_participant_conv_fk FOREIGN KEY (conversation_id) REFERENCES conversation(id) ON DELETE CASCADE,
    CONSTRAINT conv_participant_part_fk FOREIGN KEY (participant_id) REFERENCES person(id) ON DELETE CASCADE
);

CREATE TABLE conversation_message (
    id BIGINT NOT NULL,
    conversation_id BIGINT NOT NULL,
    from_person_id BIGINT NOT NULL,
    create_date timestamp DEFAULT now() NOT NULL,
    message TEXT NOT NULL,
    CONSTRAINT conv_message_pk PRIMARY KEY (id),
    CONSTRAINT conv_message_pers_fk FOREIGN KEY (from_person_id) REFERENCES person(id) ON DELETE CASCADE,
    CONSTRAINT conv_message_conv_fk FOREIGN KEY (conversation_id) REFERENCES conversation(id) ON DELETE CASCADE
);

CREATE INDEX idx_conversation_type ON conversation(type);

COMMIT;