BEGIN;

ALTER TABLE entity_member_role_name 
ALTER COLUMN name TYPE VARCHAR(50);

ALTER TABLE entity_member_role
ALTER COLUMN role TYPE VARCHAR(50);


-- rename event related roles from E_xxx to EVENT_xxx 
UPDATE entity_member_role_name SET name = 'EVENT_REJECTED_INVITATION' WHERE name = 'E_HAS_REJECTED';
UPDATE entity_member_role_name SET name = 'EVENT_ATTEND' WHERE name = 'E_ATTEND';
UPDATE entity_member_role_name SET name = 'EVENT_DONT_ATTEND' WHERE name = 'E_DONT_ATTEND';
UPDATE entity_member_role_name SET name = 'EVENT_MAYBE_ATTEND' WHERE name = 'E_MAYBE_ATTEND';
UPDATE entity_member_role_name SET name = 'EVENT_ON_WAITINGLIST' WHERE name = 'E_ON_WAITINGLIST';
UPDATE entity_member_role_name SET name = 'EVENT_IS_INVITED' WHERE name = 'E_IS_INVITED';


CREATE SEQUENCE entity_waitlist_order_seq
    START WITH 1
    INCREMENT BY 1;

CREATE TABLE entity_waitlist (
    entity_id BIGINT NOT NULL,
    person_id BIGINT NOT NULL,
    waitlist_order BIGINT NOT NULL,
    CONSTRAINT entity_waitlist_pk PRIMARY KEY (entity_id, person_id),
    CONSTRAINT entity_waitlist_entity_fk FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE,
    CONSTRAINT entity_waitlist_person_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE
);

CREATE TABLE sh_entity_waitlist (
    "entity_id" bigint,
    "person_id" bigint,
    "waitlist_order" bigint,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_waitlist','sh_entity_waitlist','f');

COMMIT;
