BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00005, '7.8', '00005_#patch_create_entity_recommendation_table', 'FEATURE', '#4847 - Creates a table to store recommendations of an entity by one person to another', now());

CREATE TABLE entity_recommendation (
    person_id bigint NOT NULL,
    entity_id bigint NOT NULL,
    recommender_id bigint NOT NULL,
    recommend_message character varying(4000) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT ent_rec_pk PRIMARY KEY (entity_id, person_id),
    CONSTRAINT ent_rec_entity_fk FOREIGN KEY (entity_id) REFERENCES entity(id),
    CONSTRAINT ent_rec_person_fk FOREIGN KEY (person_id) REFERENCES person(id),
    CONSTRAINT ent_rec_recommender_fk FOREIGN KEY (recommender_id) REFERENCES person(id)
);

CREATE TABLE sh_entity_recommendation (
    "person_id" bigint,
    "entity_id" bigint,
    "recommender_id" bigint,
    "recommend_message" character varying(4000),
    "create_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("entity_id", "person_id")
);

INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_recommendation','sh_entity_recommendation','f');

COMMIT;