BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00007, '7.6', '00007_#patch_add_subject_id_to_workstream_entry.sql', 'BUGFIX', '#7819 Workstream: Nicht alle Aktivitäten werden auf die Startseite gestreamt.', now());

ALTER TABLE workstream_entry
ADD subject_item_id bigint,
ADD subject_item_type character varying(32)
;

ALTER TABLE sh_workstream_entry
ADD subject_item_id bigint,
ADD subject_item_type character varying(32)
;

-- migrate subject IDs from attributes
update workstream_entry
set subject_item_id = wea.id, subject_item_type = wea.type
from
(
    select entry_id, key, cast(substr(value, strpos(value, ',') + 1, length(value)) as bigint) as id, substr(value, 0, strpos(value, ',')) as type
    from workstream_entry_attribute
) as wea
where workstream_entry.id = wea.entry_id
   and (
      workstream_entry.type = 'NEWSBLOG_ARTICLE_CREATED' AND wea.key = 'newsblog_article_id'
   or workstream_entry.type = 'NEWSBLOG_ARTICLE_UPDATED' AND wea.key = 'newsblog_article_id'
   or workstream_entry.type = 'NEWSBLOG_ARTICLE_COMMENTED' AND wea.key = 'newsblog_article_id'
   or workstream_entry.type = 'FORUM_ARTICLE_CREATED' AND wea.key = 'topic_id'
   or workstream_entry.type = 'FORUM_TOPIC_CREATED' AND wea.key = 'topic_id'
   or workstream_entry.type = 'ALBUM_IMAGE_CREATED' AND wea.key = 'image_id'
   or workstream_entry.type = 'ALBUM_IMAGE_COMMENTED' AND wea.key = 'image_id'
   or workstream_entry.type = 'DOCUMENT_ENTITY_NEW' AND wea.key = 'document_id'
   or workstream_entry.type = 'DOCUMENT_BLOG_NEW' AND wea.key = 'article_id'
   or workstream_entry.type = 'DOCUMENT_COMMENT' AND wea.key = 'document_id'
   or workstream_entry.type = 'VIDEOLINK_CREATED' AND wea.key = 'video_id'
   or workstream_entry.type = 'VIDEOLINK_COMMENTED' AND wea.key = 'video_id')
;

update sh_workstream_entry
set subject_item_id = wea.id, subject_item_type = wea.type
from
(
    select entry_id, key, cast(substr(value, strpos(value, ',') + 1, length(value)) as bigint) as id, substr(value, 0, strpos(value, ',')) as type
    from sh_workstream_entry_attribute
) as wea
where sh_workstream_entry.id = wea.entry_id
   and (
      sh_workstream_entry.type = 'NEWSBLOG_ARTICLE_CREATED' AND wea.key = 'newsblog_article_id'
   or sh_workstream_entry.type = 'NEWSBLOG_ARTICLE_UPDATED' AND wea.key = 'newsblog_article_id'
   or sh_workstream_entry.type = 'NEWSBLOG_ARTICLE_COMMENTED' AND wea.key = 'newsblog_article_id'
   or sh_workstream_entry.type = 'FORUM_ARTICLE_CREATED' AND wea.key = 'topic_id'
   or sh_workstream_entry.type = 'FORUM_TOPIC_CREATED' AND wea.key = 'topic_id'
   or sh_workstream_entry.type = 'ALBUM_IMAGE_CREATED' AND wea.key = 'image_id'
   or sh_workstream_entry.type = 'ALBUM_IMAGE_COMMENTED' AND wea.key = 'image_id'
   or sh_workstream_entry.type = 'DOCUMENT_ENTITY_NEW' AND wea.key = 'document_id'
   or sh_workstream_entry.type = 'DOCUMENT_BLOG_NEW' AND wea.key = 'article_id'
   or sh_workstream_entry.type = 'DOCUMENT_COMMENT' AND wea.key = 'document_id'
   or sh_workstream_entry.type = 'VIDEOLINK_CREATED' AND wea.key = 'video_id'
   or sh_workstream_entry.type = 'VIDEOLINK_COMMENTED' AND wea.key = 'video_id')
;

update workstream_entry
set subject_item_id = wea.id, subject_item_type = 'PROFILE'
from
(
    select entry_id, cast(wea.value as bigint) as id
    from workstream_entry_attribute wea
    where wea.key = 'friend_id'
) as wea
where workstream_entry.id = wea.entry_id
and workstream_entry.type = 'PROFILE_NEW_CONTACT';

update sh_workstream_entry
set subject_item_id = wea.id, subject_item_type = 'PROFILE'
from
(
    select entry_id, cast(wea.value as bigint) as id
    from sh_workstream_entry_attribute wea
    where wea.key = 'friend_id'
) as wea
where sh_workstream_entry.id = wea.entry_id
and sh_workstream_entry.type = 'PROFILE_NEW_CONTACT';
  
-- for microblog postings, the subject is the message id itself
update workstream_entry
set subject_item_id = id,
    subject_item_type = 'WORKSTREAM_MESSAGE'
where type = 'MICROBLOG_POSTING';

update sh_workstream_entry
set subject_item_id = id,
    subject_item_type = 'WORKSTREAM_MESSAGE'
where type = 'MICROBLOG_POSTING';

-- all other messages: subject ID = origin ID
UPDATE workstream_entry
SET subject_item_id = origin_item_id,
    subject_item_type = origin_item_type
WHERE subject_item_id IS NULL;

UPDATE sh_workstream_entry
SET subject_item_id = origin_item_id,
    subject_item_type = origin_item_type
WHERE subject_item_id IS NULL;

ALTER TABLE workstream_entry
ALTER subject_item_id SET NOT NULL,
ALTER subject_item_type SET NOT NULL
;

create index workstream_entry_subject_idx on workstream_entry(subject_item_id, subject_item_type, origin_item_id, origin_item_type, id);

drop index like_subscribe_subscriber_id_idx;
create index like_subscribe_subscriber_id_idx on like_subscribe(subscriber_id, item_id, item_type);

COMMIT;
