BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01207, '6.1', 'alter-and-migrate-entity-table-privacy-for-roles', 'FEATURE', 'Adjust entity-table for the roles-based visibility (new auth). (#1066)', now());

CREATE TABLE entity_privacy (
    entity_id bigint NOT NULL,
    privacy_type varchar(50) NOT NULL,
    authority_name varchar(50) NOT NULL,

        create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),

        FOREIGN KEY ( entity_id ) REFERENCES entity ( id )  ON DELETE CASCADE
);

INSERT INTO entity_privacy SELECT id, 'VISIBILITY', 'ALL' FROM entity WHERE visible_for = 0;
INSERT INTO entity_privacy SELECT id, 'VISIBILITY', 'LOGGED_IN' FROM entity WHERE visible_for = 1;
INSERT INTO entity_privacy SELECT id, 'VISIBILITY', 'WHOLE_LINKED_ENTITY' FROM entity WHERE visible_for = 2;
INSERT INTO entity_privacy SELECT id, 'VISIBILITY', 'ENTITY_MEMBER' FROM entity WHERE visible_for = 3;

INSERT INTO entity_privacy SELECT id, 'JOINING', 'ALL' FROM entity WHERE joining_rule = 0;
INSERT INTO entity_privacy SELECT id, 'JOINING', 'LOGGED_IN' FROM entity WHERE joining_rule = 1;
INSERT INTO entity_privacy SELECT id, 'JOINING', 'WHOLE_LINKED_ENTITY' FROM entity WHERE joining_rule = 2;
INSERT INTO entity_privacy SELECT id, 'JOINING', 'INVITED_OR_REQUESTED' FROM entity WHERE joining_rule = 3;
INSERT INTO entity_privacy SELECT id, 'JOINING', 'ENTITY_HAS_INVITATION' FROM entity WHERE joining_rule = 4;

INSERT INTO entity_privacy SELECT id, 'INVITING', 'ENTITY_MEMBER' FROM entity WHERE inviting_rule = 0;
INSERT INTO entity_privacy SELECT id, 'INVITING', 'CO_ADMIN' FROM entity WHERE inviting_rule = 1;
INSERT INTO entity_privacy SELECT id, 'INVITING', 'SUPERADMIN' FROM entity WHERE inviting_rule = 2;

INSERT INTO entity_privacy SELECT id, 'NEWSLETTER', 'ENTITY_MEMBER' FROM entity WHERE newsletter_rule = 0;
INSERT INTO entity_privacy SELECT id, 'NEWSLETTER', 'CO_ADMIN' FROM entity WHERE newsletter_rule = 1;

ALTER TABLE entity DROP COLUMN visible_for;
ALTER TABLE entity DROP COLUMN joining_rule;
ALTER TABLE entity DROP COLUMN inviting_rule;
ALTER TABLE entity DROP COLUMN newsletter_rule;

COMMIT;
