BEGIN;
INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01206, '6.1', 'create-entity_linked_entity_type_privacy-for-roles', 'FEATURE', 'Create table for linking entities to entities (new auth). (#1066)', now());

-- Fill entity_linked_entity_type_privacy with default values
CREATE TABLE tmp_entity_types (t bigint);
INSERT INTO tmp_entity_types (t) VALUES (0);
INSERT INTO tmp_entity_types (t) VALUES (1);
INSERT INTO tmp_entity_types (t) VALUES (2);
INSERT INTO tmp_entity_types (t) VALUES (3);
INSERT INTO tmp_entity_types (t) VALUES (4);
INSERT INTO tmp_entity_types (t) VALUES (5);

INSERT INTO entity_linked_entity_type_privacy(entity_id, entity_type, privacy_status)
    SELECT e.id, t.t, (COALESCE((
        SELECT default_privacy_status
            FROM entity_type_linked_entity_type
            WHERE linked_entity_type_id = e.entity_type
          AND entity_type_id = t.t), 1))
    FROM entity e, tmp_entity_types t
    WHERE e.id not in (SELECT entity_id from entity_linked_entity_type_privacy);

DROP TABLE tmp_entity_types;

-- Migrate entity_linked_entity_type_privacy

ALTER TABLE entity_linked_entity_type_privacy RENAME TO entity_linked_entity_type_privacy_old;

CREATE TABLE entity_linked_entity_type_privacy (
    entity_id bigint NOT NULL,
    entity_type varchar(100) NOT NULL,
    authority_name varchar(50) NOT NULL,

        create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),

        PRIMARY KEY (entity_id, entity_type, authority_name),
    FOREIGN KEY ( entity_id ) REFERENCES entity ( id )  ON DELETE CASCADE

        --no foreign key for the authority_name, since most roles are defined in the enum Role.java.
        --the database contains only the customer-specific roles.
);

INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'NETWORK',     'CO_ADMIN' FROM entity_linked_entity_type_privacy_old WHERE (privacy_status=1 OR privacy_status=0) AND entity_type=0;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'GROUP',       'CO_ADMIN' FROM entity_linked_entity_type_privacy_old WHERE (privacy_status=1 OR privacy_status=0) AND entity_type=1;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'WIKI',        'CO_ADMIN' FROM entity_linked_entity_type_privacy_old WHERE (privacy_status=1 OR privacy_status=0) AND entity_type=2;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'APPOINTMENT', 'CO_ADMIN' FROM entity_linked_entity_type_privacy_old WHERE (privacy_status=1 OR privacy_status=0) AND entity_type=3;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'PUBLICATION', 'CO_ADMIN' FROM entity_linked_entity_type_privacy_old WHERE (privacy_status=1 OR privacy_status=0) AND entity_type=4;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'TOPIC',       'CO_ADMIN' FROM entity_linked_entity_type_privacy_old WHERE (privacy_status=1 OR privacy_status=0) AND entity_type=5;

INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'NETWORK',     'ENTITY_MEMBER' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=1 AND entity_type=0;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'GROUP',       'ENTITY_MEMBER' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=1 AND entity_type=1;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'WIKI',        'ENTITY_MEMBER' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=1 AND entity_type=2;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'APPOINTMENT', 'ENTITY_MEMBER' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=1 AND entity_type=3;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'PUBLICATION', 'ENTITY_MEMBER' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=1 AND entity_type=4;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'TOPIC',       'ENTITY_MEMBER' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=1 AND entity_type=5;

INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'NETWORK',     'LOGGED_IN' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=2 AND entity_type=0;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'GROUP',       'LOGGED_IN' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=2 AND entity_type=1;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'WIKI',        'LOGGED_IN' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=2 AND entity_type=2;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'APPOINTMENT', 'LOGGED_IN' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=2 AND entity_type=3;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'PUBLICATION', 'LOGGED_IN' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=2 AND entity_type=4;
INSERT INTO entity_linked_entity_type_privacy SELECT entity_id, 'TOPIC',       'LOGGED_IN' FROM entity_linked_entity_type_privacy_old WHERE privacy_status=2 AND entity_type=5;

COMMIT;
