BEGIN;

INSERT INTO version(id, "release", name, "type", description, "date")
VALUES (01200, '6.0.0', 'add-foreign-key-constraint-to-dynamic-attributes', 'BUGFIX', 'Adds a FK constraint against the person_id so that dynamic attributes are removed when persons are removed', now());

-- first, delete remains of orphaned dynamic attributes
DELETE FROM dynamic_person_attributes WHERE person_id NOT IN ( SELECT person_id FROM person );

-- add FK constraint
ALTER TABLE dynamic_person_attributes ADD CONSTRAINT dpa_person_id_foreign_key FOREIGN KEY (person_id) REFERENCES person(person_id) ON DELETE CASCADE;

COMMIT;
