BEGIN;
--
-- PostgreSQL database dump
--

-- Dumped from database version 9.1.6
-- Dumped by pg_dump version 9.1.6
-- Started on 2012-10-18 11:39:14 CEST

-- SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

--
-- TOC entry 3604 (class 0 OID 0)
-- Dependencies: 6
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: -
--

-- COMMENT ON SCHEMA public IS 'standard public schema';


--
-- TOC entry 365 (class 3079 OID 11645)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

-- CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 3605 (class 0 OID 0)
-- Dependencies: 365
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--

-- COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- TOC entry 377 (class 1255 OID 112933)
-- Dependencies: 1211 6
-- Name: _(character varying, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE OR REPLACE FUNCTION _(character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql STABLE
    AS $_$
    DECLARE
        _original ALIAS FOR $1;
        _language_id ALIAS FOR $2;
        _translation VARCHAR(255);
    BEGIN
        IF _original IS NULL OR _language_id IS NULL THEN
            RETURN _original;
        END IF;
        SELECT translation INTO _translation
            FROM translation
            WHERE translation.language_id = _language_id
              AND translation.native = _original;
        IF NOT FOUND OR _translation IS NULL THEN
            RETURN _original;
        ELSE
            RETURN _translation;
        END IF;
    END;
$_$;


--
-- TOC entry 378 (class 1255 OID 112934)
-- Dependencies: 6
-- Name: getcityid(character varying, character varying, bigint); Type: FUNCTION; Schema: public; Owner: -
--

CREATE OR REPLACE FUNCTION getcityid(character varying, character varying, bigint) RETURNS bigint
    LANGUAGE sql STABLE
    AS $_$
        select id from cities where cities.name = $1 and cities.region_id = getNetworkId( $2, 300, $3 )
$_$;


--
-- TOC entry 379 (class 1255 OID 112935)
-- Dependencies: 6
-- Name: getnetworkid(character varying, integer, bigint); Type: FUNCTION; Schema: public; Owner: -
--

CREATE OR REPLACE FUNCTION getnetworkid(character varying, integer, bigint) RETURNS bigint
    LANGUAGE sql STABLE
    AS $_$
        select id from network where network.name = $1 and network.type = $2 and network.parent_id = $3
$_$;


--
-- TOC entry 380 (class 1255 OID 112936)
-- Dependencies: 6
-- Name: getschoolid(character varying, character varying, bigint); Type: FUNCTION; Schema: public; Owner: -
--

CREATE OR REPLACE FUNCTION getschoolid(character varying, character varying, bigint) RETURNS bigint
    LANGUAGE sql STABLE
    AS $_$
    SELECT id FROM network WHERE network.name = $1 AND network."type" = 4 AND network.parent_id = getNetworkId( $2, 2, $3)
$_$;


--
-- TOC entry 381 (class 1255 OID 112937)
-- Dependencies: 1211 6
-- Name: insert_translation(character varying, character, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE OR REPLACE FUNCTION insert_translation(character varying, character, character varying) RETURNS void
    LANGUAGE plpgsql
    AS $_$
    DECLARE
        _native ALIAS FOR $1;
        _language ALIAS FOR $2;
        _translation ALIAS FOR $3;
        _dummy VARCHAR(255);
        _native_id BIGINT;
    BEGIN
        SELECT id INTO _native_id FROM native WHERE native = _native;
        IF NOT FOUND THEN
            SELECT nextval('native_seq') INTO _native_id;
            INSERT INTO native (id, native) VALUES (_native_id, _native);
        END IF;
            SELECT translation INTO _dummy FROM translation
        WHERE translation.language_id = _language AND translation.native_id = _native_id;
        IF NOT FOUND THEN
                INSERT INTO translation (native_id, language_id, translation) VALUES (_native_id, _language, _translation);
        END IF;
    RETURN;
    END;
$_$;


SET default_with_oids = false;

--
-- TOC entry 161 (class 1259 OID 112938)
-- Dependencies: 6
-- Name: accepted_external_invitation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE accepted_external_invitation (
    inviter_id numeric(10,0) NOT NULL,
    person_id numeric(10,0) NOT NULL
);


--
-- TOC entry 162 (class 1259 OID 112941)
-- Dependencies: 2575 2576 2577 6
-- Name: adminnews; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE adminnews (
    id numeric(10,0) NOT NULL,
    header character varying(200) NOT NULL,
    url character varying(100),
    content character varying(1000) NOT NULL,
    locale character varying(2) NOT NULL,
    "from" timestamp without time zone DEFAULT now() NOT NULL,
    "to" timestamp without time zone DEFAULT (now() + '10 days'::interval) NOT NULL,
    status boolean DEFAULT true NOT NULL
);


--
-- TOC entry 163 (class 1259 OID 112950)
-- Dependencies: 6
-- Name: adminnews_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE adminnews_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3606 (class 0 OID 0)
-- Dependencies: 163
-- Name: adminnews_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('adminnews_seq', 0, false);


--
-- TOC entry 164 (class 1259 OID 112952)
-- Dependencies: 2578 2579 6
-- Name: album; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE album (
    id bigint NOT NULL,
    title character varying(255) NOT NULL,
    description text,
    location character varying(80),
    access integer DEFAULT 0,
    createdate timestamp with time zone DEFAULT now() NOT NULL,
    person_id bigint,
    group_id bigint,
    wiki_group_id bigint,
    network_id bigint,
    appointment_id bigint
);


--
-- TOC entry 165 (class 1259 OID 112960)
-- Dependencies: 6
-- Name: album_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE album_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3607 (class 0 OID 0)
-- Dependencies: 165
-- Name: album_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('album_seq', 0, false);


--
-- TOC entry 166 (class 1259 OID 112962)
-- Dependencies: 2580 2581 2582 2583 2584 6
-- Name: appointment_participant; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE appointment_participant (
    person_id numeric(10,0) NOT NULL,
    appointment_id bigint NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    list integer,
    modify_date timestamp without time zone DEFAULT now() NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    date_in_list timestamp without time zone DEFAULT now() NOT NULL,
    participant_role integer DEFAULT 0 NOT NULL,
    last_notify_list integer,
    last_notify_date timestamp without time zone,
    inviter_id bigint
);


--
-- TOC entry 167 (class 1259 OID 112970)
-- Dependencies: 6
-- Name: appointment_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE appointment_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3608 (class 0 OID 0)
-- Dependencies: 167
-- Name: appointment_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('appointment_seq', 0, false);


--
-- TOC entry 168 (class 1259 OID 112972)
-- Dependencies: 2585 2586 2587 2588 2589 2590 2591 2592 2593 2594 2595 2596 6
-- Name: appointment_widget_configurations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE appointment_widget_configurations (
    appointment_id bigint NOT NULL,
    list_participant_visible boolean DEFAULT true NOT NULL,
    list_wait_visible boolean DEFAULT true NOT NULL,
    list_undecided_visible boolean DEFAULT true NOT NULL,
    list_rejected_visible boolean DEFAULT true NOT NULL,
    news_visible boolean DEFAULT true NOT NULL,
    documents_visible boolean DEFAULT true NOT NULL,
    album_visible boolean DEFAULT true NOT NULL,
    video_visible boolean DEFAULT true NOT NULL,
    forum_visible boolean DEFAULT true NOT NULL,
    wall_visible boolean DEFAULT true NOT NULL,
    admin_visible boolean DEFAULT true NOT NULL,
    privacy_visible boolean DEFAULT true NOT NULL
);


--
-- TOC entry 169 (class 1259 OID 112987)
-- Dependencies: 2597 2598 2599 2600 6
-- Name: appointments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE appointments (
    appointment_id bigint DEFAULT nextval('appointment_seq'::regclass) NOT NULL,
    appointment_name character varying(255) NOT NULL,
    network_id bigint NOT NULL,
    start_at timestamp without time zone NOT NULL,
    end_at timestamp without time zone NOT NULL,
    closing_date timestamp without time zone,
    timezone character varying(100) NOT NULL,
    participant_limited boolean NOT NULL,
    participant_count integer,
    description text NOT NULL,
    recent_news text,
    location character varying(255),
    office character varying(255),
    contact_name character varying(255),
    website character varying(255),
    email character varying(255),
    phone character varying(50),
    fax character varying(50),
    street character varying(255),
    zipcode character varying(10),
    city character varying(255),
    state character varying(255),
    country_id bigint,
    keywords character varying(255),
    visible_for integer DEFAULT 0 NOT NULL,
    joining_rule integer DEFAULT 0 NOT NULL,
    inviting_rule integer DEFAULT 0 NOT NULL
);


--
-- TOC entry 170 (class 1259 OID 112997)
-- Dependencies: 2601 6
-- Name: base_property; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE base_property (
    id bigint NOT NULL,
    property_name character varying(255) NOT NULL,
    converter_class character varying(255),
    converter_config character varying(255),
    description character varying(1000) NOT NULL,
    default_value text,
    inheritance_type character varying(255) NOT NULL,
    container_name character varying(255) NOT NULL,
    last_changed timestamp without time zone NOT NULL,
    change_user character varying(255),
    create_at timestamp without time zone DEFAULT now()
);


--
-- TOC entry 171 (class 1259 OID 113004)
-- Dependencies: 6
-- Name: cities; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE cities (
    id bigint NOT NULL,
    name character varying(255),
    region_id bigint NOT NULL
);


--
-- TOC entry 172 (class 1259 OID 113007)
-- Dependencies: 6
-- Name: cityid_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE cityid_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3609 (class 0 OID 0)
-- Dependencies: 172
-- Name: cityid_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('cityid_seq', 0, false);


--
-- TOC entry 173 (class 1259 OID 113009)
-- Dependencies: 2602 2603 2604 6
-- Name: contact_data_basic; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contact_data_basic (
    person_id bigint NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    co character varying(130),
    street character varying(255),
    zipcode character varying(10),
    zipcode_successive boolean DEFAULT false,
    city character varying(255),
    country_id bigint,
    email character varying(100),
    phone character varying(100),
    fax character varying(100),
    mobile character varying(100),
    website character varying(255),
    created_at timestamp without time zone DEFAULT now(),
    modified_at timestamp without time zone
);


--
-- TOC entry 174 (class 1259 OID 113018)
-- Dependencies: 6
-- Name: country_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE country_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3610 (class 0 OID 0)
-- Dependencies: 174
-- Name: country_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('country_seq', 245, true);


--
-- TOC entry 175 (class 1259 OID 113020)
-- Dependencies: 2605 2606 2607 6
-- Name: country; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE country (
    id bigint DEFAULT nextval('country_seq'::regclass) NOT NULL,
    name character varying(255),
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 176 (class 1259 OID 113026)
-- Dependencies: 6
-- Name: customer_domain; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE customer_domain (
    customer_domain_name character varying(255) NOT NULL
);


--
-- TOC entry 177 (class 1259 OID 113029)
-- Dependencies: 6
-- Name: deleted_adminnews; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE deleted_adminnews (
    adminnews_id numeric(10,0) NOT NULL,
    person_id numeric(10,0) NOT NULL
);


--
-- TOC entry 178 (class 1259 OID 113032)
-- Dependencies: 6
-- Name: document_files_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE document_files_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3611 (class 0 OID 0)
-- Dependencies: 178
-- Name: document_files_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('document_files_seq', 0, false);


--
-- TOC entry 179 (class 1259 OID 113034)
-- Dependencies: 2608 2609 2610 2611 2612 2613 6
-- Name: document_files; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE document_files (
    id bigint DEFAULT nextval('document_files_seq'::regclass) NOT NULL,
    description character varying(1024),
    keywords character varying(4096),
    download_count bigint DEFAULT 0 NOT NULL,
    checked_out_by bigint DEFAULT (-1),
    checked_out_at timestamp without time zone,
    status integer DEFAULT 0 NOT NULL,
    status_changed_by bigint DEFAULT (-1),
    status_changed_at timestamp without time zone,
    CONSTRAINT document_files_positive_download_count CHECK ((download_count >= 0))
);


--
-- TOC entry 180 (class 1259 OID 113046)
-- Dependencies: 6
-- Name: document_versions_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE document_versions_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3612 (class 0 OID 0)
-- Dependencies: 180
-- Name: document_versions_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('document_versions_seq', 0, false);


--
-- TOC entry 181 (class 1259 OID 113048)
-- Dependencies: 2614 2615 2616 2617 2618 6
-- Name: document_versions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE document_versions (
    id bigint DEFAULT nextval('document_versions_seq'::regclass) NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    filename character varying(256) NOT NULL,
    document_file_id bigint NOT NULL,
    url character varying(1024) NOT NULL,
    uploaded_by bigint DEFAULT (-1) NOT NULL,
    uploaded_at timestamp without time zone DEFAULT now() NOT NULL,
    size bigint NOT NULL,
    file_type_id bigint NOT NULL,
    restored_from integer,
    CONSTRAINT document_versions_positive_size CHECK ((size > 0))
);


--
-- TOC entry 182 (class 1259 OID 113059)
-- Dependencies: 2619 6
-- Name: domain_property; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE domain_property (
    id bigint NOT NULL,
    base_property bigint NOT NULL,
    domain character varying(255) NOT NULL,
    overridden_value text,
    last_changed timestamp without time zone,
    change_user character varying(255),
    create_at timestamp without time zone DEFAULT now()
);


--
-- TOC entry 183 (class 1259 OID 113066)
-- Dependencies: 6
-- Name: dynamic_person_attributes; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE dynamic_person_attributes (
    person_id bigint NOT NULL,
    orderidx integer,
    tab character varying(255),
    section character varying(255),
    name character varying(255),
    value text,
    section_clone integer
);


--
-- TOC entry 184 (class 1259 OID 113072)
-- Dependencies: 6
-- Name: email_notifications; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE email_notifications (
    person_id numeric(10,0) NOT NULL
);


--
-- TOC entry 185 (class 1259 OID 113075)
-- Dependencies: 2620 6
-- Name: employment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE employment (
    id numeric(10,0) NOT NULL,
    employer character varying(50) NOT NULL,
    "position" character varying(50),
    city character varying(50),
    startat date NOT NULL,
    endat date,
    person_id numeric(10,0) NOT NULL,
    website character varying(256),
    industry_id smallint,
    occupation_id smallint,
    job_status_id smallint,
    activities character varying(1024),
    is_current boolean,
    created_at timestamp without time zone DEFAULT now(),
    modified_at timestamp without time zone
);


--
-- TOC entry 186 (class 1259 OID 113082)
-- Dependencies: 6
-- Name: employment_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE employment_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3613 (class 0 OID 0)
-- Dependencies: 186
-- Name: employment_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('employment_seq', 0, false);


--
-- TOC entry 187 (class 1259 OID 113084)
-- Dependencies: 6
-- Name: entity_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE entity_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3614 (class 0 OID 0)
-- Dependencies: 187
-- Name: entity_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('entity_seq', 0, false);


--
-- TOC entry 188 (class 1259 OID 113086)
-- Dependencies: 2621 2622 2623 2624 2625 2626 2627 2628 2629 2630 2631 2632 6
-- Name: entity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity (
    id bigint DEFAULT nextval('entity_seq'::regclass) NOT NULL,
    entity_type bigint NOT NULL,
    name character varying(255) NOT NULL,
    start_at timestamp without time zone,
    end_at timestamp without time zone,
    closing_date timestamp without time zone,
    timezone character varying(255),
    participant_limited boolean DEFAULT false NOT NULL,
    participant_count integer,
    description text,
    location character varying(255),
    tags text,
    subdomain character varying(255),
    is_subdomain_deactivated boolean DEFAULT false NOT NULL,
    external_domain character varying(255),
    google_maps_api_key character varying(255),
    logo character varying(255),
    icon character varying(255),
    visible_for integer DEFAULT 0 NOT NULL,
    joining_rule integer DEFAULT 0 NOT NULL,
    inviting_rule integer DEFAULT 0 NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),
    widgets_show_sub_entities boolean DEFAULT true NOT NULL,
    network_id bigint,
    group_id bigint,
    wiki_id bigint,
    appointment_id bigint,
    aggregate_workstream boolean DEFAULT true NOT NULL,
    category character varying(32) DEFAULT ''::character varying NOT NULL,
    newsletter_rule integer DEFAULT 1 NOT NULL,
    text_if_not_visible text
);


--
-- TOC entry 189 (class 1259 OID 113104)
-- Dependencies: 6
-- Name: entity_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_category (
    entity_type bigint NOT NULL,
    category character varying(32) NOT NULL,
    "order" integer NOT NULL
);


--
-- TOC entry 190 (class 1259 OID 113107)
-- Dependencies: 2633 2634 6
-- Name: entity_component; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_component (
    entity_id bigint NOT NULL,
    component_type character varying(32) NOT NULL,
    "position" bigint NOT NULL,
    "order" integer NOT NULL,
    visible boolean DEFAULT true NOT NULL,
    open boolean DEFAULT true NOT NULL
);


--
-- TOC entry 191 (class 1259 OID 113112)
-- Dependencies: 2635 2636 2637 6
-- Name: entity_contact_data; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_contact_data (
    entity_id bigint NOT NULL,
    office character varying(255),
    contact_name character varying(255),
    website character varying(255),
    email character varying(255),
    phone character varying(100),
    fax character varying(100),
    street character varying(255),
    zipcode character varying(50),
    city character varying(255),
    state character varying(255),
    country_id bigint,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),
    lat double precision,
    lng double precision,
    notresolvable boolean DEFAULT false
);


--
-- TOC entry 192 (class 1259 OID 113121)
-- Dependencies: 2638 2639 2640 2641 2642 6
-- Name: entity_design; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_design (
    entity_id bigint NOT NULL,
    page_border_color character(7),
    navigation_background_color character(7),
    navigation_quicklink_color character(7),
    navigation_separator_background_color character(7),
    navigation_separator_text_color character(7),
    header_background_color character(7),
    header_border_color character(7),
    header_text_color character(7),
    header_link_color character(7),
    heading_box_background_color character(7),
    heading_box_text_color character(7),
    heading_box_border_color character(7),
    subheading_box_background_color character(7),
    subheading_box_text_color character(7),
    subheading_box_link_color character(7),
    subheading_box_border_color character(7),
    subheading_box_line_color character(7),
    inner_background_color character(7),
    outer_background_color character(7),
    text_color character(7),
    link_color character(7),
    line_color character(7),
    button_background_color character(7),
    button_text_color character(7),
    box_top_border boolean,
    box_bottom_border boolean,
    box_left_border boolean,
    box_right_border boolean,
    horizontal_navigation_background_color character(7),
    horizontal_navigation_link_color character(7),
    horizontal_navigation character varying(255),
    navigation_separator character varying(255),
    heading_box character varying(255),
    banner character varying(255),
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),
    background_horizontal_repeat boolean DEFAULT false NOT NULL,
    background_vertical_repeat boolean DEFAULT false NOT NULL,
    background_image character varying(255),
    background_scroll_fix boolean DEFAULT false NOT NULL,
    horizontal_navigation_selected_link character(7),
    horizontal_navigation_selected_background character(7),
    horizontal_navigation_sub_line character(7),
    horizontal_navigation_selected_image character varying(255)
);


--
-- TOC entry 193 (class 1259 OID 113132)
-- Dependencies: 2643 2644 6
-- Name: entity_link; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_link (
    entity_id bigint NOT NULL,
    linked_entity_id bigint NOT NULL,
    "order" integer NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 194 (class 1259 OID 113137)
-- Dependencies: 2645 2646 6
-- Name: entity_linked_entity_type_privacy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_linked_entity_type_privacy (
    entity_id bigint NOT NULL,
    entity_type bigint NOT NULL,
    privacy_status integer NOT NULL,
    modify_date timestamp without time zone DEFAULT now() NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 195 (class 1259 OID 113142)
-- Dependencies: 2647 2648 2649 2650 2651 6
-- Name: entity_member; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_member (
    person_id bigint NOT NULL,
    entity_id bigint NOT NULL,
    member_status integer,
    member_role integer DEFAULT 0 NOT NULL,
    status_modify_date timestamp without time zone DEFAULT now() NOT NULL,
    last_notify_status integer,
    last_notify_date timestamp without time zone,
    inviter_id bigint DEFAULT (-1),
    invite_message text,
    modify_date timestamp without time zone DEFAULT now() NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 196 (class 1259 OID 113153)
-- Dependencies: 6
-- Name: entity_navigation_links_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE entity_navigation_links_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3615 (class 0 OID 0)
-- Dependencies: 196
-- Name: entity_navigation_links_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('entity_navigation_links_seq', 0, false);


--
-- TOC entry 197 (class 1259 OID 113155)
-- Dependencies: 2652 2653 2654 2655 2656 6
-- Name: entity_navigation_links; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_navigation_links (
    id bigint DEFAULT nextval('entity_navigation_links_seq'::regclass) NOT NULL,
    entity_id bigint NOT NULL,
    text character varying(63) DEFAULT ''::character varying NOT NULL,
    target character varying(255) DEFAULT ''::character varying NOT NULL,
    list_index integer NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 198 (class 1259 OID 113163)
-- Dependencies: 6
-- Name: entity_navigation_sublinks_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE entity_navigation_sublinks_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3616 (class 0 OID 0)
-- Dependencies: 198
-- Name: entity_navigation_sublinks_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('entity_navigation_sublinks_seq', 0, false);


--
-- TOC entry 199 (class 1259 OID 113165)
-- Dependencies: 2657 2658 2659 2660 2661 6
-- Name: entity_navigation_sublinks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_navigation_sublinks (
    id bigint DEFAULT nextval('entity_navigation_sublinks_seq'::regclass) NOT NULL,
    parent_id bigint NOT NULL,
    text character varying(63) DEFAULT ''::character varying NOT NULL,
    target character varying(255) DEFAULT ''::character varying NOT NULL,
    list_index integer NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    edit_date timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 200 (class 1259 OID 113173)
-- Dependencies: 2662 2663 2664 2665 2666 2667 2668 2669 2670 2671 2672 2673 2674 2675 2676 2677 2678 2679 2680 2681 2682 2683 2684 2685 6
-- Name: entity_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_type (
    id bigint NOT NULL,
    subdomain_activated boolean NOT NULL,
    external_domain_activated boolean NOT NULL,
    design_activated boolean NOT NULL,
    duration_time_activated boolean NOT NULL,
    participant_limit_activated boolean NOT NULL,
    closing_date_activated boolean NOT NULL,
    freetext_location_activated boolean NOT NULL,
    horizontal_navigation_activated boolean NOT NULL,
    linked_entity_required boolean NOT NULL,
    visible_for_all_activated boolean NOT NULL,
    joining_for_all_activated boolean NOT NULL,
    sitemap_activated boolean NOT NULL,
    notify_member_on_location_change_activated boolean NOT NULL,
    notify_member_on_duration_time_change_activated boolean NOT NULL,
    notfiy_member_on_delete_activated boolean NOT NULL,
    logo_activated boolean NOT NULL,
    icon_activated boolean NOT NULL,
    delete_by_admin_activated boolean NOT NULL,
    creating_allowed boolean NOT NULL,
    join_request_allowed boolean NOT NULL,
    entity_type_activated boolean NOT NULL,
    entity_left_navigation_order integer NOT NULL,
    display_on_left_navigation boolean NOT NULL,
    display_as_list_on_left_navigation boolean NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),
    display_join_child_popup_on_join_entity boolean NOT NULL,
    category_force boolean DEFAULT false NOT NULL,
    default_visible_for bigint DEFAULT 1 NOT NULL,
    default_joining_rule bigint DEFAULT 1 NOT NULL,
    default_inviting_rule bigint DEFAULT 0 NOT NULL,
    show_option_aggregate_workstream boolean DEFAULT true NOT NULL,
    default_aggregate_workstream boolean DEFAULT true NOT NULL,
    show_option_widgets_show_sub_entities boolean DEFAULT true NOT NULL,
    default_widgets_show_sub_entities boolean DEFAULT true NOT NULL,
    toolbar_infowidget character varying(2048) DEFAULT '[[''Templates'',''FitWindow'', ''-'',''Cut'', ''Copy'', ''Paste'', ''PasteText'',''PasteWord'',''Image'',''Table'',''Rule'', ''Source'' ],[ ''Undo'',''Redo'',''Bold'',''Italic'',''Underline'',''StrikeThrough'',''-'',''OrderedList'',''UnorderedList'',''Outdent'',''Indent'',''-'',''JustifyLeft'',''JustifyCenter'',''JustifyRight'',''JustifyFull'' ],[ ''FontFormat'',''FontSize'',''TextColor'',''BGColor'',''RemoveFormat'',''-'',''JustConnectOpenLinkPopup'',''Unlink'',''Anchor'']]'::character varying NOT NULL,
    toolbar_newsblog character varying(2048) DEFAULT '[[''Templates'',''FitWindow'',''-'',''Cut'',''Copy'',''Paste'',''PasteText'',''PasteWord'',''Image'',''Table'',''Rule'',''Source''],[''Undo'',''Redo'',''Bold'',''Italic'',''Underline'',''StrikeThrough'',''-'',''OrderedList'',''UnorderedList'',''Outdent'',''Indent'',''-'',''JustifyLeft'',''JustifyCenter'',''JustifyRight'',''JustifyFull''],[''FontFormat'',''FontSize'',''TextColor'',''BGColor'',''RemoveFormat'',''-'',''JustConnectOpenLinkPopup'',''Unlink'',''Anchor'']]'::character varying NOT NULL,
    toolbar_raweditor character varying(2048) DEFAULT '[[''Templates'',''FitWindow'', ''-'',''Cut'', ''Copy'', ''Paste'', ''PasteText'',''PasteWord'',''Image'',''Table'',''Rule'', ''Source'' ],[ ''Undo'',''Redo'',''Bold'',''Italic'',''Underline'',''StrikeThrough'',''-'',''OrderedList'',''UnorderedList'',''Outdent'',''Indent'',''-'',''JustifyLeft'',''JustifyCenter'',''JustifyRight'',''JustifyFull'' ],[ ''FontFormat'',''FontSize'',''TextColor'',''BGColor'',''RemoveFormat'',''-'',''JustConnectOpenLinkPopup'',''Unlink'',''Anchor'']]'::character varying NOT NULL,
    toolbar_wiki character varying(2048) DEFAULT '[[''Templates'',''FitWindow'',''-'',''Cut'',''Copy'',''Paste'',''PasteText'',''PasteWord'',''Image'',''Table'',''Rule'',''Source''],[''Undo'',''Redo'',''Bold'',''Italic'',''Underline'',''StrikeThrough'',''-'',''OrderedList'',''UnorderedList'',''Outdent'',''Indent'',''-'',''JustifyLeft'',''JustifyCenter'',''JustifyRight'',''JustifyFull''],[''FontFormat'',''FontSize'',''TextColor'',''BGColor'',''RemoveFormat'',''-'',''JustConnectOpenLinkPopup'',''Unlink'',''Anchor'']]'::character varying NOT NULL,
    join_options_configurable boolean DEFAULT true,
    invite_options_configurable boolean DEFAULT true,
    leave_allowed boolean DEFAULT true,
    invite_by_superadmin_only_activated boolean DEFAULT false,
    join_by_invitation_only_activated boolean DEFAULT false,
    default_newsletter_rule integer DEFAULT 0 NOT NULL,
    teaser_left character varying(100) DEFAULT 'ICON_WITH_TEASER_TEXT'::character varying NOT NULL,
    teaser_center character varying(100) DEFAULT 'ICON_WITH_TEASER_TEXT'::character varying NOT NULL,
    teaser_right character varying(100) DEFAULT 'ICON_WITH_ENTITY_NAME'::character varying NOT NULL,
    show_description_in_search_badge boolean DEFAULT false NOT NULL
);


--
-- TOC entry 201 (class 1259 OID 113203)
-- Dependencies: 2686 2687 6
-- Name: entity_type_allowed_component; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_type_allowed_component (
    entity_type_id bigint NOT NULL,
    component_type character varying(100) NOT NULL,
    "position" bigint NOT NULL,
    default_order integer NOT NULL,
    default_visible boolean NOT NULL,
    default_open boolean NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 202 (class 1259 OID 113208)
-- Dependencies: 2688 2689 2690 6
-- Name: entity_type_linked_entity_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_type_linked_entity_type (
    entity_type_id bigint NOT NULL,
    linked_entity_type_id bigint NOT NULL,
    min_count integer NOT NULL,
    max_count integer,
    display_as_listbox boolean NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),
    default_privacy_status bigint DEFAULT 0 NOT NULL
);


--
-- TOC entry 203 (class 1259 OID 113214)
-- Dependencies: 2691 2692 6
-- Name: entity_type_member_status_rights; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE entity_type_member_status_rights (
    entity_type_id bigint NOT NULL,
    member_status integer NOT NULL,
    read_access boolean NOT NULL,
    write_access boolean NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 204 (class 1259 OID 113219)
-- Dependencies: 6
-- Name: event_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE event_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3617 (class 0 OID 0)
-- Dependencies: 204
-- Name: event_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('event_seq', 0, false);


--
-- TOC entry 205 (class 1259 OID 113221)
-- Dependencies: 6
-- Name: event_subtype_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE event_subtype_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3618 (class 0 OID 0)
-- Dependencies: 205
-- Name: event_subtype_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('event_subtype_seq', 0, false);


--
-- TOC entry 206 (class 1259 OID 113223)
-- Dependencies: 6
-- Name: event_type_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE event_type_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3619 (class 0 OID 0)
-- Dependencies: 206
-- Name: event_type_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('event_type_seq', 0, false);


--
-- TOC entry 207 (class 1259 OID 113225)
-- Dependencies: 6
-- Name: external_invitation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE external_invitation (
    inviter_id numeric(10,0) NOT NULL,
    email character varying(100) NOT NULL,
    hash character varying(100) NOT NULL,
    entity_id bigint
);


--
-- TOC entry 208 (class 1259 OID 113228)
-- Dependencies: 6
-- Name: file_types_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE file_types_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3620 (class 0 OID 0)
-- Dependencies: 208
-- Name: file_types_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('file_types_seq', 22, true);


--
-- TOC entry 209 (class 1259 OID 113230)
-- Dependencies: 2693 2694 6
-- Name: file_types; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE file_types (
    id bigint DEFAULT nextval('file_types_seq'::regclass) NOT NULL,
    extension character varying(32) NOT NULL,
    mime_type character varying(64) DEFAULT 'application/octet-stream'::character varying NOT NULL,
    description character varying(1024) NOT NULL,
    icon_url character varying(1024) NOT NULL
);


--
-- TOC entry 210 (class 1259 OID 113238)
-- Dependencies: 6
-- Name: forum; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE forum (
    forum_id bigint NOT NULL,
    affilation integer NOT NULL,
    id bigint NOT NULL,
    description text NOT NULL
);


--
-- TOC entry 211 (class 1259 OID 113244)
-- Dependencies: 6
-- Name: forum_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE forum_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3621 (class 0 OID 0)
-- Dependencies: 211
-- Name: forum_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('forum_seq', 0, false);


--
-- TOC entry 212 (class 1259 OID 113246)
-- Dependencies: 2695 2696 6
-- Name: forum_topic; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE forum_topic (
    topic_id bigint NOT NULL,
    forum_id bigint NOT NULL,
    caption character varying(255) NOT NULL,
    date timestamp without time zone DEFAULT now(),
    create_date timestamp without time zone DEFAULT now(),
    author_id bigint NOT NULL,
    last_replier_id bigint NOT NULL,
    hits bigint
);


--
-- TOC entry 213 (class 1259 OID 113251)
-- Dependencies: 2697 6
-- Name: forum_topic_article; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE forum_topic_article (
    topic_id bigint NOT NULL,
    caption character varying(255) NOT NULL,
    date timestamp without time zone DEFAULT now(),
    author_id bigint NOT NULL,
    article_text text NOT NULL,
    id bigint NOT NULL,
    editor_id bigint,
    edit_date timestamp without time zone,
    edit_reason character varying(50)
);


--
-- TOC entry 214 (class 1259 OID 113258)
-- Dependencies: 6
-- Name: forum_topic_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE forum_topic_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3622 (class 0 OID 0)
-- Dependencies: 214
-- Name: forum_topic_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('forum_topic_seq', 0, false);


--
-- TOC entry 215 (class 1259 OID 113260)
-- Dependencies: 2698 6
-- Name: google_language_cache; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE google_language_cache (
    source_hash bigint NOT NULL,
    source_language character varying(8) NOT NULL,
    target_text text NOT NULL,
    target_language character varying(8) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 216 (class 1259 OID 113267)
-- Dependencies: 6
-- Name: google_maps_location_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE google_maps_location_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3623 (class 0 OID 0)
-- Dependencies: 216
-- Name: google_maps_location_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('google_maps_location_seq', 0, false);


--
-- TOC entry 217 (class 1259 OID 113269)
-- Dependencies: 6
-- Name: greeting; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE greeting (
    sender_id numeric(10,0) NOT NULL,
    recipient_id numeric(10,0) NOT NULL
);


--
-- TOC entry 218 (class 1259 OID 113272)
-- Dependencies: 2699 2700 2701 2702 2703 6
-- Name: group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "group" (
    group_id bigint NOT NULL,
    group_name character varying(255) NOT NULL,
    network_id bigint NOT NULL,
    description text NOT NULL,
    recent_news text,
    office character varying(255),
    website character varying(255),
    email character varying(255),
    contact_name character varying(255),
    street character varying(255),
    zipcode character varying(10),
    city character varying(255),
    state character varying(255),
    country_id bigint,
    closed boolean,
    image character varying(255),
    group_owner_person_id bigint NOT NULL,
    keywords character varying(255),
    activated boolean DEFAULT true NOT NULL,
    member_may_post_image boolean DEFAULT true NOT NULL,
    member_may_post_video boolean DEFAULT true NOT NULL,
    member_may_post_document boolean DEFAULT true NOT NULL,
    invitable_for integer DEFAULT 5 NOT NULL
);


--
-- TOC entry 219 (class 1259 OID 113283)
-- Dependencies: 2704 2705 6
-- Name: group_member; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE group_member (
    group_id bigint NOT NULL,
    person_id bigint NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    member_date timestamp with time zone DEFAULT now() NOT NULL,
    inviter_id bigint
);


--
-- TOC entry 220 (class 1259 OID 113288)
-- Dependencies: 6
-- Name: group_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE group_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3624 (class 0 OID 0)
-- Dependencies: 220
-- Name: group_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('group_seq', 0, false);


--
-- TOC entry 221 (class 1259 OID 113290)
-- Dependencies: 6
-- Name: group_subtype_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE group_subtype_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3625 (class 0 OID 0)
-- Dependencies: 221
-- Name: group_subtype_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('group_subtype_seq', 0, false);


--
-- TOC entry 222 (class 1259 OID 113292)
-- Dependencies: 6
-- Name: group_type_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE group_type_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3626 (class 0 OID 0)
-- Dependencies: 222
-- Name: group_type_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('group_type_seq', 0, false);


--
-- TOC entry 223 (class 1259 OID 113294)
-- Dependencies: 6
-- Name: ignorelist; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE ignorelist (
    person_id numeric(10,0) NOT NULL,
    ignored_id numeric(10,0) NOT NULL
);


--
-- TOC entry 224 (class 1259 OID 113297)
-- Dependencies: 2706 6
-- Name: image; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE image (
    id bigint NOT NULL,
    title character varying(255) NOT NULL,
    album_id bigint NOT NULL,
    filename character varying(255) NOT NULL,
    owner_id bigint NOT NULL,
    "order" integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 225 (class 1259 OID 113304)
-- Dependencies: 2707 6
-- Name: image_comment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE image_comment (
    id bigint NOT NULL,
    comment text NOT NULL,
    person_id bigint NOT NULL,
    image_id bigint NOT NULL,
    createdate timestamp with time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 226 (class 1259 OID 113311)
-- Dependencies: 6
-- Name: image_comment_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE image_comment_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3627 (class 0 OID 0)
-- Dependencies: 226
-- Name: image_comment_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('image_comment_seq', 0, false);


--
-- TOC entry 227 (class 1259 OID 113313)
-- Dependencies: 6
-- Name: image_person_link; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE image_person_link (
    person_id bigint NOT NULL,
    image_id bigint NOT NULL
);


--
-- TOC entry 228 (class 1259 OID 113316)
-- Dependencies: 6
-- Name: image_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE image_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3628 (class 0 OID 0)
-- Dependencies: 228
-- Name: image_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('image_seq', 0, false);


--
-- TOC entry 229 (class 1259 OID 113318)
-- Dependencies: 6
-- Name: industries; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE industries (
    id integer NOT NULL,
    language character varying(5) NOT NULL,
    name character varying(100)
);


--
-- TOC entry 230 (class 1259 OID 113321)
-- Dependencies: 6
-- Name: job_status; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE job_status (
    id integer NOT NULL,
    language character varying(5) NOT NULL,
    name character varying(100)
);


--
-- TOC entry 231 (class 1259 OID 113324)
-- Dependencies: 2708 2709 6
-- Name: kadgets; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE kadgets (
    id bigint NOT NULL,
    owner_id bigint NOT NULL,
    name character varying(50) NOT NULL,
    description character varying(512) NOT NULL,
    url character varying(128) NOT NULL,
    is_published boolean DEFAULT false NOT NULL,
    is_external boolean DEFAULT false
);


--
-- TOC entry 232 (class 1259 OID 113332)
-- Dependencies: 2710 6
-- Name: language; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE language (
    id character(2) NOT NULL,
    name character varying(50),
    translated boolean DEFAULT false
);


--
-- TOC entry 233 (class 1259 OID 113336)
-- Dependencies: 6
-- Name: map_document_files_appointments_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE map_document_files_appointments_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3629 (class 0 OID 0)
-- Dependencies: 233
-- Name: map_document_files_appointments_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('map_document_files_appointments_seq', 0, false);


--
-- TOC entry 234 (class 1259 OID 113338)
-- Dependencies: 2711 6
-- Name: map_document_files_appointments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_document_files_appointments (
    id bigint DEFAULT nextval('map_document_files_appointments_seq'::regclass) NOT NULL,
    document_file_id bigint NOT NULL,
    appointment_id bigint NOT NULL
);


--
-- TOC entry 235 (class 1259 OID 113342)
-- Dependencies: 6
-- Name: map_document_files_groups_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE map_document_files_groups_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3630 (class 0 OID 0)
-- Dependencies: 235
-- Name: map_document_files_groups_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('map_document_files_groups_seq', 0, false);


--
-- TOC entry 236 (class 1259 OID 113344)
-- Dependencies: 2712 6
-- Name: map_document_files_groups; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_document_files_groups (
    id bigint DEFAULT nextval('map_document_files_groups_seq'::regclass) NOT NULL,
    document_file_id bigint NOT NULL,
    group_id bigint NOT NULL
);


--
-- TOC entry 237 (class 1259 OID 113348)
-- Dependencies: 6
-- Name: map_document_files_networks_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE map_document_files_networks_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3631 (class 0 OID 0)
-- Dependencies: 237
-- Name: map_document_files_networks_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('map_document_files_networks_seq', 0, false);


--
-- TOC entry 238 (class 1259 OID 113350)
-- Dependencies: 2713 6
-- Name: map_document_files_networks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_document_files_networks (
    id bigint DEFAULT nextval('map_document_files_networks_seq'::regclass) NOT NULL,
    document_file_id bigint NOT NULL,
    network_id bigint NOT NULL
);


--
-- TOC entry 239 (class 1259 OID 113354)
-- Dependencies: 6
-- Name: map_document_files_wiki_groups_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE map_document_files_wiki_groups_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3632 (class 0 OID 0)
-- Dependencies: 239
-- Name: map_document_files_wiki_groups_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('map_document_files_wiki_groups_seq', 0, false);


--
-- TOC entry 240 (class 1259 OID 113356)
-- Dependencies: 2714 6
-- Name: map_document_files_wiki_groups; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_document_files_wiki_groups (
    id bigint DEFAULT nextval('map_document_files_wiki_groups_seq'::regclass) NOT NULL,
    document_file_id bigint NOT NULL,
    wiki_group_id bigint NOT NULL
);


--
-- TOC entry 241 (class 1259 OID 113360)
-- Dependencies: 6
-- Name: map_kadgets_networks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_kadgets_networks (
    id bigint NOT NULL,
    kadget_id bigint NOT NULL,
    network_id bigint NOT NULL,
    "position" integer NOT NULL
);


--
-- TOC entry 242 (class 1259 OID 113363)
-- Dependencies: 6
-- Name: map_network_city; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_network_city (
    network_id bigint NOT NULL,
    city_id bigint NOT NULL
);


--
-- TOC entry 243 (class 1259 OID 113366)
-- Dependencies: 2715 2716 6
-- Name: map_person_network; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_person_network (
    person_id numeric(10,0) NOT NULL,
    network_id bigint NOT NULL,
    join_date timestamp without time zone DEFAULT now() NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    inviter_id bigint NOT NULL
);


--
-- TOC entry 244 (class 1259 OID 113371)
-- Dependencies: 6
-- Name: map_person_person; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_person_person (
    person_id numeric(10,0) NOT NULL,
    friend_id numeric(10,0) NOT NULL
);


--
-- TOC entry 245 (class 1259 OID 113374)
-- Dependencies: 6
-- Name: map_person_person_invite; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_person_person_invite (
    person_id numeric(10,0) NOT NULL,
    friend_id numeric(10,0) NOT NULL,
    message text
);


--
-- TOC entry 246 (class 1259 OID 113380)
-- Dependencies: 6
-- Name: map_person_relationshiptype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_person_relationshiptype (
    person_id numeric(10,0) NOT NULL,
    relationshiptype_id numeric(2,0) NOT NULL
);


--
-- TOC entry 247 (class 1259 OID 113383)
-- Dependencies: 6
-- Name: map_url_network; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE map_url_network (
    url character varying(50) NOT NULL,
    network_id bigint NOT NULL,
    current boolean NOT NULL
);


--
-- TOC entry 248 (class 1259 OID 113386)
-- Dependencies: 6
-- Name: mdl_album_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_album_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3633 (class 0 OID 0)
-- Dependencies: 248
-- Name: mdl_album_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_album_seq', 0, false);


--
-- TOC entry 249 (class 1259 OID 113388)
-- Dependencies: 2717 2718 2719 2720 2721 2722 2723 2724 6
-- Name: mdl_album; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_album (
    id bigint DEFAULT nextval('mdl_album_seq'::regclass) NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    is_module boolean DEFAULT true NOT NULL,
    owner_id bigint DEFAULT (-1),
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    edit_date timestamp without time zone DEFAULT now() NOT NULL,
    title character varying(255) NOT NULL,
    description text DEFAULT ''::text NOT NULL,
    location character varying(80) DEFAULT ''::character varying NOT NULL,
    friends_only boolean DEFAULT true NOT NULL,
    old_album_id bigint
);


--
-- TOC entry 250 (class 1259 OID 113402)
-- Dependencies: 6
-- Name: mdl_album_image_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_album_image_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3634 (class 0 OID 0)
-- Dependencies: 250
-- Name: mdl_album_image_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_album_image_seq', 0, false);


--
-- TOC entry 251 (class 1259 OID 113404)
-- Dependencies: 2725 2726 2727 2728 6
-- Name: mdl_album_image; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_album_image (
    id bigint DEFAULT nextval('mdl_album_image_seq'::regclass) NOT NULL,
    title character varying(255) NOT NULL,
    album_id bigint NOT NULL,
    filename character varying(255) NOT NULL,
    owner_id bigint DEFAULT (-1) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    edit_date timestamp without time zone DEFAULT now() NOT NULL,
    old_album_image_id bigint
);


--
-- TOC entry 252 (class 1259 OID 113414)
-- Dependencies: 6
-- Name: mdl_comments_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_comments_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3635 (class 0 OID 0)
-- Dependencies: 252
-- Name: mdl_comments_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_comments_seq', 0, false);


--
-- TOC entry 253 (class 1259 OID 113416)
-- Dependencies: 2729 2730 2731 6
-- Name: mdl_comments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_comments (
    id bigint DEFAULT nextval('mdl_comments_seq'::regclass) NOT NULL,
    author_id bigint DEFAULT (-1),
    text character varying(1000) NOT NULL,
    posted_at timestamp without time zone DEFAULT now() NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    custom_info character varying(255)
);


--
-- TOC entry 254 (class 1259 OID 113425)
-- Dependencies: 6
-- Name: mdl_document_versions_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_document_versions_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3636 (class 0 OID 0)
-- Dependencies: 254
-- Name: mdl_document_versions_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_document_versions_seq', 0, false);


--
-- TOC entry 255 (class 1259 OID 113427)
-- Dependencies: 2732 2733 2734 2735 2736 6
-- Name: mdl_document_versions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_document_versions (
    id bigint DEFAULT nextval('mdl_document_versions_seq'::regclass) NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    filename character varying(256) NOT NULL,
    document_id bigint NOT NULL,
    url character varying(1024) NOT NULL,
    uploaded_by bigint DEFAULT (-1) NOT NULL,
    uploaded_at timestamp without time zone DEFAULT now() NOT NULL,
    size bigint NOT NULL,
    file_type_id bigint NOT NULL,
    restored_from integer,
    CONSTRAINT mdl_document_versions_positive_size CHECK ((size > 0))
);


--
-- TOC entry 256 (class 1259 OID 113438)
-- Dependencies: 6
-- Name: mdl_documents_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_documents_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3637 (class 0 OID 0)
-- Dependencies: 256
-- Name: mdl_documents_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_documents_seq', 0, false);


--
-- TOC entry 257 (class 1259 OID 113440)
-- Dependencies: 2737 2738 2739 2740 2741 2742 6
-- Name: mdl_documents; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_documents (
    id bigint DEFAULT nextval('mdl_documents_seq'::regclass) NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    description character varying(1024),
    keywords character varying(4096),
    download_count bigint DEFAULT 0 NOT NULL,
    checked_out_by bigint DEFAULT (-1),
    checked_out_at timestamp without time zone,
    status integer DEFAULT 0 NOT NULL,
    status_changed_by bigint DEFAULT (-1),
    status_changed_at timestamp without time zone,
    CONSTRAINT mdl_document_files_positive_download_count CHECK ((download_count >= 0))
);


--
-- TOC entry 258 (class 1259 OID 113452)
-- Dependencies: 6
-- Name: mdl_forum_migration; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_forum_migration (
    entity_id bigint,
    old_forum_id bigint
);


--
-- TOC entry 259 (class 1259 OID 113455)
-- Dependencies: 6
-- Name: mdl_forum_topic_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_forum_topic_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3638 (class 0 OID 0)
-- Dependencies: 259
-- Name: mdl_forum_topic_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_forum_topic_seq', 0, false);


--
-- TOC entry 260 (class 1259 OID 113457)
-- Dependencies: 2743 2744 2745 2746 2747 2748 6
-- Name: mdl_forum_topic; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_forum_topic (
    id bigint DEFAULT nextval('mdl_forum_topic_seq'::regclass) NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    caption character varying(255) NOT NULL,
    edit_date timestamp without time zone DEFAULT now() NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL,
    last_replier_id bigint DEFAULT (-1) NOT NULL,
    hits bigint DEFAULT 0 NOT NULL,
    old_topic_id bigint
);


--
-- TOC entry 261 (class 1259 OID 113466)
-- Dependencies: 6
-- Name: mdl_forum_topic_article_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_forum_topic_article_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3639 (class 0 OID 0)
-- Dependencies: 261
-- Name: mdl_forum_topic_article_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_forum_topic_article_seq', 0, false);


--
-- TOC entry 262 (class 1259 OID 113468)
-- Dependencies: 2749 2750 2751 2752 6
-- Name: mdl_forum_topic_article; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_forum_topic_article (
    id bigint DEFAULT nextval('mdl_forum_topic_article_seq'::regclass) NOT NULL,
    topic_id bigint NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL,
    article_text text NOT NULL,
    editor_id bigint DEFAULT (-1),
    edit_date timestamp without time zone,
    edit_reason character varying(50)
);


--
-- TOC entry 263 (class 1259 OID 113478)
-- Dependencies: 6
-- Name: mdl_videolink_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE mdl_videolink_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3640 (class 0 OID 0)
-- Dependencies: 263
-- Name: mdl_videolink_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('mdl_videolink_seq', 0, false);


--
-- TOC entry 264 (class 1259 OID 113480)
-- Dependencies: 2753 2754 2755 2756 2757 6
-- Name: mdl_videolink; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mdl_videolink (
    id bigint DEFAULT nextval('mdl_videolink_seq'::regclass) NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    title character varying(255) NOT NULL,
    url character varying(255) NOT NULL,
    edit_date timestamp without time zone DEFAULT now() NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL,
    public boolean DEFAULT true NOT NULL
);


--
-- TOC entry 265 (class 1259 OID 113491)
-- Dependencies: 2758 6
-- Name: message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE message (
    message_id numeric(10,0) NOT NULL,
    sender_id numeric(10,0) NOT NULL,
    message text NOT NULL,
    subject character varying(255) NOT NULL,
    date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 266 (class 1259 OID 113498)
-- Dependencies: 6
-- Name: message_inbox; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE message_inbox (
    owner_id numeric(10,0) NOT NULL,
    message_id numeric(10,0) NOT NULL,
    message_status numeric(1,0) NOT NULL
);


--
-- TOC entry 267 (class 1259 OID 113501)
-- Dependencies: 6
-- Name: message_outbox; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE message_outbox (
    owner_id numeric(10,0) NOT NULL,
    message_id numeric(10,0) NOT NULL,
    message_status numeric(1,0) NOT NULL
);


--
-- TOC entry 268 (class 1259 OID 113504)
-- Dependencies: 6
-- Name: message_recipients; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE message_recipients (
    message_id numeric(10,0) NOT NULL,
    recipient_id numeric(10,0) NOT NULL
);


--
-- TOC entry 269 (class 1259 OID 113507)
-- Dependencies: 6
-- Name: messageid_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE messageid_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3641 (class 0 OID 0)
-- Dependencies: 269
-- Name: messageid_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('messageid_seq', 0, false);


--
-- TOC entry 270 (class 1259 OID 113509)
-- Dependencies: 6
-- Name: native; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE native (
    id bigint NOT NULL,
    native character varying(255)
);


--
-- TOC entry 271 (class 1259 OID 113512)
-- Dependencies: 6
-- Name: native_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE native_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3642 (class 0 OID 0)
-- Dependencies: 271
-- Name: native_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('native_seq', 107, true);


--
-- TOC entry 272 (class 1259 OID 113514)
-- Dependencies: 2759 2760 6
-- Name: network; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network (
    id bigint NOT NULL,
    name character varying(255),
    type smallint,
    description character varying(512),
    parent_id bigint,
    url character varying(50),
    additional_url character varying(255),
    subtitle character varying(200),
    keywords character varying(100),
    language character(2),
    logo character varying(255),
    banner character varying(255),
    icon character varying(255),
    homepage_url character varying(255),
    closed boolean NOT NULL,
    is_additional_url_deactivated boolean DEFAULT false NOT NULL,
    visible_for integer,
    access_for integer,
    invitable_for integer,
    google_maps_api_key character varying(255),
    sort_priority integer,
    redirect_to_network_id bigint,
    horizontal_navigation character varying(255),
    navigation_separator character varying(255),
    heading_box character varying(255),
    widgets_show_sub_networks boolean DEFAULT false NOT NULL
);


--
-- TOC entry 273 (class 1259 OID 113522)
-- Dependencies: 6
-- Name: network_designs; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network_designs (
    network_id bigint NOT NULL,
    page_border_color character(7),
    navigation_background_color character(7),
    navigation_quicklink_color character(7),
    navigation_separator_background_color character(7),
    navigation_separator_text_color character(7),
    header_background_color character(7),
    header_border_color character(7),
    header_text_color character(7),
    header_link_color character(7),
    heading_box_background_color character(7),
    heading_box_text_color character(7),
    heading_box_border_color character(7),
    subheading_box_background_color character(7),
    subheading_box_text_color character(7),
    subheading_box_link_color character(7),
    subheading_box_border_color character(7),
    subheading_box_line_color character(7),
    inner_background_color character(7),
    outer_background_color character(7),
    text_color character(7),
    link_color character(7),
    border_color character(7),
    button_background_color character(7),
    button_text_color character(7),
    box_top_border boolean,
    box_bottom_border boolean,
    box_left_border boolean,
    box_right_border boolean,
    horizontal_navigation_background_color character(7),
    horizontal_navigation_link_color character(7)
);


--
-- TOC entry 274 (class 1259 OID 113525)
-- Dependencies: 2761 2762 6
-- Name: network_links; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network_links (
    network_id1 bigint NOT NULL,
    network_id2 bigint NOT NULL,
    status integer NOT NULL,
    member_date timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT network_links_check CHECK ((network_id1 <> network_id2))
);


--
-- TOC entry 275 (class 1259 OID 113530)
-- Dependencies: 6
-- Name: network_navigation_links; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network_navigation_links (
    id bigint NOT NULL,
    network_id bigint NOT NULL,
    text character varying(63),
    target character varying(255),
    list_index integer NOT NULL
);


--
-- TOC entry 276 (class 1259 OID 113533)
-- Dependencies: 6
-- Name: network_navigation_links_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE network_navigation_links_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3643 (class 0 OID 0)
-- Dependencies: 276
-- Name: network_navigation_links_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('network_navigation_links_seq', 1, false);


--
-- TOC entry 277 (class 1259 OID 113535)
-- Dependencies: 2763 6
-- Name: network_news; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network_news (
    id bigint NOT NULL,
    network_id bigint NOT NULL,
    person_id bigint NOT NULL,
    heading character varying(120) NOT NULL,
    content character varying(4000) NOT NULL,
    link character varying(255),
    posted_on timestamp(0) with time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 278 (class 1259 OID 113542)
-- Dependencies: 6 277
-- Name: network_news_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE network_news_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3644 (class 0 OID 0)
-- Dependencies: 278
-- Name: network_news_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE network_news_id_seq OWNED BY network_news.id;


--
-- TOC entry 3645 (class 0 OID 0)
-- Dependencies: 278
-- Name: network_news_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('network_news_id_seq', 1, false);


--
-- TOC entry 279 (class 1259 OID 113544)
-- Dependencies: 6
-- Name: network_news_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE network_news_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3646 (class 0 OID 0)
-- Dependencies: 279
-- Name: network_news_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('network_news_seq', 0, false);


--
-- TOC entry 280 (class 1259 OID 113546)
-- Dependencies: 6
-- Name: network_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network_type (
    id smallint NOT NULL,
    name character varying(255)
);


--
-- TOC entry 281 (class 1259 OID 113549)
-- Dependencies: 6
-- Name: network_valid_child_type; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network_valid_child_type (
    parent_type smallint NOT NULL,
    child_type smallint NOT NULL
);


--
-- TOC entry 282 (class 1259 OID 113552)
-- Dependencies: 2765 2766 2767 2768 2769 2770 2771 2772 2773 2774 2775 2776 2777 2778 2779 2780 2781 2782 2783 2784 2785 2786 2787 2788 6
-- Name: network_widget_configurations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE network_widget_configurations (
    network_id bigint NOT NULL,
    is_member_images_visible boolean DEFAULT true NOT NULL,
    is_feed_visible boolean DEFAULT true NOT NULL,
    is_news_visible boolean DEFAULT true NOT NULL,
    is_events_visible boolean DEFAULT true NOT NULL,
    is_member_videolinks_visible boolean DEFAULT true NOT NULL,
    is_forum_visible boolean DEFAULT true NOT NULL,
    is_wall_visible boolean DEFAULT true NOT NULL,
    is_members_visible boolean DEFAULT true NOT NULL,
    is_groups_visible boolean DEFAULT true NOT NULL,
    is_images_visible boolean DEFAULT true NOT NULL,
    is_videolinks_visible boolean DEFAULT true NOT NULL,
    is_details_visible boolean DEFAULT true NOT NULL,
    is_news_member_writable boolean DEFAULT true NOT NULL,
    is_events_member_writable boolean DEFAULT true NOT NULL,
    is_images_member_writable boolean DEFAULT true NOT NULL,
    is_videolinks_member_writable boolean DEFAULT true NOT NULL,
    is_kadgets_visible boolean DEFAULT true NOT NULL,
    is_network_links_visible boolean,
    is_documents_visible boolean DEFAULT true NOT NULL,
    is_documents_member_writable boolean DEFAULT true NOT NULL,
    is_wikis_visible boolean DEFAULT true NOT NULL,
    is_wiki_tag_cloud_visible boolean DEFAULT true NOT NULL,
    is_google_map_visible boolean DEFAULT true NOT NULL,
    member_images_position integer NOT NULL,
    feed_position integer NOT NULL,
    news_position integer NOT NULL,
    events_position integer NOT NULL,
    member_videolinks_position integer NOT NULL,
    forum_position integer NOT NULL,
    wall_position integer NOT NULL,
    members_position integer NOT NULL,
    groups_position integer NOT NULL,
    images_position integer NOT NULL,
    videolinks_position integer NOT NULL,
    details_position integer NOT NULL,
    kadgets_position integer DEFAULT 8 NOT NULL,
    network_links_position integer,
    documents_position integer DEFAULT 4 NOT NULL,
    wikis_position integer NOT NULL,
    wiki_tag_cloud_position integer NOT NULL,
    google_map_position integer NOT NULL
);


--
-- TOC entry 283 (class 1259 OID 113579)
-- Dependencies: 6
-- Name: newsblog_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE newsblog_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3647 (class 0 OID 0)
-- Dependencies: 283
-- Name: newsblog_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('newsblog_seq', 0, false);


--
-- TOC entry 284 (class 1259 OID 113581)
-- Dependencies: 2789 2790 2791 2792 2793 2794 2795 2796 6
-- Name: newsblog; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE newsblog (
    id bigint DEFAULT nextval('newsblog_seq'::regclass) NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    headline character varying(255) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    edit_date timestamp without time zone DEFAULT now() NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL,
    source_text character varying(255) DEFAULT ''::character varying NOT NULL,
    source_href character varying(255) DEFAULT ''::character varying NOT NULL,
    keywords character varying(255) DEFAULT ''::character varying NOT NULL,
    text text NOT NULL,
    image_id bigint,
    draft boolean DEFAULT false NOT NULL
);


--
-- TOC entry 285 (class 1259 OID 113595)
-- Dependencies: 6
-- Name: occupations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE occupations (
    id integer NOT NULL,
    language character varying(5) NOT NULL,
    name character varying(100)
);


--
-- TOC entry 286 (class 1259 OID 113598)
-- Dependencies: 6
-- Name: open_social_app_data; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE open_social_app_data (
    id numeric(10,0) NOT NULL,
    key character varying(100) NOT NULL,
    value character varying(10000) NOT NULL,
    kadget_id bigint,
    person_id bigint NOT NULL
);


--
-- TOC entry 287 (class 1259 OID 113604)
-- Dependencies: 2797 2798 2799 2800 2801 2802 2803 2804 2805 2806 2807 2808 2809 2810 2811 2812 2813 6
-- Name: person; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE person (
    person_id numeric(10,0) NOT NULL,
    last_login timestamp without time zone DEFAULT now() NOT NULL,
    show_tempstartpage boolean DEFAULT true NOT NULL,
    account_active boolean,
    title character varying(255),
    firstname character varying(50) NOT NULL,
    surname character varying(100) NOT NULL,
    email character varying(100),
    newmail character varying(100),
    activation_hash character varying(100),
    birthday date,
    password_hash character(28),
    keywords character varying(255),
    gender smallint DEFAULT 0 NOT NULL,
    zodiac_id numeric(2,0),
    relationshipstatus_id numeric(2,0),
    politview_id numeric(2,0),
    religview_id numeric(2,0),
    home_city character varying(255) DEFAULT ''::character varying,
    home_country character varying(255) DEFAULT ''::character varying,
    language_id character(2),
    current_city character varying(255) DEFAULT ''::character varying,
    current_country character varying(255) DEFAULT ''::character varying,
    password_question character varying(255),
    password_answer character varying(255),
    registerdate timestamp without time zone DEFAULT now(),
    terms_accepted boolean,
    image character varying(64),
    profile_visibility smallint DEFAULT 0 NOT NULL,
    friends_visibility boolean DEFAULT false NOT NULL,
    show_visits boolean DEFAULT true NOT NULL,
    show_image_loginpage boolean DEFAULT true NOT NULL,
    allow_newsletter boolean DEFAULT true,
    blocked boolean DEFAULT false NOT NULL,
    show_actions_in_networks boolean DEFAULT true NOT NULL,
    default_timezone character varying(100),
    modified_at timestamp without time zone,
    created_at timestamp without time zone DEFAULT now(),
    birthday_visibility character varying(64) DEFAULT 'NONE'::character varying,
    status_id smallint,
    hashed_id character varying(32) NOT NULL
);


--
-- TOC entry 288 (class 1259 OID 113627)
-- Dependencies: 6
-- Name: person_nofriends_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE person_nofriends_message (
    person_id bigint NOT NULL
);


--
-- TOC entry 289 (class 1259 OID 113630)
-- Dependencies: 6
-- Name: person_primary_network; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE person_primary_network (
    person_id bigint,
    network_id bigint
);


--
-- TOC entry 290 (class 1259 OID 113633)
-- Dependencies: 6
-- Name: personid_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE personid_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3648 (class 0 OID 0)
-- Dependencies: 290
-- Name: personid_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('personid_seq', 0, true);


--
-- TOC entry 291 (class 1259 OID 113635)
-- Dependencies: 6
-- Name: politview; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE politview (
    politview_id numeric(2,0) NOT NULL,
    politview_name character varying(50) NOT NULL
);


--
-- TOC entry 292 (class 1259 OID 113638)
-- Dependencies: 2814 2815 6
-- Name: profile_allowed_component; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE profile_allowed_component (
    component_type character varying(100) NOT NULL,
    "position" bigint NOT NULL,
    default_order integer NOT NULL,
    default_visibility integer NOT NULL,
    may_modify_visibility boolean NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 293 (class 1259 OID 113643)
-- Dependencies: 2816 2817 6
-- Name: profile_component; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE profile_component (
    person_id bigint NOT NULL,
    component_type character varying(100) NOT NULL,
    visibility integer NOT NULL,
    "position" bigint NOT NULL,
    "order" integer NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 294 (class 1259 OID 113648)
-- Dependencies: 2818 6
-- Name: profile_visitor; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE profile_visitor (
    visitor_id numeric(10,0) NOT NULL,
    profile_person_id numeric(10,0) NOT NULL,
    visit_date timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 295 (class 1259 OID 113652)
-- Dependencies: 6
-- Name: properties_tmp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE properties_tmp (
    property_name character varying(255) NOT NULL
);


--
-- TOC entry 296 (class 1259 OID 113655)
-- Dependencies: 6
-- Name: raweditor_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE raweditor_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3649 (class 0 OID 0)
-- Dependencies: 296
-- Name: raweditor_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('raweditor_seq', 0, false);


--
-- TOC entry 297 (class 1259 OID 113657)
-- Dependencies: 6
-- Name: raweditor_version_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE raweditor_version_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3650 (class 0 OID 0)
-- Dependencies: 297
-- Name: raweditor_version_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('raweditor_version_seq', 0, false);


--
-- TOC entry 298 (class 1259 OID 113659)
-- Dependencies: 2819 2820 2821 6
-- Name: raweditor_version; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE raweditor_version (
    id bigint DEFAULT nextval('raweditor_version_seq'::regclass) NOT NULL,
    raweditor_id bigint NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    editor_type character varying(32) NOT NULL,
    version integer NOT NULL,
    text text NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL
);


--
-- TOC entry 299 (class 1259 OID 113668)
-- Dependencies: 6
-- Name: relationshipstatus; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE relationshipstatus (
    relationshipstatus_id numeric(2,0) NOT NULL,
    relationshipstatus_name character varying(50) NOT NULL
);


--
-- TOC entry 300 (class 1259 OID 113671)
-- Dependencies: 6
-- Name: relationshiptype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE relationshiptype (
    relationshiptype_id numeric(2,0) NOT NULL,
    relationshiptype_name character varying(50) NOT NULL
);


--
-- TOC entry 301 (class 1259 OID 113674)
-- Dependencies: 6
-- Name: religview; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE religview (
    religview_id numeric(2,0) NOT NULL,
    religview_name character varying(50) NOT NULL
);


--
-- TOC entry 302 (class 1259 OID 113677)
-- Dependencies: 2822 2823 6
-- Name: rights; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE rights (
    person_id numeric(10,0) NOT NULL,
    is_admin boolean DEFAULT false NOT NULL,
    is_translator boolean DEFAULT true NOT NULL
);


--
-- TOC entry 303 (class 1259 OID 113682)
-- Dependencies: 6
-- Name: school; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE school (
    id numeric(10,0) NOT NULL,
    name character varying(50) NOT NULL,
    gradyear numeric(4,0) NOT NULL,
    person_id numeric(10,0) NOT NULL
);


--
-- TOC entry 304 (class 1259 OID 113685)
-- Dependencies: 6
-- Name: school_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE school_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3651 (class 0 OID 0)
-- Dependencies: 304
-- Name: school_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('school_seq', 0, false);


--
-- TOC entry 305 (class 1259 OID 113687)
-- Dependencies: 6
-- Name: schooltype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE schooltype (
    schooltype_id numeric(2,0) NOT NULL,
    schooltype_name character varying(50) NOT NULL
);


--
-- TOC entry 306 (class 1259 OID 113690)
-- Dependencies: 6
-- Name: seq_base_property; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_base_property
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3652 (class 0 OID 0)
-- Dependencies: 306
-- Name: seq_base_property; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_base_property', 3947, true);


--
-- TOC entry 307 (class 1259 OID 113692)
-- Dependencies: 6
-- Name: seq_cities; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_cities
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3653 (class 0 OID 0)
-- Dependencies: 307
-- Name: seq_cities; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_cities', 0, false);


--
-- TOC entry 308 (class 1259 OID 113694)
-- Dependencies: 6
-- Name: seq_domain_property; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_domain_property
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3654 (class 0 OID 0)
-- Dependencies: 308
-- Name: seq_domain_property; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_domain_property', 3560, true);


--
-- TOC entry 309 (class 1259 OID 113696)
-- Dependencies: 6
-- Name: seq_forum_article; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_forum_article
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3655 (class 0 OID 0)
-- Dependencies: 309
-- Name: seq_forum_article; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_forum_article', 0, false);


--
-- TOC entry 310 (class 1259 OID 113698)
-- Dependencies: 6
-- Name: seq_kadgets; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_kadgets
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3656 (class 0 OID 0)
-- Dependencies: 310
-- Name: seq_kadgets; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_kadgets', 0, false);


--
-- TOC entry 311 (class 1259 OID 113700)
-- Dependencies: 6
-- Name: seq_map_kadgets_networks; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_map_kadgets_networks
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3657 (class 0 OID 0)
-- Dependencies: 311
-- Name: seq_map_kadgets_networks; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_map_kadgets_networks', 0, false);


--
-- TOC entry 312 (class 1259 OID 113702)
-- Dependencies: 6
-- Name: seq_network; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_network
    START WITH 1000
    INCREMENT BY 1
    MINVALUE 1000
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3658 (class 0 OID 0)
-- Dependencies: 312
-- Name: seq_network; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_network', 1045, true);


--
-- TOC entry 313 (class 1259 OID 113704)
-- Dependencies: 6
-- Name: seq_open_social_app_data; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_open_social_app_data
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3659 (class 0 OID 0)
-- Dependencies: 313
-- Name: seq_open_social_app_data; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_open_social_app_data', 1, false);


--
-- TOC entry 314 (class 1259 OID 113706)
-- Dependencies: 6
-- Name: seq_start_page_profiles; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_start_page_profiles
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3660 (class 0 OID 0)
-- Dependencies: 314
-- Name: seq_start_page_profiles; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_start_page_profiles', 0, false);


--
-- TOC entry 315 (class 1259 OID 113708)
-- Dependencies: 6
-- Name: seq_status; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_status
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3661 (class 0 OID 0)
-- Dependencies: 315
-- Name: seq_status; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_status', 0, false);


--
-- TOC entry 316 (class 1259 OID 113710)
-- Dependencies: 6
-- Name: seq_version; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_version
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3662 (class 0 OID 0)
-- Dependencies: 316
-- Name: seq_version; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_version', 0, false);


--
-- TOC entry 317 (class 1259 OID 113712)
-- Dependencies: 2824 2825 6
-- Name: start_page_profiles; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE start_page_profiles (
    id bigint NOT NULL,
    person_id bigint NOT NULL,
    language character varying(2),
    activated boolean DEFAULT false NOT NULL,
    image character varying(255),
    deleted boolean DEFAULT false NOT NULL
);


--
-- TOC entry 318 (class 1259 OID 113717)
-- Dependencies: 6
-- Name: status; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE status (
    id bigint NOT NULL,
    default_short_status_name character varying(255) NOT NULL,
    default_long_status_name character varying(1024)
);


--
-- TOC entry 319 (class 1259 OID 113723)
-- Dependencies: 6
-- Name: status_translation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE status_translation (
    id bigint NOT NULL,
    status_id smallint NOT NULL,
    language character(2) NOT NULL,
    gender smallint,
    short_status_name character varying(255),
    long_status_name character varying(1024)
);


--
-- TOC entry 320 (class 1259 OID 113729)
-- Dependencies: 2826 2827 6
-- Name: subscription; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE subscription (
    id bigint NOT NULL,
    subscriber_id bigint NOT NULL,
    created_at timestamp without time zone DEFAULT now(),
    modified_at timestamp without time zone DEFAULT now(),
    subscription_type character varying(32) NOT NULL,
    item_id bigint,
    item_type character varying(32),
    entity_id bigint NOT NULL,
    component_type character varying(32)
);


--
-- TOC entry 321 (class 1259 OID 113734)
-- Dependencies: 2828 2829 2830 6
-- Name: subscription_notification; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE subscription_notification (
    id bigint NOT NULL,
    actor_id bigint NOT NULL,
    created_at timestamp without time zone DEFAULT now(),
    modified_at timestamp without time zone DEFAULT now(),
    subscription_type character varying(32) NOT NULL,
    notification_type character varying(32) NOT NULL,
    item_id bigint,
    item_type character varying(32),
    entity_id bigint NOT NULL,
    component_type character varying(32),
    in_progress boolean DEFAULT false NOT NULL,
    comment_id bigint
);


--
-- TOC entry 322 (class 1259 OID 113740)
-- Dependencies: 6
-- Name: subscription_notification_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE subscription_notification_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3663 (class 0 OID 0)
-- Dependencies: 322
-- Name: subscription_notification_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('subscription_notification_seq', 0, false);


--
-- TOC entry 323 (class 1259 OID 113742)
-- Dependencies: 6
-- Name: subscription_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE subscription_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3664 (class 0 OID 0)
-- Dependencies: 323
-- Name: subscription_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('subscription_seq', 0, false);


--
-- TOC entry 324 (class 1259 OID 113744)
-- Dependencies: 6
-- Name: survey_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE survey_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3665 (class 0 OID 0)
-- Dependencies: 324
-- Name: survey_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('survey_seq', 0, false);


--
-- TOC entry 325 (class 1259 OID 113746)
-- Dependencies: 2831 2832 2833 2834 6
-- Name: survey; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE survey (
    id bigint DEFAULT nextval('survey_seq'::regclass) NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    title character varying(255) NOT NULL,
    expired_date timestamp without time zone,
    owner_id bigint DEFAULT (-1) NOT NULL,
    result_visibilty integer NOT NULL,
    anonym boolean NOT NULL,
    participant_may_modify boolean NOT NULL,
    auto_delete_answers boolean NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 326 (class 1259 OID 113753)
-- Dependencies: 2835 2836 6
-- Name: survey_participant_answer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE survey_participant_answer (
    participant_id bigint,
    survey_question_id bigint NOT NULL,
    survey_predefined_multiple_choice_answer_id bigint,
    freetext_answer text,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 327 (class 1259 OID 113761)
-- Dependencies: 6
-- Name: survey_predefined_multiple_choice_answer_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE survey_predefined_multiple_choice_answer_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3666 (class 0 OID 0)
-- Dependencies: 327
-- Name: survey_predefined_multiple_choice_answer_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('survey_predefined_multiple_choice_answer_seq', 0, false);


--
-- TOC entry 328 (class 1259 OID 113763)
-- Dependencies: 2837 2838 2839 6
-- Name: survey_predefined_multiple_choice_answer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE survey_predefined_multiple_choice_answer (
    id bigint DEFAULT nextval('survey_predefined_multiple_choice_answer_seq'::regclass) NOT NULL,
    survey_question_id bigint NOT NULL,
    answer text NOT NULL,
    "order" integer,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 329 (class 1259 OID 113772)
-- Dependencies: 6
-- Name: survey_question_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE survey_question_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3667 (class 0 OID 0)
-- Dependencies: 329
-- Name: survey_question_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('survey_question_seq', 0, false);


--
-- TOC entry 330 (class 1259 OID 113774)
-- Dependencies: 2840 2841 2842 6
-- Name: survey_question; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE survey_question (
    id bigint DEFAULT nextval('survey_question_seq'::regclass) NOT NULL,
    survey_id bigint NOT NULL,
    question text NOT NULL,
    "order" integer,
    is_freetext_answer boolean NOT NULL,
    min_answer integer,
    max_answer integer,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now()
);


--
-- TOC entry 331 (class 1259 OID 113783)
-- Dependencies: 2843 6
-- Name: systemmessage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE systemmessage (
    id numeric(10,0) NOT NULL,
    action_code character varying(50) NOT NULL,
    date timestamp without time zone DEFAULT now(),
    creator_id numeric(10,0) NOT NULL,
    receiver_id numeric(10,0),
    friendsfriend_id numeric(10,0),
    group_id bigint,
    wiki_group_id bigint,
    video_post_id bigint,
    topic_id bigint,
    foto_id bigint,
    network_id bigint,
    album_id bigint,
    appointment_id bigint,
    document_version_id bigint,
    document_file_id bigint
);


--
-- TOC entry 332 (class 1259 OID 113787)
-- Dependencies: 6
-- Name: systemmessageid_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE systemmessageid_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3668 (class 0 OID 0)
-- Dependencies: 332
-- Name: systemmessageid_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('systemmessageid_seq', 0, false);


--
-- TOC entry 333 (class 1259 OID 113789)
-- Dependencies: 6
-- Name: translation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE translation (
    language_id character(2) NOT NULL,
    native_id bigint NOT NULL,
    translation character varying(255)
);


--
-- TOC entry 334 (class 1259 OID 113792)
-- Dependencies: 6
-- Name: uni_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE uni_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3669 (class 0 OID 0)
-- Dependencies: 334
-- Name: uni_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('uni_seq', 0, false);


--
-- TOC entry 335 (class 1259 OID 113794)
-- Dependencies: 6
-- Name: university; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE university (
    id numeric(10,0) NOT NULL,
    name character varying(50) NOT NULL,
    degree character varying(50) NOT NULL,
    course character varying(50) NOT NULL,
    gradyear numeric(4,0) NOT NULL,
    person_id numeric(10,0) NOT NULL,
    university_department_id bigint
);


--
-- TOC entry 336 (class 1259 OID 113797)
-- Dependencies: 6
-- Name: university_department; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE university_department (
    id bigint NOT NULL,
    language character varying(5) NOT NULL,
    name character varying(255) NOT NULL
);


--
-- TOC entry 337 (class 1259 OID 113800)
-- Dependencies: 6
-- Name: universitytype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE universitytype (
    universitytype_id numeric(2,0) NOT NULL,
    universitytype_name character varying(50) NOT NULL
);


--
-- TOC entry 338 (class 1259 OID 113803)
-- Dependencies: 6
-- Name: version; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE version (
    id bigint NOT NULL,
    release character varying(255),
    name character varying(255),
    type character varying(255),
    description text,
    date timestamp without time zone
);


--
-- TOC entry 339 (class 1259 OID 113809)
-- Dependencies: 2844 2845 6
-- Name: videolink; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE videolink (
    id numeric(10,0) NOT NULL,
    url character varying(70) NOT NULL,
    description character varying(1000) NOT NULL,
    date timestamp without time zone DEFAULT now(),
    owner_id bigint,
    network_id bigint,
    group_id bigint,
    public boolean DEFAULT false NOT NULL
);


--
-- TOC entry 340 (class 1259 OID 113817)
-- Dependencies: 2846 6
-- Name: videolink_comment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE videolink_comment (
    id numeric(10,0) NOT NULL,
    message character varying(1000) NOT NULL,
    videolink_id numeric(10,0),
    author_id numeric(10,0) NOT NULL,
    createtime timestamp without time zone DEFAULT now()
);


--
-- TOC entry 341 (class 1259 OID 113824)
-- Dependencies: 6
-- Name: videolink_comment_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE videolink_comment_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3670 (class 0 OID 0)
-- Dependencies: 341
-- Name: videolink_comment_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('videolink_comment_seq', 0, false);


--
-- TOC entry 342 (class 1259 OID 113826)
-- Dependencies: 6
-- Name: videolink_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE videolink_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3671 (class 0 OID 0)
-- Dependencies: 342
-- Name: videolink_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('videolink_seq', 0, false);


--
-- TOC entry 343 (class 1259 OID 113828)
-- Dependencies: 2847 6
-- Name: wallmessage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wallmessage (
    wallmessage_id numeric(10,0) NOT NULL,
    author_id numeric(10,0) NOT NULL,
    recipient_id numeric(10,0),
    message character varying(1000) NOT NULL,
    date timestamp without time zone DEFAULT now(),
    document_version integer,
    group_id bigint,
    network_id bigint,
    document_id bigint,
    wiki_group_id bigint,
    appointment_id bigint
);


--
-- TOC entry 344 (class 1259 OID 113835)
-- Dependencies: 6
-- Name: wallmessageid_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE wallmessageid_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3672 (class 0 OID 0)
-- Dependencies: 344
-- Name: wallmessageid_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('wallmessageid_seq', 0, false);


--
-- TOC entry 345 (class 1259 OID 113837)
-- Dependencies: 6
-- Name: wiki_editor_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE wiki_editor_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3673 (class 0 OID 0)
-- Dependencies: 345
-- Name: wiki_editor_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('wiki_editor_seq', 0, false);


--
-- TOC entry 346 (class 1259 OID 113839)
-- Dependencies: 2848 6
-- Name: wiki_editor; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_editor (
    id bigint DEFAULT nextval('wiki_editor_seq'::regclass) NOT NULL,
    parent_item_id bigint NOT NULL,
    parent_item_type character varying(32) NOT NULL,
    old_group_id bigint
);


--
-- TOC entry 347 (class 1259 OID 113843)
-- Dependencies: 2849 6
-- Name: wiki_editor_backup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_editor_backup (
    wiki_editor_id bigint NOT NULL,
    headline character varying(255) NOT NULL,
    wiki_text text NOT NULL,
    author_id bigint NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 348 (class 1259 OID 113850)
-- Dependencies: 6
-- Name: wiki_editor_version_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE wiki_editor_version_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3674 (class 0 OID 0)
-- Dependencies: 348
-- Name: wiki_editor_version_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('wiki_editor_version_seq', 0, false);


--
-- TOC entry 349 (class 1259 OID 113852)
-- Dependencies: 2850 2851 2852 2853 6
-- Name: wiki_editor_version; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_editor_version (
    id bigint DEFAULT nextval('wiki_editor_version_seq'::regclass) NOT NULL,
    wiki_editor_id bigint NOT NULL,
    headline character varying(255) NOT NULL,
    wiki_text text NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    restored_from bigint,
    old_page_id bigint
);


--
-- TOC entry 350 (class 1259 OID 113862)
-- Dependencies: 6
-- Name: wiki_group_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE wiki_group_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3675 (class 0 OID 0)
-- Dependencies: 350
-- Name: wiki_group_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('wiki_group_seq', 0, false);


--
-- TOC entry 351 (class 1259 OID 113864)
-- Dependencies: 2854 2855 2856 6
-- Name: wiki_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_group (
    id bigint DEFAULT nextval('wiki_group_seq'::regclass) NOT NULL,
    network_id bigint NOT NULL,
    image character varying(255),
    create_date timestamp without time zone DEFAULT now(),
    name character varying(255) NOT NULL,
    zipcode character varying(10),
    institution character varying(255),
    contact_name character varying(255),
    state character varying(255),
    description character varying(4096),
    keywords character varying(4096),
    street character varying(255),
    city character varying(255),
    country_id bigint,
    accessible_for integer,
    visible_for integer,
    editable_for integer,
    invitable_for integer DEFAULT 5
);


--
-- TOC entry 352 (class 1259 OID 113873)
-- Dependencies: 2857 2858 6
-- Name: wiki_group_member; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_group_member (
    wiki_group_id bigint NOT NULL,
    inviter_id bigint,
    person_id bigint NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    member_date timestamp with time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 353 (class 1259 OID 113878)
-- Dependencies: 2859 2860 2861 2862 2863 2864 2865 2866 2867 6
-- Name: wiki_group_widget_configurations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_group_widget_configurations (
    wiki_group_id bigint NOT NULL,
    is_member_images_visible boolean DEFAULT true NOT NULL,
    is_members_visible boolean DEFAULT true NOT NULL,
    is_forum_visible boolean DEFAULT true NOT NULL,
    is_wall_visible boolean DEFAULT true NOT NULL,
    is_documents_visible boolean DEFAULT true NOT NULL,
    is_privacy_visible boolean DEFAULT true NOT NULL,
    is_wikis_visible boolean DEFAULT true NOT NULL,
    is_groups_visible boolean DEFAULT true NOT NULL,
    is_admin_list_visible boolean DEFAULT true NOT NULL
);


--
-- TOC entry 354 (class 1259 OID 113890)
-- Dependencies: 6
-- Name: wiki_page_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE wiki_page_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3676 (class 0 OID 0)
-- Dependencies: 354
-- Name: wiki_page_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('wiki_page_seq', 0, false);


--
-- TOC entry 355 (class 1259 OID 113892)
-- Dependencies: 2868 2869 6
-- Name: wiki_page; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_page (
    id bigint DEFAULT nextval('wiki_page_seq'::regclass) NOT NULL,
    wiki_group_id bigint NOT NULL,
    headline character varying(255) NOT NULL,
    summary text,
    keywords character varying(4096),
    create_date timestamp without time zone DEFAULT now(),
    locked_by bigint
);


--
-- TOC entry 356 (class 1259 OID 113900)
-- Dependencies: 6
-- Name: wiki_page_backup_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE wiki_page_backup_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3677 (class 0 OID 0)
-- Dependencies: 356
-- Name: wiki_page_backup_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('wiki_page_backup_seq', 0, false);


--
-- TOC entry 357 (class 1259 OID 113902)
-- Dependencies: 2870 2871 6
-- Name: wiki_page_backup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_page_backup (
    id bigint DEFAULT nextval('wiki_page_backup_seq'::regclass) NOT NULL,
    wiki_page_id bigint NOT NULL,
    person_id bigint NOT NULL,
    headline character varying(255) NOT NULL,
    summary text,
    wiki_text text,
    keywords character varying(4096),
    edit_date timestamp without time zone DEFAULT now() NOT NULL
);


--
-- TOC entry 358 (class 1259 OID 113910)
-- Dependencies: 6
-- Name: wiki_page_version_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE wiki_page_version_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3678 (class 0 OID 0)
-- Dependencies: 358
-- Name: wiki_page_version_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('wiki_page_version_seq', 0, false);


--
-- TOC entry 359 (class 1259 OID 113912)
-- Dependencies: 2872 2873 2874 2875 6
-- Name: wiki_page_version; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE wiki_page_version (
    id bigint DEFAULT nextval('wiki_page_version_seq'::regclass) NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    wiki_text text NOT NULL,
    wiki_page_id bigint NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL,
    edit_date timestamp without time zone DEFAULT now() NOT NULL,
    restored_from bigint
);


--
-- TOC entry 360 (class 1259 OID 113922)
-- Dependencies: 6
-- Name: workstream; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE workstream (
    entry_id bigint NOT NULL,
    item_id bigint NOT NULL,
    item_type character varying(32) NOT NULL
);


--
-- TOC entry 361 (class 1259 OID 113925)
-- Dependencies: 6
-- Name: workstream_entries_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE workstream_entries_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3679 (class 0 OID 0)
-- Dependencies: 361
-- Name: workstream_entries_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('workstream_entries_seq', 0, false);


--
-- TOC entry 362 (class 1259 OID 113927)
-- Dependencies: 2876 2877 2878 6
-- Name: workstream_entries; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE workstream_entries (
    id bigint DEFAULT nextval('workstream_entries_seq'::regclass) NOT NULL,
    type character varying(32) NOT NULL,
    origin_item_id bigint NOT NULL,
    origin_item_type character varying(32) NOT NULL,
    author_id bigint DEFAULT (-1) NOT NULL,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    modified_at timestamp without time zone
);


--
-- TOC entry 363 (class 1259 OID 113933)
-- Dependencies: 6
-- Name: workstream_entry_attributes; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE workstream_entry_attributes (
    entry_id bigint NOT NULL,
    key character varying(24) NOT NULL,
    value character varying(5000) NOT NULL
);


--
-- TOC entry 364 (class 1259 OID 113939)
-- Dependencies: 6
-- Name: zodiac; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE zodiac (
    zodiac_id numeric(2,0) NOT NULL,
    zodiac_name character varying(50) NOT NULL
);


--
-- TOC entry 2764 (class 2604 OID 113942)
-- Dependencies: 278 277
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY network_news ALTER COLUMN id SET DEFAULT nextval('network_news_id_seq'::regclass);


--
-- TOC entry 3468 (class 0 OID 112938)
-- Dependencies: 161 3599
-- Data for Name: accepted_external_invitation; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 3469 (class 0 OID 112941)
-- Dependencies: 162 3599
-- Data for Name: adminnews; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 3470 (class 0 OID 112952)
-- Dependencies: 164 3599
-- Data for Name: album; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 3471 (class 0 OID 112962)
-- Dependencies: 166 3599
-- Data for Name: appointment_participant; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 3472 (class 0 OID 112972)
-- Dependencies: 168 3599
-- Data for Name: appointment_widget_configurations; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 3473 (class 0 OID 112987)
-- Dependencies: 169 3599
-- Data for Name: appointments; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 3474 (class 0 OID 112997)
-- Dependencies: 170 3599
-- Data for Name: base_property; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO base_property VALUES (172, 'Basic/Constants/invalidPasswordRetrievalKey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The link to reset your password is either invalid or older than one month. Please request a new one through the login page ("Forgot your password?" link).', 'O', 'messages', '2011-01-13 17:47:51.042', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (173, 'Entity/Constants/assignedTypeNotAllowed/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning element of this type is not allowed', 'O', 'messages', '2011-01-13 17:48:00.875', NULL, '2010-10-26 13:50:24.30358');
INSERT INTO base_property VALUES (174, 'NewsletterHtml/Messages/networkJoined', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (joined place <a href="{2}">{3}</a>)', 'O', 'messages', '2011-01-13 17:47:49.526', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (175, 'NewsletterHtml/Messages/newGroup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.581', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (176, 'Basic/Constants/maennlich', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Male', 'O', 'messages', '2010-10-22 17:52:24.189', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (177, 'Newsletter/Messages/newPhotosInGroup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group {0} (several new photos)', 'O', 'messages', '2011-01-13 17:47:49.749', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (178, 'Basic/Constants/ignoredUsers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Ignored users', 'O', 'messages', '2011-01-13 17:47:50.021', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (179, 'Basic/Constants/resendActivationMail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Resend activation e-mail', 'O', 'messages', '2011-01-13 17:47:50.073', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (180, 'Basic/Constants/localeTime', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Local time', 'O', 'messages', '2011-01-13 17:47:50.411', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (181, 'Basic/Constants/bitteAuswaehlen', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Please select', 'O', 'messages', '2010-10-22 17:52:24.886', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (182, 'Basic/Constants/noSubject', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<no subject>', 'O', 'messages', '2011-01-13 17:47:50.192', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (183, 'Basic/Constants/lieblingsmusik', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favorite music', 'O', 'messages', '2011-01-13 17:47:50.456', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (184, 'Basic/Constants/newsActive', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'News active', 'O', 'messages', '2011-01-13 17:47:51.046', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (185, 'Basic/Constants/fromUsersForUsers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'From users for users', 'O', 'messages', '2011-01-13 17:47:51.276', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (186, 'Basic/Messages/xPostYtimesReaded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} posts, {1} times read', 'O', 'messages', '2011-01-13 17:47:51.899', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (187, 'Basic/Messages/fieldInvalidData', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The data of field "{0}" are invalid.', 'O', 'messages', '2011-01-13 17:47:52.001', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (188, 'Entity/Constants/acceptJoinRequest/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:48:00.865', NULL, '2010-10-26 13:50:23.789233');
INSERT INTO base_property VALUES (189, 'NewsletterHtml/Messages/groupNewWallEntry', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new comment)', 'O', 'messages', '2011-01-13 17:47:49.561', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (190, 'Newsletter/Messages/xHasJoinedWikiY', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (joined wiki page {1})', 'O', 'messages', '2011-01-13 17:47:49.884', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (191, 'Basic/Constants/noPermission', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'You do not have permission for this action.', 'O', 'messages', '2010-10-22 17:52:23.436', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (192, 'Basic/Constants/news', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'News', 'O', 'messages', '2011-01-13 17:47:49.976', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (193, 'Basic/Constants/agbGelesenUndAkzeptiert', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'I have read the <A href="#info.terms">Terms of Use</A> and the <A href="#info.data_protection">Data Protection Guidelines and accept them.</A>', 'O', 'messages', '2010-10-22 17:52:23.495', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (194, 'Basic/Constants/saveChanges', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save changes', 'O', 'messages', '2011-01-13 17:47:50.197', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (195, 'Basic/Constants/recentObservers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Recent visitors on your profile', 'O', 'messages', '2011-01-13 17:47:50.808', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (196, 'Entity/Constants/declineJoinRequest/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:48:00.868', NULL, '2010-10-26 13:50:23.991383');
INSERT INTO base_property VALUES (197, 'Basic/Constants/vor1Tag', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '1 day ago', 'O', 'messages', '2011-01-13 17:47:50.917', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (198, 'Basic/Constants/looseChangesOnClose', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not save your changes yet.', 'O', 'messages', '2011-01-13 17:47:50.922', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (199, 'Basic/Constants/successDialogTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Success', 'O', 'messages', '2011-01-13 17:47:51.443', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (200, 'Entity/Constants/assignmentOnlyForAdminOrMember/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigment only for admins or members', 'O', 'messages', '2011-01-13 17:48:00.871', NULL, '2010-10-26 13:50:24.199064');
INSERT INTO base_property VALUES (201, 'NewsletterHtml/Messages/wikiPageJoined', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (joined wiki page <a href="{2}">{3}</a>)', 'O', 'messages', '2011-01-13 17:47:49.568', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (202, 'Basic/Constants/passwordForgottenDescript', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you forgot your password, please enter your login e-mail here. You will receive an e-mail that contains a link to reset your password shortly.', 'O', 'messages', '2011-01-13 17:47:50.355', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (203, 'Basic/Constants/yourAccountIsBlocked', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your account was blocked by the admin', 'O', 'messages', '2011-01-13 17:47:50.016', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (204, 'Entity/Constants/mandatory/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'mandatory', 'O', 'messages', '2011-01-13 17:48:00.951', NULL, '2010-10-26 13:50:26.801417');
INSERT INTO base_property VALUES (205, 'Entity/Constants/hideAddressData/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'hide', 'O', 'messages', '2011-01-13 17:48:00.958', NULL, '2010-10-26 13:50:26.907746');
INSERT INTO base_property VALUES (206, 'Footerpages/Constants/hilfeText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h1>Hilfe zu OpenNetworX</h1> <p>Bitte klick <a href="http://wiki.opennetworx.org/w/index.php?title=OpenNetworX_FAQ&setlang=de" title="OpenNetworX-Hilfe">hier</a>, um zur OpenNetworX-Hilfe zu gelangen.</p>', 'O', 'messages', '2011-01-13 17:47:53.628', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (207, 'Entity/Constants/entityName/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:48:00.809', NULL, '2010-10-26 13:50:25.052949');
INSERT INTO base_property VALUES (208, 'Entity/Constants/joiningRule/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:48:00.904', NULL, '2010-10-26 13:50:25.167567');
INSERT INTO base_property VALUES (209, 'Entity/Constants/fax/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:48:00.91', NULL, '2010-10-26 13:50:25.265572');
INSERT INTO base_property VALUES (210, 'Forum/Constants/neuesThema', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add Topic', 'O', 'messages', '2011-01-13 17:47:52.266', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (211, 'Telltale/Constants/diskriminierung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Discriminatory content', 'O', 'messages', '2011-01-13 17:47:52.443', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (212, 'Telltale/Constants/youtubeInformieren', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please report this issue at YouTube, too.', 'O', 'messages', '2011-01-13 17:47:52.462', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (213, 'Entity/Constants/parentNetworks/Topic', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Networks', 'O', 'messages', '2010-12-14 13:23:33.441', NULL, '2010-10-26 13:50:25.824758');
INSERT INTO base_property VALUES (214, 'Entity/Constants/parentAppointments/Topic', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent Events', 'O', 'messages', '2010-12-14 13:23:33.554', NULL, '2010-10-26 13:50:26.037158');
INSERT INTO base_property VALUES (215, 'Entity/Constants/parentPublications/Topic', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent Publications', 'O', 'messages', '2010-12-14 13:23:33.676', NULL, '2010-10-26 13:50:26.24193');
INSERT INTO base_property VALUES (216, 'Album/Constants/noTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '(No title)', 'O', 'messages', '2011-01-13 17:47:52.575', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (217, 'Album/Constants/showHtmlUploadDialog', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If there is no upload dialog shown within 20 seconds, please click here to uploade photos separately.', 'O', 'messages', '2011-01-13 17:47:52.63', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (218, 'Album/Messages/appointmentMayOnlyContainNImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The upload of your photos failed. An event album may not carry more than {0} photos.', 'O', 'messages', '2011-01-13 17:47:52.924', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (219, 'Footerpages/Constants/impressumText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h1>Impressum</h1> <h2>Adresse:</h2> <p>OpenNetworX Stiftung <br > Rödingsmarkt 14 <br > 20459 Hamburg </p> <h2>Kontakt:</h2> <p>E-Mail: <a href="mailto:contact[at]opennetworx.org">contact[at]opennetworx.org</a><br >Telefon: +49-(0)40-36098791</p> <h2>Vorstand:</h2> <p>Rolf Schmidt-Holtz<br >Dr. Thomas Kreye, CFA<br ></p> <p>Sitz der Stiftung: Hamburg</p> <p>Die OpenNetworX Stiftung hat keinen Einfluss darauf, welche Inhalte Mitglieder auf ihren persönlichen Seiten, in Gruppen, Netzwerken oder Foren einstellen. Für diese Inhalte ist der jeweilige Verfasser verantwortlich.</p>', 'O', 'messages', '2011-01-13 17:47:53.518', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (220, 'Entity/Constants/widgetsShowSubEntities/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show entites', 'O', 'messages', '2011-01-13 17:48:00.916', NULL, '2010-10-26 13:50:25.493109');
INSERT INTO base_property VALUES (221, 'Entity/Constants/googleMapAPIKey/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Google-Maps-API Key', 'O', 'messages', '2011-01-13 17:48:00.965', NULL, '2010-10-26 13:50:27.131703');
INSERT INTO base_property VALUES (222, 'Basic/Messages/numberRangeNotAllowed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The number of field "{0}" is not between {1} and {2}', 'O', 'messages', '2011-01-13 17:47:52.007', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (223, 'Entity/Constants/participants/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:48:00.885', NULL, '2010-10-26 13:50:24.422091');
INSERT INTO base_property VALUES (224, 'Entity/Constants/street/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:48:00.891', NULL, '2010-10-26 13:50:24.624915');
INSERT INTO base_property VALUES (225, 'Entity/Constants/statusSaved/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'saved', 'O', 'messages', '2011-01-13 17:48:00.927', NULL, '2010-10-26 13:50:25.719927');
INSERT INTO base_property VALUES (226, 'Entity/Constants/participantLimitedTo/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Limit participants to:', 'O', 'messages', '2011-01-13 17:48:00.938', NULL, '2010-10-26 13:50:26.369978');
INSERT INTO base_property VALUES (227, 'Network/Messages/headingBoxExtraText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The recommended graphic dimensions are {1} pixels height and {0} pixels width. If the height is less or more than {1} pixels, the graphic will be scaled to a height of {2} pixels. If after scaling the width is more than {0} pixels, the graphic will be cropped at its right end. If after scaling the width is less than {0} pixels, the graphic will be tiled to fill {0} pixels.', 'O', 'messages', '2011-01-13 17:47:52.201', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (228, 'Entity/Constants/navigationSeparator/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:48:00.896', NULL, '2010-10-26 13:50:24.843736');
INSERT INTO base_property VALUES (229, 'Entity/Constants/backToOverview/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Back to overview', 'O', 'messages', '2011-01-13 17:48:00.943', NULL, '2010-10-26 13:50:26.576793');
INSERT INTO base_property VALUES (230, 'Album/Constants/reallyWantToDeleteAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete album', 'O', 'messages', '2011-01-13 17:47:52.654', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (231, 'Entity/Constants/coAdmin/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-Admin', 'O', 'messages', '2011-01-13 17:48:00.899', NULL, '2010-10-26 13:50:30.077586');
INSERT INTO base_property VALUES (232, 'Entity/Constants/externalURL/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External URL', 'O', 'messages', '2011-01-13 17:48:00.996', NULL, '2010-10-26 13:50:27.778445');
INSERT INTO base_property VALUES (233, 'Entity/Constants/logoComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo', 'O', 'messages', '2011-01-13 17:48:01.095', NULL, '2010-10-26 13:50:30.705262');
INSERT INTO base_property VALUES (234, 'Entity/Constants/buttonText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button: Text', 'O', 'messages', '2011-01-13 17:49:57.95', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (235, 'Entity/Constants/configComponents/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:48:01.056', NULL, '2010-10-26 13:50:29.444116');
INSERT INTO base_property VALUES (236, 'Entity/Messages/xInternalInviationWasSent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people with platform account.', 'O', 'messages', '2011-01-13 17:49:58.526', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (237, 'Footerpages/Constants/presseText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h1>Blog:</h1> <p>Bitte klick <a href="http://blog.opennetworx.org" title="OpenNetworX-Blog">hier</a>, um zum OpenNetworX-Blog zu gelangen.</p>', 'O', 'messages', '2011-01-13 17:47:53.499', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (238, 'Exception/Constants/captchaCodeTimeout', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The security code has expired. A new one is shown. Please enter this one.', 'O', 'messages', '2011-01-13 17:47:53.719', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (239, 'Document/Constants/termsOfUse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I own the rights to publish this file and it does not violate the Terms of Use.', 'O', 'messages', '2011-01-13 17:47:54.405', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (240, 'Entity/Constants/googleMapAPIKeyHelpText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>If you enter an external network URL, Google Maps will not work any more, since the current global key only works for subdomains.</p><p>If you want use Google Maps with an external URL, you need to obtain a Google Maps API key for your domain and enter it here.</p><p>See: <a href="http://code.google.com/intl/en-US/apis/maps/signup.html" target="_blank">http://code.google.com/intl/en-US/apis/maps/signup.html</a></p>', 'O', 'messages', '2011-01-13 17:48:00.982', NULL, '2010-10-26 13:50:27.356915');
INSERT INTO base_property VALUES (241, 'Entity/Constants/memberSettings/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:48:01.003', NULL, '2010-10-26 13:50:27.987404');
INSERT INTO base_property VALUES (242, 'Entity/Constants/createEntitySuccessfully/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:48:01.064', NULL, '2010-10-26 13:50:29.663377');
INSERT INTO base_property VALUES (243, 'Entity/Constants/rulesComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:48:01.106', NULL, '2010-10-26 13:50:31.020246');
INSERT INTO base_property VALUES (244, 'Entity/Constants/componentsRightColumn/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in right column', 'O', 'messages', '2011-01-13 17:48:01.113', NULL, '2010-10-26 13:50:31.231873');
INSERT INTO base_property VALUES (245, 'Entity/Constants/maps/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Google Maps', 'O', 'messages', '2011-01-13 17:48:01.01', NULL, '2010-10-26 13:50:28.189517');
INSERT INTO base_property VALUES (246, 'Exception/Constants/objectDoesntExist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The object you are trying to access does not exist (anymore).', 'O', 'messages', '2011-01-13 17:47:53.78', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (247, 'Document/Messages/restoreCheckedOutDocument', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Document is checked out by {0} {1}. Restore this version anyway?', 'O', 'messages', '2011-01-13 17:47:54.46', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (248, 'WikiEditor/Constants/antiSamyError', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your text contained forbidden (not visible) elements that were removed. This may happen if you e.g. insert a Word-Text via the clipboard. The visible content of your text has not been changed.', 'O', 'messages', '2011-01-13 17:47:54.618', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (249, 'Entity/Constants/joiningForAll/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Users with and without plattform account', 'O', 'messages', '2011-01-13 17:48:01.032', NULL, '2010-10-26 13:50:28.716065');
INSERT INTO base_property VALUES (250, 'Entity/Constants/externalDomainInUse/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External Domain already in use', 'O', 'messages', '2011-01-13 17:48:00.989', NULL, '2010-10-26 13:50:27.562675');
INSERT INTO base_property VALUES (251, 'Entity/Constants/joiningOnlyForMembersOfLinkedEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:48:01.038', NULL, '2010-10-26 13:50:28.927874');
INSERT INTO base_property VALUES (252, 'Entity/Constants/invitingByAllMebers/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members', 'O', 'messages', '2011-01-13 17:48:01.045', NULL, '2010-10-26 13:50:29.131157');
INSERT INTO base_property VALUES (253, 'Entity/Constants/configEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:48:01.071', NULL, '2010-10-26 13:50:29.866347');
INSERT INTO base_property VALUES (254, 'Entity/Constants/rejection/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Not participating', 'O', 'messages', '2011-01-13 17:48:01.082', NULL, '2010-10-26 13:50:30.291095');
INSERT INTO base_property VALUES (255, 'Document/Constants/fileDocumentDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'File deleted.', 'O', 'messages', '2011-01-13 17:47:54.398', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (256, 'Entity/Constants/visibleForWholePlatForm/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for users with an existing plattform account', 'O', 'messages', '2011-01-13 17:48:01.017', NULL, '2010-10-26 13:50:28.30466');
INSERT INTO base_property VALUES (257, 'Entity/Constants/visibleForMemberOfAssociatedEntities/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:48:01.026', NULL, '2010-10-26 13:50:28.507138');
INSERT INTO base_property VALUES (258, 'Entity/Constants/uploadImage/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload Image', 'O', 'messages', '2011-01-13 17:48:01.053', NULL, '2010-10-26 13:50:29.343416');
INSERT INTO base_property VALUES (259, 'Entity/Constants/optionsComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:48:01.088', NULL, '2010-10-26 13:50:30.503297');
INSERT INTO base_property VALUES (260, 'Entity/Constants/randomMembersComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:48:01.1', NULL, '2010-10-26 13:50:30.817515');
INSERT INTO base_property VALUES (261, 'Forum/Messages/feedTopicCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} startet the topic {1}', 'O', 'messages', '2011-01-13 17:47:52.303', NULL, '2010-09-23 01:57:42.400663');
INSERT INTO base_property VALUES (262, 'Entity/Constants/deleteCoAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:55.455', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (263, 'Entity/Constants/subBoxText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Text', 'O', 'messages', '2011-01-13 17:47:57.364', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (264, 'Entity/Constants/duration/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Time', 'O', 'messages', '2011-01-13 17:47:59.536', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (265, 'WikiEditor/Constants/restoreBackup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore', 'O', 'messages', '2011-01-13 17:47:54.6', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (266, 'Entity/Constants/members/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:47:56.495', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (267, 'Entity/Constants/linkedEntityPrivacyStatusAdminAndMembers/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins and members', 'O', 'messages', '2011-01-13 17:47:55.843', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (268, 'Entity/Messages/attentionXWillBecomeAdminAndYouWillBecomeCoAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Warning: If you give {0} the admin status, you will become co-admin. Only {0} can give you an admin status again.', 'O', 'messages', '2011-01-13 17:47:56.343', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (269, 'Entity/Constants/sendNotificationToSelectedParticipantNow/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send notifications now', 'O', 'messages', '2011-01-13 17:47:58.592', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (270, 'Entity/Constants/randomMembersComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:59.857', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (271, 'Entity/Constants/textOnBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Text', 'O', 'messages', '2011-01-13 17:48:00.022', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (273, 'Profile/Constants/contactData', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact data', 'O', 'messages', '2011-01-13 17:47:45.584', NULL, '2010-09-23 01:57:44.137359');
INSERT INTO base_property VALUES (274, 'Entity/Constants/baseDataComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Base Data', 'O', 'messages', '2011-01-13 17:48:01.085', NULL, '2010-10-26 13:50:30.391891');
INSERT INTO base_property VALUES (275, 'Basic/Messages/saved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} saved.', 'O', 'messages', '2011-01-13 17:47:51.791', NULL, '2010-09-23 01:57:42.074211');
INSERT INTO base_property VALUES (276, 'Document/Constants/checkOut', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Check out and download', 'O', 'messages', '2011-01-13 17:47:54.411', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (277, '/Basic/Constants/ok', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'OK', 'O', 'messages', '2011-01-13 17:47:54.852', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (278, 'Profile/Constants/memberships', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Memberships', 'O', 'messages', '2011-01-13 17:47:45.812', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (279, '/Basic/Constants/resendActivationMail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Resend activation email', 'O', 'messages', '2011-01-13 17:47:54.907', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (280, 'Basic/Messages/registrationSucceededAndAccountActivated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Dear {0} {1}, <br/> your registration was successful and your account is now activated.', 'O', 'messages', '2011-01-13 17:47:52.075', NULL, '2010-09-23 01:57:42.250411');
INSERT INTO base_property VALUES (281, 'Entity/Messages/mailSubjectParticipantList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on participant list', 'O', 'messages', '2011-01-13 17:47:56.367', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (352, 'Profile/Constants/alternativeEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Alternative email', 'O', 'messages', '2011-01-13 17:47:45.845', NULL, '2010-09-23 01:57:44.235691');
INSERT INTO base_property VALUES (282, 'Entity/Constants/linkedEntityPrivacyAssignmentHeader/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who is allowed to assign other elements to this event?', 'O', 'messages', '2011-01-13 17:47:57.444', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (283, 'Entity/Constants/entities/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki pages', 'O', 'messages', '2011-01-13 17:47:58.037', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (284, 'Entity/Constants/widgetsDontShowSubEntitiesOption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show elements of affiliate places', 'O', 'messages', '2011-01-13 17:47:55.246', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (285, 'Entity/Constants/entityJoinRequest/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Project join request', 'O', 'messages', '2011-01-13 17:47:59.455', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (286, 'Entity/Constants/participantStatusText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participate', 'O', 'messages', '2011-01-13 17:48:00.26', NULL, '2010-08-06 17:21:45.746787');
INSERT INTO base_property VALUES (287, 'Entity/Constants/entityNotVisibleTitle/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity privacy settings', 'O', 'messages', '2011-01-13 17:47:55.835', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (288, 'Appointment/Constants/reportAppointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report event', 'O', 'messages', '2011-01-13 17:47:54.828', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (289, 'Entity/Constants/invitingRule/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:56.902', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (290, 'Entity/Constants/participants/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:47:58.321', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (291, 'Entity/Constants/joinEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:47:59.586', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (292, 'Entity/Constants/navigationLinks/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation: Links', 'O', 'messages', '2011-01-13 17:47:59.957', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (293, 'Entity/Constants/myMemberStatusComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attending Status', 'O', 'messages', '2011-01-13 17:48:01.092', NULL, '2010-10-26 13:50:30.603932');
INSERT INTO base_property VALUES (294, 'Entity/Constants/adminListComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:48:01.103', NULL, '2010-10-26 13:50:30.918895');
INSERT INTO base_property VALUES (295, '/Basic/Constants/profile', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Profile', 'O', 'messages', '2011-01-13 17:47:54.895', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (296, 'Entity/Constants/componentsLeftColumn/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in left column', 'O', 'messages', '2011-01-13 17:48:01.11', NULL, '2010-10-26 13:50:31.132393');
INSERT INTO base_property VALUES (297, 'Entity/Constants/deleteFromMemberList/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:48:01.121', NULL, '2010-10-26 13:50:31.332901');
INSERT INTO base_property VALUES (298, 'Entity/Constants/subdomainInUse/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The subdomain is already in use', 'O', 'messages', '2011-01-13 17:47:57.097', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (299, 'Entity/Constants/createEntitySuccessfully/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:47:57.186', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (300, 'Entity/Constants/ifNoHeader/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you do not upload any header, the event name will appear instead. Best are headers of exactly 783 pixels width and about 80 pixels height. If your header''s width is greater, it will be scaled to fit.', 'O', 'messages', '2011-01-13 17:47:57.306', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (301, 'Entity/Constants/invitationPopupPleaseSelectPersonToInvite/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No person selected, no one to invite.', 'O', 'messages', '2011-01-13 17:47:57.512', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (302, 'Entity/Constants/inviteAllMyContacts/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite all my contacts', 'O', 'messages', '2011-01-13 17:47:57.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (303, 'Entity/Messages/doRealyWantToDeleteCoAdminX/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove {0} from co-admins?', 'O', 'messages', '2011-01-13 17:47:57.927', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (304, 'Entity/Messages/mailSubjectParticipantList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on participant list', 'O', 'messages', '2011-01-13 17:47:57.934', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (305, 'Entity/Constants/members/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:58.034', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (306, 'Entity/Constants/entity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki page', 'O', 'messages', '2011-01-13 17:47:58.043', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (307, 'Entity/Constants/closingDate/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline', 'O', 'messages', '2011-01-13 17:47:58.189', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (308, 'Entity/Constants/myMemberStatusComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attending status', 'O', 'messages', '2011-01-13 17:47:58.545', NULL, '2010-08-06 17:21:40.136932');
INSERT INTO base_property VALUES (309, 'Entity/Constants/entityWasSelectedError/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:47:58.796', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (310, 'Entity/Constants/toWaitlist/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in waiting list', 'O', 'messages', '2011-01-13 17:48:01.124', NULL, '2010-10-26 13:50:31.442197');
INSERT INTO base_property VALUES (311, '/Basic/Constants/tags', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:47:54.86', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (312, '/Basic/Constants/timeFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'hh:mm a', 'O', 'messages', '2011-01-13 17:47:54.863', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (313, 'Entity/Constants/invalidEntitySelectionOccur/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'One or more of your selection is invalid.', 'O', 'messages', '2011-01-13 17:47:58.812', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (314, 'Entity/Constants/randomMembersComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:55.676', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (315, 'Entity/Constants/colorDesign/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design', 'O', 'messages', '2011-01-13 17:47:55.728', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (316, 'Entity/Constants/inviteViaEmail/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite via e-mail', 'O', 'messages', '2011-01-13 17:47:55.934', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (317, 'Entity/Constants/makeCoAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make co-admin', 'O', 'messages', '2011-01-13 17:47:56.883', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (318, 'Entity/Constants/assignedTypeNotAllowed/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning element of this type is not allowed', 'O', 'messages', '2011-01-13 17:47:56.933', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (319, 'Entity/Constants/subdomainHelpLink/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'How does this work?', 'O', 'messages', '2011-01-13 17:47:59.744', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (320, 'Entity/Constants/notifcationMailsWasSentToSelectedParticipant/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Notifications sent.', 'O', 'messages', '2011-01-13 17:48:01.148', NULL, '2010-10-26 13:50:31.752942');
INSERT INTO base_property VALUES (321, 'Entity/Constants/toPerticipantList/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in participant list', 'O', 'messages', '2011-01-13 17:48:01.127', NULL, '2010-10-26 13:50:31.541543');
INSERT INTO base_property VALUES (322, 'Entity/Constants/thisEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This project', 'O', 'messages', '2011-01-13 17:47:59.474', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (323, 'Entity/Constants/invited', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invited', 'O', 'messages', '2011-01-13 17:49:55.762', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (324, 'Entity/Constants/googleMapAPIKeyHelpText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>If you enter an external place URL, Google Maps will not work any more, since the current global key only works for subdomains.</p><p>If you want use Google Maps with an external URL, you need to obtain a Google Maps-API key for your domain and enter it here.</p><p>See: <a href="http://code.google.com/intl/en-US/apis/maps/signup.html" target="_blank">http://code.google.com/intl/en-US/apis/maps/signup.html</a></p>', 'O', 'messages', '2011-01-13 17:49:57.589', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (325, 'Entity/Constants/parentWikis/Group', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent wiki pages', 'O', 'messages', '2010-12-14 13:24:43.097', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (326, 'Entity/Constants/randomMembersComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:49:56.136', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (327, 'Entity/Mails/entityInvitation/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname invites you to group "$ENTITY.Name".

#if ( !$MESSAGE.empty )
$MESSAGE
#end

Pick up invitation:
$STARTPAGE_URI

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.454', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (328, 'Entity/Constants/entityWasSelectedError', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:49:56.382', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (329, 'Entity/Constants/noNotfiedParticipantSelected/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No persons for notification selected.', 'O', 'messages', '2011-01-13 17:48:01.145', NULL, '2010-10-26 13:50:31.64324');
INSERT INTO base_property VALUES (330, 'Entity/Constants/notNotifiedParticipant/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'People unnotified', 'O', 'messages', '2011-01-13 17:48:01.155', NULL, '2010-10-26 13:50:31.853743');
INSERT INTO base_property VALUES (331, 'Entity/Constants/currentLogo/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current Logo', 'O', 'messages', '2011-01-13 17:48:01.161', NULL, '2010-10-26 13:50:32.067118');
INSERT INTO base_property VALUES (332, 'Entity/Mails/entityRemoveMembershipStatus/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from event "$ENTITY.Name".

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.553', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (333, 'Entity/Constants/invitationPopupNoPersonsInserted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No one added, everyone is already in your list.', 'O', 'messages', '2011-01-13 17:49:56.451', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (334, 'Entity/Constants/assignedTypeNotAllowed/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning element of this type is not allowed', 'O', 'messages', '2011-01-13 17:49:57.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (335, 'Entity/Constants/uploadLogo/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload Logo', 'O', 'messages', '2011-01-13 17:48:01.164', NULL, '2010-10-26 13:50:32.16877');
INSERT INTO base_property VALUES (336, 'Entity/Mails/entityRemoveMembershipStatus/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from group "$ENTITY.Name".

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.449', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (337, 'Album/Messages/feedAlbumCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the album {1}.', 'O', 'messages', '2011-01-13 17:47:52.887', NULL, '2010-09-23 01:57:42.845707');
INSERT INTO base_property VALUES (338, 'Entity/Constants/preview/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:48:01.189', NULL, '2010-10-26 13:50:32.590964');
INSERT INTO base_property VALUES (339, 'Entity/Constants/parents', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Parents', 'O', 'messages', '2011-01-13 17:49:55.692', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (340, 'Entity/Constants/toPerticipantList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in participant list', 'O', 'messages', '2011-01-13 17:49:57.764', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (341, 'Profile/Constants/occupation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Job category', 'O', 'messages', '2011-01-13 17:47:45.853', NULL, '2010-09-23 01:57:44.241419');
INSERT INTO base_property VALUES (342, 'Basic/Constants/accountActivationFailed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p><b>Your account could not be activated</b></p><p>The activation link provided in your email possibly includes a line feed. An example for a link including a line feed is:</p><tt style="color:red">http://www.mydomain.org/?activateaccount=123ABC456dEf<br/>GhIjKlM=?locale=de</tt><p>The second line is also part of the link. So the direction in your browser needs to be:</p><tt style="color: green">http://www.mydomain.org/?activateaccount=123ABC456dEfGhIjKlM=?locale=de</tt><p>Also please pay attention that the link may not include any spaces. The following would also be invalid:</p><tt style="color: red">http://www.mydomain.org/?activateaccount=123ABC456dEf&nbsp;GhIjKlM=?locale=de</tt>', 'O', 'messages', '2011-01-13 17:47:50.492', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (343, 'Basic/Messages/allowNewsletter', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send me an e-mail including a summary of recent activities every {0} days.', 'O', 'messages', '2011-01-13 17:47:51.785', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (344, 'Album/Messages/feedUnnamedImageCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} uploaded a <a href="{2}">photo</a> in the album {1}.', 'O', 'messages', '2011-01-13 17:47:52.896', NULL, '2010-09-23 01:57:42.851325');
INSERT INTO base_property VALUES (345, '/Basic/Constants/subdomainMayOnlyContain', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'A subdomain may only contain letters (no special characters), points and dashes and must consist of at least 3 characters.', 'O', 'messages', '2011-01-13 17:47:54.932', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (346, '/Basic/Constants/pleaseSelect', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please select', 'O', 'messages', '2011-01-13 17:47:55.058', NULL, '2010-09-23 01:57:44.237339');
INSERT INTO base_property VALUES (347, 'Entity/Constants/boxBorders/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Borders heading box', 'O', 'messages', '2011-01-13 17:48:01.196', NULL, '2010-10-26 13:50:32.706034');
INSERT INTO base_property VALUES (348, 'Entity/Constants/subBox/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:49:57.894', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (349, 'Album/Messages/feedUnamedImageCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} commented a <a href="{2}">photo</a> in the album {1}.', 'O', 'messages', '2011-01-13 17:47:52.881', NULL, '2010-09-23 01:57:42.856475');
INSERT INTO base_property VALUES (350, 'Entity/Constants/successfullySavedEntityDesign/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design saved.', 'O', 'messages', '2011-01-13 17:48:01.202', NULL, '2010-10-26 13:50:32.908673');
INSERT INTO base_property VALUES (351, 'Profile/Constants/preview', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:47:45.806', NULL, '2010-09-23 01:57:44.14442');
INSERT INTO base_property VALUES (353, 'Entity/Constants/sendNotificationToSelectedParticipantNow/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send notifications now', 'O', 'messages', '2011-01-13 17:48:01.158', NULL, '2010-10-26 13:50:31.955245');
INSERT INTO base_property VALUES (354, 'Entity/Constants/currentIcon/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current Icon', 'O', 'messages', '2011-01-13 17:48:01.166', NULL, '2010-10-26 13:50:32.269676');
INSERT INTO base_property VALUES (355, 'Entity/Constants/navigation/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation', 'O', 'messages', '2011-01-13 17:48:01.213', NULL, '2010-10-26 13:50:33.125785');
INSERT INTO base_property VALUES (356, 'Entity/Constants/pageBorders/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation and site borders', 'O', 'messages', '2011-01-13 17:48:01.219', NULL, '2010-10-26 13:50:33.333323');
INSERT INTO base_property VALUES (357, 'Profile/Constants/industry', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Sector', 'O', 'messages', '2011-01-13 17:47:45.847', NULL, '2010-09-23 01:57:44.239845');
INSERT INTO base_property VALUES (358, 'Entity/Constants/colorDesign/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Color & design', 'O', 'messages', '2011-01-13 17:48:01.179', NULL, '2010-10-26 13:50:32.383367');
INSERT INTO base_property VALUES (359, 'Entity/Constants/horizontalNavigationLink/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Link in horizontal navigation', 'O', 'messages', '2011-01-13 17:48:01.234', NULL, '2010-10-26 13:50:33.540384');
INSERT INTO base_property VALUES (360, 'Entity/Constants/headerText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text in header', 'O', 'messages', '2011-01-13 17:48:01.24', NULL, '2010-10-26 13:50:33.75568');
INSERT INTO base_property VALUES (361, 'Entity/Mails/entityWaitList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now on waiting list of wiki page "$ENTITY.Name".

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.492', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (362, 'Document/Messages/documentReportViolationMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in document with ID: {0}', 'O', 'messages', '2011-01-13 17:47:54.471', NULL, '2010-10-11 23:30:39.964687');
INSERT INTO base_property VALUES (363, 'NewsBlog/Messages/feedNewDocument', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} uploaded the document {2} in the article {1}', 'O', 'messages', '2011-01-13 17:47:54.727', NULL, '2010-09-23 01:57:43.980407');
INSERT INTO base_property VALUES (364, 'Entity/Constants/headerBorder/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Border', 'O', 'messages', '2011-01-13 17:49:57.882', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (365, 'Workstream/Messages/feedOriginForeignProfile', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'on the profile of {0}', 'O', 'messages', '2011-01-13 17:47:54.645', NULL, '2010-09-23 01:57:43.949979');
INSERT INTO base_property VALUES (366, 'Workstream/Messages/microblogReportViolationMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in microblog message with ID: {0}', 'O', 'messages', '2011-01-13 17:47:54.658', NULL, '2010-10-11 23:30:40.186779');
INSERT INTO base_property VALUES (367, 'NewsBlog/Messages/newsblogReportViolationMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in newsblog with ID: {0}', 'O', 'messages', '2011-01-13 17:47:54.733', NULL, '2010-10-11 23:30:40.288404');
INSERT INTO base_property VALUES (368, 'Entity/Constants/subBoxText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Text', 'O', 'messages', '2011-01-13 17:49:57.898', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (369, 'Entity/Constants/linkedEntityPrivacyAssignmentHeader/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who is allowed to assign other elements to this group?', 'O', 'messages', '2011-01-13 17:49:57.995', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (370, 'Entity/Constants/inviteMyContactsButtonText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite my contacts', 'O', 'messages', '2011-01-13 17:49:58.073', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (371, 'Entity/Constants/participantPopupMsgLosingWaitlistPosition/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will loose your position on the waiting list.', 'O', 'messages', '2011-01-13 17:49:58.165', NULL, '2010-08-06 17:21:38.459171');
INSERT INTO base_property VALUES (372, 'Entity/Constants/statusOptionUndecidedStatus/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I am undecided', 'O', 'messages', '2011-01-13 17:49:58.185', NULL, '2010-08-06 17:21:38.486909');
INSERT INTO base_property VALUES (373, 'NewsBlog/Constants/noArticleCreateOne', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No Articles. <a>Create one.</a>', 'O', 'messages', '2011-01-13 17:47:54.811', NULL, '2010-09-23 01:57:44.027446');
INSERT INTO base_property VALUES (374, 'Entity/Constants/state/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'State', 'O', 'messages', '2011-01-13 17:49:58.334', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (375, 'Profile/Constants/period', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Period', 'O', 'messages', '2011-01-13 17:47:45.408', NULL, '2010-09-23 01:57:44.065976');
INSERT INTO base_property VALUES (376, 'Workstream/Constants/feedOriginProfileFemale', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'on her profile', 'O', 'messages', '2011-01-13 17:47:54.67', NULL, '2010-09-23 01:57:43.957021');
INSERT INTO base_property VALUES (377, 'Profile/Constants/saveContactDataConfirmMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, 'A confirmation popup with this messages will only appears during saving the contact data, if the setting key
''Settings/profile/display confirm popup while save contact deta'' is true', 'Do you realy want to save your contact data?', 'O', 'messages', '2011-01-13 17:47:45.936', NULL, '2010-10-11 23:30:40.54082');
INSERT INTO base_property VALUES (378, 'Document/Constants/reportViolation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violation', 'O', 'messages', '2011-01-13 17:47:54.326', NULL, '2010-10-11 23:30:39.584398');
INSERT INTO base_property VALUES (379, 'Profile/Messages/feedNewContact', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} and {1} are now contacts', 'O', 'messages', '2011-01-13 17:47:54.841', NULL, '2010-09-23 01:57:44.048105');
INSERT INTO base_property VALUES (380, 'Entity/Constants/requestDeletion/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request Deletion', 'O', 'messages', '2011-01-13 17:47:56.168', NULL, '2010-10-11 23:30:41.676604');
INSERT INTO base_property VALUES (381, 'Workstream/Constants/feedOriginStartpageFemale', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'on her personal startpage', 'O', 'messages', '2011-01-13 17:47:54.675', NULL, '2010-09-23 01:57:43.966274');
INSERT INTO base_property VALUES (382, 'Workstream/Constants/adminMayPost', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admins may post into the microblog', 'O', 'messages', '2011-01-13 17:47:54.681', NULL, '2010-09-23 01:57:43.970877');
INSERT INTO base_property VALUES (383, 'Workstream/Constants/composerPlaceholder', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'What''s interesting?', 'O', 'messages', '2011-01-13 17:47:54.687', NULL, '2010-09-23 01:57:43.974512');
INSERT INTO base_property VALUES (384, 'Workstream/Constants/tooltipCommentMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Comment this message', 'O', 'messages', '2011-01-13 17:47:54.71', NULL, '2010-10-11 23:30:40.247398');
INSERT INTO base_property VALUES (385, 'Document/Messages/feedNewDocumentVersionInEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} has uploaded version {2} of the document {1}.', 'O', 'messages', '2011-01-13 17:47:54.45', NULL, '2010-09-23 01:57:43.668056');
INSERT INTO base_property VALUES (386, 'NewsBlog/Messages/feedArticleCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the new article {1}', 'O', 'messages', '2011-01-13 17:47:54.724', NULL, '2010-09-23 01:57:43.986063');
INSERT INTO base_property VALUES (387, 'Basic/Constants/accountNotActivated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your account has not been activated yet. If you did not receive the activation e-mail, make it sent to you again.', 'O', 'messages', '2011-01-13 17:47:50.011', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (388, 'Network/Messages/horizontalNavigationExtraText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The recommended graphic dimensions are {0} pixels wide and {1} pixels tall. If the height is less than {2} or more than {3} pixels the graphic will be scaled to a height of {2} resp. {3} pixels. If after scaling the width is more than {0} pixels, the graphic will be cropped at its right end. If after scaling the width is less than {0} pixels, the graphic will be tiled to fill {0} pixels.', 'O', 'messages', '2011-01-13 17:47:52.191', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (454, 'Album/Constants/insertImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Insert image', 'O', 'messages', '2011-01-13 17:47:52.53', NULL, '2010-10-01 17:32:04.011972');
INSERT INTO base_property VALUES (537, 'Entity/Constants/entityPrivacyHeader/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:48:01.338', NULL, '2010-10-26 13:50:36.183454');
INSERT INTO base_property VALUES (389, 'Footerpages/Constants/articlesOfAssociationText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h1>Team</h1><p><h2>Rolf Schmidt-Holtz</h2>Stifter und Vorstand</p><p><h2>Dr. Thomas Kreye, CFA</h2>Geschäftsführender Vorstand</p><p><h2>Sebastian Ebert</h2>Stellvertretender Geschäftsführer</p><p><h2>Philipp Schuch</h2>Entwicklung & Technologie</p><p><h2>Dr. Benjamin Jörissen</h2>Berater Bildung und Innovation</p><p><h2>Janna Schmidt-Holtz</h2>Kommunikation</p><p><h2>Benjamin Tittel</h2>Community Administrator</p><p><h2>Stefan Rieder</h2>Plattformoptimierung</p><p><h2>Raffael Jesche</h2>Grafik & Design</p>', 'O', 'messages', '2011-01-13 17:47:53.474', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (390, '/Basic/Constants/accountNotActivated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your account has not been activated yet. If you did not receive the activation e-mail, make it sent to you again.', 'O', 'messages', '2011-01-13 17:47:54.891', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (391, 'Entity/Constants/googleMapAPIKeyHelpText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>If you enter an external place URL, Google Maps will not work any more, since the current global key only works for subdomains.</p><p>If you want use Google Maps with an external URL, you need to obtain a Google Maps-API key for your domain and enter it here.</p><p>See: <a href="http://code.google.com/intl/en-US/apis/maps/signup.html" target="_blank">http://code.google.com/intl/en-US/apis/maps/signup.html</a></p>', 'O', 'messages', '2011-01-13 17:47:55.589', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (392, 'Entity/Messages/attentionXWillBecomeAdminAndYouWillBecomeCoAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Warning: If you give {0} the admin status, you will become co-admin. Only {0} can give you an admin status again.', 'O', 'messages', '2011-01-13 17:47:57.913', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (393, 'Entity/Constants/visibleForMemberOfAssociatedEntities/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:58.476', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (394, 'Entity/Constants/acceptInvitationOption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept Invitation', 'O', 'messages', '2011-01-13 17:47:59.069', NULL, '2010-10-11 23:30:44.276881');
INSERT INTO base_property VALUES (395, 'Entity/Constants/notifcationMailsWasSentToSelectedParticipant/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Notifications sent.', 'O', 'messages', '2011-01-13 17:49:57.772', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (396, 'Workstream/Constants/reportViolation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report Violation', 'O', 'messages', '2011-01-13 17:47:54.678', NULL, '2010-10-11 23:30:40.201626');
INSERT INTO base_property VALUES (397, 'NewsBlog/Constants/reportViolation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report Violation', 'O', 'messages', '2011-01-13 17:47:54.746', NULL, '2010-10-11 23:30:40.294927');
INSERT INTO base_property VALUES (398, 'Entity/Messages/xExternalInviationWasSent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people without platform account.', 'O', 'messages', '2011-01-13 17:47:57.966', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (399, 'Entity/Mails/entityGotJoinRequest/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wants to join the wiki "$ENTITY.Name".

Confirm or decline:
$STARTPAGE_URI

Wiki page:
$ENTITY_URI

--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu. If you do not want further notifications, please go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.513', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (400, 'Entity/Messages/entityDeleteRquestMailHeader/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deletion request for entity "{0}" (ID: {1}) has been submitted.', 'O', 'messages', '2011-01-13 17:47:58.008', NULL, '2010-10-11 23:30:43.246937');
INSERT INTO base_property VALUES (401, 'Entity/Mails/messageReceived', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wrote you a message:

$SUBJECT

$MESSAGE

Log in to reply:
$STARTPAGE_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.627', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (402, 'Entity/Constants/requestDeletion/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request Deletion', 'O', 'messages', '2011-01-13 17:47:57.726', NULL, '2010-10-11 23:30:43.018974');
INSERT INTO base_property VALUES (403, 'Exception/Constants/dirtyWikiTextException', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your text contained forbidden (not visible) elements that were removed. This may happen if you e.g. insert a Word-Text via the clipboard. The visible content of your text has not been changed.', 'O', 'messages', '2011-01-13 17:47:53.768', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (404, 'Entity/Constants/acceptInvitationOption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept Invitation', 'O', 'messages', '2011-01-13 17:47:57.733', NULL, '2010-10-11 23:30:43.034083');
INSERT INTO base_property VALUES (405, 'Entity/Messages/externalURLPopupText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>You must set the so called "CNAME" (also called "canonical name") at your domain provider.</p><p>A corresponding function should exist in the maintenance-menu of your domain provider. Make the CNAME-entry point to the name of your event at {0}.</p><p>This should look like this:</p><p><b>www.mydomain.com >> CNAME >> www.{1}.{0}</b></p>', 'O', 'messages', '2011-01-13 17:47:57.909', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (406, 'Entity/Constants/requestDeletion/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request Deletion', 'O', 'messages', '2011-01-13 17:47:59.063', NULL, '2010-10-11 23:30:44.268344');
INSERT INTO base_property VALUES (407, 'Entity/Messages/entityDeleteRquestMailHeader/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deletion request for entity "{0}" (ID: {1}) has been submitted.', 'O', 'messages', '2011-01-13 17:47:59.359', NULL, '2010-10-11 23:30:44.385015');
INSERT INTO base_property VALUES (408, 'Entity/Constants/whyDeleteEntityCaption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Why should the space be deleted?', 'O', 'messages', '2011-01-13 17:48:00.36', NULL, '2010-10-11 23:30:45.171497');
INSERT INTO base_property VALUES (409, 'Entity/Constants/acceptInvitationOption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept Invitation', 'O', 'messages', '2011-01-13 17:47:56.176', NULL, '2010-10-11 23:30:41.693445');
INSERT INTO base_property VALUES (410, 'WikiEditor/Messages/viewDiffHeadline', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Changes of {0} ({1} | {2}) from {3} to {4} ({5} | {6}) from {7}', 'O', 'messages', '2011-01-13 17:47:54.542', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (411, 'Entity/Mails/entityDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname deleted the entity "$ENTITY.Name".


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.371', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (412, 'Entity/Messages/entityDeleteRquestMailHeader/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deletion request for entity "{0}" (ID: {1}) has been submitted.', 'O', 'messages', '2011-01-13 17:47:56.465', NULL, '2010-10-11 23:30:41.927013');
INSERT INTO base_property VALUES (413, 'Profile/Constants/allProfileStatusFilterOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:45.837', NULL, '2010-10-01 17:32:06.271922');
INSERT INTO base_property VALUES (415, 'Workstream/Constants/noNewMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'There are no new messages.', 'O', 'messages', '2011-01-13 17:47:54.705', NULL, '2010-10-01 17:32:06.181668');
INSERT INTO base_property VALUES (416, 'Entity/Messages/subjectTextExternalInvite/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invites you to wiki page "{1}"!', 'O', 'messages', '2011-01-13 17:47:59.236', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (417, 'Entity/Messages/attentionXWillBecomeAdminAndYouWillBecomeCoAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Warning: If you give {0} the admin status, you will become co-admin. Only {0} can give you an admin status again.', 'O', 'messages', '2011-01-13 17:47:59.253', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (418, 'Entity/Constants/entityClosedNotAcceptingInvitationPossibleAnymore/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot take part any more.', 'O', 'messages', '2011-01-13 17:48:00.178', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (419, 'Entity/Mails/messageEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wrote a message to the members of project "$ENTITY.Name":

$SUBJECT

$MESSAGE

Log in to reply:
$STARTPAGE_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.573', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (420, 'Entity/Messages/requestToDeleteEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request entity deletion for entity "{0}"', 'O', 'messages', '2011-01-13 17:47:56.462', NULL, '2010-10-11 23:30:41.907604');
INSERT INTO base_property VALUES (421, 'Entity/Constants/realyWantToLeaveEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave this entity?', 'O', 'messages', '2011-01-13 17:49:56.638', NULL, '2010-10-01 17:33:54.582851');
INSERT INTO base_property VALUES (422, 'Entity/Constants/displayPrimaryMemberOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show primary members', 'O', 'messages', '2011-01-13 17:49:56.712', NULL, '2010-10-01 17:33:54.624359');
INSERT INTO base_property VALUES (423, 'Entity/Constants/acceptInvitationOption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept Invitation', 'O', 'messages', '2011-01-13 17:48:00.363', NULL, '2010-10-11 23:30:45.182858');
INSERT INTO base_property VALUES (424, 'Entity/Constants/assignedEntites/Publication', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Assigned Content', 'O', 'messages', '2010-10-07 11:36:34.798', NULL, '2010-10-07 11:36:34.798213');
INSERT INTO base_property VALUES (425, 'Entity/Constants/displayPrimaryMemberOption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Display Primary Member', 'O', 'messages', '2011-01-13 17:48:00.349', NULL, '2010-10-01 17:32:10.894644');
INSERT INTO base_property VALUES (426, 'Entity/Constants/requestDeletion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request Deletion', 'O', 'messages', '2011-01-13 17:49:56.72', NULL, '2010-10-11 23:31:03.232854');
INSERT INTO base_property VALUES (427, 'Entity/Constants/displayPrimaryMemberOption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Display Primary Member', 'O', 'messages', '2011-01-13 17:47:57.719', NULL, '2010-10-01 17:32:08.758506');
INSERT INTO base_property VALUES (428, 'Survey/Constants/surveyExpiredMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Survey expired.', 'O', 'messages', '2011-01-13 17:48:02.843', NULL, '2010-10-01 17:32:11.538153');
INSERT INTO base_property VALUES (429, 'Entity/Constants/assignedEntites/Network', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Assigned Content', 'O', 'messages', '2010-10-07 11:36:30.239', NULL, '2010-10-07 11:36:30.238861');
INSERT INTO base_property VALUES (430, 'Entity/Constants/whyDeleteEntityCaption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Why should the space be deleted?', 'O', 'messages', '2011-01-13 17:47:57.729', NULL, '2010-10-11 23:30:43.022908');
INSERT INTO base_property VALUES (431, 'Entity/Constants/assignedEntites/Appointment', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Assigned Content', 'O', 'messages', '2010-10-07 11:36:32.776', NULL, '2010-10-07 11:36:32.776503');
INSERT INTO base_property VALUES (432, 'Entity/Messages/requestToDeleteEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request entity deletion for entity "{0}"', 'O', 'messages', '2011-01-13 17:47:58.005', NULL, '2010-10-11 23:30:43.243325');
INSERT INTO base_property VALUES (433, 'Entity/Constants/acceptInvitationOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept Invitation', 'O', 'messages', '2011-01-13 17:49:56.728', NULL, '2010-10-11 23:31:03.236267');
INSERT INTO base_property VALUES (434, 'Entity/Messages/requestToDeleteEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request entity deletion for entity "{0}"', 'O', 'messages', '2011-01-13 17:47:59.357', NULL, '2010-10-11 23:30:44.383352');
INSERT INTO base_property VALUES (435, '/Calendar/Constants/februarShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Feb', 'O', 'messages', '2011-01-13 17:48:02.875', NULL, '2010-10-01 17:32:11.572454');
INSERT INTO base_property VALUES (436, 'Entity/Constants/assignedEntites', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Assigned Content', 'O', 'messages', '2010-10-07 11:36:52.319', NULL, '2010-10-07 11:36:52.318565');
INSERT INTO base_property VALUES (437, 'Entity/Constants/assignedEntites/Group', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Assigned Content', 'O', 'messages', '2010-10-07 11:36:53.724', NULL, '2010-10-07 11:36:53.723714');
INSERT INTO base_property VALUES (438, '/Calendar/Constants/JuneShort', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Jun', 'O', 'messages', '2010-10-22 17:52:34.213', NULL, '2010-10-01 17:32:11.580208');
INSERT INTO base_property VALUES (439, 'Entity/Messages/requestToDeleteEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request entity deletion for entity "{0}"', 'O', 'messages', '2011-01-13 17:49:57.032', NULL, '2010-10-11 23:31:03.583267');
INSERT INTO base_property VALUES (440, 'Survey/Constants/alreadyParticipateMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You already participated.', 'O', 'messages', '2011-01-13 17:48:02.848', NULL, '2010-10-01 17:32:11.541445');
INSERT INTO base_property VALUES (441, '/Calendar/Constants/aprilShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Apr', 'O', 'messages', '2011-01-13 17:48:02.878', NULL, '2010-10-01 17:32:11.57732');
INSERT INTO base_property VALUES (442, '/Comments/Constants/showFurtherComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show one further comment', 'O', 'messages', '2011-01-13 17:49:57.089', NULL, '2010-10-11 23:31:03.597034');
INSERT INTO base_property VALUES (443, 'Entity/Constants/displayPrimaryMemberOption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Display Primary Member', 'O', 'messages', '2011-01-13 17:49:58.245', NULL, '2010-10-01 17:33:55.896319');
INSERT INTO base_property VALUES (444, 'Entity/Constants/whyDeleteEntityCaption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Why should the space be deleted?', 'O', 'messages', '2011-01-13 17:49:58.273', NULL, '2010-10-11 23:31:04.575712');
INSERT INTO base_property VALUES (445, 'Entity/Constants/openMapPopup/Wiki', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Enlarged view', 'O', 'messages', '2010-10-12 11:29:56.621', NULL, '2010-10-07 11:36:33.890148');
INSERT INTO base_property VALUES (446, 'Entity/Constants/displayPrimaryMemberOption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Display Primary Member', 'O', 'messages', '2011-01-13 17:47:59.056', NULL, '2010-10-01 17:32:09.956521');
INSERT INTO base_property VALUES (447, 'Entity/Constants/whyDeleteEntityCaption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Why should the space be deleted?', 'O', 'messages', '2011-01-13 17:47:59.066', NULL, '2010-10-11 23:30:44.270111');
INSERT INTO base_property VALUES (448, 'Entity/Constants/requestDeletion/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request Deletion', 'O', 'messages', '2011-01-13 17:48:00.356', NULL, '2010-10-11 23:30:45.168843');
INSERT INTO base_property VALUES (449, 'Entity/Messages/entityDeleteRquestMailHeader/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deletion request for entity "{0}" (ID: {1}) has been submitted.', 'O', 'messages', '2011-01-13 17:48:00.636', NULL, '2010-10-11 23:30:45.400326');
INSERT INTO base_property VALUES (450, '/Calendar/Constants/decemberShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Dec', 'O', 'messages', '2011-01-13 17:48:02.895', NULL, '2010-10-01 17:32:11.59785');
INSERT INTO base_property VALUES (451, '/Calendar/Constants/augustShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Aug', 'O', 'messages', '2011-01-13 17:48:02.887', NULL, '2010-10-01 17:32:11.585367');
INSERT INTO base_property VALUES (452, '/Calendar/Constants/octoberShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Oct', 'O', 'messages', '2011-01-13 17:48:02.892', NULL, '2010-10-01 17:32:11.591899');
INSERT INTO base_property VALUES (453, 'Profile/Constants/profileStatusFilterLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status filter', 'O', 'messages', '2011-01-13 17:47:45.876', NULL, '2010-10-01 17:32:06.274069');
INSERT INTO base_property VALUES (455, 'Search/Constants/noTagsAvailable', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No tags available', 'O', 'messages', '2011-01-13 17:47:52.956', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (456, 'Entity/Constants/displayPrimaryMemberOption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Display Primary Member', 'O', 'messages', '2011-01-13 17:47:56.16', NULL, '2010-10-01 17:32:07.378823');
INSERT INTO base_property VALUES (457, '/Calendar/Constants/julyShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Jul', 'O', 'messages', '2011-01-13 17:48:02.885', NULL, '2010-10-01 17:32:11.582236');
INSERT INTO base_property VALUES (458, 'Entity/Constants/openMapPopup', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Enlarged view', 'O', 'messages', '2010-10-12 11:28:46.815', NULL, '2010-10-07 11:36:52.313773');
INSERT INTO base_property VALUES (459, 'Entity/Constants/openMapPopup/Appointment', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Enlarged view', 'O', 'messages', '2010-10-12 11:29:32.806', NULL, '2010-10-07 11:36:32.774214');
INSERT INTO base_property VALUES (460, 'Entity/Constants/openMapPopup/Group', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Enlarged view', 'O', 'messages', '2010-10-12 11:29:39.345', NULL, '2010-10-07 11:36:53.720798');
INSERT INTO base_property VALUES (461, 'Entity/Constants/openMapPopup/Network', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Enlarged view', 'O', 'messages', '2010-10-12 11:29:45.999', NULL, '2010-10-07 11:36:30.217027');
INSERT INTO base_property VALUES (462, 'Entity/Constants/realyWantToLeaveEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave this wiki page?', 'O', 'messages', '2011-01-13 17:47:58.996', NULL, '2010-10-01 17:32:09.934555');
INSERT INTO base_property VALUES (463, 'Entity/Constants/openMapPopup/Publication', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Enlarged view', 'O', 'messages', '2010-10-12 11:29:51.376', NULL, '2010-10-07 11:36:34.796332');
INSERT INTO base_property VALUES (464, 'Entity/Constants/navigationSeparatorText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text in vavigation separator', 'O', 'messages', '2011-01-13 17:48:01.223', NULL, '2010-10-26 13:50:33.434704');
INSERT INTO base_property VALUES (465, 'Entity/Constants/realyWantToLeaveEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave this project?', 'O', 'messages', '2011-01-13 17:48:00.294', NULL, '2010-10-01 17:32:10.850502');
INSERT INTO base_property VALUES (466, 'Entity/Messages/requestToDeleteEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request entity deletion for entity "{0}"', 'O', 'messages', '2011-01-13 17:48:00.633', NULL, '2010-10-11 23:30:45.397561');
INSERT INTO base_property VALUES (467, 'Entity/Constants/uploadIcon/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload Icon', 'O', 'messages', '2011-01-13 17:48:01.169', NULL, '2010-10-26 13:50:32.380066');
INSERT INTO base_property VALUES (468, 'Entity/Constants/toggleColorAdjustments/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Advanced settings (optional)', 'O', 'messages', '2011-01-13 17:48:01.193', NULL, '2010-10-26 13:50:32.702966');
INSERT INTO base_property VALUES (469, '/Calendar/Constants/novemberShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Nov', 'O', 'messages', '2011-01-13 17:48:02.894', NULL, '2010-10-01 17:32:11.595239');
INSERT INTO base_property VALUES (470, 'Entity/Constants/requestDeletion/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request Deletion', 'O', 'messages', '2011-01-13 17:49:58.269', NULL, '2010-10-11 23:31:04.572265');
INSERT INTO base_property VALUES (471, 'Entity/Constants/whyDeleteEntityCaption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Why should the space be deleted?', 'O', 'messages', '2011-01-13 17:49:56.724', NULL, '2010-10-11 23:31:03.234531');
INSERT INTO base_property VALUES (472, 'Entity/Constants/acceptInvitationOption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept Invitation', 'O', 'messages', '2011-01-13 17:49:58.288', NULL, '2010-10-11 23:31:04.579717');
INSERT INTO base_property VALUES (473, 'Entity/Constants/realyWantToLeaveEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave this place?', 'O', 'messages', '2011-01-13 17:47:56.099', NULL, '2010-10-01 17:32:07.328836');
INSERT INTO base_property VALUES (474, 'Entity/Constants/assignedEntites/Wiki', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Assigned Content', 'O', 'messages', '2010-10-07 11:36:33.893', NULL, '2010-10-07 11:36:33.893307');
INSERT INTO base_property VALUES (475, 'Entity/Constants/acceptChanges/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept changes', 'O', 'messages', '2011-01-13 17:48:01.199', NULL, '2010-10-26 13:50:32.807919');
INSERT INTO base_property VALUES (476, 'Entity/Constants/realyWantToLeaveEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave this event?', 'O', 'messages', '2011-01-13 17:47:57.665', NULL, '2010-10-01 17:32:08.720148');
INSERT INTO base_property VALUES (477, 'Entity/Constants/adjustColors/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Customize colors', 'O', 'messages', '2011-01-13 17:48:01.182', NULL, '2010-10-26 13:50:32.487476');
INSERT INTO base_property VALUES (478, '/Calendar/Constants/mayShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'May', 'O', 'messages', '2011-01-13 17:48:02.881', NULL, '2010-10-01 17:32:11.578804');
INSERT INTO base_property VALUES (479, 'Entity/Constants/navigationLinks/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Links in navigation', 'O', 'messages', '2011-01-13 17:48:01.216', NULL, '2010-10-26 13:50:33.225851');
INSERT INTO base_property VALUES (480, 'Entity/Messages/entityDeleteRquestMailHeader', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deletion request for entity "{0}" (ID: {1}) has been submitted.', 'O', 'messages', '2011-01-13 17:49:57.035', NULL, '2010-10-11 23:31:03.584998');
INSERT INTO base_property VALUES (481, '/Comments/Messages/showFurtherComments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show {0} further comments', 'O', 'messages', '2011-01-13 17:49:57.104', NULL, '2010-10-11 23:31:03.604194');
INSERT INTO base_property VALUES (482, '/Calendar/Constants/MarchShort', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Mar', 'O', 'messages', '2010-10-22 17:52:34.202', NULL, '2010-10-01 17:32:11.575913');
INSERT INTO base_property VALUES (483, 'Entity/Constants/horizontalNavigationBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation', 'O', 'messages', '2011-01-13 17:48:01.231', NULL, '2010-10-26 13:50:33.438562');
INSERT INTO base_property VALUES (484, 'Entity/Constants/headerBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:48:01.237', NULL, '2010-10-26 13:50:33.654749');
INSERT INTO base_property VALUES (485, 'Survey/Constants/onlyMemberMayParticipateMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only members may participate.', 'O', 'messages', '2011-01-13 17:48:02.846', NULL, '2010-10-01 17:32:11.539916');
INSERT INTO base_property VALUES (486, '/Calendar/Constants/januarShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Jan', 'O', 'messages', '2011-01-13 17:48:02.872', NULL, '2010-10-01 17:32:11.569542');
INSERT INTO base_property VALUES (487, '/Calendar/Constants/septemberShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Sep', 'O', 'messages', '2011-01-13 17:48:02.889', NULL, '2010-10-01 17:32:11.589364');
INSERT INTO base_property VALUES (488, 'Entity/Constants/realyWantToLeaveEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave this group?', 'O', 'messages', '2011-01-13 17:49:58.199', NULL, '2010-10-01 17:33:55.80726');
INSERT INTO base_property VALUES (489, 'Entity/Messages/entityDeleteRquestMailHeader/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deletion request for entity "{0}" (ID: {1}) has been submitted.', 'O', 'messages', '2011-01-13 17:49:58.567', NULL, '2010-10-11 23:31:04.838719');
INSERT INTO base_property VALUES (490, 'Entity/Messages/requestToDeleteEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request entity deletion for entity "{0}"', 'O', 'messages', '2011-01-13 17:49:58.563', NULL, '2010-10-11 23:31:04.834691');
INSERT INTO base_property VALUES (491, 'Entity/Constants/invitationPopupSelection/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection', 'O', 'messages', '2011-01-13 17:48:01.374', NULL, '2010-10-26 13:50:37.230552');
INSERT INTO base_property VALUES (492, 'Entity/Constants/deleteElement/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:48:01.345', NULL, '2010-10-26 13:50:36.388455');
INSERT INTO base_property VALUES (493, 'NewsletterHtml/Messages/newAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Album: <a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.489', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (494, 'Entity/Constants/enterNameOfEntityHere/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of entity', 'O', 'messages', '2011-01-13 17:48:00.698', NULL, '2010-10-26 13:50:36.284911');
INSERT INTO base_property VALUES (495, 'Entity/Constants/headingBoxText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text and links in heading box', 'O', 'messages', '2011-01-13 17:48:01.25', NULL, '2010-10-26 13:50:34.0706');
INSERT INTO base_property VALUES (496, 'Entity/Constants/linksOnBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Links on background', 'O', 'messages', '2011-01-13 17:48:01.282', NULL, '2010-10-26 13:50:34.993934');
INSERT INTO base_property VALUES (497, 'Entity/Constants/entityNotVisibleText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The content of this entity is not visible for every user. You need to join this entity or get an invitation first.', 'O', 'messages', '2011-01-13 17:48:01.317', NULL, '2010-10-26 13:50:35.645526');
INSERT INTO base_property VALUES (498, 'Entity/Constants/linkedEntityPrivacyStatusAnybody/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anybody', 'O', 'messages', '2011-01-13 17:48:01.323', NULL, '2010-10-26 13:50:35.862798');
INSERT INTO base_property VALUES (499, 'Entity/Constants/linkedEntityPrivacyStatusAdminOnly/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins', 'O', 'messages', '2011-01-13 17:48:01.332', NULL, '2010-10-26 13:50:35.967412');
INSERT INTO base_property VALUES (500, 'Entity/Constants/duplicateEntitySelectionErrorOccur/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:48:01.35', NULL, '2010-10-26 13:50:36.599265');
INSERT INTO base_property VALUES (501, 'Entity/Constants/parentEntityRequiredError/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'At least you have to assign one element', 'O', 'messages', '2011-01-13 17:48:01.353', NULL, '2010-10-26 13:50:36.602129');
INSERT INTO base_property VALUES (502, 'Entity/Constants/invalidEntitySelectionOccur/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'One or more of your selection are invalid.', 'O', 'messages', '2011-01-13 17:48:01.359', NULL, '2010-10-26 13:50:36.81635');
INSERT INTO base_property VALUES (503, 'Entity/Constants/invitationPopupShowInviteMessage/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:48:01.39', NULL, '2010-10-26 13:50:37.444364');
INSERT INTO base_property VALUES (504, 'Entity/Constants/invitationPopupPleaseSelectPersonToInvite/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No person selected, nobody to invite.', 'O', 'messages', '2011-01-13 17:48:01.396', NULL, '2010-10-26 13:50:37.54925');
INSERT INTO base_property VALUES (505, 'Entity/Constants/invitationPopupNoPersonsFound/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No people found, nothing to insert.', 'O', 'messages', '2011-01-13 17:48:01.401', NULL, '2010-10-26 13:50:37.764119');
INSERT INTO base_property VALUES (506, 'Entity/Constants/buttonBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Buttons', 'O', 'messages', '2011-01-13 17:48:01.289', NULL, '2010-10-26 13:50:35.196731');
INSERT INTO base_property VALUES (507, 'Profile/Constants/employer', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Employer', 'O', 'messages', '2011-01-13 17:47:45.762', NULL, '2010-09-23 01:57:44.091865');
INSERT INTO base_property VALUES (508, 'Profile/Constants/endAt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'End at', 'O', 'messages', '2011-01-13 17:47:45.779', NULL, '2010-09-23 01:57:44.095103');
INSERT INTO base_property VALUES (509, 'Entity/Constants/linkedEntityPrivacyAssignmentHeader/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assignment', 'O', 'messages', '2011-01-13 17:48:01.335', NULL, '2010-10-26 13:50:36.068609');
INSERT INTO base_property VALUES (510, 'Entity/Constants/onlyEntitiesWhereYouAreAdmin/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only entities where you are the administrator', 'O', 'messages', '2011-01-13 17:48:00.709', NULL, '2010-10-26 13:50:37.018257');
INSERT INTO base_property VALUES (511, 'Entity/Constants/headerLinks/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Links in header', 'O', 'messages', '2011-01-13 17:48:01.246', NULL, '2010-10-26 13:50:33.856808');
INSERT INTO base_property VALUES (512, 'Entity/Constants/headingBoxBorder/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border of heading box', 'O', 'messages', '2011-01-13 17:48:01.251', NULL, '2010-10-26 13:50:34.171675');
INSERT INTO base_property VALUES (513, 'Entity/Constants/subBoxText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text in subbox', 'O', 'messages', '2011-01-13 17:48:01.255', NULL, '2010-10-26 13:50:34.383607');
INSERT INTO base_property VALUES (514, 'Entity/Constants/subBoxBorder/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border of subbox', 'O', 'messages', '2011-01-13 17:48:01.259', NULL, '2010-10-26 13:50:34.553305');
INSERT INTO base_property VALUES (515, 'Entity/Constants/outerBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Outer background', 'O', 'messages', '2011-01-13 17:48:01.269', NULL, '2010-10-26 13:50:34.678681');
INSERT INTO base_property VALUES (516, 'Entity/Constants/borderTop/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (top)', 'O', 'messages', '2011-01-13 17:48:01.298', NULL, '2010-10-26 13:50:35.309041');
INSERT INTO base_property VALUES (517, 'Entity/Constants/borderBottom/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (buttom)', 'O', 'messages', '2011-01-13 17:48:01.304', NULL, '2010-10-26 13:50:35.410547');
INSERT INTO base_property VALUES (518, 'Entity/Constants/borderRight/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (right)', 'O', 'messages', '2011-01-13 17:48:01.308', NULL, '2010-10-26 13:50:35.540503');
INSERT INTO base_property VALUES (519, 'Profile/Constants/titleText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:45.862', NULL, '2010-09-23 01:57:44.254235');
INSERT INTO base_property VALUES (520, 'Entity/Constants/assignEntityToElements/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assign this entity to other elements', 'O', 'messages', '2011-01-13 17:48:00.705', NULL, '2010-10-26 13:50:36.38544');
INSERT INTO base_property VALUES (521, 'Entity/Constants/errorDecliningInvitation/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining invitation.', 'O', 'messages', '2011-01-13 17:48:01.449', NULL, '2010-10-26 13:50:39.234554');
INSERT INTO base_property VALUES (522, 'Entity/Constants/entityJoinRequest/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity Join Requets', 'O', 'messages', '2011-01-13 17:48:00.719', NULL, '2010-10-26 13:50:39.664723');
INSERT INTO base_property VALUES (523, 'Entity/Constants/widgetsShowSubEntitiesOption/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show entites of sub entities', 'O', 'messages', '2011-01-13 17:48:00.723', NULL, '2010-10-26 13:50:39.818139');
INSERT INTO base_property VALUES (524, 'Entity/Constants/headerBorder/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border of header', 'O', 'messages', '2011-01-13 17:48:01.248', NULL, '2010-10-26 13:50:33.96912');
INSERT INTO base_property VALUES (525, 'Entity/Constants/subBox/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:48:01.253', NULL, '2010-10-26 13:50:34.282164');
INSERT INTO base_property VALUES (526, 'Entity/Constants/subBoxLinks/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Links the subbox', 'O', 'messages', '2011-01-13 17:48:01.257', NULL, '2010-10-26 13:50:34.484908');
INSERT INTO base_property VALUES (527, 'Entity/Constants/subBoxLine/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox separator line', 'O', 'messages', '2011-01-13 17:48:01.266', NULL, '2010-10-26 13:50:34.67572');
INSERT INTO base_property VALUES (528, 'Entity/Constants/innerBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Inner background', 'O', 'messages', '2011-01-13 17:48:01.273', NULL, '2010-10-26 13:50:34.780493');
INSERT INTO base_property VALUES (529, 'Entity/Constants/textOnBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text on background', 'O', 'messages', '2011-01-13 17:48:01.275', NULL, '2010-10-26 13:50:34.879356');
INSERT INTO base_property VALUES (530, 'Entity/Constants/lineOnBackground/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separator line on background', 'O', 'messages', '2011-01-13 17:48:01.286', NULL, '2010-10-26 13:50:35.095244');
INSERT INTO base_property VALUES (531, 'Entity/Constants/buttonText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text on buttons', 'O', 'messages', '2011-01-13 17:48:01.292', NULL, '2010-10-26 13:50:35.305876');
INSERT INTO base_property VALUES (532, 'Entity/Constants/borderLeft/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (left)', 'O', 'messages', '2011-01-13 17:48:01.306', NULL, '2010-10-26 13:50:35.42461');
INSERT INTO base_property VALUES (533, 'Entity/Constants/errorDecliningJoinRequest/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining join request.', 'O', 'messages', '2011-01-13 17:48:01.456', NULL, '2010-10-26 13:50:39.452196');
INSERT INTO base_property VALUES (534, 'Entity/Constants/notAllowedToEditInfoWidget/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit information', 'O', 'messages', '2011-01-13 17:48:01.31', NULL, '2010-10-26 13:50:35.544029');
INSERT INTO base_property VALUES (535, 'Entity/Constants/entityNotVisibleTitle/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity privacy settings', 'O', 'messages', '2011-01-13 17:48:01.32', NULL, '2010-10-26 13:50:35.746843');
INSERT INTO base_property VALUES (536, 'Entity/Constants/linkedEntityPrivacyStatusAdminAndMembers/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins and members', 'O', 'messages', '2011-01-13 17:48:01.329', NULL, '2010-10-26 13:50:35.866015');
INSERT INTO base_property VALUES (538, 'Entity/Constants/entityWasSelectedError/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:48:01.348', NULL, '2010-10-26 13:50:36.49788');
INSERT INTO base_property VALUES (539, 'Entity/Constants/selectASuggestedEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection not found. Please select a suggested entity.', 'O', 'messages', '2011-01-13 17:48:01.356', NULL, '2010-10-26 13:50:36.703252');
INSERT INTO base_property VALUES (540, 'Entity/Constants/recursiveAssigmentOccur/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning this element will cause a recursive assigment. Assigning this element is not possible.', 'O', 'messages', '2011-01-13 17:48:01.366', NULL, '2010-10-26 13:50:36.91697');
INSERT INTO base_property VALUES (541, 'Entity/Constants/sendInvites/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send invites', 'O', 'messages', '2011-01-13 17:48:01.371', NULL, '2010-10-26 13:50:37.128451');
INSERT INTO base_property VALUES (542, 'Entity/Constants/invitationPopupMessage/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite message', 'O', 'messages', '2011-01-13 17:48:01.377', NULL, '2010-10-26 13:50:37.332355');
INSERT INTO base_property VALUES (543, 'Entity/Constants/invitationPopupList/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:48:01.38', NULL, '2010-10-26 13:50:37.441414');
INSERT INTO base_property VALUES (544, 'Entity/Constants/invitationPopupHideInviteMessage/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove', 'O', 'messages', '2011-01-13 17:48:01.393', NULL, '2010-10-26 13:50:37.54622');
INSERT INTO base_property VALUES (545, 'Entity/Constants/invitationPopupNoPersonsInserted/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Nobody added, since they are already in your list.', 'O', 'messages', '2011-01-13 17:48:01.398', NULL, '2010-10-26 13:50:37.650342');
INSERT INTO base_property VALUES (546, 'Entity/Constants/inviteViaEmail/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite via email', 'O', 'messages', '2011-01-13 17:48:01.411', NULL, '2010-10-26 13:50:37.866228');
INSERT INTO base_property VALUES (547, 'Entity/Constants/inviteMyContactsButtonText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite my contacts', 'O', 'messages', '2011-01-13 17:48:01.417', NULL, '2010-10-26 13:50:38.077146');
INSERT INTO base_property VALUES (548, 'Entity/Constants/enterEmailHelpText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'separated by comma, semicolon, space or return', 'O', 'messages', '2011-01-13 17:48:01.426', NULL, '2010-10-26 13:50:38.281696');
INSERT INTO base_property VALUES (549, 'Entity/Mails/entityDataChanged/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname modified wiki page "$ENTITY.Name":

$ENTITY_OLD_DATA

Changed to:

$ENTITY_NEW_DATA

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.497', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (550, 'Entity/Mails/messageEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wrote a message to the members of event "$ENTITY.Name":

$SUBJECT

$MESSAGE

Log in to reply:
$STARTPAGE_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.548', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (551, 'Entity/Constants/followedEmailsAreInvalid/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Following emails are invalid:', 'O', 'messages', '2011-01-13 17:48:01.431', NULL, '2010-10-26 13:50:38.494649');
INSERT INTO base_property VALUES (552, 'Entity/Constants/entityClosedNotAcceptingJoinRequestPossibleAnymore/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You can''t accept this request anymore.', 'O', 'messages', '2011-01-13 17:48:01.443', NULL, '2010-10-26 13:50:39.029651');
INSERT INTO base_property VALUES (553, 'Profile/Constants/website', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:47:45.642', NULL, '2010-09-23 01:57:44.089238');
INSERT INTO base_property VALUES (554, 'Entity/Constants/maps', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Geographical search', 'O', 'messages', '2011-01-13 17:49:56.036', NULL, '2010-10-05 16:40:34.717069');
INSERT INTO base_property VALUES (555, 'Entity/Constants/maps/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Geographical search', 'O', 'messages', '2011-01-13 17:49:57.621', NULL, '2010-10-05 16:40:36.011511');
INSERT INTO base_property VALUES (556, 'Profile/Constants/jabber', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Jabber', 'O', 'messages', '2011-01-13 17:47:45.74', NULL, '2010-09-23 01:57:44.075934');
INSERT INTO base_property VALUES (557, 'Profile/Constants/startAt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Start at', 'O', 'messages', '2011-01-13 17:47:45.774', NULL, '2010-09-23 01:57:44.09347');
INSERT INTO base_property VALUES (558, 'Profile/Constants/primaryEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Primary email', 'O', 'messages', '2011-01-13 17:47:45.841', NULL, '2010-09-23 01:57:44.233881');
INSERT INTO base_property VALUES (559, 'Profile/Constants/jobStatus', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Job status', 'O', 'messages', '2011-01-13 17:47:45.859', NULL, '2010-09-23 01:57:44.126386');
INSERT INTO base_property VALUES (560, 'Profile/Constants/privateContactDataVisibilityText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your private contact data is only visible for yourself', 'O', 'messages', '2011-01-13 17:47:45.865', NULL, '2010-10-05 16:40:09.684191');
INSERT INTO base_property VALUES (561, 'Profile/Constants/businessContactDataImportText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select to import your business contact data', 'O', 'messages', '2011-01-13 17:47:45.907', NULL, '2010-10-05 16:40:09.701829');
INSERT INTO base_property VALUES (562, 'Videolink/Messages/feedNamedVideoNew', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} posted the video {1}.', 'O', 'messages', '2011-01-13 17:47:54.287', NULL, '2010-10-05 16:40:08.48443');
INSERT INTO base_property VALUES (563, 'Videolink/Messages/feedNamedVideoCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} commented the video {1}.', 'O', 'messages', '2011-01-13 17:47:54.291', NULL, '2010-10-05 16:40:08.492434');
INSERT INTO base_property VALUES (564, 'Workstream/Constants/tooltipDeleteWorkstreamMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete this message', 'O', 'messages', '2011-01-13 17:47:54.707', NULL, '2010-10-05 16:40:09.43415');
INSERT INTO base_property VALUES (565, 'Profile/Constants/businessContactData', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Business contact data', 'O', 'messages', '2011-01-13 17:47:45.595', NULL, '2010-09-23 01:57:44.133194');
INSERT INTO base_property VALUES (566, 'Profile/Constants/activities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activities', 'O', 'messages', '2011-01-13 17:47:45.608', NULL, '2010-09-23 01:57:44.079867');
INSERT INTO base_property VALUES (567, 'Profile/Messages/feedUpdatedProfileMale', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} updated his profile.', 'O', 'messages', '2011-01-13 17:47:54.838', NULL, '2010-10-05 16:40:09.733513');
INSERT INTO base_property VALUES (568, 'Profile/Constants/aim', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'AIM', 'O', 'messages', '2011-01-13 17:47:45.616', NULL, '2010-09-23 01:57:44.072102');
INSERT INTO base_property VALUES (569, 'Profile/Constants/co', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'c/o', 'O', 'messages', '2011-01-13 17:47:45.62', NULL, '2010-09-23 01:57:44.083603');
INSERT INTO base_property VALUES (570, '/Basic/Constants/noEntry', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No entry', 'O', 'messages', '2011-01-13 17:47:54.943', NULL, '2010-09-23 01:57:44.165258');
INSERT INTO base_property VALUES (571, '/Basic/Constants/location', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:47:55.164', NULL, '2010-10-05 16:40:09.953314');
INSERT INTO base_property VALUES (572, 'Entity/Constants/enterEmailsHere/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter e-mail address', 'O', 'messages', '2011-01-13 17:47:55.946', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (573, 'Entity/Constants/addEmails/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:55.954', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (574, 'Entity/Constants/maps/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Geographical search', 'O', 'messages', '2011-01-13 17:47:59.762', NULL, '2010-10-05 16:40:14.457517');
INSERT INTO base_property VALUES (575, 'Entity/Messages/entityReportViolationMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in entity -> "{0}" (Entity ID: {1})', 'O', 'messages', '2011-01-13 17:49:57.028', NULL, '2010-10-08 11:38:13.959161');
INSERT INTO base_property VALUES (576, 'Entity/Messages/entityReportViolationMessages/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in entity -> "{0}" (Entity ID: {1})', 'O', 'messages', '2011-01-13 17:48:00.63', NULL, '2010-10-08 11:37:54.458488');
INSERT INTO base_property VALUES (577, 'Basic/Constants/educationAndWork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Education and work', 'O', 'messages', '2011-01-13 17:47:50.425', NULL, '2010-11-01 15:43:24.347708');
INSERT INTO base_property VALUES (578, 'Profile/Constants/unknownUniverstiyDepartment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unkown', 'O', 'messages', '2011-01-13 17:47:45.927', NULL, '2010-10-08 11:37:47.25607');
INSERT INTO base_property VALUES (579, 'Profile/Messages/feedUpdatedProfileFemale', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} updated her profile.', 'O', 'messages', '2011-01-13 17:47:54.835', NULL, '2010-10-05 16:40:09.725545');
INSERT INTO base_property VALUES (580, 'Basic/Constants/oldPasswordEmpty', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter the old password.', 'O', 'messages', '2011-01-13 17:47:50.59', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (581, 'Basic/Constants/erforderlich', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:47:50.617', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (582, 'Videolink/Messages/feedUnnamedVideoNew', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} posted a <a href="{1}">video</a>.', 'O', 'messages', '2011-01-13 17:47:54.294', NULL, '2010-10-05 16:40:08.46101');
INSERT INTO base_property VALUES (583, 'Videolink/Messages/feedUnnamedVideoCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} commented a <a href="{1}">video</a>.', 'O', 'messages', '2011-01-13 17:47:54.303', NULL, '2010-10-05 16:40:08.488914');
INSERT INTO base_property VALUES (584, 'Entity/Constants/whyDeleteEntityCaption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Why should the space be deleted?', 'O', 'messages', '2011-01-13 17:47:56.172', NULL, '2010-10-11 23:30:41.690063');
INSERT INTO base_property VALUES (585, 'Entity/Constants/maps/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Geographical search', 'O', 'messages', '2011-01-13 17:47:57.123', NULL, '2010-10-05 16:40:11.761937');
INSERT INTO base_property VALUES (586, 'Entity/Constants/maps/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Geographical search', 'O', 'messages', '2011-01-13 17:47:58.45', NULL, '2010-10-05 16:40:13.252347');
INSERT INTO base_property VALUES (587, 'Entity/Constants/maps/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Geographical search', 'O', 'messages', '2011-01-13 17:47:55.608', NULL, '2010-10-05 16:40:10.394977');
INSERT INTO base_property VALUES (588, 'Entity/Constants/inviteAllMyContacts/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite all my contacts', 'O', 'messages', '2011-01-13 17:48:01.414', NULL, '2010-10-26 13:50:37.968269');
INSERT INTO base_property VALUES (589, 'Entity/Constants/enterEmailsHere/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter email address', 'O', 'messages', '2011-01-13 17:48:01.423', NULL, '2010-10-26 13:50:38.180605');
INSERT INTO base_property VALUES (590, 'Entity/Constants/addEmails/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:48:01.428', NULL, '2010-10-26 13:50:38.391582');
INSERT INTO base_property VALUES (591, 'Entity/Constants/reportViolationOption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violation', 'O', 'messages', '2011-01-13 17:47:56.164', NULL, '2010-10-08 11:37:48.420575');
INSERT INTO base_property VALUES (592, '/Basic/Constants/assignedEntites', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Geographical search', 'O', 'messages', '2011-01-13 17:47:55.107', NULL, '2010-10-08 11:37:47.500442');
INSERT INTO base_property VALUES (593, 'Entity/Constants/thisEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity', 'O', 'messages', '2011-01-13 17:48:00.736', NULL, '2010-10-26 13:50:40.141528');
INSERT INTO base_property VALUES (594, 'Entity/Constants/entityClosedNotAcceptingInvitationPossibleAnymore/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You can''t take part any more.', 'O', 'messages', '2011-01-13 17:48:01.434', NULL, '2010-10-26 13:50:38.886168');
INSERT INTO base_property VALUES (595, 'Entity/Constants/errorAcceptingInvitation/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting invitation.', 'O', 'messages', '2011-01-13 17:48:01.446', NULL, '2010-10-26 13:50:39.131992');
INSERT INTO base_property VALUES (596, 'Entity/Constants/enterEmailHelpText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma, semicolon, space or return', 'O', 'messages', '2011-01-13 17:47:55.95', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (597, 'Entity/Constants/errorAcceptingJoinRequest/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting join request.', 'O', 'messages', '2011-01-13 17:48:01.454', NULL, '2010-10-26 13:50:39.350546');
INSERT INTO base_property VALUES (598, 'Entity/Constants/entityInvitations/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity Invitations', 'O', 'messages', '2011-01-13 17:48:00.714', NULL, '2010-10-26 13:50:39.554136');
INSERT INTO base_property VALUES (599, 'Entity/Constants/widgetsDontShowSubEntitiesOption/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only show entites of this entity', 'O', 'messages', '2011-01-13 17:48:00.727', NULL, '2010-10-26 13:50:39.821181');
INSERT INTO base_property VALUES (600, 'Entity/Constants/deleteNotPossibleAssigmentAvailable/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete not possible. There are still assigned elements:', 'O', 'messages', '2011-01-13 17:48:01.459', NULL, '2010-10-26 13:50:39.698749');
INSERT INTO base_property VALUES (601, 'Profile/Constants/importAcceptQuestion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Would you like to import your contact data?', 'O', 'messages', '2011-01-13 17:47:45.913', NULL, '2010-10-05 16:40:09.705133');
INSERT INTO base_property VALUES (602, 'Profile/Constants/businessContactDataVisibilityText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your business contact data is only visible for yourself', 'O', 'messages', '2011-01-13 17:47:45.871', NULL, '2010-10-05 16:40:09.692707');
INSERT INTO base_property VALUES (603, 'Profile/Constants/privateContactDataImportText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please select to import your private contact data.', 'O', 'messages', '2011-01-13 17:47:45.881', NULL, '2010-10-05 16:40:09.698541');
INSERT INTO base_property VALUES (604, 'Entity/Constants/dontAggregateWorkstreamOption/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'do not aggregate workstream', 'O', 'messages', '2011-01-13 17:48:01.503', NULL, '2010-10-26 13:50:39.926086');
INSERT INTO base_property VALUES (605, 'Entity/Constants/reportViolationOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violation', 'O', 'messages', '2011-01-13 17:49:56.716', NULL, '2010-10-08 11:38:13.710502');
INSERT INTO base_property VALUES (606, 'Entity/Constants/reportViolationOption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violation', 'O', 'messages', '2011-01-13 17:49:58.264', NULL, '2010-10-08 11:38:15.057728');
INSERT INTO base_property VALUES (607, 'Entity/Messages/entityReportViolationMessages/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in entity -> "{0}" (Entity ID: {1})', 'O', 'messages', '2011-01-13 17:47:56.459', NULL, '2010-10-08 11:37:48.771449');
INSERT INTO base_property VALUES (608, 'Entity/Messages/entityReportViolationMessages/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in entity -> "{0}" (Entity ID: {1})', 'O', 'messages', '2011-01-13 17:49:58.56', NULL, '2010-10-08 11:38:15.27777');
INSERT INTO base_property VALUES (609, 'Entity/Constants/reportViolationOption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violation', 'O', 'messages', '2011-01-13 17:47:57.722', NULL, '2010-10-08 11:37:50.222462');
INSERT INTO base_property VALUES (610, 'Entity/Messages/entityReportViolationMessages/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in entity -> "{0}" (Entity ID: {1})', 'O', 'messages', '2011-01-13 17:47:58.002', NULL, '2010-10-08 11:37:50.481263');
INSERT INTO base_property VALUES (611, 'Entity/Constants/reportViolationOption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violation', 'O', 'messages', '2011-01-13 17:47:59.059', NULL, '2010-10-08 11:37:52.221403');
INSERT INTO base_property VALUES (652, 'Newsletter/Messages/newAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Album: {0} (new)', 'O', 'messages', '2011-01-13 17:47:49.682', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (612, 'Entity/Messages/entityReportViolationMessages/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in entity -> "{0}" (Entity ID: {1})', 'O', 'messages', '2011-01-13 17:47:59.354', NULL, '2010-10-08 11:37:52.501085');
INSERT INTO base_property VALUES (613, 'Entity/Constants/reportViolationOption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violation', 'O', 'messages', '2011-01-13 17:48:00.353', NULL, '2010-10-08 11:37:54.091098');
INSERT INTO base_property VALUES (614, 'Entity/Constants/thisEntityAndSubItems/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity and subitems', 'O', 'messages', '2011-01-13 17:48:00.731', NULL, '2010-10-26 13:50:40.020991');
INSERT INTO base_property VALUES (615, 'Entity/Constants/aggregateWorkstreamOption/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'aggregate workstream', 'O', 'messages', '2011-01-13 17:48:01.495', NULL, '2010-10-26 13:50:39.922939');
INSERT INTO base_property VALUES (616, 'Entity/Constants/horizontalNavigationRestoreDefault/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore Default', 'O', 'messages', '2011-01-13 17:48:01.514', NULL, '2010-10-26 13:50:40.243179');
INSERT INTO base_property VALUES (617, 'Entity/Constants/horizontalNavigationCancel/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:48:01.516', NULL, '2010-10-26 13:50:40.345111');
INSERT INTO base_property VALUES (618, 'Entity/Constants/statusOptionNotAttend/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I don''t participate', 'O', 'messages', '2011-01-13 17:48:01.81', NULL, '2010-10-26 13:50:41.407436');
INSERT INTO base_property VALUES (619, 'Profile/Constants/unitversityDepartmentLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'University department', 'O', 'messages', '2011-01-13 17:47:45.921', NULL, '2010-10-08 11:37:47.233784');
INSERT INTO base_property VALUES (620, '/Basic/Constants/openMapPopup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enlarged view', 'O', 'messages', '2011-01-13 17:47:55.104', NULL, '2010-10-08 11:37:47.495681');
INSERT INTO base_property VALUES (621, '/Basic/Constants/addressNotLocatable', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The address you entered was not found.', 'O', 'messages', '2011-01-13 17:47:55.11', NULL, '2010-10-08 11:37:47.535254');
INSERT INTO base_property VALUES (622, 'Newsletter/Messages/entityNewWallEntry', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (new wall entry)', 'O', 'messages', '2011-01-13 17:47:49.825', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (623, 'NewsletterHtml/Messages/newPhoto', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo: <a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.6', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (624, 'Basic/Constants/photo', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Photo', 'O', 'messages', '2010-10-22 17:52:23.9', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (625, 'Newsletter/Messages/xJoinedTheGroupY', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (joined group {1})', 'O', 'messages', '2011-01-13 17:47:49.869', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (626, 'Newsletter/Messages/xJoinedTheNetworkY', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (joined place {1})', 'O', 'messages', '2011-01-13 17:47:49.878', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (627, 'Newsletter/Messages/xHasNewFriendY', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (now contact of {1})', 'O', 'messages', '2011-01-13 17:47:49.891', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (628, 'Newsletter/Messages/changedProfile', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (profile modified2)', 'O', 'messages', '2011-01-13 17:47:49.896', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (629, 'Newsletter/Messages/newVideo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video: {0} (new)', 'O', 'messages', '2011-01-13 17:47:49.902', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (630, 'Login/Constants/forgotPassword', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Forgot your password?', 'O', 'messages', '2011-01-13 17:47:49.932', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (631, 'NewsletterHtml/Messages/newFriend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (now contact of <a href="{2}">{3}</a>)', 'O', 'messages', '2011-01-13 17:47:49.577', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (632, 'Basic/Constants/am', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'On', 'O', 'messages', '2011-01-13 17:47:51.767', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (633, 'Entity/Constants/boxBorders/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Borders heading box', 'O', 'messages', '2011-01-13 17:47:55.741', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (634, 'Basic/Constants/block', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Block', 'O', 'messages', '2011-01-13 17:47:51.737', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (635, 'NewsletterHtml/Messages/wikiPageChanged', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (modified)', 'O', 'messages', '2011-01-13 17:47:49.572', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (636, 'Entity/Constants/acceptChanges/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept changes', 'O', 'messages', '2011-01-13 17:47:55.744', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (637, 'Entity/Constants/successfullySavedEntityDesign/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design saved.', 'O', 'messages', '2011-01-13 17:47:55.747', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (638, 'Entity/Constants/headerBorder/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Border', 'O', 'messages', '2011-01-13 17:47:55.773', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (639, 'Entity/Constants/headingBoxText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Text and links', 'O', 'messages', '2011-01-13 17:47:55.775', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (640, 'NewsletterHtml/Messages/wikiPageNewWallEntry', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new wall entry)', 'O', 'messages', '2011-01-13 17:47:49.575', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (641, 'Basic/Constants/gruesstDich', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'sends you a smile.', 'O', 'messages', '2011-01-13 17:47:50.658', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (642, 'NewsletterHtml/Messages/newWikiPage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.586', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (643, 'NewsletterHtml/Messages/newDocumentVersion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new version)', 'O', 'messages', '2011-01-13 17:47:49.591', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (644, 'NewsletterHtml/Messages/newDocumentComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new comment)', 'O', 'messages', '2011-01-13 17:47:49.595', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (645, 'NewsletterHtml/Messages/newAppointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.598', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (646, 'NewsletterHtml/Messages/newPhotosInGroup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group <a href="{0}">{1}</a> (several new photos)', 'O', 'messages', '2011-01-13 17:47:49.605', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (647, 'NewsletterHtml/Messages/newDiscussionTopic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new topic)', 'O', 'messages', '2011-01-13 17:47:49.609', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (648, 'NewsletterHtml/Messages/newDiscussionComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new answer)', 'O', 'messages', '2011-01-13 17:47:49.613', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (649, 'NewsletterHtml/Messages/newVideoInGroup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video: <a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.626', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (650, 'NewsletterHtml/Messages/newVideoProfileVideoLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video: <a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.632', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (651, 'Newsletter/Messages/subject', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Individual update for {0} on {1}', 'O', 'messages', '2011-01-13 17:47:49.676', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (653, 'Newsletter/Messages/newPhoto', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo: {0} (new)', 'O', 'messages', '2011-01-13 17:47:49.739', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (654, 'Newsletter/Messages/newPhotoComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo: {0} (new comment)', 'O', 'messages', '2011-01-13 17:47:49.744', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (655, 'Newsletter/Messages/newDiscussionTopic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (new topic)', 'O', 'messages', '2011-01-13 17:47:49.754', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (656, 'Newsletter/Messages/newDiscussionComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (new answer)', 'O', 'messages', '2011-01-13 17:47:49.759', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (657, 'NewsletterHtml/Messages/newVideoCommentInGroup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video: <a href="{0}">{1}</a> (new comment)', 'O', 'messages', '2011-01-13 17:47:49.629', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (658, 'Newsletter/Messages/newVideoComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video: {0} (new comment)', 'O', 'messages', '2011-01-13 17:47:49.796', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (659, 'Newsletter/Messages/entityChanged', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (modified)', 'O', 'messages', '2011-01-13 17:47:49.819', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (660, 'Newsletter/Messages/newEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (new)', 'O', 'messages', '2011-01-13 17:47:49.687', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (661, '/Comments/Constants/comments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Comments', 'O', 'messages', '2011-01-13 17:49:57.068', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (662, 'Basic/Constants/deleteAccount', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete account', 'O', 'messages', '2011-01-13 17:47:50.035', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (663, 'Basic/Constants/and', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'and', 'O', 'messages', '2010-10-26 17:31:57.353', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (664, 'Basic/Constants/education', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Education', 'O', 'messages', '2010-10-26 17:31:55.821', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (665, 'Basic/Constants/newEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'New e-mail address', 'O', 'messages', '2011-01-13 17:47:50.162', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (666, 'Basic/Constants/newMembers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'New users', 'O', 'messages', '2011-01-13 17:47:51.671', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (667, 'Basic/Constants/beschreibung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:47:50.228', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (668, 'Basic/Constants/zeitFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'h:mm a', 'O', 'messages', '2011-01-13 17:47:50.681', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (669, 'Basic/Constants/skip', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Skip', 'O', 'messages', '2011-01-13 17:47:51.702', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (670, 'Basic/Constants/post', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:51.75', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (671, 'Basic/Constants/close', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Close', 'O', 'messages', '2011-01-13 17:47:51.697', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (672, 'Basic/Constants/message', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:51.729', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (673, 'Basic/Constants/language', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Language', 'O', 'messages', '2011-01-13 17:47:51.706', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (674, 'Basic/Constants/bis', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'to', 'O', 'messages', '2011-01-13 17:47:49.971', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (675, 'Entity/Constants/subBox/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:47:55.779', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (676, 'Entity/Constants/subBoxText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Text', 'O', 'messages', '2011-01-13 17:47:55.781', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (677, 'Basic/Constants/degree', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Degree', 'O', 'messages', '2011-01-13 17:47:50.061', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (678, 'Entity/Constants/headingBoxBorder/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Border', 'O', 'messages', '2011-01-13 17:47:55.777', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (679, 'Basic/Constants/work', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'work', 'O', 'messages', '2010-10-26 17:31:55.645', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (680, 'Entity/Constants/buttonText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button: Text', 'O', 'messages', '2011-01-13 17:47:55.808', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (681, 'Basic/Constants/days', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'd', 'O', 'messages', '2011-01-13 17:47:49.986', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (682, 'Basic/Constants/addVideolink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Post a video', 'O', 'messages', '2011-01-13 17:47:50.039', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (683, 'Basic/Constants/geburtstag', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Birthday', 'O', 'messages', '2011-01-13 17:47:50.122', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (684, 'Basic/Constants/ok', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'OK', 'O', 'messages', '2011-01-13 17:47:49.966', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (685, 'Basic/Constants/deletedUser', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '(deleted user)', 'O', 'messages', '2011-01-13 17:47:50.049', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (686, 'Basic/Constants/hasNewFriend', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'is now contact of', 'O', 'messages', '2010-10-22 17:52:24.786', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (687, 'Basic/Constants/tags', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Tags', 'O', 'messages', '2010-10-22 17:52:23.412', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (688, 'Entity/Constants/linksOnBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Links', 'O', 'messages', '2011-01-13 17:47:55.797', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (689, 'Basic/Constants/addJob', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:50.177', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (690, 'Basic/Constants/startAt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Start at', 'O', 'messages', '2011-01-13 17:47:50.167', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (691, 'Basic/Constants/current', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current status', 'O', 'messages', '2011-01-13 17:47:51.72', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (692, 'Basic/Constants/text', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text', 'O', 'messages', '2011-01-13 17:47:51.711', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (693, 'Basic/Constants/website', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Homepage', 'O', 'messages', '2011-01-13 17:47:50.157', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (694, 'Basic/Constants/code', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Code', 'O', 'messages', '2011-01-13 17:47:51.755', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (695, 'Basic/Constants/endAt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'end at', 'O', 'messages', '2011-01-13 17:47:50.172', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (696, 'Basic/Constants/yourWall', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Your wall', 'O', 'messages', '2010-10-22 17:52:24.855', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (697, 'Basic/Constants/datumsFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'M/d/y', 'O', 'messages', '2011-01-13 17:47:51.586', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (698, 'Basic/Constants/position', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Position', 'O', 'messages', '2011-01-13 17:47:51.693', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (699, 'Basic/Constants/kaiooRegistrationMailSubject', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your registration', 'O', 'messages', '2011-01-13 17:47:50.079', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (700, 'Basic/Constants/uploadedAlbum', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'created an album.', 'O', 'messages', '2010-10-22 17:52:24.773', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (701, 'Entity/Constants/buttonBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button', 'O', 'messages', '2011-01-13 17:47:55.803', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (702, 'Basic/Constants/zipcode', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'ZIP', 'O', 'messages', '2011-01-13 17:47:50.152', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (703, 'Profile/Constants/work', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Work', 'O', 'messages', '2011-01-13 17:47:45.507', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (704, 'Basic/Constants/youCanUplaodPictureType', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'You can upload JPG, PNG or GIF files (4 MB max.).', 'O', 'messages', '2010-12-23 19:09:55.385', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (705, 'Basic/Constants/videolink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Videos', 'O', 'messages', '2011-01-13 17:47:49.991', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (706, 'Basic/Constants/privacy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:49.996', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (707, 'Entity/Constants/youHadNotAttended/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You didn''t participate', 'O', 'messages', '2011-01-13 17:48:01.555', NULL, '2010-10-26 13:50:40.775335');
INSERT INTO base_property VALUES (708, 'Basic/Constants/decimalCharacter', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '.', 'O', 'messages', '2011-01-13 17:47:50.217', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (709, 'Basic/Constants/fehlerNachrichtSenden', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'An error occurred while sending the message.', 'O', 'messages', '2010-10-22 17:52:23.607', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (710, 'Basic/Constants/freunde', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contacts', 'O', 'messages', '2011-01-13 17:47:50.263', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (711, 'Basic/Constants/freundesEinladungAnnehmen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Confirm contact request?', 'O', 'messages', '2011-01-13 17:47:50.29', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (712, 'Basic/Constants/addToStartProfileListSucceed', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Profile added.', 'O', 'messages', '2010-10-22 17:52:23.705', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (713, 'Basic/Constants/irreversibleAction', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You cannot undo this action.', 'O', 'messages', '2011-01-13 17:47:50.328', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (714, 'Basic/Constants/fehlerFreundschaftBestatigt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting contact!', 'O', 'messages', '2011-01-13 17:47:50.363', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (715, 'Basic/Constants/showOldMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '[Show message history]', 'O', 'messages', '2011-01-13 17:47:50.368', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (716, 'Basic/Constants/uploadPictures', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload photo', 'O', 'messages', '2011-01-13 17:47:50.397', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (717, 'Basic/Constants/gespeichert', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved.', 'O', 'messages', '2011-01-13 17:47:50.233', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (718, 'Basic/Constants/zurueck', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Back', 'O', 'messages', '2011-01-13 17:47:50.308', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (719, 'Basic/Constants/fehlerFreundschaftAbgelehnt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error ignoring contact request.', 'O', 'messages', '2011-01-13 17:47:50.314', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (720, 'Basic/Constants/allowBasic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Other users may view a limited profile.', 'O', 'messages', '2011-01-13 17:47:50.324', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (721, 'Basic/Constants/yourPhone', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your phone number', 'O', 'messages', '2011-01-13 17:47:50.338', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (722, 'Basic/Constants/um', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'at', 'O', 'messages', '2011-01-13 17:47:51.037', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (723, 'Basic/Constants/completeRegistrationHeading', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Security question to complete registration', 'O', 'messages', '2010-10-22 17:52:23.729', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (724, 'Basic/Constants/naechsteGeburtstage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Birthdays', 'O', 'messages', '2011-01-13 17:47:50.373', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (725, 'Basic/Constants/wholeDay', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Whole day', 'O', 'messages', '2011-01-13 17:47:50.378', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (726, 'Basic/Constants/change', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Change', 'O', 'messages', '2011-01-13 17:47:50.387', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (727, 'Entity/Constants/horizontalNavigationSuccessfullySaved/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation saved.', 'O', 'messages', '2011-01-13 17:48:01.536', NULL, '2010-10-26 13:50:40.559133');
INSERT INTO base_property VALUES (728, 'Entity/Constants/youAreUndecided/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You''re undecided', 'O', 'messages', '2011-01-13 17:48:01.579', NULL, '2010-10-26 13:50:40.880159');
INSERT INTO base_property VALUES (729, 'Basic/Constants/today', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'today', 'O', 'messages', '2011-01-13 17:47:50.001', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (730, 'Basic/Constants/aboutMe', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'About me', 'O', 'messages', '2011-01-13 17:47:50.201', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (731, 'Basic/Constants/yourLastName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your lastname', 'O', 'messages', '2011-01-13 17:47:50.238', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (732, 'Basic/Constants/wirklichLoeschen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete?', 'O', 'messages', '2011-01-13 17:47:50.243', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (733, 'Basic/Constants/grussLoeschen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove smile', 'O', 'messages', '2011-01-13 17:47:50.282', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (734, 'Basic/Constants/newPassword', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'New password', 'O', 'messages', '2011-01-13 17:47:50.518', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (735, 'Entity/Constants/horizontalNavigationSave/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:48:01.524', NULL, '2010-10-26 13:50:40.454315');
INSERT INTO base_property VALUES (736, 'Basic/Constants/studiengang', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Study course', 'O', 'messages', '2011-01-13 17:47:50.301', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (737, 'Basic/Constants/infoDialogTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:47:50.248', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (738, 'Basic/Constants/optionen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:47:51.675', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (739, 'Basic/Constants/mr', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mr.', 'O', 'messages', '2011-01-13 17:47:51.764', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (740, 'Entity/Constants/textOnBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Text', 'O', 'messages', '2011-01-13 17:47:55.794', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (741, 'Basic/Constants/newsHeader', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'News subject', 'O', 'messages', '2011-01-13 17:47:50.333', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (742, 'Profile/Constants/homeCountry', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Home country', 'O', 'messages', '2011-01-13 17:47:45.705', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (743, 'Basic/Constants/geloescht', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deleted.', 'O', 'messages', '2011-01-13 17:47:50.417', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (744, 'Basic/Constants/handynr', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Mobile', 'O', 'messages', '2010-10-22 17:52:23.87', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (745, 'Basic/Constants/fotosHochladen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload your photos', 'O', 'messages', '2011-01-13 17:47:50.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (746, 'Entity/Constants/participantPopupMsgLosingWaitlistPosition/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will loose your position on the waiting list.', 'O', 'messages', '2011-01-13 17:48:01.804', NULL, '2010-10-26 13:50:41.296976');
INSERT INTO base_property VALUES (747, 'Basic/Constants/antworten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Reply', 'O', 'messages', '2011-01-13 17:47:50.446', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (748, 'Basic/Constants/titel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Title', 'O', 'messages', '2011-01-13 17:47:50.45', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (749, 'Basic/Constants/vor1Minute', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'less than one minute ago', 'O', 'messages', '2011-01-13 17:47:50.632', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (750, 'Basic/Constants/empfaengerTipp', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Type name of a contact', 'O', 'messages', '2011-01-13 17:47:50.636', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (751, 'Basic/Constants/newMailActivationSucceeded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your new e-mail address was activated.', 'O', 'messages', '2011-01-13 17:47:50.641', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (752, 'Basic/Constants/looseChanges', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Discard changes', 'O', 'messages', '2011-01-13 17:47:50.822', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (753, 'Basic/Constants/newsContentInsertBlankLineForParagraph', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'News body', 'O', 'messages', '2011-01-13 17:47:50.646', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (754, 'Basic/Constants/notificationsViaEmailNo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No', 'O', 'messages', '2011-01-13 17:47:50.653', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (755, 'Basic/Constants/abbrechen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:47:50.827', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (756, 'Entity/Constants/statusOptionWantToAttend/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I participate', 'O', 'messages', '2011-01-13 17:48:01.826', NULL, '2010-10-26 13:50:41.509043');
INSERT INTO base_property VALUES (757, 'Entity/Constants/statusOptionUndecidedStatus/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I''m undecided', 'O', 'messages', '2011-01-13 17:48:01.858', NULL, '2010-10-26 13:50:41.611008');
INSERT INTO base_property VALUES (758, 'Entity/Constants/writeMessageToAllMembers/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to all members', 'O', 'messages', '2011-01-13 17:48:01.866', NULL, '2010-10-26 13:50:41.721005');
INSERT INTO base_property VALUES (759, 'Basic/Constants/duHastKeineFreunde', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not add any contacts yet.', 'O', 'messages', '2011-01-13 17:47:50.482', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (760, 'Basic/Constants/alle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:50.487', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (761, 'Basic/Constants/nachrichtenSchreiben', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Compose message', 'O', 'messages', '2011-01-13 17:47:50.5', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (762, 'Basic/Constants/addToStartProfileList', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Goto start profile list', 'O', 'messages', '2010-10-22 17:52:23.823', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (763, 'Basic/Constants/newsfeedsLabel', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Show news', 'O', 'messages', '2010-10-22 17:52:23.893', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (764, 'Basic/Constants/chooseNewPwd', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Choose new password', 'O', 'messages', '2011-01-13 17:47:50.537', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (765, 'Basic/Constants/fehlerNachrichtAnzeigen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The message cannot be displayed due to a connection error.', 'O', 'messages', '2011-01-13 17:47:50.547', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (766, 'Basic/Constants/noRecipientSpecifyOrRecipientInvalid', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No recipient entered or recipient invalid.', 'O', 'messages', '2011-01-13 17:47:50.551', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (767, 'Basic/Constants/personalTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Title', 'O', 'messages', '2011-01-13 17:47:50.561', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (768, 'Basic/Constants/lieblingsserie', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favorite movies and TV shows', 'O', 'messages', '2011-01-13 17:47:50.57', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (769, 'Basic/Constants/interessen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Interests', 'O', 'messages', '2011-01-13 17:47:50.666', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (770, 'Basic/Constants/notSavedYet', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Not saved yet', 'O', 'messages', '2011-01-13 17:47:50.671', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (771, 'Basic/Constants/freundschaftBeenden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove as contact', 'O', 'messages', '2011-01-13 17:47:50.855', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (772, 'Entity/Constants/youHaveRequestToAttend/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request sent.', 'O', 'messages', '2011-01-13 17:48:01.59', NULL, '2010-10-26 13:50:40.981558');
INSERT INTO base_property VALUES (773, 'Basic/Constants/removePicture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete photo', 'O', 'messages', '2011-01-13 17:47:50.542', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (774, 'Basic/Constants/newsDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'News deleted.', 'O', 'messages', '2011-01-13 17:47:50.86', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (775, 'Album/Constants/newAlbumOr', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or', 'O', 'messages', '2011-01-13 17:47:52.838', NULL, '2010-10-11 23:30:38.936605');
INSERT INTO base_property VALUES (776, 'Album/Messages/imageReportViolationMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in photo -> "{0}" ({1}) in album with ID {2}', 'O', 'messages', '2011-01-13 17:47:52.933', NULL, '2010-10-11 23:30:38.995045');
INSERT INTO base_property VALUES (777, 'Entity/Constants/deleteEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:55.43', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (778, 'Entity/Constants/horizontalNavigationEnterTitleAndLink/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter link name and link target', 'O', 'messages', '2011-01-13 17:48:01.529', NULL, '2010-10-26 13:50:40.556055');
INSERT INTO base_property VALUES (779, 'Entity/Constants/horizontalNavigationEdit/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:48:01.546', NULL, '2010-10-26 13:50:40.661423');
INSERT INTO base_property VALUES (780, 'Entity/Constants/youAreNotAttend/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You don''t participate', 'O', 'messages', '2011-01-13 17:48:01.57', NULL, '2010-10-26 13:50:40.778383');
INSERT INTO base_property VALUES (781, 'Basic/Constants/noIgnores', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Nobody is being ignored.', 'O', 'messages', '2011-01-13 17:47:50.565', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (782, 'Basic/Constants/meinProfilBearbeiten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit profile', 'O', 'messages', '2011-01-13 17:47:50.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (783, 'Basic/Constants/videoLinkNotImplementedYet', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'xxxasdf', 'O', 'messages', '2011-01-13 17:47:50.865', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (784, 'Basic/Constants/freundVon', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact of', 'O', 'messages', '2011-01-13 17:47:50.879', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (785, 'Basic/Constants/youHaveNoUpcomingBirthdays', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No birthdays of your contacts until next week.', 'O', 'messages', '2011-01-13 17:47:50.884', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (786, 'Profile/Constants/education', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Education', 'O', 'messages', '2011-01-13 17:47:45.577', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (787, 'Basic/Constants/haveAcceptPictureTermOfUse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept the Terms of Use first.', 'O', 'messages', '2011-01-13 17:47:50.586', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (788, 'Basic/Constants/vor1Stunde', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '1 hour ago', 'O', 'messages', '2011-01-13 17:47:50.686', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (789, 'Basic/Constants/pagerVor', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '>>', 'O', 'messages', '2011-01-13 17:47:50.69', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (790, 'Basic/Constants/oder', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'or', 'O', 'messages', '2010-10-22 17:52:24.41', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (791, 'Basic/Constants/accountdata', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'User data', 'O', 'messages', '2011-01-13 17:47:50.695', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (792, 'Basic/Constants/keineVideolinksVorhanden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No videos posted yet.', 'O', 'messages', '2011-01-13 17:47:50.719', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (793, 'Basic/Constants/freundschaftsEinladungVersandt', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Contact request sent.', 'O', 'messages', '2010-11-01 15:43:24.514', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (794, 'Basic/Constants/adressdaten', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Address', 'O', 'messages', '2010-10-22 17:52:24.423', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (795, 'Basic/Constants/nein', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No', 'O', 'messages', '2011-01-13 17:47:50.793', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (796, 'Basic/Constants/fehlerGruss', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error giving smile.', 'O', 'messages', '2011-01-13 17:47:50.889', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (797, 'Basic/Constants/gotoVideolistAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All users', 'O', 'messages', '2011-01-13 17:47:50.894', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (798, 'Basic/Constants/userIsNotBlocked', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The user is currently NOT blocked.', 'O', 'messages', '2011-01-13 17:47:50.898', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (799, 'Basic/Constants/registrieren', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Register', 'O', 'messages', '2011-01-13 17:47:50.798', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (800, 'Basic/Constants/errorDialogTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error', 'O', 'messages', '2011-01-13 17:47:50.94', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (801, 'Basic/Constants/gotoVideolist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:50.945', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (802, 'Basic/Constants/aktivitaeten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activities', 'O', 'messages', '2011-01-13 17:47:50.95', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (803, 'Basic/Constants/videolinkFromFriends', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video posts of contacts', 'O', 'messages', '2011-01-13 17:47:50.955', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (804, 'Basic/Constants/newsfeedDeactivateText', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'No function, will be removed soon', 'O', 'messages', '2010-10-04 14:39:30.89', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (805, 'Basic/Constants/plz', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'ZIP', 'O', 'messages', '2011-01-13 17:47:50.803', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (806, 'Basic/Constants/annehmen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:50.96', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (807, 'Basic/Constants/freundschaftBeendet', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact removed.', 'O', 'messages', '2011-01-13 17:47:50.812', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (808, 'Basic/Constants/weiterschreiben', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Continue writing', 'O', 'messages', '2011-01-13 17:47:50.969', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (809, 'Basic/Constants/accountActivationSucceded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your account has been activated.', 'O', 'messages', '2011-01-13 17:47:50.978', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (810, 'Basic/Constants/pictureUploadedSuccess', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo uploaded.', 'O', 'messages', '2011-01-13 17:47:50.992', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (811, 'Basic/Constants/profileVisibilityDescript', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who can view my profile?', 'O', 'messages', '2011-01-13 17:47:50.931', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (812, 'Basic/Constants/currentPicture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current photo', 'O', 'messages', '2011-01-13 17:47:51.009', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (813, 'Basic/Constants/newsletter', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Newsletter', 'O', 'messages', '2011-01-13 17:47:51.112', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (814, 'Basic/Constants/empfaenger', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Recipient', 'O', 'messages', '2011-01-13 17:47:51.116', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (815, 'Basic/Constants/diskutieren', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Discuss in groups', 'O', 'messages', '2011-01-13 17:47:51.032', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (816, 'Profile/Constants/country', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Country', 'O', 'messages', '2011-01-13 17:47:46.052', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (817, 'Basic/Constants/changeNews', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit admin-news', 'O', 'messages', '2011-01-13 17:47:51.13', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (818, 'Basic/Constants/completeRegistration', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Complete registration', 'O', 'messages', '2011-01-13 17:47:51.136', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (819, 'Profile/Constants/homeCity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Home town', 'O', 'messages', '2011-01-13 17:47:45.7', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (820, 'Basic/Constants/noEntries', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No entries', 'O', 'messages', '2011-01-13 17:47:50.207', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (821, 'Basic/Constants/informFriendsNo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No', 'O', 'messages', '2011-01-13 17:47:50.74', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (822, 'Basic/Constants/pick', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Pick', 'O', 'messages', '2011-01-13 17:47:51.027', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (823, 'Basic/Constants/gesendeteNachrichten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Sent messages', 'O', 'messages', '2011-01-13 17:47:51.126', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (824, 'Basic/Constants/videolinkDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video deleted.', 'O', 'messages', '2011-01-13 17:47:51.061', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (825, 'Basic/Constants/noTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '(no title)', 'O', 'messages', '2011-01-13 17:47:51.216', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (826, 'Basic/Constants/telefonnummer', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Land line', 'O', 'messages', '2010-10-22 17:52:24.552', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (827, 'Basic/Constants/newsfeeds', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'xxxasdf', 'O', 'messages', '2010-10-22 17:52:24.557', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (828, 'Basic/Constants/notificationsLabel', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Show news', 'O', 'messages', '2010-10-22 17:52:24.562', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (829, 'Basic/Constants/weblink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Link', 'O', 'messages', '2011-01-13 17:47:50.726', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (830, 'Basic/Constants/toStartPage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To go to start page, click here.', 'O', 'messages', '2011-01-13 17:47:51.089', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (831, 'Basic/Constants/accountDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Account deleted.', 'O', 'messages', '2011-01-13 17:47:51.094', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (832, 'Basic/Constants/mustEnterFirstAndSurName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enter your first and lastname.', 'O', 'messages', '2011-01-13 17:47:50.732', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (833, 'Basic/Constants/registerNow', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Sign up', 'O', 'messages', '2011-01-13 17:47:50.745', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (834, 'Basic/Constants/etc', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'And a lot more', 'O', 'messages', '2011-01-13 17:47:50.926', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (835, 'Basic/Constants/selectLanguage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select language', 'O', 'messages', '2011-01-13 17:47:50.936', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (836, 'Basic/Constants/videolinkPostedBy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Posted by', 'O', 'messages', '2011-01-13 17:47:50.999', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (837, 'Basic/Constants/mrs', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mrs.', 'O', 'messages', '2011-01-13 17:47:51.004', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (838, 'Basic/Constants/alleAnzeigen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:51.1', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (839, 'Basic/Constants/kontaktdaten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact information', 'O', 'messages', '2011-01-13 17:47:51.104', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (840, 'Basic/Constants/passwordsNotEqual', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Password confirmation is incorrect.', 'O', 'messages', '2011-01-13 17:47:51.314', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (841, 'Basic/Constants/enterCodeHere', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enter the code here ', 'O', 'messages', '2011-01-13 17:47:51.32', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (842, 'Basic/Constants/gegruesst', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Smile sent.', 'O', 'messages', '2011-01-13 17:47:51.358', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (843, 'Forum/Constants/eineAntwort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'One reply', 'O', 'messages', '2011-01-13 17:47:52.296', NULL, '2010-10-26 13:47:20.694608');
INSERT INTO base_property VALUES (844, 'Search/Constants/filterTypeLabelNewsBlogs', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Newsblog articles', 'O', 'messages', '2011-01-13 17:47:53.241', NULL, '2010-10-26 13:47:36.487675');
INSERT INTO base_property VALUES (845, 'Search/Constants/filterTypeLabelAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:53.282', NULL, '2010-10-11 23:30:39.078966');
INSERT INTO base_property VALUES (846, 'Exception/Messages/exceedingLength', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} is exceeding the length of {1} characters', 'O', 'messages', '2011-01-13 17:47:53.816', NULL, '2010-10-26 13:47:42.843665');
INSERT INTO base_property VALUES (847, 'Videolink/Constants/newVideo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add a new video', 'O', 'messages', '2011-01-13 17:47:54.087', NULL, '2010-10-26 13:47:46.40783');
INSERT INTO base_property VALUES (848, 'Videolink/Constants/videolinksWidget', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video links', 'O', 'messages', '2011-01-13 17:47:54.095', NULL, '2010-10-26 13:47:46.610309');
INSERT INTO base_property VALUES (849, 'Videolink/Constants/adminMayEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin may post video links', 'O', 'messages', '2011-01-13 17:47:54.099', NULL, '2010-10-26 13:47:46.72537');
INSERT INTO base_property VALUES (850, 'Basic/Constants/profilAnlegen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create profile', 'O', 'messages', '2011-01-13 17:47:51.24', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (851, 'Basic/Constants/warningDialogTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Warning', 'O', 'messages', '2011-01-13 17:47:51.247', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (852, 'Basic/Constants/schule', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'High school', 'O', 'messages', '2011-01-13 17:47:51.266', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (853, 'Basic/Constants/einstellungen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Account Settings', 'O', 'messages', '2011-01-13 17:47:51.262', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (854, 'Basic/Constants/editieren', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:47:51.272', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (855, 'Basic/Constants/confirmDeleteAccount', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To confirm, please enter your password.', 'O', 'messages', '2011-01-13 17:47:51.352', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (856, 'Basic/Constants/visitedPages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'May others see that you visited their profile?', 'O', 'messages', '2011-01-13 17:47:51.363', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (857, 'Basic/Constants/uploadPicture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload photo', 'O', 'messages', '2011-01-13 17:47:51.367', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (858, 'Basic/Constants/deselectAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deselect all', 'O', 'messages', '2011-01-13 17:47:51.417', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (859, 'Basic/Constants/questionDialogTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Question', 'O', 'messages', '2011-01-13 17:47:51.422', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (860, 'Basic/Constants/askForFriendShip', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request contact?', 'O', 'messages', '2011-01-13 17:47:51.426', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (861, 'Basic/Constants/yourFirstName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your firstname', 'O', 'messages', '2011-01-13 17:47:51.434', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (862, 'Basic/Constants/gruesse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Smiles', 'O', 'messages', '2011-01-13 17:47:51.44', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (863, 'Basic/Constants/frage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Question', 'O', 'messages', '2011-01-13 17:47:51.449', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (864, 'Basic/Constants/freundschaftBestaetigt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact confirmed.', 'O', 'messages', '2011-01-13 17:47:51.452', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (865, 'Basic/Constants/gemeldet', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Reported.', 'O', 'messages', '2011-01-13 17:47:51.466', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (866, 'Basic/Constants/betreff', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subject', 'O', 'messages', '2011-01-13 17:47:51.49', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (867, 'Basic/Constants/nachrichtSchicken', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send message', 'O', 'messages', '2011-01-13 17:47:51.478', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (868, 'Basic/Constants/zurueckgruessen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Smile back', 'O', 'messages', '2011-01-13 17:47:51.496', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (869, 'Basic/Constants/absender', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Sender', 'O', 'messages', '2011-01-13 17:47:51.657', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (870, 'Forum/Messages/antworten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} replies', 'O', 'messages', '2011-01-13 17:47:52.322', NULL, '2010-10-26 13:47:21.263375');
INSERT INTO base_property VALUES (871, 'Telltale/Messages/videolinkVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in videolink -> "{0}" [Author:"{1}" ({2})]', 'O', 'messages', '2011-01-13 17:47:52.356', NULL, '2010-10-26 13:47:21.934332');
INSERT INTO base_property VALUES (872, 'Profile/Constants/personalInformation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Personal information', 'O', 'messages', '2011-01-13 17:47:45.944', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (873, 'Basic/Constants/vernetzen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Connect with your contacts', 'O', 'messages', '2011-01-13 17:47:51.051', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (874, 'Basic/Constants/alleFreunde', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:51.056', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (875, 'Basic/Constants/kennstduschon', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you already know ...', 'O', 'messages', '2011-01-13 17:47:51.221', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (876, 'Basic/Constants/lastTwoWeeks', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Last 2 weeks', 'O', 'messages', '2010-10-22 17:52:24.754', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (877, 'Basic/Constants/putWrongPassword', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Password not correct.', 'O', 'messages', '2011-01-13 17:47:51.291', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (878, 'Basic/Constants/registerOrLogin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Sign up or log in', 'O', 'messages', '2011-01-13 17:47:51.281', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (879, 'Basic/Constants/justMyFriends', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Just my contacts', 'O', 'messages', '2011-01-13 17:47:51.285', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (880, 'Basic/Constants/passwordEmpty', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'An empty new password is not permitted.', 'O', 'messages', '2011-01-13 17:47:51.296', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (881, 'Basic/Constants/gruessen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Give a smile', 'O', 'messages', '2011-01-13 17:47:51.3', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (882, 'Basic/Constants/vor1Woche', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '1 week ago', 'O', 'messages', '2011-01-13 17:47:51.305', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (883, 'Basic/Constants/statusEmployee', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'xxxasdf', 'O', 'messages', '2010-10-22 17:52:24.793', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (884, 'Basic/Constants/melden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report', 'O', 'messages', '2011-01-13 17:47:51.309', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (885, 'Basic/Constants/invalidVideolink', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Invalid YouTube link', 'O', 'messages', '2010-10-22 17:52:24.799', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (886, 'Basic/Constants/wirdGeladen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Loading ...', 'O', 'messages', '2011-01-13 17:47:51.342', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (887, 'Basic/Constants/empfangeneNachrichten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Received messages', 'O', 'messages', '2011-01-13 17:47:51.151', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (888, 'Basic/Constants/alterBlockingState', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'View blocking status', 'O', 'messages', '2011-01-13 17:47:51.207', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (889, 'Basic/Constants/insertVideolinkHeading', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'YouTube link', 'O', 'messages', '2011-01-13 17:47:51.471', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (890, 'Basic/Constants/shoutbox', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wall', 'O', 'messages', '2011-01-13 17:47:51.457', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (891, 'Basic/Constants/notFilledFields', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please fill the following fields', 'O', 'messages', '2011-01-13 17:47:51.462', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (892, 'Basic/Constants/friendsVisibilityDescript', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who can view my list of contacts?', 'O', 'messages', '2011-01-13 17:47:51.508', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (893, 'Basic/Constants/abschlussjahr', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Year', 'O', 'messages', '2011-01-13 17:47:51.513', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (894, 'Basic/Constants/basisdaten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic information', 'O', 'messages', '2011-01-13 17:47:51.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (895, 'Basic/Constants/eineAntwort', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'One reply', 'O', 'messages', '2010-10-22 17:52:24.947', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (896, 'Basic/Constants/vom', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'From', 'O', 'messages', '2010-10-22 17:52:24.952', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (897, 'Basic/Constants/strasse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:47:51.572', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (898, 'Basic/Constants/arbeitgeber', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Employer', 'O', 'messages', '2011-01-13 17:47:51.577', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (899, 'Basic/Constants/yourEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your e-mail address', 'O', 'messages', '2011-01-13 17:47:51.604', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (900, 'Basic/Constants/userIsBlocked', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The user is currently blocked.', 'O', 'messages', '2011-01-13 17:47:51.614', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (901, 'Basic/Constants/visitedAllowed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Yes', 'O', 'messages', '2011-01-13 17:47:51.619', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (902, 'Basic/Constants/datumsFormatGeburtstag', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'EEEE, MMMM dd', 'O', 'messages', '2011-01-13 17:47:51.622', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (903, 'Basic/Constants/noObservers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No visits on your profile.', 'O', 'messages', '2011-01-13 17:47:51.627', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (904, 'Basic/Constants/weiblich', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Female', 'O', 'messages', '2010-10-22 17:52:24.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (905, 'Basic/Constants/uhr', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:51.632', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (906, 'Basic/Constants/keineMitteilung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No message', 'O', 'messages', '2011-01-13 17:47:51.635', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (907, 'Basic/Constants/alsFreundEinladen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request contact', 'O', 'messages', '2011-01-13 17:47:51.644', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (908, 'Basic/Constants/addUni', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:51.649', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (909, 'Basic/Messages/antworten', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', '{0} replies', 'O', 'messages', '2010-10-22 17:52:25.284', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (910, 'Basic/Messages/profileChanged', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} changed the profile.', 'O', 'messages', '2011-01-13 17:47:51.821', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (911, 'Basic/Constants/von', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'From', 'O', 'messages', '2011-01-13 17:47:51.68', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (912, 'Basic/Messages/videoLinkPosted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} posted video {1}', 'O', 'messages', '2011-01-13 17:47:51.961', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (913, 'Basic/Messages/uploadedAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the album {1}', 'O', 'messages', '2011-01-13 17:47:51.966', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (914, 'Basic/Messages/wroteOnWall', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wrote something on {1}', 'O', 'messages', '2011-01-13 17:47:51.971', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (915, 'Videolink/Constants/reportViolation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report Violation', 'O', 'messages', '2011-01-13 17:47:54.083', NULL, '2010-10-26 13:47:46.287412');
INSERT INTO base_property VALUES (916, 'Videolink/Constants/memberMayEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members may post video links', 'O', 'messages', '2011-01-13 17:47:54.103', NULL, '2010-10-26 13:47:46.729034');
INSERT INTO base_property VALUES (917, 'Videolink/Constants/noVideoLinksAddOne', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No video links added. <a>Add a video link.</a>', 'O', 'messages', '2011-01-13 17:47:54.11', NULL, '2010-10-26 13:47:46.933778');
INSERT INTO base_property VALUES (918, 'Entity/Constants/exportEntityMemberAndChildEntitiesToCSV/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list (also including assigned elements where you are Admin of)', 'O', 'messages', '2011-01-13 17:47:59.052', NULL, '2010-09-23 01:57:46.921308');
INSERT INTO base_property VALUES (919, 'Entity/Messages/feedNewWikiVersion/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created version {1} in the wiki editor', 'O', 'messages', '2011-01-13 17:47:59.216', NULL, '2010-09-23 01:57:46.963218');
INSERT INTO base_property VALUES (920, 'Survey/Constants/publishLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Publish', 'O', 'messages', '2011-01-13 17:48:02.742', NULL, '2010-09-23 01:57:48.171597');
INSERT INTO base_property VALUES (921, 'Survey/Constants/doYouRealyWantToDeleteYourAnswers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete your answers?', 'O', 'messages', '2011-01-13 17:48:02.825', NULL, '2010-09-23 01:57:48.266625');
INSERT INTO base_property VALUES (922, 'Basic/Constants/bild', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo', 'O', 'messages', '2011-01-13 17:47:51.402', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (923, 'Basic/Constants/lastWeek', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Last week', 'O', 'messages', '2010-10-22 17:52:24.837', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (924, 'Basic/Constants/noSuchUser', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No user registered with this e-mail address.', 'O', 'messages', '2011-01-13 17:47:51.408', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (925, 'Basic/Constants/loeschen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:51.518', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (926, 'Basic/Constants/startPageProfileConfiguration', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Configure profiles for start page', 'O', 'messages', '2011-01-13 17:47:51.412', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (927, 'Basic/Constants/editAdminnewsDateFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'M/d/y h:mm a', 'O', 'messages', '2011-01-13 17:47:51.554', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (928, 'Basic/Constants/nachrichtGesendet', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message sent.', 'O', 'messages', '2011-01-13 17:47:51.558', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (929, 'Basic/Constants/notificationsViaEmailYes', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Yes', 'O', 'messages', '2011-01-13 17:47:51.54', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (930, 'Basic/Messages/personalPhotoCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} commented one of your {1}', 'O', 'messages', '2011-01-13 17:47:52.06', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (931, 'Survey/Constants/noSurveysAvailable', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No surveys.', 'O', 'messages', '2011-01-13 17:48:02.748', NULL, '2010-09-23 01:57:48.18142');
INSERT INTO base_property VALUES (932, 'Basic/Constants/kaiooMember', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:51.666', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (933, 'Basic/Messages/videoPostCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} commented your video {1}', 'O', 'messages', '2011-01-13 17:47:51.781', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (934, 'Basic/Messages/missingInput', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please fill the following fields: {0}', 'O', 'messages', '2011-01-13 17:47:51.856', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (935, 'Basic/Messages/addAsAFriend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request {0} for contact', 'O', 'messages', '2011-01-13 17:47:51.861', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (936, 'Basic/Messages/greetUser', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Give {0} a smile', 'O', 'messages', '2011-01-13 17:47:51.866', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (937, 'Basic/Messages/vorTagen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} days ago', 'O', 'messages', '2011-01-13 17:47:51.94', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (938, 'Basic/Messages/vorStunden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} hours ago', 'O', 'messages', '2011-01-13 17:47:51.946', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (939, 'Basic/Messages/vorMinuten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} minutes ago', 'O', 'messages', '2011-01-13 17:47:51.951', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (940, 'Basic/Messages/validationExceptions', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<ul>{0}</ul>', 'O', 'messages', '2011-01-13 17:47:51.976', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (941, 'Basic/Messages/fillFieldx', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please fill the "{0}".', 'O', 'messages', '2011-01-13 17:47:51.978', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (942, 'Basic/Messages/selectFieldx', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please select from the list "{0}".', 'O', 'messages', '2011-01-13 17:47:51.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (943, 'Basic/Messages/enteredDateAndTimeInvalid', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The time and date entered in field "{0}" is invalid.', 'O', 'messages', '2011-01-13 17:47:51.988', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (944, 'Basic/Messages/enteredTimeInvalid', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The time entered in field "{0}" is invalid.', 'O', 'messages', '2011-01-13 17:47:51.996', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (945, 'Basic/Messages/oneComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '1 comment', 'O', 'messages', '2011-01-13 17:47:52.025', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (946, 'Basic/Messages/xComments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} comments', 'O', 'messages', '2011-01-13 17:47:52.029', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (947, 'Groups/Constants/joinRequests', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Group requests', 'O', 'messages', '2010-09-02 16:34:52.968', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (948, 'Groups/Constants/leaveGroup', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Leave group', 'O', 'messages', '2010-09-02 16:34:53.003', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (949, 'Basic/Messages/validationException', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<li>{0}</li>', 'O', 'messages', '2011-01-13 17:47:52.067', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (950, 'Basic/Messages/remaining', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '({0}/{1})', 'O', 'messages', '2011-01-13 17:47:52.078', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (951, 'Basic/Messages/delete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete {0}', 'O', 'messages', '2011-01-13 17:47:52.082', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (952, 'Basic/Messages/upload', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload {0}', 'O', 'messages', '2011-01-13 17:47:51.776', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (953, 'Basic/Messages/genetiveWithFinalSSound', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0}''''', 'O', 'messages', '2011-01-13 17:47:51.875', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (954, 'Basic/Messages/viewPhotoAlbums', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'View {0} albums', 'O', 'messages', '2011-01-13 17:47:51.89', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (955, 'Basic/Messages/startAfterEndTime', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Field "{0}": Start time after end time is not allowed', 'O', 'messages', '2011-01-13 17:47:52.012', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (956, 'Basic/Messages/dateNotBetweenXAndY', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The date in "{0}" is not between {1} and {2}.', 'O', 'messages', '2011-01-13 17:47:52.021', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (957, 'Basic/Messages/notANumber', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter a valid number in field "{0}" ', 'O', 'messages', '2011-01-13 17:47:52.086', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (958, 'Videolink/Constants/videolinkURL', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video URL', 'O', 'messages', '2011-01-13 17:47:54.123', NULL, '2010-10-26 13:47:47.260843');
INSERT INTO base_property VALUES (959, 'Basic/Messages/personxHatEingeladen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add {0} as contact?', 'O', 'messages', '2011-01-13 17:47:51.847', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (960, 'Basic/Messages/wall', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wall', 'O', 'messages', '2011-01-13 17:47:51.87', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (961, 'Basic/Messages/viewFriendslist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'View {0} contact list', 'O', 'messages', '2011-01-13 17:47:51.885', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (962, 'Basic/Messages/tooLong', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} is too long.', 'O', 'messages', '2011-01-13 17:47:51.921', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (963, 'Basic/Messages/vorMonaten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} months ago', 'O', 'messages', '2011-01-13 17:47:51.931', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (964, 'Basic/Messages/vorWochen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} weeks ago', 'O', 'messages', '2011-01-13 17:47:51.936', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (965, 'Videolink/Constants/mayNotAdd', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You may not add video links.', 'O', 'messages', '2011-01-13 17:47:54.106', NULL, '2010-10-26 13:47:46.832565');
INSERT INTO base_property VALUES (966, 'Videolink/Constants/addVideolinkPopupTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add a video link', 'O', 'messages', '2011-01-13 17:47:54.115', NULL, '2010-10-26 13:47:47.056665');
INSERT INTO base_property VALUES (967, 'Entity/Constants/participateToAssignedEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Become member of assigned publications', 'O', 'messages', '2011-01-13 17:48:00.338', NULL, '2010-09-23 01:57:47.592572');
INSERT INTO base_property VALUES (968, 'Survey/Constants/notAllowedToSeeSurvey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to view this survey', 'O', 'messages', '2011-01-13 17:48:02.803', NULL, '2010-09-23 01:57:48.239533');
INSERT INTO base_property VALUES (969, 'Network/Constants/previewHeaderLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header link', 'O', 'messages', '2011-01-13 17:47:52.143', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (970, 'Network/Constants/previewSubboxLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Link in subbox', 'O', 'messages', '2011-01-13 17:47:52.147', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (971, 'Network/Constants/previewHeadingBoxText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box', 'O', 'messages', '2011-01-13 17:47:52.156', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (972, 'Forum/Constants/themaStartenButton', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Post', 'O', 'messages', '2011-01-13 17:47:52.24', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (973, 'Forum/Constants/themaMelden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report topic', 'O', 'messages', '2011-01-13 17:47:52.25', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (974, 'Forum/Constants/aenderungsgrundEingeben', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Reason for modification', 'O', 'messages', '2011-01-13 17:47:52.284', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (975, 'Forum/Constants/aenderungsgrund', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Reason for modification', 'O', 'messages', '2011-01-13 17:47:52.288', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (976, 'Forum/Messages/lastChange', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Last change on {0} at {1} by {2}', 'O', 'messages', '2011-01-13 17:47:52.317', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (977, 'Forum/Messages/letzteAenderung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Last change on {0} at {1} by', 'O', 'messages', '2011-01-13 17:47:52.326', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (978, 'Forum/Messages/createdOnBy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created on {0} by {1}', 'O', 'messages', '2011-01-13 17:47:52.33', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (979, 'Telltale/Messages/albumVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in album -> "{0}" ({1})', 'O', 'messages', '2011-01-13 17:47:52.361', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (980, 'Telltale/Messages/gruppenVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in group -> "{0}" (group-ID: {1})', 'O', 'messages', '2011-01-13 17:47:52.37', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (981, 'Telltale/Messages/personVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in profile -> "{0} {1}" (person ID: {2})', 'O', 'messages', '2011-01-13 17:47:52.375', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (982, 'Telltale/Messages/personMelden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report {0}', 'O', 'messages', '2011-01-13 17:47:52.379', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (983, 'Telltale/Messages/netzwerkVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in place -> "{0}" (place ID: {1})', 'O', 'messages', '2011-01-13 17:47:52.383', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (984, 'Network/Constants/headingBoxBackgroundPicture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Graphic for heading boxes', 'O', 'messages', '2011-01-13 17:47:52.093', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (985, 'Telltale/Messages/netzwerkLoeschBeantragung', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Request place deletion for place "{0}"', 'O', 'messages', '2010-10-08 11:37:45.036', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (986, 'Network/Constants/previewQuicklink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Quicklink', 'O', 'messages', '2011-01-13 17:47:52.098', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (987, 'Network/Constants/previewButton', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button', 'O', 'messages', '2011-01-13 17:47:52.103', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (988, 'Network/Constants/horizontalNavigationBackgroundPicture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Graphic for horizontal navigation', 'O', 'messages', '2011-01-13 17:47:52.105', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (989, 'Network/Constants/previewLinkOnBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Link on background', 'O', 'messages', '2011-01-13 17:47:52.111', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (990, 'Network/Constants/previewTextOnBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text on background', 'O', 'messages', '2011-01-13 17:47:52.121', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (991, 'Network/Constants/previewMenuItem', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Menu item', 'O', 'messages', '2011-01-13 17:47:52.125', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (992, 'Network/Constants/previewSubboxText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:47:52.13', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (993, 'Network/Constants/previewNavigationSeparator', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:47:52.132', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (994, 'Network/Constants/foundNewNetworkTwoLines', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create <BR> place', 'O', 'messages', '2011-01-13 17:47:52.137', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (995, 'Network/Constants/navigationSeparatorBackgroundPicture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Graphic for navigation separator', 'O', 'messages', '2011-01-13 17:47:52.152', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (996, 'Network/Constants/previewHeadingBoxLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Link', 'O', 'messages', '2011-01-13 17:47:52.164', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (997, 'Forum/Constants/forum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Discussion forum', 'O', 'messages', '2011-01-13 17:47:52.207', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (998, 'Forum/Constants/memberMayEditComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members may post messages', 'O', 'messages', '2011-01-13 17:47:52.213', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (999, 'Forum/Constants/adminMayEditComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin may post messages', 'O', 'messages', '2011-01-13 17:47:52.216', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1000, 'Forum/Constants/zeitFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'H:mm', 'O', 'messages', '2011-01-13 17:47:52.222', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1001, 'Forum/Constants/datumsFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'MM/dd/yyyy', 'O', 'messages', '2011-01-13 17:47:52.227', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1002, 'Forum/Constants/themaLoeschen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete topic', 'O', 'messages', '2011-01-13 17:47:52.23', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1003, 'Forum/Constants/beitragWirklichLoeschen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete post?', 'O', 'messages', '2011-01-13 17:47:52.235', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1004, 'Groups/Constants/inviteToGroupButton', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Invite', 'O', 'messages', '2010-09-02 16:34:52.979', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1049, 'Telltale/Constants/sonstiges', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Miscellaneous', 'O', 'messages', '2011-01-13 17:47:52.5', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1005, 'Groups/Constants/confirmDeleteMember', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Remove member from group?', 'O', 'messages', '2010-09-02 16:34:52.986', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1006, 'Groups/Constants/newAdminGranted', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'New admin defined.', 'O', 'messages', '2010-09-02 16:34:52.989', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1007, 'Groups/Constants/groupDeleted', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Group deleted.', 'O', 'messages', '2010-09-02 16:34:52.993', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1008, 'Network/Constants/previewHeaderText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:52.16', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1009, 'Telltale/Messages/meldungsKonstante', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0}

user message:
', 'O', 'messages', '2011-01-13 17:47:52.343', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1010, 'Telltale/Messages/reallyIgnoreUser', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Ignore {0}?', 'O', 'messages', '2011-01-13 17:47:52.411', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1011, 'Album/Constants/deleteImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete photo', 'O', 'messages', '2011-01-13 17:47:52.519', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1012, 'Album/Constants/deleteAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete album', 'O', 'messages', '2011-01-13 17:47:52.523', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1013, 'Album/Constants/uploadedAt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Uploaded at', 'O', 'messages', '2011-01-13 17:47:52.539', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1014, 'Album/Constants/createdate', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:47:52.543', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1015, 'Album/Constants/accessAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:52.548', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1016, 'Album/Constants/edit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit photos', 'O', 'messages', '2011-01-13 17:47:52.556', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1017, 'Album/Constants/adminMayEditComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin may upload photos', 'O', 'messages', '2011-01-13 17:47:52.569', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1018, 'Album/Constants/allPhotos', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All photos', 'O', 'messages', '2011-01-13 17:47:52.584', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1019, 'Album/Constants/commentCreateSuccess', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Comment saved.', 'O', 'messages', '2011-01-13 17:47:52.597', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1020, 'Album/Constants/albumsOfFriends', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Albums of contacts', 'O', 'messages', '2011-01-13 17:47:52.686', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1021, 'Album/Constants/noImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No photos', 'O', 'messages', '2011-01-13 17:47:52.692', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1022, 'Album/Constants/alben', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Albums', 'O', 'messages', '2011-01-13 17:47:52.695', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1023, 'Album/Constants/youHaveToWriteAcoment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to enter a comment.', 'O', 'messages', '2011-01-13 17:47:52.709', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1024, 'Album/Constants/chanceTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Change title', 'O', 'messages', '2011-01-13 17:47:52.714', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1025, 'Album/Constants/enterATitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enter photo title', 'O', 'messages', '2011-01-13 17:47:52.718', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1026, 'Album/Constants/announceAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report album', 'O', 'messages', '2011-01-13 17:47:52.723', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1027, 'Album/Constants/announceImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report photo', 'O', 'messages', '2011-01-13 17:47:52.728', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1028, 'Album/Constants/myAlbums', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My albums', 'O', 'messages', '2011-01-13 17:47:52.732', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1029, 'Album/Constants/photos', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photos', 'O', 'messages', '2011-01-13 17:47:52.754', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1030, 'Album/Constants/save', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:52.847', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1031, 'Album/Constants/location', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:47:52.851', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1032, 'Album/Constants/images', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photos', 'O', 'messages', '2011-01-13 17:47:52.855', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1033, 'Album/Constants/description', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:47:52.86', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1034, 'Album/Constants/access', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visible for', 'O', 'messages', '2011-01-13 17:47:52.869', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1035, 'Forum/Constants/hinweisAlleFelderAusfuellen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please fill all fields.', 'O', 'messages', '2011-01-13 17:47:52.271', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1036, 'Forum/Constants/themaWirklichLoeschen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete topic?', 'O', 'messages', '2011-01-13 17:47:52.279', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1037, 'Telltale/Messages/ignoreUser', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Ignore {0}', 'O', 'messages', '2011-01-13 17:47:52.337', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1038, 'Telltale/Messages/ignoreUserOnFriendinvi', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Permanently ignore {0}', 'O', 'messages', '2011-01-13 17:47:52.415', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1039, 'Telltale/Messages/addedXtoIgnoreList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} added to your ignore list.', 'O', 'messages', '2011-01-13 17:47:52.418', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1040, 'Telltale/Constants/requestDeletion', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Request deletion', 'O', 'messages', '2010-10-08 11:37:45.085', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1041, 'Telltale/Constants/reason', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Reason', 'O', 'messages', '2011-01-13 17:47:52.432', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1042, 'Telltale/Constants/personMelden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report user', 'O', 'messages', '2011-01-13 17:47:52.436', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1043, 'Telltale/Constants/pornografischesBild', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Pornographic content', 'O', 'messages', '2011-01-13 17:47:52.455', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1044, 'Telltale/Constants/beitragMelden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report post', 'O', 'messages', '2011-01-13 17:47:52.457', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1045, 'Telltale/Constants/netzwerkMelden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report place', 'O', 'messages', '2011-01-13 17:47:52.473', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1046, 'Telltale/Constants/videoMelden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report video', 'O', 'messages', '2011-01-13 17:47:52.439', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2544, '/Basic/Constants/myMenu', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My menu', 'O', 'messages', '2011-01-13 17:47:54.999', NULL, '2010-08-10 18:57:29.013427');
INSERT INTO base_property VALUES (1047, 'Telltale/Constants/gruppeMelden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report group', 'O', 'messages', '2011-01-13 17:47:52.492', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1048, 'Telltale/Constants/rassismus', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Racist content', 'O', 'messages', '2011-01-13 17:47:52.496', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1050, 'Album/Constants/deleteComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete comment', 'O', 'messages', '2011-01-13 17:47:52.508', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1051, 'Album/Constants/album', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Album', 'O', 'messages', '2011-01-13 17:47:52.514', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1052, 'Telltale/Constants/doppeltVorhanden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Duplicate', 'O', 'messages', '2011-01-13 17:47:52.481', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1053, 'Telltale/Constants/meldeGrund', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Kind of violation', 'O', 'messages', '2011-01-13 17:47:52.484', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1054, 'Album/Constants/lastUploadDate', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Last upload on', 'O', 'messages', '2011-01-13 17:47:52.588', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1055, 'Album/Constants/allAlbums', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All albums', 'O', 'messages', '2011-01-13 17:47:52.737', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1056, 'Album/Constants/albumInsertSuccess', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Album created.', 'O', 'messages', '2011-01-13 17:47:52.741', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1057, 'Album/Constants/toAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Goto album', 'O', 'messages', '2011-01-13 17:47:52.746', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1058, 'Album/Constants/editMyPhotos', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit my photos', 'O', 'messages', '2011-01-13 17:47:52.75', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1059, 'Album/Constants/noImagesUploadedYet', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No photos uploaded yet.', 'O', 'messages', '2011-01-13 17:47:52.759', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1060, 'Album/Constants/pictureSuccessfullyDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo deleted.', 'O', 'messages', '2011-01-13 17:47:52.766', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1061, 'Album/Constants/uploadPhotos', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add photos', 'O', 'messages', '2011-01-13 17:47:52.772', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1062, 'Album/Constants/albumLocation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:47:52.786', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1063, 'Album/Constants/noPhotosSelectedToDelete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No photos selected to delete', 'O', 'messages', '2011-01-13 17:47:52.8', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1064, 'Album/Constants/enterImageTitleHere', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Set title', 'O', 'messages', '2011-01-13 17:47:52.808', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1065, 'Album/Constants/noAlbums', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No albums created yet.', 'O', 'messages', '2011-01-13 17:47:52.649', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1066, 'Album/Messages/uploadedByOn', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Uploaded by {0} on {1}', 'O', 'messages', '2011-01-13 17:47:52.928', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1067, 'Search/Constants/searchIn', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Search', 'O', 'messages', '2011-01-13 17:47:52.945', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1068, 'Search/Constants/showMoreTags', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'More', 'O', 'messages', '2011-01-13 17:47:52.952', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1069, 'Search/Constants/searchAction', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Search', 'O', 'messages', '2011-01-13 17:47:52.964', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1070, 'Search/Constants/searchTags', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:47:53.036', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1071, 'Search/Constants/showLessTags', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Less', 'O', 'messages', '2011-01-13 17:47:53.052', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1072, 'Search/Constants/enterUserName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:47:53.057', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1073, 'Search/Constants/filterTypeLabelProfiles', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Profiles', 'O', 'messages', '2011-01-13 17:47:53.07', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1074, 'Search/Constants/filterTypeLabelGroups', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Groups', 'O', 'messages', '2011-01-13 17:47:53.094', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1075, 'Search/Constants/filterTypeLabelWikis', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki pages', 'O', 'messages', '2011-01-13 17:47:53.194', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1076, 'Search/Constants/filterTypeLabelNetworks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Places', 'O', 'messages', '2011-01-13 17:47:53.211', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1077, 'Search/Constants/list', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:47:53.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1078, 'Telltale/Constants/anderer', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Other', 'O', 'messages', '2011-01-13 17:47:52.465', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1079, 'Telltale/Constants/meldeKommentar', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Comment', 'O', 'messages', '2011-01-13 17:47:52.469', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1080, 'Telltale/Constants/wirdNichtMehrBenoetigt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Is no longer needed', 'O', 'messages', '2011-01-13 17:47:52.477', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1081, 'Album/Constants/albumEditSuccess', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Changes saved.', 'O', 'messages', '2011-01-13 17:47:52.592', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1082, 'Album/Constants/youHaveToSelectImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please select photos first.', 'O', 'messages', '2011-01-13 17:47:52.601', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1083, 'Album/Constants/albumTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Title', 'O', 'messages', '2011-01-13 17:47:52.605', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1084, 'Album/Constants/createAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create album', 'O', 'messages', '2011-01-13 17:47:52.61', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1085, 'Album/Constants/deleteSelectedImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete selected photos', 'O', 'messages', '2011-01-13 17:47:52.641', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1086, 'Album/Constants/editAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit album', 'O', 'messages', '2011-01-13 17:47:52.646', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1087, 'Album/Constants/albumSuccessfullyDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Album deleted.', 'O', 'messages', '2011-01-13 17:47:52.812', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1088, 'Album/Constants/reallyWantToDeletePhoto', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete photo?', 'O', 'messages', '2011-01-13 17:47:52.659', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1089, 'Album/Constants/imageComments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo comments', 'O', 'messages', '2011-01-13 17:47:52.663', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1090, 'Album/Constants/prevImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Previous', 'O', 'messages', '2011-01-13 17:47:52.667', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1091, 'Album/Constants/albumName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Album', 'O', 'messages', '2011-01-13 17:47:52.672', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1092, 'Album/Constants/albumFull', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The album is full.', 'O', 'messages', '2011-01-13 17:47:52.676', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1093, 'Album/Constants/picture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo', 'O', 'messages', '2011-01-13 17:47:52.681', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1094, 'Search/Constants/filterTypeLabelPublications', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Projects', 'O', 'messages', '2011-01-13 17:47:53.23', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1095, 'Search/Constants/filterHeader', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Filter', 'O', 'messages', '2011-01-13 17:47:53.276', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1096, 'Exception/Messages/illegalEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The e-mail {0} can not be used. Only e-mails like {1} are allowed.', 'O', 'messages', '2011-01-13 17:47:53.805', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1097, 'Exception/Messages/spammingForbidden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are only allowed to send {0} messages per minute. Your message was not sent.', 'O', 'messages', '2011-01-13 17:47:53.825', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1098, 'ExternalInvitation/Constants/proposeWeltbeweger', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Propose Weltbeweger', 'O', 'messages', '2011-01-13 17:47:53.831', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1099, 'DateAndTime/Constants/tomorrow', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tomorrow', 'O', 'messages', '2011-01-13 17:47:53.854', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1100, 'DateAndTime/Constants/april', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'April', 'O', 'messages', '2011-01-13 17:47:53.954', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1101, 'DateAndTime/Constants/august', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'August', 'O', 'messages', '2011-01-13 17:47:53.958', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1102, 'DateAndTime/Constants/december', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'December', 'O', 'messages', '2011-01-13 17:47:53.962', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1103, 'DateAndTime/Constants/february', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'February', 'O', 'messages', '2011-01-13 17:47:53.966', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1104, 'Search/Constants/filterTypeLabelDocuments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Documents', 'O', 'messages', '2011-01-13 17:47:53.22', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1105, 'DateAndTime/Constants/july', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'July', 'O', 'messages', '2011-01-13 17:47:53.982', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1106, 'DateAndTime/Constants/june', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'June', 'O', 'messages', '2011-01-13 17:47:53.987', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1107, 'DateAndTime/Constants/march', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'March', 'O', 'messages', '2011-01-13 17:47:53.991', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1108, 'DateAndTime/Constants/may', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'May', 'O', 'messages', '2011-01-13 17:47:53.995', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1109, 'DateAndTime/Constants/november', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'November', 'O', 'messages', '2011-01-13 17:47:54.002', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1110, 'DateAndTime/Constants/october', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'October', 'O', 'messages', '2011-01-13 17:47:54.006', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1111, 'DateAndTime/Constants/september', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'September', 'O', 'messages', '2011-01-13 17:47:54.026', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1112, 'Mail/Constants/resetPasswordMailTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Forgot your password?', 'O', 'messages', '2011-01-13 17:47:54.052', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1113, 'Search/Constants/filterTypeLabelAppointments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Events', 'O', 'messages', '2011-01-13 17:47:53.061', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1114, 'DateAndTime/Constants/january', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'January', 'O', 'messages', '2011-01-13 17:47:53.979', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1115, 'Search/Constants/foundIn', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Found in', 'O', 'messages', '2011-01-13 17:47:52.988', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1116, 'Search/Constants/selectAppointmentListOfNetwork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of events', 'O', 'messages', '2011-01-13 17:47:53.009', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1117, 'Mail/Constants/videoPostCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Somebody made a comment on one of your videos.', 'O', 'messages', '2011-01-13 17:47:54.057', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1118, 'Search/Constants/selectGroupListOfNetwork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of groups', 'O', 'messages', '2011-01-13 17:47:52.993', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1119, 'Search/Constants/entirePlatform', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entire platform', 'O', 'messages', '2011-01-13 17:47:53.016', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1120, 'Footerpages/Constants/hilfe', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.484', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1121, 'Footerpages/Constants/articlesOfAssociation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.512', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1122, 'Footerpages/Constants/uebertoro', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.545', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1123, 'Footerpages/Constants/presse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.577', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1124, 'Footerpages/Constants/datenschutzTextPart4', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h2>3. Keine Weitergabe der Daten an Dritte</h2><p>OpenNetworX gibt Ihre Daten nicht an Dritte weiter, es sei denn, es besteht eine gesetzliche Verpflichtung zur Weitergabe (z.B. bei Anfragen von Strafverfolgungsbehörden und sonstigen staatlichen Einrichtungen mit entsprechenden Befugnissen).</p> <h2>4. Cookies</h2><p>Cookies sind kleine Textdateien, die auf Ihrem Computer gespeichert werden. Sie dienen dazu, den Nutzer beim Login zu identifizieren, die korrekte Menüsprache auszuwählen und den reibungslosen Betrieb zu gewährleisten. Cookies können im Internet-Browser deaktiviert werden. Es wird aber davon abgeraten, weil dies die Funktionalität von OpenNetworX einschränken kann.</p> <h2>5. Datensicherheit</h2><p>Täglich tauchen neue Viren im Internet auf, mit denen versucht wird, Sicherheitsbarrieren zu überwinden. OpenNetworX hält seine Systeme ständig auf dem neuesten Sicherheitsstandard. Sie sollten sich jedoch darüber bewusst sein, dass es keinen hundertprozentigen Schutz geben kann.</p> <h2>6. Protokolldateien</h2><p>Beim Seitenaufruf kann OpenNetworX die IP-Adresse des Rechners, die Bezeichnung der aufgerufenen Seite, die zugehörige Uhrzeit und einige Informationen zum genutzten Internet-Browser speichern. Diese Daten werden nicht verarbeitet und können ohne weiteres auch keinem einzelnen Nutzer zugeordnet werden. OpenNetworX hält diese Informationen fest, um im Bedarfsfall (z.B. bei einem Angriff durch Hacker) den Schuldigen identifizieren zu können. Die Speicherung der Daten kommt somit der Sicherheit aller Nutzer zugute.</p> <h2>7. Deaktivierung des Accounts</h2><p>Nach einer Deaktivierung des Accounts können die Daten des Nutzers nicht mehr abgerufen werden. Es kann aufgrund der im Zwischenspeicher (Cache) vorgehaltenen Daten vorkommen, dass die Nutzerdaten nach Deaktivierung des Accounts noch kurzzeitig verfügbar sind.</p> <h2>Kommentar:</h2> <p>Wenn Du Deinen Account löschst, werden Deine persönlichen Daten unwiderruflich gelöscht und Deine Foreneinträge und persönlichen Nachrichten anonymisiert, so dass sie Dir nicht mehr zuzuordnen sind. Es wird deshalb anonymisiert, um den Ablauf der Diskussionen bzw. der Nachrichtenhistorie nicht zu zerstören.</p><h2>8. Änderungen der Informationen zum Datenschutz</h2><p>Durch die sich ständig ändernden Inhalte und Funktionen von OpenNetworX sowie der entsprechenden Software kann es von Zeit zu Zeit notwendig werden, diese Datenschutzerklärung zu erneuern. Die jeweils aktuelle Version kann auf der Website eingesehen werden.</p> <h2>9. Auskunftsrecht und Kontakt</h2><p>Jeder Nutzer hat das Recht, kostenlos Auskunft von über die zu seiner Person gespeicherten personenbezogenen Daten zu erhalten. Das Auskunftsersuchen ist schriftlich an OpenNetworX zu richten. Dem Auskunftsersuchen ist eine beglaubigte Kopie eines amtlichen und gültigen Personalausweises beizufügen. Die Auskunft wird elektronisch an die angegebene E-Mail-Adresse oder per Post an die im Personalausweis des Nutzers angegebene Anschrift gesendet.</p> <p>OpenNetworX Stiftung<br >Rödingsmarkt 14<br >20459 Hamburg<br >Deutschland</p>', 'O', 'messages', '2011-01-13 17:47:53.61', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1125, 'Footerpages/Constants/agb', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.618', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1126, 'Footerpages/Constants/impressum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.624', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1127, 'Footerpages/Constants/datenschutz', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.633', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1128, 'Exception/Constants/wrongPasswordSupplied', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invalid password. Try again!', 'O', 'messages', '2011-01-13 17:47:53.743', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1129, 'Exception/Constants/tooManyNetworkAdministrations', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You already administer the maximum number of places.', 'O', 'messages', '2011-01-13 17:47:53.747', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1130, 'Exception/Constants/runAsyncOnUnavailable', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Loading code not possible.', 'O', 'messages', '2011-01-13 17:47:53.752', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1131, 'Exception/Constants/invalidEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This e-mail address is invalid.', 'O', 'messages', '2011-01-13 17:47:53.764', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1132, 'Exception/Constants/incompatibleRemoteService', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'IMPORTANT: To make this site work correctly you need to empty your browser cache. Please press "Ctrl" and "F5" on your keyboard simultaneously.', 'O', 'messages', '2011-01-13 17:47:53.772', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1133, 'Videolink/Constants/videolistView', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video listview', 'O', 'messages', '2011-01-13 17:47:54.091', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1134, 'Videolink/Messages/onPersonsVideolist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Posted by {0}', 'O', 'messages', '2011-01-13 17:47:54.307', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1135, 'Document/Constants/statusReleased', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Released', 'O', 'messages', '2011-01-13 17:47:54.361', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1136, 'Document/Constants/statusFinal', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Final', 'O', 'messages', '2011-01-13 17:47:54.36', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1137, 'Document/Constants/uploadFile', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload file', 'O', 'messages', '2011-01-13 17:47:54.365', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1138, 'Document/Constants/noFurtherDocumentVersions', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No additional versions uploaded.', 'O', 'messages', '2011-01-13 17:47:54.367', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1139, 'Document/Constants/fileDocumentAskDelete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete file including all versions and comments?', 'O', 'messages', '2011-01-13 17:47:54.368', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1140, 'Document/Constants/fileDocumentVersionDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Version deleted.', 'O', 'messages', '2011-01-13 17:47:54.394', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1141, 'Document/Constants/separateTagsWithCommas', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separate tags by commas', 'O', 'messages', '2011-01-13 17:47:54.396', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1142, 'Document/Constants/name', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:47:54.428', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1143, 'Document/Constants/fileSize', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Size', 'O', 'messages', '2011-01-13 17:47:54.434', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1144, 'Document/Constants/version', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Version', 'O', 'messages', '2011-01-13 17:47:54.435', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1145, 'Document/Constants/content', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Content', 'O', 'messages', '2011-01-13 17:47:54.437', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1146, 'Document/Constants/status', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:47:54.439', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1147, 'Document/Constants/download', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Download', 'O', 'messages', '2011-01-13 17:47:54.441', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1148, 'Document/Constants/restore', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore', 'O', 'messages', '2011-01-13 17:47:54.443', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1149, 'Document/Messages/theFileSizeMustBeXOrLess', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The file size must be {0} or less.', 'O', 'messages', '2011-01-13 17:47:54.454', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1150, 'Document/Messages/maximumFileSizeIs', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The maximum file size allowed is {0}.', 'O', 'messages', '2011-01-13 17:47:54.463', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1151, 'Document/Messages/xDownloads', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} downloads', 'O', 'messages', '2011-01-13 17:47:54.468', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1152, 'Document/Messages/oneDownload', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '1 Download', 'O', 'messages', '2011-01-13 17:47:54.466', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1153, 'Exception/Constants/invalidHomepageUrl', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The homepage URL is invalid.', 'O', 'messages', '2011-01-13 17:47:53.732', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1154, 'Exception/Constants/alreadyGreatedException', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please wait until this person viewed your smile. Afterwards you can send a smile again.', 'O', 'messages', '2011-01-13 17:47:53.739', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1155, 'Mail/Messages/msgReceived', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wrote you a message!', 'O', 'messages', '2011-01-13 17:47:54.063', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1156, 'Mail/Messages/invitationAsFriend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} sent you a contact request.', 'O', 'messages', '2011-01-13 17:47:54.068', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1157, 'Mail/Messages/wallWritten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wrote on your wall.', 'O', 'messages', '2011-01-13 17:47:54.072', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1158, 'Document/Constants/author', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Author', 'O', 'messages', '2011-01-13 17:47:54.313', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1159, 'Document/Constants/documents', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Documents', 'O', 'messages', '2011-01-13 17:47:54.316', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1160, 'Document/Constants/changedBy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Changed by', 'O', 'messages', '2011-01-13 17:47:54.323', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1161, 'Document/Constants/restoredFrom', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restored from', 'O', 'messages', '2011-01-13 17:47:54.329', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1162, 'Document/Constants/checkedOutBy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Checked out by', 'O', 'messages', '2011-01-13 17:47:54.335', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1163, 'Document/Constants/by', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'By', 'O', 'messages', '2011-01-13 17:47:54.338', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1164, 'Document/Constants/accessDeniedDownloadCanceled', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Access denied! Download canceled.', 'O', 'messages', '2011-01-13 17:47:54.345', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1165, 'Document/Constants/notLoggedInDownloadCanceled', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'User not logged in! Download canceled.', 'O', 'messages', '2011-01-13 17:47:54.346', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1166, 'Wiki/Constants/groupDeleted', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Wiki page deleted.', 'O', 'messages', '2010-09-02 16:34:54.542', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1167, 'Document/Constants/notFoundDownloadCanceled', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Document not found! Download canceled.', 'O', 'messages', '2011-01-13 17:47:54.348', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1168, 'Document/Constants/notLoggedInUploadCanceled', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'User not logged in! Upload canceled.', 'O', 'messages', '2011-01-13 17:47:54.35', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1169, 'Document/Constants/noDocumentsUploaded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No documents uploaded.', 'O', 'messages', '2011-01-13 17:47:54.352', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1170, 'Document/Constants/downloadCount', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Downloads', 'O', 'messages', '2011-01-13 17:47:54.354', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1171, 'Document/Constants/statusEmpty', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Not set', 'O', 'messages', '2011-01-13 17:47:54.356', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1172, 'Document/Constants/statusDraft', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Draft', 'O', 'messages', '2011-01-13 17:47:54.358', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1173, 'WikiEditor/Messages/lastSavedByAt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved by {0} at {1}', 'O', 'messages', '2011-01-13 17:47:54.517', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1174, 'WikiEditor/Messages/lastSavedByBefore', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved by {0} {1}', 'O', 'messages', '2011-01-13 17:47:54.52', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1175, 'WikiEditor/Messages/lastBackup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved {0}', 'O', 'messages', '2011-01-13 17:47:54.523', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1176, 'WikiEditor/Constants/wikiIgnoreLock', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Ignore', 'O', 'messages', '2011-01-13 17:47:54.597', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1177, 'Wiki/Constants/joinRequests', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Requests', 'O', 'messages', '2010-09-02 16:34:54.528', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1178, 'Wiki/Constants/groupAdmin', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Wiki page admin', 'O', 'messages', '2010-09-02 16:34:54.53', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1179, 'Wiki/Constants/inviteToGroupButton', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Invite', 'O', 'messages', '2010-09-02 16:34:54.533', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1180, 'Wiki/Constants/inviteMemberToGroup', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Invite your contacts to this wiki page', 'O', 'messages', '2010-09-02 16:34:54.535', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1181, 'Wiki/Constants/newAdminGranted', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'New admin defined.', 'O', 'messages', '2010-09-02 16:34:54.54', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1182, 'WikiEditor/Constants/legendChanged', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Changed', 'O', 'messages', '2011-01-13 17:47:54.611', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1183, 'WikiEditor/Constants/legendRemoved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Removed', 'O', 'messages', '2011-01-13 17:47:54.613', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1184, 'WikiEditor/Constants/deleteVersion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:54.614', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1185, 'WikiEditor/Constants/compare', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Compare', 'O', 'messages', '2011-01-13 17:47:54.637', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1186, 'WikiEditor/Constants/pleaseSelectTwoVersions', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please choose 2 versions for comparison.', 'O', 'messages', '2011-01-13 17:47:54.616', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1187, 'WikiEditor/Constants/close', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Close', 'O', 'messages', '2011-01-13 17:47:54.638', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1188, 'WikiEditor/Constants/save', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:54.64', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1189, 'NewsBlog/Constants/newsBlog', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Newsblog', 'O', 'messages', '2011-01-13 17:47:54.742', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1190, 'NewsBlog/Constants/adminMayEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin may post news', 'O', 'messages', '2011-01-13 17:47:54.751', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1191, 'NewsBlog/Constants/newNewsBlogArticleBreadcrumb', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'New news blog article', 'O', 'messages', '2011-01-13 17:47:54.763', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1192, 'Entity/Constants/phone/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Phone', 'O', 'messages', '2011-01-13 17:47:55.448', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1193, 'Document/Constants/deleteAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete all', 'O', 'messages', '2011-01-13 17:47:54.4', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1194, 'Document/Constants/addDocumentUpperCase', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add a document.', 'O', 'messages', '2011-01-13 17:47:54.401', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1195, 'Document/Constants/versionAskDelete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete version?', 'O', 'messages', '2011-01-13 17:47:54.403', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1196, 'Document/Constants/uploadSuccess', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'File uploaded.', 'O', 'messages', '2011-01-13 17:47:54.407', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1197, 'Document/Constants/versionHistory', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Version history', 'O', 'messages', '2011-01-13 17:47:54.409', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1198, 'Wiki/Constants/headline', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Headline', 'O', 'messages', '2011-01-13 17:47:54.478', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1199, 'Wiki/Constants/createYourOwnWay', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a way yourself', 'O', 'messages', '2011-01-13 17:47:54.508', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1200, 'Wiki/Constants/content', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Content', 'O', 'messages', '2011-01-13 17:47:54.511', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1201, 'WikiEditor/Messages/wikiIsLocked', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The user {0} is currently editing this wiki page', 'O', 'messages', '2011-01-13 17:47:54.53', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1202, 'WikiEditor/Messages/reallyDelete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete version {0}?', 'O', 'messages', '2011-01-13 17:47:54.536', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1203, 'WikiEditor/Messages/version', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Version {0}', 'O', 'messages', '2011-01-13 17:47:54.554', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1204, 'WikiEditor/Constants/restoreVersion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore', 'O', 'messages', '2011-01-13 17:47:54.566', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1205, 'WikiEditor/Constants/restoredFrom', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restored from', 'O', 'messages', '2011-01-13 17:47:54.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1206, 'WikiEditor/Constants/wikiEditor', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki editor', 'O', 'messages', '2011-01-13 17:47:54.558', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1207, 'WikiEditor/Constants/back', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Back', 'O', 'messages', '2011-01-13 17:47:54.569', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1208, 'WikiEditor/Constants/edit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:47:54.572', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1209, 'WikiEditor/Constants/versionHistory', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Version history', 'O', 'messages', '2011-01-13 17:47:54.575', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1210, 'WikiEditor/Constants/looseChanges', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Discard changes', 'O', 'messages', '2011-01-13 17:47:54.578', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1211, 'WikiEditor/Constants/looseChangesOnClose', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not save your changes yet.', 'O', 'messages', '2011-01-13 17:47:54.582', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1212, 'WikiEditor/Constants/saveAndClose', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save and close', 'O', 'messages', '2011-01-13 17:47:54.591', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1213, 'WikiEditor/Constants/lastBackupLessThanAMinute', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved less than 1 minute ago', 'O', 'messages', '2011-01-13 17:47:54.594', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1214, 'NewsBlog/Constants/articleDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Article deleted!', 'O', 'messages', '2011-01-13 17:47:54.796', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1215, 'Entity/Constants/entities/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Place', 'O', 'messages', '2011-01-13 17:47:55.196', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1216, 'Entity/Constants/thisEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This place', 'O', 'messages', '2011-01-13 17:47:55.256', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1217, 'Entity/Constants/thisEntityAndSubItems/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This place and subplaces', 'O', 'messages', '2011-01-13 17:47:55.251', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1218, 'Entity/Constants/externalURL/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External place URL', 'O', 'messages', '2011-01-13 17:47:55.225', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1219, 'Entity/Constants/timezone/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:47:55.402', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1220, 'Entity/Constants/navigationLinks/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation: Links', 'O', 'messages', '2011-01-13 17:47:55.754', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1221, 'Entity/Constants/address/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:47:56.225', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1222, 'Entity/Constants/header/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:56.233', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1223, 'Entity/Constants/invited/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invited', 'O', 'messages', '2011-01-13 17:47:55.445', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1224, 'Entity/Constants/declineInvite/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:55.476', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1225, 'NewsBlog/Messages/dateAndAuthor', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} {1} | {2}', 'O', 'messages', '2011-01-13 17:47:54.721', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1226, 'Entity/Constants/member/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member', 'O', 'messages', '2011-01-13 17:47:56.237', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1227, 'Entity/Constants/requests/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Requests', 'O', 'messages', '2011-01-13 17:47:56.257', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1228, 'Entity/Constants/country/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Country', 'O', 'messages', '2011-01-13 17:47:56.24', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1229, 'Entity/Constants/cancel/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:47:56.265', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1230, 'WikiEditor/Constants/deleteBackup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Discard changes', 'O', 'messages', '2011-01-13 17:47:54.603', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1231, 'NewsBlog/Constants/pleaseFillText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please fill text', 'O', 'messages', '2011-01-13 17:47:54.778', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1232, 'WikiEditor/Constants/toCompareSelectVersions', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select 2 versions to compare', 'O', 'messages', '2011-01-13 17:47:54.606', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1233, 'Entity/Constants/widgetsShowSubEntities/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Elements in teasers', 'O', 'messages', '2011-01-13 17:47:55.223', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1234, 'WikiEditor/Constants/memberMayEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members may edit', 'O', 'messages', '2011-01-13 17:47:54.588', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1235, 'WikiEditor/Constants/legendAdded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Added', 'O', 'messages', '2011-01-13 17:47:54.609', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1236, 'Entity/Constants/onlyEntitiesWhereYouAreAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You must be admin of this place', 'O', 'messages', '2011-01-13 17:47:55.236', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1237, 'Entity/Constants/description/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:47:56.261', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1238, 'Entity/Constants/assignEntityToElements/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assign this place to another place', 'O', 'messages', '2011-01-13 17:47:55.232', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1239, 'NewsBlog/Constants/addArticle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add article', 'O', 'messages', '2011-01-13 17:47:54.748', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1240, 'NewsBlog/Constants/source', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Source', 'O', 'messages', '2011-01-13 17:47:54.823', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1241, 'Entity/Constants/allEntityMembers/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All place members', 'O', 'messages', '2011-01-13 17:47:55.212', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1242, 'Entity/Constants/childEntities/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Places', 'O', 'messages', '2011-01-13 17:47:55.218', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1243, 'WikiEditor/Constants/selectLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select link', 'O', 'messages', '2011-01-13 17:47:54.619', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1244, 'Entity/Constants/enterNameOfEntityHere/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of place', 'O', 'messages', '2011-01-13 17:47:55.23', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1245, 'Entity/Constants/duration/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Time', 'O', 'messages', '2011-01-13 17:47:55.4', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1246, 'Entity/Constants/myEntities/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My places', 'O', 'messages', '2011-01-13 17:47:55.227', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1247, 'Entity/Constants/entity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Place', 'O', 'messages', '2011-01-13 17:47:55.203', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1248, 'Entity/Constants/admin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:47:55.453', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1249, 'Entity/Constants/city/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City/town', 'O', 'messages', '2011-01-13 17:47:55.492', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1250, 'Entity/Constants/email/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:47:55.438', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1251, 'Entity/Constants/addElement/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add element', 'O', 'messages', '2011-01-13 17:47:56.221', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1252, 'NewsBlog/Constants/selectArticleImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select image', 'O', 'messages', '2011-01-13 17:47:54.79', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1253, 'Entity/Constants/makeCoAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make co-admin', 'O', 'messages', '2011-01-13 17:47:55.461', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1254, 'Entity/Constants/office/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Office', 'O', 'messages', '2011-01-13 17:47:55.525', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1255, 'Entity/Constants/headingBox/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading boxes', 'O', 'messages', '2011-01-13 17:47:55.489', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1256, 'Entity/Constants/coAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admin', 'O', 'messages', '2011-01-13 17:47:55.509', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1257, 'Entity/Constants/tagsSeparatorHint/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma', 'O', 'messages', '2011-01-13 17:47:55.574', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1258, 'Entity/Constants/showAddressData/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show', 'O', 'messages', '2011-01-13 17:47:55.58', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1259, 'Entity/Constants/googleMapAPIKeyHelpLink/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Help', 'O', 'messages', '2011-01-13 17:47:55.586', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1260, 'Entity/Constants/parentNetworks/Network', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent places', 'O', 'messages', '2010-12-14 13:22:04.011', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1261, 'Entity/Constants/googleMapAPIKey/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Google Maps-API key', 'O', 'messages', '2011-01-13 17:47:55.583', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1262, 'Entity/Constants/parentGroups/Network', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent groups', 'O', 'messages', '2010-12-14 13:22:04.044', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1263, 'Entity/Constants/subdomainInUse/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The subdomain is already in use', 'O', 'messages', '2011-01-13 17:47:55.593', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1264, 'Entity/Constants/subdomainHelpLink/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'How does this work?', 'O', 'messages', '2011-01-13 17:47:55.599', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1265, 'Entity/Constants/privacyRules/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:55.605', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1266, 'Entity/Constants/waitlist/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Waiting list', 'O', 'messages', '2011-01-13 17:47:55.657', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1267, 'Entity/Constants/configEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:47:55.65', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1268, 'Entity/Constants/optionsComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:47:55.667', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1269, 'Entity/Constants/logoComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo', 'O', 'messages', '2011-01-13 17:47:55.672', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1270, 'Entity/Constants/adminListComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:55.679', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1271, 'Entity/Constants/inviteToEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:55.653', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1272, 'Entity/Constants/makeAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make admin', 'O', 'messages', '2011-01-13 17:47:55.459', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1273, 'Profile/Constants/noMembership', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No membership', 'O', 'messages', '2011-01-13 17:47:45.816', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1274, 'Entity/Constants/coAdmins/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admins', 'O', 'messages', '2011-01-13 17:47:55.479', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1275, 'Entity/Constants/contactName/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:47:55.532', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1276, 'Entity/Constants/widgetsShowSubEntitiesOption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show elements of affiliate places', 'O', 'messages', '2011-01-13 17:47:55.241', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1277, 'Entity/Constants/tags/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:47:55.416', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1278, 'Entity/Constants/closingDate/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline', 'O', 'messages', '2011-01-13 17:47:55.423', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1279, 'Entity/Constants/saveEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:55.567', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1280, 'Entity/Constants/visibilityRule/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visibility of content', 'O', 'messages', '2011-01-13 17:47:55.61', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1281, 'Entity/Constants/rejection/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation rejected', 'O', 'messages', '2011-01-13 17:47:55.66', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1282, 'Entity/Constants/joinEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:47:55.463', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1283, 'Entity/Constants/location/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:47:56.254', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1284, 'Entity/Constants/rulesComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:55.682', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1285, 'Entity/Constants/participantLimitedTo/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Limit participants to', 'O', 'messages', '2011-01-13 17:47:55.557', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1286, 'Entity/Constants/website/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:47:55.502', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1287, 'Entity/Constants/joiningRule/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:47:55.522', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1288, 'Entity/Constants/mandatory/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:47:55.57', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1289, 'Entity/Constants/hideAddressData/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:47:55.577', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1290, 'Entity/Constants/editEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic informations', 'O', 'messages', '2011-01-13 17:47:55.551', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1291, 'Entity/Constants/fax/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:47:55.529', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1292, 'Entity/Constants/declineJoinRequest/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:55.478', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1293, 'Entity/Constants/participantUnlimited/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unlimited number of participants', 'O', 'messages', '2011-01-13 17:47:55.554', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1294, 'Entity/Constants/joiningOnlyForMembersOfPlatform/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:55.624', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1295, 'Entity/Constants/joiningOnlyForMembersOfLinkedEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:55.626', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1296, 'Entity/Constants/deleteElement/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:55.861', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1297, 'Entity/Constants/currentIcon/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current icon', 'O', 'messages', '2011-01-13 17:47:55.722', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1298, 'Entity/Constants/toPerticipantList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in participant list', 'O', 'messages', '2011-01-13 17:47:55.699', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1299, 'Entity/Constants/uploadIcon/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload icon', 'O', 'messages', '2011-01-13 17:47:55.725', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1300, 'Entity/Constants/preview/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:47:55.735', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1301, 'Entity/Constants/outerBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background outside', 'O', 'messages', '2011-01-13 17:47:55.79', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1302, 'Entity/Constants/innerBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background inside', 'O', 'messages', '2011-01-13 17:47:55.792', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1303, 'Entity/Constants/borderLeft/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (left)', 'O', 'messages', '2011-01-13 17:47:55.819', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1304, 'Entity/Constants/linkedEntityPrivacyStatusAnybody/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anybody', 'O', 'messages', '2011-01-13 17:47:55.839', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1305, 'Entity/Constants/linkedEntityPrivacyAssignmentHeader/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who is allowed to assign other elements to this place?', 'O', 'messages', '2011-01-13 17:47:55.852', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1306, 'Entity/Constants/uploadLogo/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload logo', 'O', 'messages', '2011-01-13 17:47:55.719', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1307, 'Entity/Constants/duplicateEntitySelectionErrorOccur/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:47:55.868', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1308, 'Entity/Constants/parentEntityRequiredError/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please assign this place to at least one element', 'O', 'messages', '2011-01-13 17:47:55.873', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1309, 'Entity/Constants/selectASuggestedEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection not found. Please select a suggested entity.', 'O', 'messages', '2011-01-13 17:47:55.876', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1310, 'Entity/Constants/borderTop/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (top)', 'O', 'messages', '2011-01-13 17:47:55.811', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1311, 'Entity/Constants/infoWidgetComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:47:55.42', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1312, 'Entity/Constants/admins/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:55.457', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1313, 'Entity/Constants/leaveEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave', 'O', 'messages', '2011-01-13 17:47:55.465', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1314, 'Entity/Constants/deleteLogo/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete logo', 'O', 'messages', '2011-01-13 17:47:55.468', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1315, 'Entity/Constants/acceptInvite/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:55.472', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1316, 'Entity/Constants/acceptJoinRequest/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:55.474', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1317, 'Entity/Constants/joiningForAll/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Users with and without platform account', 'O', 'messages', '2011-01-13 17:47:55.62', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1318, 'Entity/Constants/joiningByRequestOrInviteOnly/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only by request or invitation', 'O', 'messages', '2011-01-13 17:47:55.628', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1319, 'Entity/Constants/invitingByAllMebers/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members', 'O', 'messages', '2011-01-13 17:47:55.63', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1320, 'Entity/Constants/saveEntitySuccessfully/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:47:55.641', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1321, 'Entity/Constants/createEntitySuccessfully/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:47:55.643', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1322, 'Entity/Constants/removeJoinEntityRequest/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove join request', 'O', 'messages', '2011-01-13 17:47:55.647', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1323, 'Entity/Constants/componentsRightColumn/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in right column', 'O', 'messages', '2011-01-13 17:47:55.689', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1324, 'Entity/Constants/deleteFromMemberList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:55.692', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1325, 'Entity/Constants/toWaitlist/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in waiting list', 'O', 'messages', '2011-01-13 17:47:55.695', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1326, 'Entity/Constants/noNotfiedParticipantSelected/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No persons for notification selected.', 'O', 'messages', '2011-01-13 17:47:55.702', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1327, 'Entity/Constants/notifcationMailsWasSentToSelectedParticipant/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Notifications sent.', 'O', 'messages', '2011-01-13 17:47:55.705', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1328, 'Entity/Constants/entityPrivacyHeader/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:55.857', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1329, 'Entity/Constants/notNotifiedParticipant/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unnotified people', 'O', 'messages', '2011-01-13 17:47:55.708', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1330, 'Entity/Constants/sendNotificationToSelectedParticipantNow/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send notifications now', 'O', 'messages', '2011-01-13 17:47:55.711', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1331, 'Entity/Constants/currentLogo/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current logo', 'O', 'messages', '2011-01-13 17:47:55.714', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1332, 'Entity/Constants/borderRight/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (right)', 'O', 'messages', '2011-01-13 17:47:55.823', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1333, 'Entity/Constants/entityWasSelectedError/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:47:55.865', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1334, 'Entity/Constants/horizontalNavigationEdit/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:47:56.028', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1335, 'Entity/Messages/inviteToEntityX/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite to place {0}', 'O', 'messages', '2011-01-13 17:47:56.284', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1336, 'Entity/Messages/entityInvitationsCount/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Place invitations ({0})', 'O', 'messages', '2011-01-13 17:47:56.287', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1337, 'Entity/Messages/entityJoinRequestCount/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Place join requests ({0})', 'O', 'messages', '2011-01-13 17:47:56.293', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1338, 'Entity/Messages/subjectTextExternalInvite/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invites you to place "{1}"!', 'O', 'messages', '2011-01-13 17:47:56.325', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1339, 'Entity/Messages/userXWillBeRemoveAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified. The admin status will remain unchanged.', 'O', 'messages', '2011-01-13 17:47:56.347', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1340, 'Entity/Messages/userXWillBeRemove/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified.', 'O', 'messages', '2011-01-13 17:47:56.351', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1341, 'Entity/Messages/doRealyWantToDeleteCoAdminX/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove {0} from co-admins?', 'O', 'messages', '2011-01-13 17:47:56.36', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1342, 'Entity/Messages/mailSubjectWaitList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on waiting list', 'O', 'messages', '2011-01-13 17:47:56.363', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1343, 'Entity/Messages/mailSubjectRequesterList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have requested for participation', 'O', 'messages', '2011-01-13 17:47:56.38', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1344, 'Entity/Messages/maximumXRecipientsAllowed/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only {0} recipients allowed at a time.', 'O', 'messages', '2011-01-13 17:47:56.401', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1345, 'Entity/Messages/xExternalInviationWasSent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people without platform account.', 'O', 'messages', '2011-01-13 17:47:56.405', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1346, 'Entity/Constants/headerText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Text', 'O', 'messages', '2011-01-13 17:47:55.77', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1347, 'Entity/Messages/defineNotMoreThanEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do not define more than {0} place(s).', 'O', 'messages', '2011-01-13 17:47:56.396', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1348, 'Entity/Constants/leaveEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave', 'O', 'messages', '2011-01-13 17:47:56.891', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1349, 'Entity/Constants/adjustColors/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Customize colors', 'O', 'messages', '2011-01-13 17:47:55.731', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1350, 'Entity/Constants/headerBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:55.768', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1351, 'Entity/Constants/toggleColorAdjustments/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Advanced settings (optional)', 'O', 'messages', '2011-01-13 17:47:55.738', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1352, 'Entity/Constants/headerLinks/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Links', 'O', 'messages', '2011-01-13 17:47:55.772', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1353, 'Entity/Constants/subBoxBorder/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Border', 'O', 'messages', '2011-01-13 17:47:55.785', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1354, 'Entity/Constants/subBoxLine/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Separator line', 'O', 'messages', '2011-01-13 17:47:55.788', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1355, 'Entity/Constants/sendInvites/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send invitation', 'O', 'messages', '2011-01-13 17:47:55.888', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1356, 'Entity/Constants/invitationPopupSelection/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection', 'O', 'messages', '2011-01-13 17:47:55.892', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1357, 'Entity/Constants/invitationPopupList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:47:55.91', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1358, 'Entity/Constants/invitationPopupShowInviteMessage/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:55.915', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1359, 'Entity/Constants/invitationPopupHideInviteMessage/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove (delete)', 'O', 'messages', '2011-01-13 17:47:55.918', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1360, 'Entity/Constants/inviteMyContactsButtonText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite my contacts', 'O', 'messages', '2011-01-13 17:47:55.942', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1361, 'Entity/Constants/errorAcceptingInvitation/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting invitation.', 'O', 'messages', '2011-01-13 17:47:55.969', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1362, 'Entity/Constants/errorDecliningInvitation/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining invitation.', 'O', 'messages', '2011-01-13 17:47:55.973', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1363, 'Entity/Constants/entityInvitations/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Place invitations', 'O', 'messages', '2011-01-13 17:47:55.984', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1364, 'Entity/Constants/entityJoinRequest/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Place join request', 'O', 'messages', '2011-01-13 17:47:55.99', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1365, 'Entity/Constants/horizontalNavigationRestoreDefault/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore default', 'O', 'messages', '2011-01-13 17:47:56.009', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1366, 'Entity/Constants/horizontalNavigationCancel/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:47:56.012', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1367, 'Entity/Constants/horizontalNavigationSave/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:56.016', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1368, 'Entity/Constants/horizontalNavigationSuccessfullySaved/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation saved.', 'O', 'messages', '2011-01-13 17:47:56.024', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1369, 'Entity/Constants/subdomain/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subdomain', 'O', 'messages', '2011-01-13 17:47:56.84', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1370, 'Entity/Constants/followedEmailsAreInvalid/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Following e-mails are invalid', 'O', 'messages', '2011-01-13 17:47:55.957', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1371, 'Entity/Constants/deleteCoAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:56.871', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1372, 'Entity/Constants/entityJoinRequest/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Event join request', 'O', 'messages', '2011-01-13 17:47:56.567', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1373, 'Entity/Constants/address/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:47:57.782', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1374, 'Entity/Constants/deleteLogo/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete logo', 'O', 'messages', '2011-01-13 17:47:56.898', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1375, 'Entity/Constants/invitePerson/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite person', 'O', 'messages', '2011-01-13 17:47:56.863', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1376, 'Entity/Constants/onlyEntitiesWhereYouAreAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You must be admin of this event', 'O', 'messages', '2011-01-13 17:47:56.554', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1377, 'Entity/Constants/parents/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Parents', 'O', 'messages', '2011-01-13 17:47:56.733', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1378, 'Entity/Constants/entity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Event', 'O', 'messages', '2011-01-13 17:47:56.513', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1379, 'Entity/Constants/city/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City/town', 'O', 'messages', '2011-01-13 17:47:56.947', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1380, 'Entity/Messages/xInvitationSkiped/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people were skipped.', 'O', 'messages', '2011-01-13 17:47:56.42', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1381, 'Entity/Constants/joinEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participate', 'O', 'messages', '2011-01-13 17:47:56.887', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1382, 'Entity/Constants/enterNameOfEntityHere/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of event', 'O', 'messages', '2011-01-13 17:47:56.55', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1383, 'Entity/Constants/widgetsDontShowSubEntitiesOption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:47:56.58', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1384, 'Entity/Constants/createEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create event', 'O', 'messages', '2011-01-13 17:47:56.51', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1385, 'Entity/Constants/state/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'State', 'O', 'messages', '2011-01-13 17:47:57.79', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1386, 'Entity/Constants/inviteAllMyContacts/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite all my contacts', 'O', 'messages', '2011-01-13 17:47:55.938', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1387, 'Entity/Constants/thisEntityAndSubItems/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This event and subitems', 'O', 'messages', '2011-01-13 17:47:56.591', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1388, 'Entity/Constants/thisEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This event', 'O', 'messages', '2011-01-13 17:47:56.676', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1389, 'Entity/Constants/timezone/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:47:56.789', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1390, 'Entity/Constants/invited/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invited', 'O', 'messages', '2011-01-13 17:47:56.856', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1391, 'Entity/Constants/phone/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Phone', 'O', 'messages', '2011-01-13 17:47:56.86', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1392, 'Entity/Constants/entityInvitations/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Event invitations', 'O', 'messages', '2011-01-13 17:47:56.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1393, 'Entity/Constants/deleteIcon/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete icon', 'O', 'messages', '2011-01-13 17:47:56.894', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1394, 'Entity/Constants/declineJoinRequest/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:56.916', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1395, 'Entity/Constants/email/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:47:56.848', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1396, 'Entity/Constants/admins/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:56.875', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1397, 'Entity/Constants/admin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:47:56.868', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1398, 'Entity/Constants/addElement/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add element', 'O', 'messages', '2011-01-13 17:47:57.779', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1399, 'Entity/Messages/xInternalInviationWasSent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people with platform account.', 'O', 'messages', '2011-01-13 17:47:56.416', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1400, 'Entity/Constants/header/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:57.8', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1401, 'Entity/Constants/member/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member', 'O', 'messages', '2011-01-13 17:47:57.803', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1402, 'Entity/Constants/country/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Country', 'O', 'messages', '2011-01-13 17:47:57.811', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1403, 'Entity/Constants/location/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:47:57.814', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1404, 'Entity/Constants/parentWikis/Appointment', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent wiki pages', 'O', 'messages', '2010-12-14 13:22:23.508', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1405, 'Entity/Constants/externalURL/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External URL', 'O', 'messages', '2011-01-13 17:47:57.108', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1406, 'Entity/Constants/office/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Office', 'O', 'messages', '2011-01-13 17:47:57.019', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1407, 'Entity/Constants/showAddressData/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show', 'O', 'messages', '2011-01-13 17:47:57.082', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1408, 'Entity/Constants/optionsComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:47:57.211', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1409, 'Entity/Constants/googleMapAPIKeyHelpLink/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Help', 'O', 'messages', '2011-01-13 17:47:57.09', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1410, 'Entity/Constants/saveEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:57.068', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1411, 'Entity/Constants/parentGroups/Appointment', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent groups', 'O', 'messages', '2010-12-14 13:22:23.38', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1412, 'Entity/Constants/privacyRules/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:57.12', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1413, 'Entity/Constants/mandatory/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:47:57.071', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1414, 'Entity/Constants/zipcode/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:47:56.955', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1415, 'Entity/Constants/visibleForMember/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members', 'O', 'messages', '2011-01-13 17:47:57.14', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1416, 'Entity/Constants/tagsSeparatorHint/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma', 'O', 'messages', '2011-01-13 17:47:57.075', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1417, 'Entity/Constants/joiningForAll/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Users with and without platform account', 'O', 'messages', '2011-01-13 17:47:57.144', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1418, 'Entity/Constants/logoComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo', 'O', 'messages', '2011-01-13 17:47:57.218', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1419, 'Entity/Constants/rejection/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Not participating', 'O', 'messages', '2011-01-13 17:47:57.204', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1420, 'Entity/Constants/coAdmins/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admins', 'O', 'messages', '2011-01-13 17:47:56.921', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1421, 'Entity/Constants/visibleForAll/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For the whole internet', 'O', 'messages', '2011-01-13 17:47:57.133', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1422, 'Entity/Constants/navigationLinks/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation: Links', 'O', 'messages', '2011-01-13 17:47:57.322', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1423, 'Entity/Constants/waitlist/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Waiting list', 'O', 'messages', '2011-01-13 17:47:57.2', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1424, 'Entity/Constants/randomMembersComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:57.222', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1425, 'Entity/Constants/entityName/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Event name', 'O', 'messages', '2011-01-13 17:47:56.517', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1426, 'Entity/Constants/myEntities/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My events', 'O', 'messages', '2011-01-13 17:47:56.546', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1427, 'Entity/Constants/joiningRule/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:47:57.015', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1428, 'Entity/Constants/visibleForMemberOfAssociatedEntities/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:57.136', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1429, 'Entity/Constants/tags/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:47:56.817', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1430, 'Entity/Constants/deleteEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:56.837', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1431, 'Entity/Constants/googleMapAPIKey/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Google Maps-API key', 'O', 'messages', '2011-01-13 17:47:57.086', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1432, 'Entity/Constants/childEntities/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Events', 'O', 'messages', '2011-01-13 17:47:56.538', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1433, 'Entity/Constants/declineInvite/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:56.912', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1434, 'Entity/Constants/subdomainHelpLink/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'How does this work?', 'O', 'messages', '2011-01-13 17:47:57.104', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1435, 'Entity/Constants/widgetsShowSubEntities/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Elements in teasers', 'O', 'messages', '2011-01-13 17:47:56.542', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1436, 'Entity/Constants/participants/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:47:56.95', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1437, 'Entity/Constants/participantLimitedTo/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Limit participants to', 'O', 'messages', '2011-01-13 17:47:57.058', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1438, 'Entity/Constants/hideAddressData/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:47:57.079', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1439, 'Entity/Constants/fax/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:47:57.023', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1440, 'Entity/Constants/contactName/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:47:57.026', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1441, 'Entity/Constants/headingBox/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading boxes', 'O', 'messages', '2011-01-13 17:47:56.94', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1442, 'Entity/Constants/acceptInvite/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:56.905', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1443, 'Entity/Constants/visibilityRule/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visibility of content', 'O', 'messages', '2011-01-13 17:47:57.125', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1444, 'Entity/Constants/componentsLeftColumn/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in left column', 'O', 'messages', '2011-01-13 17:47:57.232', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1445, 'Entity/Constants/parentNetworks/Appointment', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent places', 'O', 'messages', '2010-12-14 13:22:23.37', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1446, 'Entity/Constants/boxBorders/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Borders heading box', 'O', 'messages', '2011-01-13 17:47:57.294', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1447, 'Entity/Constants/adjustColors/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Customize colors', 'O', 'messages', '2011-01-13 17:47:57.283', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1448, 'Entity/Constants/sendNotificationToSelectedParticipantNow/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send notifications now', 'O', 'messages', '2011-01-13 17:47:57.262', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1449, 'Entity/Constants/borderTop/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (top)', 'O', 'messages', '2011-01-13 17:47:57.404', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1450, 'Entity/Constants/acceptChanges/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept changes', 'O', 'messages', '2011-01-13 17:47:57.297', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1451, 'Entity/Constants/headerLinks/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Links', 'O', 'messages', '2011-01-13 17:47:57.347', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1452, 'Entity/Constants/subBoxLine/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Separator line', 'O', 'messages', '2011-01-13 17:47:57.376', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1453, 'Entity/Constants/buttonBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button', 'O', 'messages', '2011-01-13 17:47:57.397', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1454, 'Entity/Constants/buttonText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button: Text', 'O', 'messages', '2011-01-13 17:47:57.401', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1455, 'Entity/Constants/textOnBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Text', 'O', 'messages', '2011-01-13 17:47:57.386', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1456, 'Entity/Constants/lineOnBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Separator line', 'O', 'messages', '2011-01-13 17:47:57.394', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1457, 'Entity/Constants/innerBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background inside', 'O', 'messages', '2011-01-13 17:47:57.383', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1458, 'Entity/Constants/successfullySavedEntityDesign/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design saved.', 'O', 'messages', '2011-01-13 17:47:57.303', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1459, 'Entity/Constants/borderLeft/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (left)', 'O', 'messages', '2011-01-13 17:47:57.412', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1460, 'Entity/Constants/borderRight/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (right)', 'O', 'messages', '2011-01-13 17:47:57.415', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1461, 'Entity/Constants/entityNotVisibleTitle/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity privacy settings', 'O', 'messages', '2011-01-13 17:47:57.427', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1462, 'Entity/Constants/members', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:49:55.673', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1463, 'Entity/Constants/infoWidgetComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:47:56.825', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1464, 'Entity/Constants/joiningOnlyForMembersOfLinkedEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:57.161', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1465, 'Entity/Constants/joiningByRequestOrInviteOnly/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only by request or invitation', 'O', 'messages', '2011-01-13 17:47:57.164', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1466, 'Entity/Constants/invitingByAllMebers/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members', 'O', 'messages', '2011-01-13 17:47:57.167', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1467, 'Entity/Constants/configEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:47:57.194', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1468, 'Entity/Constants/inviteToEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:57.197', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1469, 'Entity/Constants/adminListComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:57.225', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1470, 'Entity/Constants/rulesComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:57.229', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1471, 'Entity/Constants/deleteFromMemberList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:57.24', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1472, 'Entity/Constants/toWaitlist/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in waiting list', 'O', 'messages', '2011-01-13 17:47:57.243', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1473, 'Entity/Constants/noNotfiedParticipantSelected/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No persons for notification selected.', 'O', 'messages', '2011-01-13 17:47:57.251', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1474, 'Entity/Constants/notifcationMailsWasSentToSelectedParticipant/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Notifications sent.', 'O', 'messages', '2011-01-13 17:47:57.254', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1475, 'Entity/Constants/currentLogo/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current logo', 'O', 'messages', '2011-01-13 17:47:57.265', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1476, 'Entity/Constants/notNotifiedParticipant/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unnotified people', 'O', 'messages', '2011-01-13 17:47:57.258', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1477, 'Entity/Constants/uploadLogo/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload logo', 'O', 'messages', '2011-01-13 17:47:57.269', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1478, 'Entity/Constants/currentIcon/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current icon', 'O', 'messages', '2011-01-13 17:47:57.272', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1479, 'Entity/Constants/uploadIcon/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload icon', 'O', 'messages', '2011-01-13 17:47:57.276', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1480, 'Entity/Constants/navigation/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation', 'O', 'messages', '2011-01-13 17:47:57.318', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1481, 'Entity/Constants/headerBorder/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Border', 'O', 'messages', '2011-01-13 17:47:57.35', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1482, 'Entity/Constants/preview/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:47:57.286', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1483, 'Entity/Constants/deleteElement/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:57.455', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1484, 'Entity/Constants/entityPrivacyHeader/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:57.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1485, 'Entity/Constants/errorAcceptingInvitation/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting invitation.', 'O', 'messages', '2011-01-13 17:47:57.555', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1486, 'Entity/Constants/errorDecliningInvitation/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining invitation.', 'O', 'messages', '2011-01-13 17:47:57.559', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1487, 'Entity/Constants/errorAcceptingJoinRequest/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting join request.', 'O', 'messages', '2011-01-13 17:47:57.564', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1488, 'Entity/Constants/errorDecliningJoinRequest/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining join request.', 'O', 'messages', '2011-01-13 17:47:57.569', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1489, 'Entity/Constants/horizontalNavigationRestoreDefault/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore default', 'O', 'messages', '2011-01-13 17:47:57.582', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1490, 'Entity/Constants/horizontalNavigationCancel/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:47:57.586', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1491, 'Entity/Constants/horizontalNavigationSave/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:57.59', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1492, 'Entity/Constants/horizontalNavigationEnterTitleAndLink/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter link name and link target', 'O', 'messages', '2011-01-13 17:47:57.593', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1493, 'Entity/Constants/horizontalNavigationSuccessfullySaved/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation saved.', 'O', 'messages', '2011-01-13 17:47:57.597', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1494, 'Entity/Constants/horizontalNavigationBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation', 'O', 'messages', '2011-01-13 17:47:57.332', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1495, 'Entity/Messages/mailSubjectInvitedList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation for event ''''{0}''''', 'O', 'messages', '2011-01-13 17:47:57.839', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1496, 'Entity/Constants/coAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admin', 'O', 'messages', '2011-01-13 17:47:56.989', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1497, 'Entity/Constants/horizontalNavigationEdit/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:47:57.6', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1498, 'Entity/Constants/removeJoinEntityRequest/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove join request', 'O', 'messages', '2011-01-13 17:47:57.189', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1499, 'Entity/Constants/headerBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:57.34', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1500, 'Entity/Constants/headerText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Text', 'O', 'messages', '2011-01-13 17:47:57.343', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1501, 'Entity/Constants/subBoxBorder/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Border', 'O', 'messages', '2011-01-13 17:47:57.372', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1502, 'Entity/Constants/linkedEntityPrivacyStatusAnybody/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anybody', 'O', 'messages', '2011-01-13 17:47:57.432', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1503, 'Entity/Constants/linkedEntityPrivacyStatusAdminAndMembers/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins and members', 'O', 'messages', '2011-01-13 17:47:57.435', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1504, 'Entity/Constants/linkedEntityPrivacyStatusAdminOnly/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins', 'O', 'messages', '2011-01-13 17:47:57.439', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1505, 'Entity/Constants/entityWasSelectedError/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:47:57.458', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1506, 'Entity/Constants/duplicateEntitySelectionErrorOccur/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:47:57.462', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1507, 'Entity/Constants/parentEntityRequiredError/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please assign this event to at least one element', 'O', 'messages', '2011-01-13 17:47:57.466', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1508, 'Entity/Constants/selectASuggestedEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection not found. Please select a suggested entity.', 'O', 'messages', '2011-01-13 17:47:57.48', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1509, 'Entity/Constants/sendInvites/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send invitation', 'O', 'messages', '2011-01-13 17:47:57.49', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1510, 'Entity/Constants/invitationPopupSelection/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection', 'O', 'messages', '2011-01-13 17:47:57.494', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1511, 'Entity/Constants/invitationPopupList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:47:57.501', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1512, 'Entity/Constants/invitationPopupShowInviteMessage/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:57.505', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1513, 'Entity/Constants/invitationPopupHideInviteMessage/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove (delete)', 'O', 'messages', '2011-01-13 17:47:57.509', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1514, 'Entity/Constants/inviteViaEmail/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite via e-mail', 'O', 'messages', '2011-01-13 17:47:57.523', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1515, 'Entity/Constants/addEmails/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:57.541', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1516, 'Entity/Constants/followedEmailsAreInvalid/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Following e-mails are invalid', 'O', 'messages', '2011-01-13 17:47:57.544', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1517, 'Entity/Constants/entityClosedNotAcceptingJoinRequestPossibleAnymore/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot accept this request anymore.', 'O', 'messages', '2011-01-13 17:47:57.552', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1518, 'Entity/Messages/defineNotMoreThanEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do not define more than {0} event(s).', 'O', 'messages', '2011-01-13 17:47:57.845', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1519, 'Entity/Messages/mailSubjectRejectorList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have declined your participation', 'O', 'messages', '2011-01-13 17:47:57.937', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1520, 'Entity/Constants/googleMapAPIKeyHelpLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Help', 'O', 'messages', '2011-01-13 17:49:55.999', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1521, 'Entity/Constants/navigation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation', 'O', 'messages', '2011-01-13 17:49:56.242', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1522, 'Entity/Constants/subBoxLine', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Separator line', 'O', 'messages', '2011-01-13 17:49:56.291', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1523, 'Entity/Constants/description/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:49:58.357', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1524, 'Entity/Constants/entityJoinRequest/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group join request', 'O', 'messages', '2011-01-13 17:49:57.254', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1525, 'Entity/Constants/widgetsDontShowSubEntitiesOption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:49:57.263', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1526, 'Entity/Constants/thisEntityAndSubItems/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This group and subitems', 'O', 'messages', '2011-01-13 17:49:57.267', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1527, 'Entity/Constants/thisEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This group', 'O', 'messages', '2011-01-13 17:49:57.272', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1528, 'Entity/Constants/createEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create group', 'O', 'messages', '2011-01-13 17:49:57.299', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1529, 'Entity/Constants/duration/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Time', 'O', 'messages', '2011-01-13 17:49:57.304', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1530, 'Entity/Messages/inviteToEntityX/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite to event {0}', 'O', 'messages', '2011-01-13 17:47:57.853', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1531, 'Entity/Messages/maximumXRecipientsAllowed/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only {0} recipients allowed at a time.', 'O', 'messages', '2011-01-13 17:47:57.952', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1532, 'Entity/Constants/timezone/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:49:57.308', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1533, 'Entity/Constants/cancel/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:49:58.361', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1534, 'Entity/Constants/deleteEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:49:57.332', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1535, 'Entity/Constants/subdomain/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subdomain', 'O', 'messages', '2011-01-13 17:49:57.349', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1536, 'Entity/Constants/subBoxLinks/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Links', 'O', 'messages', '2011-01-13 17:47:57.368', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1537, 'Entity/Constants/inviteMessage/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:49:57.352', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1538, 'Entity/Messages/entityInvitationsCount/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Event invitations ({0})', 'O', 'messages', '2011-01-13 17:47:57.856', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1539, 'Entity/Constants/header/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:49:58.337', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1540, 'Entity/Constants/inviteMyContactsButtonText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite my contacts', 'O', 'messages', '2011-01-13 17:47:57.53', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1541, 'Entity/Constants/member/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member', 'O', 'messages', '2011-01-13 17:49:58.341', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1542, 'Entity/Constants/enterEmailsHere/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter e-mail address', 'O', 'messages', '2011-01-13 17:47:57.534', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1543, 'Entity/Messages/entityJoinRequestCount/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Event join requests ({0})', 'O', 'messages', '2011-01-13 17:47:57.859', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1544, 'Entity/Messages/xInternalInviationWasSent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people with platform account.', 'O', 'messages', '2011-01-13 17:47:57.969', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1545, 'Entity/Constants/addElement/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add element', 'O', 'messages', '2011-01-13 17:49:58.326', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1546, 'Entity/Constants/enterEmailHelpText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma, semicolon, space or return', 'O', 'messages', '2011-01-13 17:47:57.537', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1547, 'Entity/Constants/address/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:49:58.329', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1548, 'Entity/Constants/country/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Country', 'O', 'messages', '2011-01-13 17:49:58.345', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1549, 'Entity/Constants/location/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:49:58.349', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1550, 'Entity/Constants/requests/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Requests', 'O', 'messages', '2011-01-13 17:49:58.353', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1551, 'Entity/Messages/xInvitationSkiped/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people were skipped.', 'O', 'messages', '2011-01-13 17:47:57.973', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1552, 'Entity/Messages/userXWillBeRemove/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified.', 'O', 'messages', '2011-01-13 17:47:57.919', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1553, 'Entity/Constants/navigationSeparator/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:49:57.482', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1554, 'Entity/Constants/widgetsShowSubEntities/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Elements in teasers', 'O', 'messages', '2011-01-13 17:49:57.226', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1555, 'Entity/Constants/tags/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:49:57.316', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1556, 'Entity/Constants/closingDate/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline', 'O', 'messages', '2011-01-13 17:49:57.324', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1557, 'Entity/Constants/privacySettings/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:57.36', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1558, 'Entity/Constants/invited/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invited', 'O', 'messages', '2011-01-13 17:49:57.364', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1559, 'Entity/Constants/phone/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Phone', 'O', 'messages', '2011-01-13 17:49:57.368', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1560, 'Entity/Constants/admin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:49:57.376', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1561, 'Entity/Constants/admins/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:49:57.384', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1562, 'Entity/Constants/joinEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:49:57.397', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1563, 'Entity/Constants/acceptJoinRequest/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:49:57.422', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1564, 'Entity/Constants/coAdmins/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admins', 'O', 'messages', '2011-01-13 17:49:57.433', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1565, 'Entity/Constants/headingBox/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading boxes', 'O', 'messages', '2011-01-13 17:49:57.455', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1566, 'Entity/Constants/participants/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:49:57.466', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1567, 'Entity/Constants/zipcode/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:49:57.47', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1568, 'Entity/Constants/joiningRule/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:49:57.494', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1569, 'Entity/Constants/office/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Office', 'O', 'messages', '2011-01-13 17:49:57.498', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1570, 'Entity/Constants/participantLimitedTo/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Limit participants to', 'O', 'messages', '2011-01-13 17:49:57.549', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1571, 'Entity/Constants/backToOverview/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To group', 'O', 'messages', '2011-01-13 17:49:57.557', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1572, 'Entity/Constants/saveEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:49:57.561', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1573, 'Entity/Constants/mandatory/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:49:57.565', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1574, 'Entity/Constants/inviteToEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:49:57.695', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1575, 'Entity/Constants/navigationLinks/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation: Links', 'O', 'messages', '2011-01-13 17:49:57.851', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1576, 'Entity/Constants/parentNetworks/Group', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent places', 'O', 'messages', '2010-12-14 13:24:42.961', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1577, 'Entity/Constants/parentAppointments/Group', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent events', 'O', 'messages', '2010-12-14 13:24:43.078', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1578, 'Entity/Messages/xInvitesToEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invited you to the following event', 'O', 'messages', '2011-01-13 17:47:57.98', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1579, 'Entity/Messages/xWantJoinEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wants to join the following event.', 'O', 'messages', '2011-01-13 17:47:57.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1580, 'Entity/Constants/makeAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make admin', 'O', 'messages', '2011-01-13 17:49:57.389', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1581, 'Entity/Constants/deleteIcon/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete icon', 'O', 'messages', '2011-01-13 17:49:57.405', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1582, 'Entity/Constants/deleteLogo/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete logo', 'O', 'messages', '2011-01-13 17:49:57.41', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1583, 'Entity/Constants/declineInvite/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:49:57.426', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1584, 'Entity/Constants/coAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admin', 'O', 'messages', '2011-01-13 17:49:57.487', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1585, 'Entity/Constants/privacyRules/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:57.618', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1586, 'Entity/Constants/visibilityRule/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visibility of content', 'O', 'messages', '2011-01-13 17:49:57.625', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1587, 'Entity/Constants/visibleForAll/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For the whole internet', 'O', 'messages', '2011-01-13 17:49:57.634', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1588, 'Entity/Constants/invitingByAllMebers/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members', 'O', 'messages', '2011-01-13 17:49:57.663', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1589, 'Entity/Constants/invitingByAdminOnly/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin/co-admins', 'O', 'messages', '2011-01-13 17:49:57.666', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1590, 'Entity/Constants/uploadImage/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo & Icon', 'O', 'messages', '2011-01-13 17:49:57.671', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1591, 'Entity/Constants/createEntitySuccessfully/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:49:57.683', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1592, 'Entity/Constants/waitlist/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Waiting list', 'O', 'messages', '2011-01-13 17:49:57.699', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1593, 'Entity/Constants/rejection/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation rejected', 'O', 'messages', '2011-01-13 17:49:57.704', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1594, 'Entity/Constants/optionsComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:49:57.712', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1595, 'Entity/Constants/logoComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo', 'O', 'messages', '2011-01-13 17:49:57.732', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1596, 'Entity/Constants/adminListComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:49:57.74', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1597, 'Entity/Constants/rulesComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:57.745', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1598, 'Entity/Constants/componentsLeftColumn/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in left column', 'O', 'messages', '2011-01-13 17:49:57.748', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1599, 'Entity/Constants/navigation/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation', 'O', 'messages', '2011-01-13 17:49:57.847', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1600, 'Entity/Constants/pageBorders/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation and site: Border', 'O', 'messages', '2011-01-13 17:49:57.855', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1601, 'Entity/Constants/subBoxLine/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Separator line', 'O', 'messages', '2011-01-13 17:49:57.91', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1602, 'Entity/Constants/outerBackground/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Outer', 'O', 'messages', '2011-01-13 17:49:57.914', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1603, 'Entity/Constants/innerBackground/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background inside', 'O', 'messages', '2011-01-13 17:49:57.918', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1604, 'Entity/Constants/joiningByRequestOrInviteOnly', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only by request or invitation', 'O', 'messages', '2011-01-13 17:49:56.084', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1605, 'Entity/Constants/subBoxLinks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Links', 'O', 'messages', '2011-01-13 17:49:56.283', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1606, 'Entity/Constants/currentIcon/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current icon', 'O', 'messages', '2011-01-13 17:49:57.807', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1607, 'Entity/Constants/headerText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Text', 'O', 'messages', '2011-01-13 17:49:57.874', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1608, 'Entity/Constants/headerLinks/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Links', 'O', 'messages', '2011-01-13 17:49:57.879', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1609, 'Entity/Constants/textOnBackground/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Text', 'O', 'messages', '2011-01-13 17:49:57.933', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1610, 'Entity/Constants/lineOnBackground/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Separator line', 'O', 'messages', '2011-01-13 17:49:57.942', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1611, 'Entity/Constants/borderTop/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (top)', 'O', 'messages', '2011-01-13 17:49:57.954', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1612, 'Entity/Constants/borderLeft/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (left)', 'O', 'messages', '2011-01-13 17:49:57.962', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1613, 'Entity/Constants/borderRight/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (right)', 'O', 'messages', '2011-01-13 17:49:57.966', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1614, 'Entity/Constants/entityNotVisibleTitle/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity privacy settings', 'O', 'messages', '2011-01-13 17:49:57.978', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1615, 'Entity/Constants/linkedEntityPrivacyStatusAnybody/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anybody', 'O', 'messages', '2011-01-13 17:49:57.982', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1616, 'Entity/Constants/entityPrivacyHeader/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:57.999', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1617, 'Entity/Messages/subjectTextExternalInvite/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invites you to group "{1}"!', 'O', 'messages', '2011-01-13 17:49:58.456', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1618, 'Basic/Constants/pleaseWait', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please wait ...', 'O', 'messages', '2011-01-13 17:47:50.788', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1619, 'Basic/Constants/stadt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City', 'O', 'messages', '2011-01-13 17:47:50.759', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1620, 'Entity/Constants/deleteElement/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:49:58.004', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1621, 'Entity/Constants/duplicateEntitySelectionErrorOccur/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:49:58.011', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1622, 'Entity/Constants/invitationPopupSelection/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection', 'O', 'messages', '2011-01-13 17:49:58.035', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1623, 'Entity/Constants/invitationPopupPleaseSelectPersonToInvite/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No person selected, no one to invite.', 'O', 'messages', '2011-01-13 17:49:58.054', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1624, 'Entity/Constants/errorDecliningInvitation/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining invitation.', 'O', 'messages', '2011-01-13 17:49:58.1', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1625, 'Basic/Constants/newsAdded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'News added.', 'O', 'messages', '2011-01-13 17:47:50.774', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1626, 'Entity/Constants/horizontalNavigationRestoreDefault/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore default', 'O', 'messages', '2011-01-13 17:49:58.127', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1627, 'Entity/Constants/invitationPopupList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:49:58.043', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1628, 'Entity/Constants/errorAcceptingJoinRequest/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting join request.', 'O', 'messages', '2011-01-13 17:49:58.115', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1629, 'Entity/Constants/horizontalNavigationCancel/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:49:58.129', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1630, 'Basic/Constants/sendingEmptyMessagesNotPossible', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enter a message body.', 'O', 'messages', '2011-01-13 17:47:50.764', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1631, 'Basic/Constants/visitedHidden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No', 'O', 'messages', '2011-01-13 17:47:50.778', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1632, 'Entity/Constants/invitationPopupShowInviteMessage/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:49:58.047', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1633, 'Basic/Constants/speichern', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:50.75', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1634, 'Basic/Constants/lieblingsbuecher', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favorite books', 'O', 'messages', '2011-01-13 17:47:50.769', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1635, 'Basic/Constants/weltbewegerName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of Weltbeweger', 'O', 'messages', '2011-01-13 17:47:50.783', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1636, 'Entity/Constants/errorAcceptingInvitation/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting invitation.', 'O', 'messages', '2011-01-13 17:49:58.096', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1637, 'Entity/Constants/errorDecliningJoinRequest/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining join request.', 'O', 'messages', '2011-01-13 17:49:58.118', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1638, 'Entity/Constants/horizontalNavigationSave/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:49:58.132', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1639, 'Basic/Constants/unblock', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unblock', 'O', 'messages', '2011-01-13 17:47:50.755', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1640, 'Entity/Constants/joiningOnlyForMembersOfLinkedEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:49:56.08', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1641, 'Entity/Constants/member/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member', 'O', 'messages', '2011-01-13 17:47:59.147', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1642, 'Entity/Constants/enterEmailsHere/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter e-mail address', 'O', 'messages', '2011-01-13 17:49:58.077', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1643, 'Entity/Constants/pageBorders', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation and site: Border', 'O', 'messages', '2011-01-13 17:49:56.25', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1644, 'Entity/Constants/outerBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background outside', 'O', 'messages', '2011-01-13 17:49:56.295', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1645, 'Entity/Messages/entityInvitationsCount/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group invitations ({0})', 'O', 'messages', '2011-01-13 17:49:58.411', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1646, 'Entity/Messages/doRealyWantToDeleteCoAdminX/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove {0} from co-admins?', 'O', 'messages', '2011-01-13 17:49:58.492', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1647, 'Entity/Constants/invitationPopupNoPersonsFound', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No people found, nothing to insert.', 'O', 'messages', '2011-01-13 17:49:56.455', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1648, 'Entity/Constants/inviteViaEmail/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite via e-mail', 'O', 'messages', '2011-01-13 17:49:58.066', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1649, 'Entity/Constants/inviteAllMyContacts/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite all my contacts', 'O', 'messages', '2011-01-13 17:49:58.069', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1650, 'Entity/Messages/mailSubjectInvitedList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation for group ''''{0}''''', 'O', 'messages', '2011-01-13 17:49:58.504', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1651, 'Entity/Messages/xExternalInviationWasSent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people without platform account.', 'O', 'messages', '2011-01-13 17:49:58.523', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1652, 'Entity/Constants/address/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:47:59.125', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1653, 'Entity/Constants/country/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Country', 'O', 'messages', '2011-01-13 17:47:59.151', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1654, 'Entity/Constants/location/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:47:59.154', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1655, 'Entity/Constants/horizontalNavigationEnterTitleAndLink/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter link name and link target', 'O', 'messages', '2011-01-13 17:49:58.134', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1656, 'Entity/Messages/mailSubjectRequesterList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have requested for participation', 'O', 'messages', '2011-01-13 17:49:58.509', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1657, 'Entity/Messages/xInvitesToEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invited you to the following group', 'O', 'messages', '2011-01-13 17:49:58.535', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1658, 'Entity/Constants/horizontalNavigationSuccessfullySaved/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation saved.', 'O', 'messages', '2011-01-13 17:49:58.136', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1659, 'Entity/Constants/horizontalNavigationEdit/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:49:58.14', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1660, 'Entity/Messages/defineNotMoreThanEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do not define more than {0} group(s).', 'O', 'messages', '2011-01-13 17:49:58.402', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1661, 'Entity/Messages/inviteToEntityX/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite to group {0}', 'O', 'messages', '2011-01-13 17:49:58.406', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1662, 'Entity/Messages/entityJoinRequestCount/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group join requests ({0})', 'O', 'messages', '2011-01-13 17:49:58.415', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1663, 'Entity/Messages/userXWillBeRemove/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified.', 'O', 'messages', '2011-01-13 17:49:58.485', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1664, 'Entity/Constants/myEntities/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My wiki pages', 'O', 'messages', '2011-01-13 17:47:58.075', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1665, 'Entity/Messages/mailSubjectWaitList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on waiting list', 'O', 'messages', '2011-01-13 17:49:58.496', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1666, 'Entity/Constants/widgetsDontShowSubEntitiesOption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:47:58.115', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1667, 'Entity/Messages/mailSubjectParticipantList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on participant list', 'O', 'messages', '2011-01-13 17:49:58.499', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1668, 'Entity/Constants/thisEntityAndSubItems/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This wiki page and subitems', 'O', 'messages', '2011-01-13 17:47:58.119', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1669, 'Entity/Messages/maximumXRecipientsAllowed/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only {0} recipients allowed at a time.', 'O', 'messages', '2011-01-13 17:49:58.52', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1670, 'Entity/Constants/state/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'State', 'O', 'messages', '2011-01-13 17:47:59.141', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1671, 'Entity/Messages/xWantJoinEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wants to join the following group.', 'O', 'messages', '2011-01-13 17:49:58.539', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1672, 'Entity/Constants/addElement/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add element', 'O', 'messages', '2011-01-13 17:47:59.122', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1673, 'Entity/Constants/header/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:59.144', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1674, 'Entity/Constants/makeCoAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make co-admin', 'O', 'messages', '2011-01-13 17:47:58.24', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1675, 'Entity/Constants/inviteMessage/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:58.202', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1676, 'Entity/Constants/privacySettings/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:58.21', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1677, 'Entity/Constants/widgetsShowSubEntities/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Elements in teasers', 'O', 'messages', '2011-01-13 17:47:58.071', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1678, 'Entity/Constants/phone/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Phone', 'O', 'messages', '2011-01-13 17:47:58.217', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1679, 'Entity/Constants/acceptJoinRequest/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:58.27', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1680, 'Entity/Constants/joinEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:47:58.244', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1681, 'Entity/Constants/duration/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Time', 'O', 'messages', '2011-01-13 17:47:58.17', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1682, 'Entity/Constants/parents/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Parents', 'O', 'messages', '2011-01-13 17:47:58.157', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1683, 'Entity/Constants/navigationLinks/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation: Links', 'O', 'messages', '2011-01-13 17:47:58.653', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1684, 'Entity/Constants/requests/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Requests', 'O', 'messages', '2011-01-13 17:47:59.158', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1685, 'Entity/Constants/makeAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make admin', 'O', 'messages', '2011-01-13 17:47:58.236', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1686, 'Entity/Constants/subdomain/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subdomain', 'O', 'messages', '2011-01-13 17:47:58.2', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1687, 'Entity/Constants/office/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Office', 'O', 'messages', '2011-01-13 17:47:58.348', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1688, 'Entity/Constants/zipcode/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:47:58.324', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1689, 'Entity/Constants/description/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:47:59.161', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1690, 'Entity/Constants/followedEmailsAreInvalid/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Following e-mails are invalid', 'O', 'messages', '2011-01-13 17:49:58.089', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1691, 'Entity/Constants/invited/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invited', 'O', 'messages', '2011-01-13 17:47:58.213', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1692, 'Entity/Constants/parentAppointments/Wiki', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent events', 'O', 'messages', '2010-12-14 13:22:43.22', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1693, 'Entity/Constants/childEntities/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki Pages', 'O', 'messages', '2011-01-13 17:47:58.067', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1694, 'Entity/Constants/admin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:47:58.224', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1695, 'Entity/Constants/widgetsShowSubEntitiesOption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:47:58.11', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1696, 'Entity/Constants/parentGroups/Wiki', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent groups', 'O', 'messages', '2010-12-14 13:22:43.14', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1697, 'Entity/Constants/participantLimitedTo/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Limit participants to', 'O', 'messages', '2011-01-13 17:47:58.384', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1698, 'Entity/Constants/entityInvitations/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki page invitations', 'O', 'messages', '2011-01-13 17:47:58.099', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1699, 'Entity/Constants/editEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic informations', 'O', 'messages', '2011-01-13 17:47:58.377', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1700, 'Entity/Constants/participantUnlimited/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unlimited number of participants', 'O', 'messages', '2011-01-13 17:47:58.381', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1701, 'Entity/Constants/headingBox/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading boxes', 'O', 'messages', '2011-01-13 17:47:58.31', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1702, 'Entity/Constants/email/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:47:58.206', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1703, 'Entity/Constants/deleteEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:58.196', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1704, 'Entity/Constants/deleteCoAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:58.228', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1705, 'Entity/Constants/enterNameOfEntityHere/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of wiki pages', 'O', 'messages', '2011-01-13 17:47:58.081', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1706, 'Entity/Constants/fax/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:47:58.352', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1707, 'Entity/Constants/contactName/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:47:58.356', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1708, 'Entity/Constants/website/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:47:58.331', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1709, 'Entity/Constants/leaveEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave', 'O', 'messages', '2011-01-13 17:47:58.248', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1710, 'Entity/Constants/cancel/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:47:59.165', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1711, 'Entity/Constants/invitePerson/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite person', 'O', 'messages', '2011-01-13 17:47:58.221', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1712, 'Entity/Constants/entityJoinRequest/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki page join request', 'O', 'messages', '2011-01-13 17:47:58.104', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1713, 'Entity/Constants/admins/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:58.232', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1714, 'Entity/Constants/declineInvite/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:58.273', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1715, 'Entity/Constants/joiningRule/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:47:58.345', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1716, 'Entity/Constants/coAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admin', 'O', 'messages', '2011-01-13 17:47:58.338', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1717, 'Entity/Constants/backToOverview/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To wiki page', 'O', 'messages', '2011-01-13 17:47:58.391', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1718, 'Entity/Constants/inviteToEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:58.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1719, 'Entity/Constants/joiningForAll/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Users with and without platform account', 'O', 'messages', '2011-01-13 17:47:58.483', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1720, 'Entity/Constants/joiningOnlyForMembersOfPlatform/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:58.487', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1721, 'Entity/Constants/configComponents/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules', 'O', 'messages', '2011-01-13 17:47:58.509', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1722, 'Entity/Constants/saveEntitySuccessfully/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:47:58.513', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1723, 'Entity/Constants/createEntitySuccessfully/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:47:58.517', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1724, 'Entity/Constants/removeJoinEntityRequest/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove join request', 'O', 'messages', '2011-01-13 17:47:58.52', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1725, 'Entity/Constants/configEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:47:58.524', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1726, 'Entity/Constants/saveEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:58.396', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1727, 'Entity/Constants/waitlist/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Waiting list', 'O', 'messages', '2011-01-13 17:47:58.531', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1728, 'Entity/Constants/rejection/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation rejected', 'O', 'messages', '2011-01-13 17:47:58.534', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1729, 'Entity/Constants/baseDataComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic data', 'O', 'messages', '2011-01-13 17:47:58.538', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1730, 'Entity/Constants/optionsComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:47:58.542', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1731, 'Entity/Constants/logoComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo', 'O', 'messages', '2011-01-13 17:47:58.549', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1732, 'Entity/Constants/randomMembersComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:58.552', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1733, 'Entity/Constants/deleteFromMemberList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:58.57', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1734, 'Entity/Constants/toPerticipantList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in participant list', 'O', 'messages', '2011-01-13 17:47:58.578', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1735, 'Entity/Constants/externalDomainInUse/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External domain already in use', 'O', 'messages', '2011-01-13 17:47:58.429', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1736, 'Entity/Constants/noNotfiedParticipantSelected/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No persons for notification selected.', 'O', 'messages', '2011-01-13 17:47:58.581', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1737, 'Entity/Constants/rulesComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:58.559', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1738, 'Entity/Constants/notifcationMailsWasSentToSelectedParticipant/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Notifications sent.', 'O', 'messages', '2011-01-13 17:47:58.585', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1739, '/Basic/Constants/saved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:47:54.914', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1740, 'Entity/Constants/tags/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:47:58.181', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1741, 'Entity/Constants/invitingRule/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:58.26', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1742, 'Entity/Constants/acceptInvite/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:58.266', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1743, 'Entity/Constants/declineJoinRequest/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:58.277', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1744, 'Entity/Constants/visibleForMember/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members', 'O', 'messages', '2011-01-13 17:47:58.48', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1745, 'Entity/Constants/mandatory/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:47:58.4', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1746, 'Entity/Constants/tagsSeparatorHint/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma', 'O', 'messages', '2011-01-13 17:47:58.404', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1747, 'Entity/Constants/hideAddressData/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:47:58.407', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1748, 'Entity/Constants/googleMapAPIKey/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Google Maps-API key', 'O', 'messages', '2011-01-13 17:47:58.414', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1749, 'Entity/Constants/googleMapAPIKeyHelpLink/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Help', 'O', 'messages', '2011-01-13 17:47:58.418', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1750, 'Entity/Constants/subdomainInUse/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The subdomain is already in use', 'O', 'messages', '2011-01-13 17:47:58.426', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1751, 'Entity/Constants/subdomainHelpLink/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'How does this work?', 'O', 'messages', '2011-01-13 17:47:58.433', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1752, 'Entity/Constants/externalURL/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External URL', 'O', 'messages', '2011-01-13 17:47:58.437', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1753, 'Entity/Constants/privacyRules/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:58.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1754, 'Entity/Constants/visibilityRule/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visibility of content', 'O', 'messages', '2011-01-13 17:47:58.464', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1755, 'Entity/Constants/coAdmins/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admins', 'O', 'messages', '2011-01-13 17:47:58.281', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1756, 'Entity/Constants/currentLogo/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current logo', 'O', 'messages', '2011-01-13 17:47:58.596', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1757, 'Entity/Constants/uploadLogo/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload logo', 'O', 'messages', '2011-01-13 17:47:58.599', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1758, 'Entity/Constants/subBox/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:47:58.693', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1759, 'Entity/Constants/successfullySavedEntityDesign/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design saved.', 'O', 'messages', '2011-01-13 17:47:58.641', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1760, 'Entity/Constants/pageBorders/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation and site: Border', 'O', 'messages', '2011-01-13 17:47:58.657', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1761, 'Entity/Constants/headerBorder/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Border', 'O', 'messages', '2011-01-13 17:47:58.682', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1762, 'Entity/Constants/acceptChanges/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept changes', 'O', 'messages', '2011-01-13 17:47:58.638', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1763, 'Entity/Constants/horizontalNavigationLink/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation: Link', 'O', 'messages', '2011-01-13 17:47:58.667', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1764, 'Entity/Constants/headingBoxText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Text and links', 'O', 'messages', '2011-01-13 17:47:58.686', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1765, 'Entity/Constants/headerText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Text', 'O', 'messages', '2011-01-13 17:47:58.675', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1766, 'Entity/Constants/preview/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:47:58.627', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1767, 'Entity/Constants/headerLinks/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Links', 'O', 'messages', '2011-01-13 17:47:58.678', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1768, 'Entity/Constants/headingBoxBorder/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Border', 'O', 'messages', '2011-01-13 17:47:58.689', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1769, 'Entity/Constants/subBoxText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Text', 'O', 'messages', '2011-01-13 17:47:58.696', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1770, 'Entity/Constants/subBoxLinks/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Links', 'O', 'messages', '2011-01-13 17:47:58.7', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1771, 'Entity/Constants/subBoxLine/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Separator line', 'O', 'messages', '2011-01-13 17:47:58.707', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1772, 'Entity/Constants/textOnBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Text', 'O', 'messages', '2011-01-13 17:47:58.718', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1773, 'Entity/Constants/linksOnBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Links', 'O', 'messages', '2011-01-13 17:47:58.722', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1774, 'Entity/Constants/outerBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background outside', 'O', 'messages', '2011-01-13 17:47:58.711', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1775, 'Entity/Constants/buttonBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button', 'O', 'messages', '2011-01-13 17:47:58.729', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1776, 'Entity/Constants/buttonText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button: Text', 'O', 'messages', '2011-01-13 17:47:58.733', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1777, 'Entity/Constants/borderTop/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (top)', 'O', 'messages', '2011-01-13 17:47:58.736', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1778, 'Entity/Constants/borderLeft/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (left)', 'O', 'messages', '2011-01-13 17:47:58.743', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1779, 'Entity/Constants/borderRight/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (right)', 'O', 'messages', '2011-01-13 17:47:58.747', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1780, '/Basic/Constants/dateTimeFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'M/d/yyyy ''at'' hh:mm a', 'O', 'messages', '2011-01-13 17:47:54.929', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1781, '/Basic/Constants/timeFormatFixedWidth', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'hh:mm a', 'O', 'messages', '2011-01-13 17:47:54.946', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1782, '/Basic/Constants/dateFormatFixedWidth', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'MM/dd/yyyy', 'O', 'messages', '2011-01-13 17:47:54.965', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1783, '/Basic/Constants/linkTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Title', 'O', 'messages', '2011-01-13 17:47:54.972', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1784, '/Basic/Constants/all', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:55.18', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1785, 'Entity/Constants/joiningByRequestOrInviteOnly/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only by request or invitation', 'O', 'messages', '2011-01-13 17:47:58.495', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1786, 'Entity/Constants/invitingByAllMebers/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members', 'O', 'messages', '2011-01-13 17:47:58.498', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1787, 'Entity/Constants/uploadImage/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo & Icon', 'O', 'messages', '2011-01-13 17:47:58.506', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1788, 'Entity/Constants/notNotifiedParticipant/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unnotified people', 'O', 'messages', '2011-01-13 17:47:58.588', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1789, 'Entity/Constants/currentIcon/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current icon', 'O', 'messages', '2011-01-13 17:47:58.603', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1790, 'Entity/Constants/uploadIcon/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload icon', 'O', 'messages', '2011-01-13 17:47:58.606', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1791, 'Entity/Constants/horizontalNavigationBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation', 'O', 'messages', '2011-01-13 17:47:58.664', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1792, 'Entity/Constants/adjustColors/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Customize colors', 'O', 'messages', '2011-01-13 17:47:58.623', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1793, 'Entity/Constants/colorDesign/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design', 'O', 'messages', '2011-01-13 17:47:58.61', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1794, 'Entity/Constants/navigation/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation', 'O', 'messages', '2011-01-13 17:47:58.649', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1795, 'Entity/Constants/toggleColorAdjustments/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Advanced settings (optional)', 'O', 'messages', '2011-01-13 17:47:58.631', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1796, 'Entity/Constants/boxBorders/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Borders heading box', 'O', 'messages', '2011-01-13 17:47:58.634', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1797, 'Entity/Constants/deleteElement/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:58.793', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1798, 'Entity/Constants/invitationPopupSelection/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection', 'O', 'messages', '2011-01-13 17:47:58.822', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1799, 'Entity/Constants/errorAcceptingJoinRequest/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting join request.', 'O', 'messages', '2011-01-13 17:47:58.89', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1800, 'Entity/Constants/errorDecliningJoinRequest/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining join request.', 'O', 'messages', '2011-01-13 17:47:58.894', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1801, 'Entity/Constants/horizontalNavigationRestoreDefault/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore default', 'O', 'messages', '2011-01-13 17:47:58.908', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1802, 'Entity/Constants/horizontalNavigationCancel/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:47:58.912', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1803, 'Entity/Constants/horizontalNavigationSave/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:58.915', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1804, 'Entity/Constants/horizontalNavigationEnterTitleAndLink/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter link name and link target', 'O', 'messages', '2011-01-13 17:47:58.919', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1805, 'Entity/Constants/horizontalNavigationSuccessfullySaved/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation saved.', 'O', 'messages', '2011-01-13 17:47:58.923', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1806, 'Entity/Constants/horizontalNavigationEdit/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:47:58.926', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1807, 'Entity/Messages/needToDefineMinEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You have to define {0} wiki page(s) minimum.', 'O', 'messages', '2011-01-13 17:47:59.185', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1808, 'Entity/Messages/defineNotMoreThanEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do not define more than {0} wiki page(s).', 'O', 'messages', '2011-01-13 17:47:59.191', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1809, 'Entity/Messages/inviteToEntityX/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite to wiki page {0}', 'O', 'messages', '2011-01-13 17:47:59.196', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1810, 'Entity/Messages/minimumBannerHeight/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The header graphic needs to be at least {0} px in height.', 'O', 'messages', '2011-01-13 17:47:59.245', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1811, 'Entity/Messages/entityJoinRequestCount/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki page join requests ({0})', 'O', 'messages', '2011-01-13 17:47:59.206', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1812, 'Entity/Messages/mailSubjectRejectorList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have declined your participation', 'O', 'messages', '2011-01-13 17:47:59.31', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1813, 'Entity/Messages/mailSubjectRequesterList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have requested for participation', 'O', 'messages', '2011-01-13 17:47:59.314', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1814, 'Entity/Messages/entityInvitationsCount/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki page invitations ({0})', 'O', 'messages', '2011-01-13 17:47:59.201', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1815, '/Basic/Constants/edit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:47:54.937', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1816, '/Basic/Constants/linkHref', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:47:54.976', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1817, 'Entity/Constants/infoWidgetComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:47:58.185', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1818, 'Entity/Constants/headerBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:58.671', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1819, 'Entity/Constants/lineOnBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Separator line', 'O', 'messages', '2011-01-13 17:47:58.725', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1820, 'Entity/Constants/linkedEntityPrivacyStatusAnybody/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anybody', 'O', 'messages', '2011-01-13 17:47:58.762', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1821, 'Entity/Constants/linkedEntityPrivacyStatusAdminOnly/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins', 'O', 'messages', '2011-01-13 17:47:58.769', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1822, 'Entity/Constants/entityNotVisibleTitle/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity privacy settings', 'O', 'messages', '2011-01-13 17:47:58.758', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1823, 'Entity/Constants/entityPrivacyHeader/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:58.789', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1824, 'Entity/Constants/invitationPopupMessage/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:58.826', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1825, 'Entity/Constants/invitationPopupList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:47:58.829', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1826, 'Entity/Constants/invitationPopupNoPersonsInserted/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No one added, everyone is already in your list.', 'O', 'messages', '2011-01-13 17:47:58.844', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1827, 'Entity/Constants/invitationPopupNoPersonsFound/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No people found, nothing to insert.', 'O', 'messages', '2011-01-13 17:47:58.847', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1828, 'Entity/Constants/inviteAllMyContacts/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite all my contacts', 'O', 'messages', '2011-01-13 17:47:58.854', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1829, 'Entity/Constants/inviteMyContactsButtonText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite my contacts', 'O', 'messages', '2011-01-13 17:47:58.858', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1830, 'Entity/Constants/enterEmailsHere/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter e-mail address', 'O', 'messages', '2011-01-13 17:47:58.862', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1831, 'Entity/Constants/addEmails/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:58.869', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1832, 'Entity/Constants/followedEmailsAreInvalid/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Following e-mails are invalid', 'O', 'messages', '2011-01-13 17:47:58.872', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1833, 'Entity/Constants/errorAcceptingInvitation/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting invitation.', 'O', 'messages', '2011-01-13 17:47:58.883', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1834, 'Entity/Constants/errorDecliningInvitation/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining invitation.', 'O', 'messages', '2011-01-13 17:47:58.887', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1835, 'Entity/Constants/inviteToEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:49:56.117', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1836, 'Entity/Constants/entityInvitations', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity invitations', 'O', 'messages', '2011-01-13 17:49:56.511', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1837, 'Entity/Constants/youAreUndecided', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are undecided', 'O', 'messages', '2011-01-13 17:49:56.59', NULL, '2010-08-06 17:22:00.495075');
INSERT INTO base_property VALUES (1838, 'Entity/Constants/notAllowedToAddEntityHere', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to add something here.', 'O', 'messages', '2011-01-13 17:49:56.679', NULL, '2010-09-23 01:58:33.891571');
INSERT INTO base_property VALUES (1839, 'Entity/Mails/entityMakeAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now admin of entity "$ENTITY.Name".

Entity:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.375', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1840, 'Entity/Constants/state', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'State', 'O', 'messages', '2011-01-13 17:49:56.794', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1841, 'Entity/Mails/invitationExternal', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$INVITER.Firstname $INVITER.Surname invites you to "$ENTITY.Name".

$MESSAGE

Register here for "$ENTITY.Name":
$INVITATION_URI', 'O', 'messages', '2011-01-13 17:48:02.381', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1871, 'Entity/Mails/activateNewMail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To activate your new e-mail address klick this link:

$ACTIVATION_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.629', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1872, 'Entity/Constants/youdidntParticipate', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You didn''t participate.', 'O', 'messages', '2011-01-13 17:49:56.683', NULL, '2010-09-23 01:58:33.894378');
INSERT INTO base_property VALUES (1873, 'Entity/Constants/addElement', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add element', 'O', 'messages', '2011-01-13 17:49:56.786', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1842, 'Entity/Mails/messageEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wrote a message to the members of group "$ENTITY.Name":

$SUBJECT

$MESSAGE

Log in to reply:
$STARTPAGE_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.442', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1843, 'Entity/Mails/entityDeleted/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname deleted the wiki page "$ENTITY.Name".


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.5', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1844, 'Entity/Constants/sendInvites/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send invitation', 'O', 'messages', '2011-01-13 17:47:58.819', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1845, 'Entity/Constants/invitationPopupShowInviteMessage/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:58.833', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1846, 'Entity/Constants/invitationPopupHideInviteMessage/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove (delete)', 'O', 'messages', '2011-01-13 17:47:58.837', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1847, 'Entity/Mails/entityMoveFromWaitlistToParticipantList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You moved from waiting list to list of participants of group "$ENTITY.Name".

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.444', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1848, 'Entity/Mails/entityMakeCoadmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now co-admin of wiki page "$ENTITY.Name".

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.503', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1849, 'Entity/Constants/invitationPopupPleaseSelectPersonToInvite/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No person selected, no one to invite.', 'O', 'messages', '2011-01-13 17:47:58.84', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1850, 'Entity/Mails/entityInvitation/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname invites you to wiki page "$ENTITY.Name".

#if ( !$MESSAGE.empty )
$MESSAGE
#end

Pick up invitation:
$STARTPAGE_URI

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.495', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1851, 'Entity/Messages/userXWillBeRemove/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified.', 'O', 'messages', '2011-01-13 17:47:59.26', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1852, 'Entity/Messages/doRealyWantToDeleteCoAdminX/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove {0} from co-admins?', 'O', 'messages', '2011-01-13 17:47:59.267', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1853, 'Entity/Messages/xInvitationSkiped/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people were skipped.', 'O', 'messages', '2011-01-13 17:47:59.331', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1854, 'Entity/Messages/xInvitesToEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invited you to the following wiki page', 'O', 'messages', '2011-01-13 17:47:59.337', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1855, 'Entity/Constants/leaveEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave', 'O', 'messages', '2011-01-13 17:49:55.808', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1856, 'Entity/Constants/invitingRule', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:49:55.82', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1857, 'Entity/Constants/declineInvite', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:49:55.832', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1858, 'Entity/Constants/declineJoinRequest', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:49:55.836', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1859, 'Entity/Constants/deleteEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:49:55.744', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1860, 'Entity/Mails/commentedVideo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname commented on one of your videos:

$MESSAGE

Log in to reply:
$DOMAIN_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.631', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1861, 'Entity/Mails/commentedImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname commented on one of your photos:

$MESSAGE


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.634', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1862, 'Entity/Messages/userXWillBeRemoveAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified. The admin status will remain unchanged.', 'O', 'messages', '2011-01-13 17:47:59.256', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1863, 'Entity/Messages/maximumXRecipientsAllowed/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only {0} recipients allowed at a time.', 'O', 'messages', '2011-01-13 17:47:59.322', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1864, 'Entity/Constants/admins', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:49:55.791', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1865, 'Entity/Mails/entityDeleted/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname deleted the group "$ENTITY.Name".


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.459', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1866, 'Entity/Mails/entityMakeCoadmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now co-admin of group "$ENTITY.Name".

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.462', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1867, 'Entity/Constants/entityName/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group name', 'O', 'messages', '2011-01-13 17:49:57.205', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1868, 'Entity/Mails/invitationFriendship', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$INVITER.Firstname $INVITER.Surname wants to add you as contact.

#if ( $MESSAGE )
#if ( !$MESSAGE.empty )
Attached message:
$MESSAGE
#end
#end

Accept or deny:
$STARTPAGE_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.636', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1869, 'Entity/Constants/participantStatusText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participate', 'O', 'messages', '2011-01-13 17:49:56.602', NULL, '2010-08-06 17:22:00.529523');
INSERT INTO base_property VALUES (1870, 'Entity/Constants/invitationPopupPleaseSelectPersonToInvite', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No person selected, no one to invite.', 'O', 'messages', '2011-01-13 17:49:56.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1874, 'Entity/Constants/entities/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Groups', 'O', 'messages', '2011-01-13 17:49:57.198', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1875, 'Entity/Messages/xExternalInviationWasSent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people without platform account.', 'O', 'messages', '2011-01-13 17:47:59.325', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1876, 'Entity/Messages/xWantJoinEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wants to join the following wiki page.', 'O', 'messages', '2011-01-13 17:47:59.341', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1877, 'Entity/Mails/entityMakeAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now admin of group "$ENTITY.Name".

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.465', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1878, 'Entity/Mails/entityMakeAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now admin of wiki page "$ENTITY.Name".

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.51', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1879, 'Entity/Constants/entityJoinRequest', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity join request', 'O', 'messages', '2011-01-13 17:49:56.515', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1880, 'Entity/Mails/greetNewUsers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$MESSAGE
', 'O', 'messages', '2011-01-13 17:48:02.638', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1881, 'Entity/Messages/xInternalInviationWasSent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people with platform account.', 'O', 'messages', '2011-01-13 17:47:59.328', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1882, 'Entity/Mails/sendPassword', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Klick this link to choose a new password:
$SENDPASSWORD_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.639', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1883, 'Entity/Constants/deleteCoAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:49:55.787', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1884, 'Entity/Constants/tags', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:49:55.721', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1885, 'Entity/Constants/acceptJoinRequest', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:49:55.828', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1886, 'Entity/Constants/invitePerson', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite platform member', 'O', 'messages', '2011-01-13 17:49:55.77', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1887, 'Entity/Constants/backToOverview', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To entity', 'O', 'messages', '2011-01-13 17:49:55.97', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1888, 'Entity/Constants/mandatory', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:49:55.978', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1889, 'Entity/Constants/participants', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:49:55.887', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1890, 'Entity/Constants/subdomainInUse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The subdomain is already in use', 'O', 'messages', '2011-01-13 17:49:56.008', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1891, 'Entity/Constants/saveEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:49:55.974', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1892, 'Entity/Constants/parentAppointments', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent events', 'O', 'messages', '2010-12-14 13:24:21.831', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1893, 'Entity/Constants/navigationSeparator', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:49:55.903', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1894, 'Entity/Constants/inviteViaEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite via e-mail', 'O', 'messages', '2011-01-13 17:49:56.459', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1895, 'Entity/Constants/attendTo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to:', 'O', 'messages', '2011-01-13 17:49:56.687', NULL, '2010-09-23 01:58:33.897294');
INSERT INTO base_property VALUES (1896, 'Entity/Mails/entityMakeCoadmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now co-admin of event "$ENTITY.Name".

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1897, 'Entity/Constants/coAdmins', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admins', 'O', 'messages', '2011-01-13 17:49:55.84', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1898, 'Entity/Constants/editEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic informations', 'O', 'messages', '2011-01-13 17:49:55.954', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1899, 'Entity/Constants/joinEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:49:55.804', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1900, 'Entity/Constants/headingBox', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading boxes', 'O', 'messages', '2011-01-13 17:49:55.876', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1901, 'Entity/Constants/parentGroups', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent groups', 'O', 'messages', '2010-12-14 13:24:21.731', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1902, 'Entity/Constants/deleteLogo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete logo', 'O', 'messages', '2011-01-13 17:49:55.816', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1903, 'Entity/Mails/entityMakeAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now admin of event "$ENTITY.Name".

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.565', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1904, 'Entity/Constants/hideAddressData', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:49:55.985', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1905, 'Entity/Constants/widgetsShowSubEntities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Elements in teasers', 'O', 'messages', '2011-01-13 17:49:55.93', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1906, 'Entity/Constants/makeCoAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make co-admin', 'O', 'messages', '2011-01-13 17:49:55.8', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1907, 'Entity/Mails/reportViolation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$MESSAGE

--
reported from: $SENDER.Firstname $SENDER.Surname ($SENDER.Id)
', 'O', 'messages', '2011-01-13 17:48:02.62', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1908, 'Entity/Constants/joiningRule', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:49:55.915', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1909, 'Entity/Constants/navigationLinks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation: Links', 'O', 'messages', '2011-01-13 17:49:56.246', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1910, 'Entity/Constants/showAddressData', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show', 'O', 'messages', '2011-01-13 17:49:55.99', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1911, 'Entity/Constants/contactName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:49:55.927', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1912, 'Entity/Constants/website', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:49:55.899', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1913, 'Entity/Constants/noRecipientsSelected', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No recipients selected.', 'O', 'messages', '2011-01-13 17:49:56.642', NULL, '2010-08-10 18:58:41.238316');
INSERT INTO base_property VALUES (1914, 'Entity/Constants/youHaveRequestToAttend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request sent.', 'O', 'messages', '2011-01-13 17:49:56.594', NULL, '2010-08-06 17:22:00.505248');
INSERT INTO base_property VALUES (1915, 'Entity/Constants/externalURL', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External URL', 'O', 'messages', '2011-01-13 17:49:56.019', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1916, 'Entity/Constants/participantUnlimited', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unlimited number of participants', 'O', 'messages', '2011-01-13 17:49:55.958', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1917, 'Entity/Constants/visibilityRule', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visibility of content', 'O', 'messages', '2011-01-13 17:49:56.041', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1918, 'Entity/Constants/fax', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:49:55.922', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1919, 'Entity/Mails/entityWaitList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now on waiting list of event "$ENTITY.Name".

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.555', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1920, 'Entity/Constants/phone', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Phone', 'O', 'messages', '2011-01-13 17:49:55.766', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1921, 'Entity/Constants/makeAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make admin', 'O', 'messages', '2011-01-13 17:49:55.795', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1922, 'Entity/Constants/coAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admin', 'O', 'messages', '2011-01-13 17:49:55.907', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1923, 'Entity/Constants/toPerticipantList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in participant list', 'O', 'messages', '2011-01-13 17:49:56.16', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1924, 'Entity/Constants/currentLogo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current logo', 'O', 'messages', '2011-01-13 17:49:56.179', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1925, 'Entity/Constants/office', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Office', 'O', 'messages', '2011-01-13 17:49:55.919', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1926, 'Entity/Constants/participantSelectedFromWaitlist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select participants manually from waiting list', 'O', 'messages', '2011-01-13 17:49:55.966', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1927, 'Entity/Constants/tagsSeparatorHint', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma', 'O', 'messages', '2011-01-13 17:49:55.982', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1928, 'Entity/Constants/myEntities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My entities', 'O', 'messages', '2011-01-13 17:49:56.151', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1929, 'Entity/Constants/visibleForWholePlatForm', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for users with an existing plattform account', 'O', 'messages', '2011-01-13 17:49:56.056', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1930, 'Entity/Constants/removeJoinEntityRequest', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove join request', 'O', 'messages', '2011-01-13 17:49:56.111', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1931, 'Entity/Constants/rejection', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Not participating', 'O', 'messages', '2011-01-13 17:49:56.124', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1932, 'Entity/Constants/optionsComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:49:56.128', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1933, 'Entity/Constants/adminListComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:49:56.138', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1934, 'Entity/Constants/deleteFromMemberList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:49:56.154', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1935, 'Entity/Constants/uploadLogo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload logo', 'O', 'messages', '2011-01-13 17:49:56.183', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1936, 'Entity/Constants/currentIcon', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current icon', 'O', 'messages', '2011-01-13 17:49:56.187', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1937, 'Entity/Constants/adjustColors', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Customize colors', 'O', 'messages', '2011-01-13 17:49:56.2', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1938, 'Entity/Constants/configComponents', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules', 'O', 'messages', '2011-01-13 17:49:56.099', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1939, 'Entity/Constants/joiningOnlyForMembersOfPlatform', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only users with an existing platform account', 'O', 'messages', '2011-01-13 17:49:56.076', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1940, 'Entity/Constants/horizontalNavigationLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation: Link', 'O', 'messages', '2011-01-13 17:49:56.258', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1941, 'Entity/Constants/saveEntitySuccessfully', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:49:56.103', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1942, 'Entity/Constants/rulesComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:56.141', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1943, 'Entity/Constants/toWaitlist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in waiting list', 'O', 'messages', '2011-01-13 17:49:56.156', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1944, 'Entity/Constants/notNotifiedParticipant', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unnotified people', 'O', 'messages', '2011-01-13 17:49:56.172', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1945, 'Entity/Constants/sendNotificationToSelectedParticipantNow', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send notifications now', 'O', 'messages', '2011-01-13 17:49:56.176', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1946, 'Entity/Constants/parentNetworks', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent places', 'O', 'messages', '2010-12-14 13:24:21.626', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1947, 'Entity/Constants/preview', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:49:56.204', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1948, 'Entity/Constants/boxBorders', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Borders heading box', 'O', 'messages', '2011-01-13 17:49:56.224', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1949, 'Entity/Constants/headerBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:49:56.263', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1950, 'Entity/Constants/uploadImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo & Icon', 'O', 'messages', '2011-01-13 17:49:56.095', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1951, 'Entity/Constants/createEntitySuccessfully', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:49:56.107', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1952, 'Entity/Constants/configEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:49:56.114', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1953, 'Entity/Constants/waitlist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Waiting list', 'O', 'messages', '2011-01-13 17:49:56.121', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1954, 'Entity/Constants/logoComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo', 'O', 'messages', '2011-01-13 17:49:56.132', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1955, 'Entity/Constants/componentsLeftColumn', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in left column', 'O', 'messages', '2011-01-13 17:49:56.143', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1956, 'Entity/Constants/linkedEntityPrivacyAssignmentHeader', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who is allowed to assign other elements to this element?', 'O', 'messages', '2011-01-13 17:49:56.362', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1957, 'Entity/Constants/infoWidgetComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:49:55.726', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1958, 'Entity/Constants/invitingByAllMebers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members', 'O', 'messages', '2011-01-13 17:49:56.087', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1959, 'Entity/Constants/invitingByAdminOnly', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin/co-admins', 'O', 'messages', '2011-01-13 17:49:56.091', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1960, 'Entity/Constants/entityPrivacyHeader', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:56.366', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1961, 'Entity/Constants/acceptChanges', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept changes', 'O', 'messages', '2011-01-13 17:49:56.229', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1962, 'Entity/Constants/successfullySavedEntityDesign', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design saved.', 'O', 'messages', '2011-01-13 17:49:56.233', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1963, 'Entity/Constants/sendInvites', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send invitation', 'O', 'messages', '2011-01-13 17:49:56.423', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1964, 'Entity/Constants/entityNotVisibleTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity privacy settings', 'O', 'messages', '2011-01-13 17:49:56.345', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1965, 'Entity/Constants/enterNameOfEntityHere', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of entity', 'O', 'messages', '2011-01-13 17:49:56.37', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1966, 'Entity/Constants/textOnBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Text', 'O', 'messages', '2011-01-13 17:49:56.303', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1967, 'Entity/Constants/linksOnBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Links', 'O', 'messages', '2011-01-13 17:49:56.307', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1968, 'Entity/Constants/invitationPopupMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation', 'O', 'messages', '2011-01-13 17:49:56.432', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1969, 'Entity/Constants/buttonText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button: Text', 'O', 'messages', '2011-01-13 17:49:56.318', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1970, 'Entity/Constants/admin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:47:59.572', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1971, 'Entity/Constants/addElement/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add element', 'O', 'messages', '2011-01-13 17:48:00.414', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1972, 'Entity/Constants/headerText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Text', 'O', 'messages', '2011-01-13 17:49:56.265', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1973, 'Entity/Constants/headerLinks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Links', 'O', 'messages', '2011-01-13 17:49:56.267', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1974, 'Entity/Constants/headingBoxBorder', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Border', 'O', 'messages', '2011-01-13 17:49:56.275', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1975, 'Entity/Constants/subBox', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:49:56.277', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1976, 'Entity/Constants/subBoxText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Text', 'O', 'messages', '2011-01-13 17:49:56.279', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1977, 'Entity/Constants/subBoxBorder', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Border', 'O', 'messages', '2011-01-13 17:49:56.287', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1978, 'Entity/Constants/innerBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background inside', 'O', 'messages', '2011-01-13 17:49:56.299', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1979, 'Entity/Constants/lineOnBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Separator line', 'O', 'messages', '2011-01-13 17:49:56.31', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1980, 'Entity/Constants/buttonBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button', 'O', 'messages', '2011-01-13 17:49:56.314', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1981, 'Entity/Constants/borderTop', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (top)', 'O', 'messages', '2011-01-13 17:49:56.322', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1982, 'Entity/Constants/borderLeft', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (left)', 'O', 'messages', '2011-01-13 17:49:56.33', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1983, 'Entity/Constants/borderRight', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (right)', 'O', 'messages', '2011-01-13 17:49:56.334', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1984, 'Entity/Constants/linkedEntityPrivacyStatusAnybody', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anybody', 'O', 'messages', '2011-01-13 17:49:56.349', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1985, 'Entity/Constants/country/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Country', 'O', 'messages', '2011-01-13 17:48:00.432', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1986, 'Entity/Constants/linkedEntityPrivacyStatusAdminAndMembers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins and members', 'O', 'messages', '2011-01-13 17:49:56.353', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1987, 'Entity/Constants/linkedEntityPrivacyStatusAdminOnly', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins', 'O', 'messages', '2011-01-13 17:49:56.357', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1988, 'Entity/Constants/deleteElement', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:49:56.378', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1989, 'Entity/Constants/onlyEntitiesWhereYouAreAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You must be admin of this entity', 'O', 'messages', '2011-01-13 17:49:56.42', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1990, 'Entity/Constants/invitationPopupList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:49:56.435', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1991, 'Entity/Constants/invitationPopupShowInviteMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:49:56.439', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1992, 'Entity/Constants/subdomain/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subdomain', 'O', 'messages', '2011-01-13 17:47:59.56', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1993, 'Entity/Constants/invitationPopupHideInviteMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove', 'O', 'messages', '2011-01-13 17:49:56.443', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1994, 'Entity/Messages/mailSubjectWaitList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on waiting list', 'O', 'messages', '2011-01-13 17:49:56.919', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1995, 'Entity/Constants/inviteAllMyContacts', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite all my contacts', 'O', 'messages', '2011-01-13 17:49:56.463', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1996, 'Entity/Constants/inviteMyContactsButtonText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite my contacts', 'O', 'messages', '2011-01-13 17:49:56.467', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1997, 'Entity/Constants/enterEmailsHere', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter e-mail address', 'O', 'messages', '2011-01-13 17:49:56.471', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1998, 'Entity/Constants/addEmails', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:49:56.48', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (1999, 'Entity/Constants/header/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:48:00.425', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2000, 'Entity/Constants/errorAcceptingJoinRequest', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting join request.', 'O', 'messages', '2011-01-13 17:49:56.504', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2001, 'Entity/Constants/horizontalNavigationRestoreDefault', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore default', 'O', 'messages', '2011-01-13 17:49:56.547', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2002, 'Entity/Constants/inviteMessage/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:59.561', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2003, 'Entity/Constants/deleteCoAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:59.574', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2004, 'Entity/Constants/member/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member', 'O', 'messages', '2011-01-13 17:48:00.429', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2005, 'Entity/Constants/childEntities/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Projects', 'O', 'messages', '2011-01-13 17:47:59.411', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2006, 'Entity/Constants/cancel/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:48:00.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2007, 'Entity/Constants/errorDecliningJoinRequest', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining join request.', 'O', 'messages', '2011-01-13 17:49:56.508', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2008, 'Entity/Constants/horizontalNavigationCancel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:49:56.551', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2009, 'Entity/Constants/followedEmailsAreInvalid', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Following e-mails are invalid', 'O', 'messages', '2011-01-13 17:49:56.483', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2010, 'Entity/Constants/errorAcceptingInvitation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting invitation.', 'O', 'messages', '2011-01-13 17:49:56.496', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2011, 'Entity/Constants/errorDecliningInvitation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining invitation.', 'O', 'messages', '2011-01-13 17:49:56.5', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2012, 'Entity/Constants/horizontalNavigationSave', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:49:56.555', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2013, 'Entity/Messages/attentionXWillBecomeAdminAndYouWillBecomeCoAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Warning: If you give {0} the admin status, you will become co-admin. Only {0} can give you an admin status again.', 'O', 'messages', '2011-01-13 17:49:56.899', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2014, 'Entity/Constants/thisEntityAndSubItems', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity and subitems', 'O', 'messages', '2011-01-13 17:49:56.54', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2015, 'Entity/Messages/mailSubjectRejectorList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have declined your participation', 'O', 'messages', '2011-01-13 17:49:56.931', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2016, 'Entity/Messages/xInvitationSkiped', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people were skipped, since they already received an invitation earlier.', 'O', 'messages', '2011-01-13 17:49:56.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2017, 'Entity/Constants/createEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create project', 'O', 'messages', '2011-01-13 17:47:59.533', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2018, 'Entity/Constants/privacySettings/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:59.565', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2019, 'Entity/Constants/admins/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:59.576', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2020, 'Entity/Constants/coAdmins/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admins', 'O', 'messages', '2011-01-13 17:47:59.619', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2021, 'Entity/Constants/thisEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity', 'O', 'messages', '2011-01-13 17:49:56.543', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2022, 'Entity/Constants/tags/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:47:59.545', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2023, 'Entity/Constants/phone/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Phone', 'O', 'messages', '2011-01-13 17:47:59.569', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2024, 'Entity/Constants/address/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:48:00.418', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2025, 'Entity/Constants/invitePerson/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite person', 'O', 'messages', '2011-01-13 17:47:59.571', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2026, 'Entity/Constants/state/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'State', 'O', 'messages', '2011-01-13 17:48:00.421', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2027, 'Entity/Constants/horizontalNavigationEnterTitleAndLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter link name and link target', 'O', 'messages', '2011-01-13 17:49:56.559', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2028, 'Entity/Messages/subjectTextExternalInvite', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invites you to entity "{1}"!', 'O', 'messages', '2011-01-13 17:49:56.883', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2029, 'Entity/Messages/minimumBannerHeight', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The header graphic needs to be at least {0} px in height.', 'O', 'messages', '2011-01-13 17:49:56.891', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2030, 'Entity/Constants/backToOverview/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To project', 'O', 'messages', '2011-01-13 17:47:59.693', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2031, 'Entity/Constants/headingBox/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading boxes', 'O', 'messages', '2011-01-13 17:47:59.628', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2032, 'Entity/Constants/parentGroups/Publication', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent groups', 'O', 'messages', '2010-12-14 13:23:13.861', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2033, 'Entity/Constants/tagsSeparatorHint/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma', 'O', 'messages', '2011-01-13 17:47:59.705', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2034, 'Entity/Constants/parentAppointments/Publication', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent events', 'O', 'messages', '2010-12-14 13:23:13.954', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2035, 'Entity/Constants/parentWikis/Publication', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent wiki pages', 'O', 'messages', '2010-12-14 13:23:13.978', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2036, 'Entity/Constants/parents/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Parents', 'O', 'messages', '2011-01-13 17:47:59.5', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2037, 'Entity/Constants/closingDate/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline', 'O', 'messages', '2011-01-13 17:47:59.551', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2038, 'Entity/Constants/googleMapAPIKey/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Google Maps-API key', 'O', 'messages', '2011-01-13 17:47:59.716', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2039, 'Entity/Messages/userXWillBeRemoveAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified. The admin status will remain unchanged.', 'O', 'messages', '2011-01-13 17:49:56.903', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2040, 'Entity/Constants/fax/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:47:59.655', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2041, 'Entity/Constants/deleteLogo/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete logo', 'O', 'messages', '2011-01-13 17:47:59.594', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2042, 'Entity/Constants/timezone/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:47:59.539', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2043, 'Entity/Constants/email/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:47:59.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2044, 'Entity/Constants/invitingRule/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:59.597', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2045, 'Entity/Constants/description/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:48:00.443', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2046, 'Entity/Constants/zipcode/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:47:59.635', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2047, 'Entity/Constants/navigationSeparator/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:47:59.64', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2048, 'Entity/Constants/office/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Office', 'O', 'messages', '2011-01-13 17:47:59.652', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2049, 'Entity/Constants/contactName/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:47:59.659', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2050, 'Entity/Constants/participantUnlimited/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unlimited number of participants', 'O', 'messages', '2011-01-13 17:47:59.683', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2051, 'Entity/Constants/saveEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:59.698', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2052, 'Entity/Messages/maximumXRecipientsAllowed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only {0} recipients allowed at a time.', 'O', 'messages', '2011-01-13 17:49:56.971', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2053, 'Entity/Messages/doRealyWantToDeleteCoAdminX', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove {0} from co-admins?', 'O', 'messages', '2011-01-13 17:49:56.915', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2054, 'Entity/Constants/hideAddressData/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:47:59.709', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2055, 'Entity/Messages/inviteToEntityX', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite to entity {0}', 'O', 'messages', '2011-01-13 17:49:56.967', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2056, 'Entity/Constants/deleteEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:59.557', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2057, 'Entity/Messages/xExternalInviationWasSent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people without platform account.', 'O', 'messages', '2011-01-13 17:49:56.975', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2058, 'Entity/Constants/requests/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Requests', 'O', 'messages', '2011-01-13 17:48:00.439', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2059, 'Entity/Constants/invited/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invited', 'O', 'messages', '2011-01-13 17:47:59.567', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2060, 'Entity/Constants/participants/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:47:59.633', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2061, 'Entity/Constants/website/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:47:59.638', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2062, 'Entity/Constants/participantLimitedTo/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Limit participants to', 'O', 'messages', '2011-01-13 17:47:59.686', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2063, 'Entity/Messages/defineNotMoreThanEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do not define more than {0} entity(ies).', 'O', 'messages', '2011-01-13 17:49:56.951', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2064, 'Entity/Messages/xInvitesToEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invited you to the following entity', 'O', 'messages', '2011-01-13 17:49:56.991', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2065, 'Entity/Constants/waitlist/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Waiting list', 'O', 'messages', '2011-01-13 17:47:59.835', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2066, 'Entity/Constants/visibilityRule/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visibility of content', 'O', 'messages', '2011-01-13 17:47:59.768', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2067, 'Entity/Constants/deleteFromMemberList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:59.875', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2068, 'Entity/Constants/toWaitlist/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in waiting list', 'O', 'messages', '2011-01-13 17:47:59.878', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2069, 'Entity/Constants/saveEntitySuccessfully/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:47:59.817', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2070, 'Entity/Constants/toPerticipantList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in participant list', 'O', 'messages', '2011-01-13 17:47:59.882', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2071, 'Entity/Constants/noNotfiedParticipantSelected/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No persons for notification selected.', 'O', 'messages', '2011-01-13 17:47:59.885', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2072, 'Entity/Constants/notifcationMailsWasSentToSelectedParticipant/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Notifications sent.', 'O', 'messages', '2011-01-13 17:47:59.889', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2073, 'Entity/Constants/notNotifiedParticipant/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'People unnotified', 'O', 'messages', '2011-01-13 17:47:59.892', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2074, 'Entity/Constants/sendNotificationToSelectedParticipantNow/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send notifications now', 'O', 'messages', '2011-01-13 17:47:59.906', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2075, 'Entity/Constants/uploadIcon/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload icon', 'O', 'messages', '2011-01-13 17:47:59.92', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2076, 'Entity/Constants/colorDesign/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design', 'O', 'messages', '2011-01-13 17:47:59.924', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2077, '/Comments/Constants/sureToDelete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Are you sure you want to delete this comment?', 'O', 'messages', '2011-01-13 17:49:57.077', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2078, '/Comments/Constants/writeAComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Write a comment...', 'O', 'messages', '2011-01-13 17:49:57.081', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2079, 'Entity/Constants/leaveEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave', 'O', 'messages', '2011-01-13 17:47:59.589', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2080, 'Entity/Constants/acceptInvite/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:59.6', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2081, 'Entity/Constants/acceptJoinRequest/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:59.603', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2082, 'Entity/Constants/declineInvite/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:59.613', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2083, 'Entity/Constants/declineJoinRequest/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:47:59.616', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2084, 'Entity/Constants/coAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-admin', 'O', 'messages', '2011-01-13 17:47:59.643', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2085, 'Entity/Constants/joiningByRequestOrInviteOnly/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only by request or invitation', 'O', 'messages', '2011-01-13 17:47:59.799', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2086, 'Entity/Constants/googleMapAPIKeyHelpLink/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Help', 'O', 'messages', '2011-01-13 17:47:59.719', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2087, 'Entity/Constants/visibleForAll/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For the whole internet', 'O', 'messages', '2011-01-13 17:47:59.776', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2088, 'Entity/Constants/inviteToEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:59.832', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2089, 'Entity/Constants/invitingByAllMebers/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members', 'O', 'messages', '2011-01-13 17:47:59.803', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2090, 'Entity/Constants/invitingByAdminOnly/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin/co-admins', 'O', 'messages', '2011-01-13 17:47:59.806', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2091, 'Entity/Constants/configComponents/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules', 'O', 'messages', '2011-01-13 17:47:59.814', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2092, 'Entity/Constants/removeJoinEntityRequest/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove join request', 'O', 'messages', '2011-01-13 17:47:59.825', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2093, 'Entity/Constants/rejection/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation rejected', 'O', 'messages', '2011-01-13 17:47:59.839', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2094, 'Entity/Constants/optionsComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Options', 'O', 'messages', '2011-01-13 17:47:59.846', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2095, 'Entity/Constants/logoComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo', 'O', 'messages', '2011-01-13 17:47:59.853', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2096, 'Entity/Constants/adminListComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:59.86', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2097, 'Entity/Constants/rulesComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:59.864', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2098, 'Entity/Constants/componentsLeftColumn/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in left column', 'O', 'messages', '2011-01-13 17:47:59.867', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2099, 'Entity/Constants/privacyRules/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:59.758', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2100, 'Entity/Constants/successfullySavedEntityDesign/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design saved.', 'O', 'messages', '2011-01-13 17:47:59.945', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2101, 'Entity/Constants/headerText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Text', 'O', 'messages', '2011-01-13 17:47:59.979', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2102, 'Entity/Constants/buttonText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Text on buttons', 'O', 'messages', '2011-01-13 17:48:00.037', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2103, 'Entity/Constants/borderTop/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (top)', 'O', 'messages', '2011-01-13 17:48:00.04', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2104, 'Entity/Constants/innerBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background inside', 'O', 'messages', '2011-01-13 17:48:00.019', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2105, 'Entity/Constants/borderRight/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (right)', 'O', 'messages', '2011-01-13 17:48:00.051', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2106, 'Entity/Constants/linkedEntityPrivacyStatusAnybody/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anybody', 'O', 'messages', '2011-01-13 17:48:00.076', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2107, 'Entity/Constants/linkedEntityPrivacyStatusAdminAndMembers/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins and members', 'O', 'messages', '2011-01-13 17:48:00.079', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2108, 'Entity/Constants/linkedEntityPrivacyStatusAdminOnly/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins', 'O', 'messages', '2011-01-13 17:48:00.083', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2109, 'Entity/Constants/entityPrivacyHeader/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:48:00.092', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2110, 'Entity/Constants/deleteElement/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:48:00.096', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2111, 'Entity/Constants/entityWasSelectedError/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:48:00.099', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2112, 'Entity/Constants/duplicateEntitySelectionErrorOccur/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:48:00.103', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2113, 'Entity/Constants/headerBorder/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Border', 'O', 'messages', '2011-01-13 17:47:59.987', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2114, 'Entity/Constants/invitationPopupPleaseSelectPersonToInvite/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No person selected, no one to invite.', 'O', 'messages', '2011-01-13 17:48:00.143', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2115, 'Entity/Constants/invitationPopupNoPersonsFound/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No people found, nothing to insert.', 'O', 'messages', '2011-01-13 17:48:00.15', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2116, 'Entity/Constants/inviteAllMyContacts/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite all my contacts', 'O', 'messages', '2011-01-13 17:48:00.157', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2117, 'Entity/Messages/xWantJoinEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wants to join the following entity.', 'O', 'messages', '2011-01-13 17:49:57.004', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2118, 'Entity/Constants/externalURL/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External URL', 'O', 'messages', '2011-01-13 17:47:59.748', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2273, '/Basic/Constants/login', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Login', 'O', 'messages', '2011-01-13 17:47:54.872', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2119, 'Entity/Constants/visibleForMember/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members', 'O', 'messages', '2011-01-13 17:47:59.785', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2120, 'Entity/Constants/joiningForAll/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Users with and without platform account', 'O', 'messages', '2011-01-13 17:47:59.788', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2121, 'Entity/Constants/navigation/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation', 'O', 'messages', '2011-01-13 17:47:59.953', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2122, 'Entity/Constants/createEntitySuccessfully/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:47:59.821', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2123, 'Entity/Constants/configEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:47:59.828', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2124, 'Entity/Constants/subBox/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:47:59.997', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2125, 'Entity/Constants/headingBoxText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Text and links', 'O', 'messages', '2011-01-13 17:47:59.99', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2126, 'Entity/Constants/acceptChanges/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept changes', 'O', 'messages', '2011-01-13 17:47:59.942', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2127, 'Entity/Constants/headingBoxBorder/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Border', 'O', 'messages', '2011-01-13 17:47:59.994', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2128, 'Entity/Constants/headerLinks/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Links', 'O', 'messages', '2011-01-13 17:47:59.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2129, 'Entity/Constants/subBoxLinks/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Links', 'O', 'messages', '2011-01-13 17:48:00.004', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2130, 'Entity/Constants/subBoxText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Text', 'O', 'messages', '2011-01-13 17:48:00.001', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2131, 'Entity/Constants/subBoxBorder/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Border', 'O', 'messages', '2011-01-13 17:48:00.008', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2132, 'Entity/Constants/parentEntityRequiredError/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please assign this project to at least one element', 'O', 'messages', '2011-01-13 17:48:00.107', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2133, 'Entity/Constants/subBoxLine/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Separator line', 'O', 'messages', '2011-01-13 17:48:00.012', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2134, 'Entity/Constants/outerBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background outside', 'O', 'messages', '2011-01-13 17:48:00.015', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2135, 'Entity/Constants/borderLeft/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (left)', 'O', 'messages', '2011-01-13 17:48:00.047', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2136, 'Entity/Constants/linksOnBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Links', 'O', 'messages', '2011-01-13 17:48:00.026', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2137, 'Entity/Constants/lineOnBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Separator line', 'O', 'messages', '2011-01-13 17:48:00.029', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2138, 'Entity/Constants/invitationPopupShowInviteMessage/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:48:00.135', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2139, 'Entity/Constants/invitationPopupHideInviteMessage/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove (delete)', 'O', 'messages', '2011-01-13 17:48:00.139', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2140, 'Entity/Constants/horizontalNavigationSave/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:48:00.227', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2141, 'Entity/Constants/horizontalNavigationEnterTitleAndLink/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter link name and link target', 'O', 'messages', '2011-01-13 17:48:00.231', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2142, 'Entity/Constants/horizontalNavigationSuccessfullySaved/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation saved.', 'O', 'messages', '2011-01-13 17:48:00.234', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2143, 'Entity/Constants/horizontalNavigationEdit/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:48:00.238', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2144, 'Entity/Messages/needToDefineMinEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You have to define {0} project(s) as minimum.', 'O', 'messages', '2011-01-13 17:48:00.471', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2145, 'Entity/Messages/defineNotMoreThanEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do not define more than {0} project(s).', 'O', 'messages', '2011-01-13 17:48:00.475', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2146, 'Entity/Messages/inviteToEntityX/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite to project {0}', 'O', 'messages', '2011-01-13 17:48:00.48', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2147, 'Entity/Messages/entityInvitationsCount/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Project invitations ({0})', 'O', 'messages', '2011-01-13 17:48:00.485', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2148, 'Entity/Messages/mailSubjectRejectorList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have declined your participation', 'O', 'messages', '2011-01-13 17:48:00.573', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2149, 'Entity/Messages/mailSubjectRequesterList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have requested for participation', 'O', 'messages', '2011-01-13 17:48:00.576', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2150, 'Entity/Constants/deleteNotPossibleAssigmentAvailable/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deleting not possible. There are still assigned elements', 'O', 'messages', '2011-01-13 17:47:57.572', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2151, 'Entity/Constants/toggleColorAdjustments/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Advanced settings (optional)', 'O', 'messages', '2011-01-13 17:47:59.934', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2152, 'Entity/Constants/boxBorders/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Borders heading box', 'O', 'messages', '2011-01-13 17:47:59.938', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2153, 'Entity/Constants/pageBorders/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation and site: Border', 'O', 'messages', '2011-01-13 17:47:59.961', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2154, 'Entity/Constants/horizontalNavigationBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation', 'O', 'messages', '2011-01-13 17:47:59.969', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2155, 'Entity/Constants/headerBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:47:59.976', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2156, 'Entity/Constants/selectASuggestedEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection not found. Please select a suggested entity.', 'O', 'messages', '2011-01-13 17:48:00.111', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2157, 'Entity/Constants/invitationPopupSelection/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection', 'O', 'messages', '2011-01-13 17:48:00.125', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2158, 'Entity/Constants/invitationPopupMessage/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:48:00.128', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2159, 'Entity/Constants/invitationPopupList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List', 'O', 'messages', '2011-01-13 17:48:00.132', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2160, 'Entity/Constants/invitationPopupNoPersonsInserted/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No one added, everyone is already in your list.', 'O', 'messages', '2011-01-13 17:48:00.146', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2161, 'Entity/Constants/inviteViaEmail/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite via e-mail', 'O', 'messages', '2011-01-13 17:48:00.153', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2162, 'Entity/Constants/inviteMyContactsButtonText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite my contacts', 'O', 'messages', '2011-01-13 17:48:00.161', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2163, 'Entity/Constants/enterEmailsHere/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter e-mail address', 'O', 'messages', '2011-01-13 17:48:00.164', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2164, 'Entity/Constants/enterEmailHelpText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma, semicolon, space or return', 'O', 'messages', '2011-01-13 17:48:00.168', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2165, 'Entity/Constants/addEmails/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:48:00.171', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2166, 'Entity/Constants/followedEmailsAreInvalid/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Following e-mails are invalid', 'O', 'messages', '2011-01-13 17:48:00.175', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2167, 'Entity/Constants/errorAcceptingInvitation/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting invitation.', 'O', 'messages', '2011-01-13 17:48:00.185', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2168, 'Entity/Constants/errorDecliningInvitation/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining invitation.', 'O', 'messages', '2011-01-13 17:48:00.189', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2169, 'Entity/Constants/errorAcceptingJoinRequest/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting join request.', 'O', 'messages', '2011-01-13 17:48:00.193', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2170, 'Entity/Constants/errorDecliningJoinRequest/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining join request.', 'O', 'messages', '2011-01-13 17:48:00.196', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2171, 'Entity/Constants/horizontalNavigationRestoreDefault/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore default', 'O', 'messages', '2011-01-13 17:48:00.22', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2172, 'Entity/Constants/horizontalNavigationCancel/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:48:00.224', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2173, 'Entity/Constants/allEntityMembers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All entity members', 'O', 'messages', '2011-01-13 17:49:55.774', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2174, 'Entity/Messages/subjectTextExternalInvite/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invites you to project "{1}"!', 'O', 'messages', '2011-01-13 17:48:00.515', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2175, 'Entity/Messages/userXWillBeRemove/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified.', 'O', 'messages', '2011-01-13 17:48:00.55', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2176, 'Entity/Messages/maximumXRecipientsAllowed/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only {0} recipients allowed at a time.', 'O', 'messages', '2011-01-13 17:48:00.586', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2177, 'Entity/Messages/mailSubjectWaitList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on waiting list', 'O', 'messages', '2011-01-13 17:48:00.56', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2178, 'Entity/Constants/assignmentOnlyForAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin of this entity', 'O', 'messages', '2011-01-13 17:49:55.865', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2179, 'Entity/Messages/xInternalInviationWasSent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people with platform account.', 'O', 'messages', '2011-01-13 17:48:00.594', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2180, 'Entity/Constants/allEntityMembers/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All group members', 'O', 'messages', '2011-01-13 17:49:57.212', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2181, 'Entity/Messages/xInvitationSkiped/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people were skipped.', 'O', 'messages', '2011-01-13 17:48:00.599', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2182, 'Basic/Constants/absenden', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send', 'O', 'messages', '2011-01-13 17:47:51.431', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2183, 'Entity/Constants/baseDataComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic data', 'O', 'messages', '2011-01-13 17:47:55.663', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2184, 'Entity/Constants/city', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City/town', 'O', 'messages', '2011-01-13 17:49:55.883', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2185, 'Entity/Constants/city/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City/town', 'O', 'messages', '2011-01-13 17:49:57.463', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2186, 'Basic/Constants/addSchool', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:51.392', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2187, 'Basic/Constants/bearbeiten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:47:50.908', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2188, 'Entity/Messages/xInvitesToEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invited you to the following project', 'O', 'messages', '2011-01-13 17:48:00.606', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2189, 'Entity/Constants/borderBottom/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (bottom)', 'O', 'messages', '2011-01-13 17:47:55.815', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2190, 'Basic/Constants/allKaiooUsers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All users', 'O', 'messages', '2011-01-13 17:47:50.974', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2191, 'Entity/Messages/doRealyWantToDeleteCoAdminX/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove {0} from co-admins?', 'O', 'messages', '2011-01-13 17:48:00.557', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2192, 'Entity/Messages/xExternalInviationWasSent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people without platform account.', 'O', 'messages', '2011-01-13 17:48:00.59', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2193, 'Entity/Constants/deleteNotPossibleAssigmentAvailable/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deleting not possible. There are still assigned elements', 'O', 'messages', '2011-01-13 17:47:55.995', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2194, 'Entity/Constants/assignmentOnlyForAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin', 'O', 'messages', '2011-01-13 17:47:56.928', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2195, 'Entity/Constants/allEntityMembers/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All event members', 'O', 'messages', '2011-01-13 17:47:56.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2196, 'Entity/Constants/borderBottom/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (bottom)', 'O', 'messages', '2011-01-13 17:48:00.044', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2197, 'Entity/Constants/baseDataComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic data', 'O', 'messages', '2011-01-13 17:47:57.207', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2198, 'Entity/Constants/invalidEntitySelectionOccur/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'One or more of your selection is invalid.', 'O', 'messages', '2011-01-13 17:47:55.88', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2199, 'Entity/Constants/borderBottom/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (bottom)', 'O', 'messages', '2011-01-13 17:47:57.408', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2200, 'Entity/Constants/baseDataComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic data', 'O', 'messages', '2011-01-13 17:47:59.843', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2201, 'Entity/Constants/currentIcon/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current icon', 'O', 'messages', '2011-01-13 17:47:59.917', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2202, 'Entity/Constants/invalidEntitySelectionOccur/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'One or more of your selection is invalid.', 'O', 'messages', '2011-01-13 17:48:00.114', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2203, 'Entity/Constants/sendInvites/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send invitation', 'O', 'messages', '2011-01-13 17:48:00.121', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2204, 'Entity/Messages/userXWillBeRemoveAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified. The admin status will remain unchanged.', 'O', 'messages', '2011-01-13 17:48:00.546', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2205, 'Entity/Messages/minimumBannerHeight/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The header graphic needs to be at least {0} px in height.', 'O', 'messages', '2011-01-13 17:48:00.524', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2206, 'Entity/Messages/entityJoinRequestCount/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Project join requests ({0})', 'O', 'messages', '2011-01-13 17:48:00.489', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2207, 'Entity/Messages/mailSubjectInvitedList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation for project ''''{0}''''', 'O', 'messages', '2011-01-13 17:48:00.567', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2208, 'Entity/Constants/externalDomainInUse/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External domain already in use', 'O', 'messages', '2011-01-13 17:47:57.101', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2209, 'Entity/Mails/invitationExternal/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$INVITER.Firstname $INVITER.Surname invites you to event "$ENTITY.Name".

$MESSAGE

Register here for "$ENTITY.Name":
$INVITATION_URI', 'O', 'messages', '2011-01-13 17:48:02.57', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2210, 'Entity/Constants/horizontalNavigationEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:49:56.566', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2211, 'Entity/Constants/allEntityMembers/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All project members', 'O', 'messages', '2011-01-13 17:47:59.402', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2212, 'Entity/Constants/childEntities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Child entities', 'O', 'messages', '2011-01-13 17:49:55.844', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2213, 'Entity/Constants/baseDataComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic data', 'O', 'messages', '2011-01-13 17:49:57.708', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2214, 'Entity/Constants/deleteNotPossibleAssigmentAvailable/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deleting not possible. There are still assigned elements', 'O', 'messages', '2011-01-13 17:49:58.12', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2215, 'Basic/Constants/currently', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'currently', 'O', 'messages', '2011-01-13 17:47:51.567', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2216, 'Entity/Messages/externalURLPopupText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>You must set the so called "CNAME" (also called "canonical name") at your domain provider.</p><p>A corresponding function should exist in the maintenance-menu of your domain provider. Make the CNAME-entry point to the name of your project at {0}.</p><p>This should look like this:</p><p><b>www.mydomain.com >> CNAME >> www.{1}.{0}</b></p>', 'O', 'messages', '2011-01-13 17:48:00.535', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2217, 'Basic/Constants/add', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:51.688', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2218, 'Entity/Constants/assignmentOnlyForAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin', 'O', 'messages', '2011-01-13 17:47:59.623', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2219, 'Basic/Constants/activate', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activate', 'O', 'messages', '2011-01-13 17:47:51.724', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2220, 'Basic/Messages/hideVideoLinkCommentx', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} comments | hide', 'O', 'messages', '2011-01-13 17:47:51.916', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2221, 'Forum/Messages/hits', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} hits', 'O', 'messages', '2011-01-13 17:47:52.313', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2222, 'DateAndTime/Constants/today', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Today', 'O', 'messages', '2011-01-13 17:47:53.851', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2223, 'Document/Constants/file', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'File', 'O', 'messages', '2011-01-13 17:47:54.432', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2224, 'Entity/Constants/city/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City/town', 'O', 'messages', '2011-01-13 17:47:58.317', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2225, 'Entity/Constants/deleteNotPossibleAssigmentAvailable/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deleting not possible. There are still assigned elements', 'O', 'messages', '2011-01-13 17:47:58.898', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2226, 'Entity/Constants/onlyEntitiesWhereYouAreAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You must be admin of this project', 'O', 'messages', '2011-01-13 17:47:59.433', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2227, 'Entity/Constants/deleteNotPossibleAssigmentAvailable/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deleting not possible. There are still assigned elements', 'O', 'messages', '2011-01-13 17:48:00.2', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2228, 'Entity/Constants/allEntityMembers/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All wiki page members', 'O', 'messages', '2011-01-13 17:47:58.054', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2229, 'Entity/Messages/xWantJoinEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wants to join the following project.', 'O', 'messages', '2011-01-13 17:48:00.611', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2230, 'Entity/Constants/baseDataComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic data', 'O', 'messages', '2011-01-13 17:49:56.126', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2231, 'Entity/Constants/ifNoHeader', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you do not upload any header, the place name will appear instead. Best are headers of exactly 783 pixels width and about 80 pixels height. If your header''s width is greater, it will be scaled to fit.', 'O', 'messages', '2011-01-13 17:49:56.237', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2232, 'Entity/Mails/invitationExternal/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$INVITER.Firstname $INVITER.Surname invites you to  group "$ENTITY.Name".

$MESSAGE

Register here for "$ENTITY.Name":
$INVITATION_URI', 'O', 'messages', '2011-01-13 17:48:02.469', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2233, 'Entity/Constants/borderBottom', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (bottom)', 'O', 'messages', '2011-01-13 17:49:56.326', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2234, 'Entity/Constants/enterEmailHelpText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma, semicolon, space or return', 'O', 'messages', '2011-01-13 17:49:56.475', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2235, 'Entity/Constants/alsoAttendTo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also attend to:', 'O', 'messages', '2011-01-13 17:49:56.691', NULL, '2010-09-23 01:58:33.900245');
INSERT INTO base_property VALUES (2236, 'Entity/Constants/youHadAttended', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated', 'O', 'messages', '2011-01-13 17:49:56.598', NULL, '2010-08-06 17:22:00.516102');
INSERT INTO base_property VALUES (2237, 'Entity/Constants/assignmentOnlyForAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin', 'O', 'messages', '2011-01-13 17:49:57.442', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2238, 'Entity/Constants/borderBottom/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (bottom)', 'O', 'messages', '2011-01-13 17:49:57.958', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2239, 'Entity/Constants/assignmentOnlyForAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin', 'O', 'messages', '2011-01-13 17:47:58.289', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2240, 'Entity/Constants/borderBottom/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Border (bottom)', 'O', 'messages', '2011-01-13 17:47:58.74', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2241, 'Basic/Constants/minutes', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'min', 'O', 'messages', '2011-01-13 17:47:51.746', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2242, 'Basic/Constants/lieblingszitate', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favorite quotes', 'O', 'messages', '2011-01-13 17:47:51.545', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2243, 'Entity/Constants/navigationSeparatorText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator: Text', 'O', 'messages', '2011-01-13 17:47:57.329', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2244, '/Basic/Constants/description', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:47:55.174', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2245, 'Entity/Constants/recursiveAssigmentOccur/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning this element will cause a recursive assignment. Assigning this element is not possible.', 'O', 'messages', '2011-01-13 17:47:55.884', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2246, 'Basic/Constants/youWillRecieveEmailFromUs', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will receive an e-mail that contains a link to reset your password shortly. If you do not receive the e-mail, check your SPAM folder.', 'O', 'messages', '2011-01-13 17:47:50.622', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2247, 'Groups/Constants/invitedMember', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Invited contacts (not confirmed yet)', 'O', 'messages', '2010-09-02 16:34:52.975', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2248, 'Basic/Constants/selectAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select all', 'O', 'messages', '2011-01-13 17:47:51.732', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2249, 'Entity/Constants/deleteNotPossibleAssigmentAvailable', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deleting not possible. There are still assigned elements', 'O', 'messages', '2011-01-13 17:49:56.519', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2250, 'Basic/Constants/sendPwdTo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email that you used for registration', 'O', 'messages', '2011-01-13 17:47:50.556', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2251, 'Basic/Constants/resendActivationMailSuccess', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will shortly receive an e-mail containing your activation link. If you do not find it in your inbox, please also check your SPAM folder.', 'O', 'messages', '2011-01-13 17:47:50.817', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2252, 'Album/Constants/albumDescription', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:47:52.791', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2253, 'Forum/Constants/alleThemen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:52.274', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2254, 'Basic/Constants/loginRegister', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Login/register', 'O', 'messages', '2011-01-13 17:47:51.022', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2255, 'Basic/Constants/newsletterDeactivated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The newsletter functionality has been deactivated by the platform admin', 'O', 'messages', '2011-01-13 17:47:51.257', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2256, 'Basic/Constants/sinceLogin', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Since last login', 'O', 'messages', '2010-10-22 17:52:24.717', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2257, 'Basic/Constants/ungueltigeEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The e-mail address is not permitted.', 'O', 'messages', '2011-01-13 17:47:51.536', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2258, 'Groups/Constants/adminLeaveGroupAlert', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'If you leave this group, it will be deleted. Leave and delete this group?', 'O', 'messages', '2010-10-06 12:21:37.372', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2259, 'Wiki/Constants/invitedMember', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Invited contacts (not replied yet)', 'O', 'messages', '2010-09-02 16:34:54.532', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2260, 'Wiki/Constants/leaveGroup', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Leave', 'O', 'messages', '2010-09-02 16:34:54.553', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2261, 'Album/Constants/newAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'New album', 'O', 'messages', '2011-01-13 17:47:52.526', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2262, 'Telltale/Messages/terminVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in event -> "{0}" (Id: {1})', 'O', 'messages', '2011-01-13 17:47:52.426', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2263, 'Album/Constants/memberMayEditComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members may upload photos', 'O', 'messages', '2011-01-13 17:47:52.565', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2264, 'Album/Constants/createANewAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a new album', 'O', 'messages', '2011-01-13 17:47:52.619', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2265, 'Search/Constants/selectWikiListOfNetwork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of wiki pages', 'O', 'messages', '2011-01-13 17:47:52.969', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2266, 'Exception/Constants/badPasswordOrUsername', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Username or password invalid.', 'O', 'messages', '2011-01-13 17:47:53.67', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2267, 'Exception/Constants/duplicateEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This e-mail address already exists.', 'O', 'messages', '2011-01-13 17:47:53.776', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2268, 'Document/Constants/theFileMustNotBeEmpty', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The file must not be empty.', 'O', 'messages', '2011-01-13 17:47:54.341', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2269, 'Entity/Constants/invalidEntitySelectionOccur/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'One or more of your selection is invalid.', 'O', 'messages', '2011-01-13 17:47:57.483', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2270, 'Document/Constants/delete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:54.43', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2271, '/Basic/Constants/dateFormat', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'MM/dd/y', 'O', 'messages', '2011-01-13 17:47:54.858', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2272, '/Basic/Constants/logout', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logout', 'O', 'messages', '2011-01-13 17:47:54.884', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2274, 'Basic/Constants/invalidLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h1>Page not found</h1><p><b>This Link is not valid (any more).</b></p>', 'O', 'messages', '2011-01-13 17:47:51.531', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2275, '/Basic/Constants/add', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:47:55.15', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2276, '/Basic/Constants/pleaseEnterURL', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter a valid URL', 'O', 'messages', '2011-01-13 17:47:54.979', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2277, 'Entity/Constants/parents/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Parents', 'O', 'messages', '2011-01-13 17:47:55.392', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2278, 'Entity/Constants/assignmentOnlyForAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin', 'O', 'messages', '2011-01-13 17:47:55.483', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2279, 'Entity/Messages/andSubItems/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} and subitems', 'O', 'messages', '2011-01-13 17:49:58.544', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2280, 'Entity/Constants/assignmentOnlyForAdminOrMember/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin or member', 'O', 'messages', '2011-01-13 17:47:58.285', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2281, 'Entity/Messages/andSubItems/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} and subitems', 'O', 'messages', '2011-01-13 17:47:59.345', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2282, 'Entity/Constants/entity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Project', 'O', 'messages', '2011-01-13 17:47:59.393', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2283, 'Entity/Constants/widgetsShowSubEntitiesOption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:47:59.46', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2284, 'Entity/Constants/parentPublications/Wiki', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent projects', 'O', 'messages', '2010-12-14 13:22:43.341', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2285, 'Entity/Constants/entityClosedNotAcceptingJoinRequestPossibleAnymore/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot accept this request anymore.', 'O', 'messages', '2011-01-13 17:47:58.879', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2286, 'Entity/Constants/invitingByAdminOnly/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin/co-admins', 'O', 'messages', '2011-01-13 17:47:55.632', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2287, 'Entity/Constants/entityNotVisibleText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The content of this entity is not visible for every user. You need to join this entity or get an invitation first.', 'O', 'messages', '2011-01-13 17:47:58.754', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2288, 'Entity/Messages/needToDefineMinEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You have to define {0} group(s) as minimum.', 'O', 'messages', '2011-01-13 17:49:58.397', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2289, 'Entity/Constants/thisEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This wiki page', 'O', 'messages', '2011-01-13 17:47:58.134', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2290, 'Entity/Constants/participantUnlimited/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unlimited number of participants', 'O', 'messages', '2011-01-13 17:47:57.054', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2291, 'WikiEditor/Constants/adminMayEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin may edit', 'O', 'messages', '2011-01-13 17:47:54.585', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2292, 'Entity/Constants/visibleForMemberOfAssociatedEntities/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:55.616', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2293, 'Entity/Constants/horizontalNavigationBackground/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation', 'O', 'messages', '2011-01-13 17:49:57.863', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2294, 'Entity/Constants/parentPublications/Publication', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent projects', 'O', 'messages', '2010-12-14 13:23:14.083', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2295, 'Entity/Constants/navigationSeparatorText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator: Text', 'O', 'messages', '2011-01-13 17:47:55.758', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2296, 'Entity/Constants/timezone/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:47:58.174', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2297, 'Entity/Messages/mailSubjectInvitedList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation for place ''''{0}''''', 'O', 'messages', '2011-01-13 17:47:56.371', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2298, 'Entity/Constants/headingBoxBorder/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Border', 'O', 'messages', '2011-01-13 17:47:57.357', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2299, 'Entity/Constants/privacySettings/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:56.852', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2300, 'Entity/Constants/invitingByAdminOnly/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin/co-admins', 'O', 'messages', '2011-01-13 17:47:57.171', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2301, 'Entity/Constants/parentAppointments/Network', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent events', 'O', 'messages', '2010-12-14 13:22:04.158', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2302, 'Entity/Constants/parentPublications/Group', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent projects', 'O', 'messages', '2010-12-14 13:24:43.19', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2303, 'Entity/Constants/parentPublications/Network', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent projects', 'O', 'messages', '2010-12-14 13:22:04.284', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2304, 'Entity/Constants/entityNotVisibleText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The content of this entity is not visible for every user. You need to join this entity or get an invitation first.', 'O', 'messages', '2011-01-13 17:47:57.422', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2305, 'Entity/Constants/description/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:47:57.82', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2306, 'Entity/Messages/andSubItems/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} and subitems', 'O', 'messages', '2011-01-13 17:47:56.443', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2307, 'Entity/Constants/assignedTypeNotAllowed/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning element of this type is not allowed', 'O', 'messages', '2011-01-13 17:47:58.293', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2308, 'Entity/Constants/showAddressData/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show', 'O', 'messages', '2011-01-13 17:47:59.712', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2309, 'Entity/Constants/parentPublications/Appointment', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent projects', 'O', 'messages', '2010-12-14 13:22:23.602', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2310, 'Entity/Constants/invitingByAdminOnly/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin/co-admins', 'O', 'messages', '2011-01-13 17:47:58.502', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2311, 'Entity/Constants/navigationSeparatorText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator: Text', 'O', 'messages', '2011-01-13 17:47:58.66', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2312, 'Entity/Constants/componentsLeftColumn/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in left column', 'O', 'messages', '2011-01-13 17:47:58.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2313, 'WikiEditor/Constants/headline', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Headline', 'O', 'messages', '2011-01-13 17:47:54.561', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2314, 'Entity/Constants/visibleForWholePlatForm/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:58.468', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2315, 'Entity/Messages/andSubItems/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} and subitems', 'O', 'messages', '2011-01-13 17:48:00.616', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2316, 'Entity/Constants/deleteIcon', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete icon', 'O', 'messages', '2011-01-13 17:49:55.812', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2317, 'Entity/Constants/assignmentOnlyForAdminOrMember', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin or member', 'O', 'messages', '2011-01-13 17:49:55.848', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2318, 'Entity/Constants/externalDomainInUse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External domain already in use', 'O', 'messages', '2011-01-13 17:49:56.011', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2319, 'Entity/Constants/privacyRules', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:56.032', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2320, 'Entity/Constants/visibleForMemberOfAssociatedEntities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of associated entities', 'O', 'messages', '2011-01-13 17:49:56.065', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2321, 'Entity/Mails/entityParticipantList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Now you are member of project "$ENTITY.Name".

Project:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.584', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2322, 'Entity/Constants/componentsRightColumn', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in right column', 'O', 'messages', '2011-01-13 17:49:56.147', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2323, 'Entity/Constants/member', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member', 'O', 'messages', '2011-01-13 17:49:56.802', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2324, 'Entity/Mails/entityWaitList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now on the waiting list of project "$ENTITY.Name".

Project:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.594', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2325, 'Entity/Messages/feedEntityCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the entity {1}', 'O', 'messages', '2011-01-13 17:49:56.859', NULL, '2010-09-23 01:58:34.12729');
INSERT INTO base_property VALUES (2326, 'Entity/Messages/userXWillBeRemove', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified.', 'O', 'messages', '2011-01-13 17:49:56.907', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2327, 'Entity/Constants/participantUnlimited/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unlimited number of participants', 'O', 'messages', '2011-01-13 17:49:57.544', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2328, 'Entity/Constants/randomMembersComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:49:57.737', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2329, 'Entity/Constants/parentGroups/Group', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent groups', 'O', 'messages', '2010-12-14 13:24:42.981', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2330, 'Entity/Constants/navigationSeparatorText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator: Text', 'O', 'messages', '2011-01-13 17:49:57.859', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2331, 'Entity/Messages/andSubItems/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} and subitems', 'O', 'messages', '2011-01-13 17:47:57.988', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2332, 'Entity/Constants/participantSelectedFromWaitlist/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select participants manually from waiting list', 'O', 'messages', '2011-01-13 17:47:59.69', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2333, 'Entity/Constants/currentLogo/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current logo', 'O', 'messages', '2011-01-13 17:47:59.91', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2334, 'Entity/Constants/uploadLogo/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload logo', 'O', 'messages', '2011-01-13 17:47:59.913', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2335, 'Entity/Constants/navigationSeparatorText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator: Text', 'O', 'messages', '2011-01-13 17:47:59.965', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2336, 'Entity/Constants/recursiveAssigmentOccur/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning this element will cause a recursive assignment. Assigning this element is not possible.', 'O', 'messages', '2011-01-13 17:48:00.118', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2337, 'Entity/Constants/parentPublications', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent projects', 'O', 'messages', '2010-12-14 13:24:21.951', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2338, '/Comments/Constants/comment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Comment', 'O', 'messages', '2011-01-13 17:49:57.093', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2339, 'Entity/Constants/subdomainHelpLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'How does this work?', 'O', 'messages', '2011-01-13 17:49:56.016', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2340, 'Basic/Constants/wallMessagesOnlVisibleForMember', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wall entries are visible for logged in members only.', 'O', 'messages', '2011-01-13 17:47:50.272', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2341, 'Network/Constants/foundYourOwnNetwork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create your own place!', 'O', 'messages', '2011-01-13 17:47:52.114', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2342, 'Basic/Constants/ausloggen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logout', 'O', 'messages', '2011-01-13 17:47:50.383', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2343, 'Basic/Constants/newsUntil', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'is displayed until', 'O', 'messages', '2011-01-13 17:47:50.392', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2344, 'Entity/Mails/entityParticipantList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Now you are member of wiki page "$ENTITY.Name".

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.477', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2345, 'Entity/Mails/invitationExternal/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$INVITER.Firstname $INVITER.Surname invites you to project "$ENTITY.Name".

$MESSAGE

Register here for "$ENTITY.Name":
$INVITATION_URI', 'O', 'messages', '2011-01-13 17:48:02.612', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2384, 'Search/Constants/selectProfileList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of profiles', 'O', 'messages', '2011-01-13 17:47:53.004', NULL, '2010-08-06 17:21:21.477236');
INSERT INTO base_property VALUES (2346, 'Entity/Constants/navigationSeparatorText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator: Text', 'O', 'messages', '2011-01-13 17:49:56.254', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2347, 'Entity/Constants/headerBorder', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header: Border', 'O', 'messages', '2011-01-13 17:49:56.269', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2348, 'Entity/Constants/invalidEntitySelectionOccur', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'One or more of your selection is invalid.', 'O', 'messages', '2011-01-13 17:49:56.411', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2349, 'Entity/Constants/widgetsShowSubEntitiesOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:49:56.523', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2350, 'Telltale/Messages/networkNewsViolationReport', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in place news -> "{0}" (place ID: {1}, place-ID: {2})', 'O', 'messages', '2011-01-13 17:47:52.422', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2351, 'Entity/Messages/mailSubjectCoAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Co-Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:49:56.871', NULL, '2010-09-23 01:58:34.131481');
INSERT INTO base_property VALUES (2352, 'Entity/Constants/widgetsDontShowSubEntitiesOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:49:56.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2353, 'Entity/Messages/andSubItems', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} and subitems', 'O', 'messages', '2011-01-13 17:49:57.008', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2354, 'Entity/Constants/parentNetworks/Publication', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent places', 'O', 'messages', '2010-12-14 13:23:13.836', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2355, 'Basic/Constants/allYourNetworksOnOnePlatform', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For your organization', 'O', 'messages', '2011-01-13 17:47:50.319', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2356, 'Album/Constants/enterAlbumName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter an album name', 'O', 'messages', '2011-01-13 17:47:52.817', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2357, 'Album/Messages/wikiGroupMayOnlyContainNImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The upload of your photos failed. A wiki page album may not carry more than {0} photos.', 'O', 'messages', '2011-01-13 17:47:52.913', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2358, 'Basic/Constants/newsSince', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'is displayed from', 'O', 'messages', '2011-01-13 17:47:51.166', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2359, '/Comments/Constants/titleForComponentInfoBoxHeader', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Comments', 'O', 'messages', '2011-01-13 17:49:57.073', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2360, 'Album/Messages/networkMayOnlyContainNImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The upload of your photos failed. A place album may not carry more than {0} photos.', 'O', 'messages', '2011-01-13 17:47:52.919', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2361, 'Entity/Constants/members/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:59.386', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2362, 'Entity/Constants/entityNotVisibleText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The content of this entity is not visible for every user. You need to join this entity or get an invitation first.', 'O', 'messages', '2011-01-13 17:49:56.342', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2363, 'Entity/Constants/recursiveAssigmentOccur', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning this element will cause a recursive assignment. Assigning this element is not possible.', 'O', 'messages', '2011-01-13 17:49:56.415', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2364, 'Entity/Messages/xInternalInviationWasSent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invitations sent to people with platform account.', 'O', 'messages', '2011-01-13 17:49:56.979', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2365, 'Album/Constants/realyWantDeleteComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete comment?', 'O', 'messages', '2011-01-13 17:47:52.636', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2366, 'Basic/Constants/getNewCode', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I cannot read the code. Give me a new one!', 'O', 'messages', '2011-01-13 17:47:51.196', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2367, 'Telltale/Messages/forumThemaVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in forum topic -> "{2}" (forum-ID:{0}, topic-ID:{1}) [author:"{3}" ({4})]', 'O', 'messages', '2011-01-13 17:47:52.351', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2368, 'Basic/Constants/aufKaioo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'xxxasdf', 'O', 'messages', '2011-01-13 17:47:51.109', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2369, 'Search/Constants/selectDocumentListOfNetwork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of documents', 'O', 'messages', '2011-01-13 17:47:53.031', NULL, '2010-08-06 17:21:21.537033');
INSERT INTO base_property VALUES (2370, 'Mail/Constants/photoCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Somebody made a comment on one of your photos.', 'O', 'messages', '2011-01-13 17:47:54.048', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2371, 'Entity/Constants/memberStatus/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:47:57.006', NULL, '2010-08-06 17:21:34.216778');
INSERT INTO base_property VALUES (2372, 'Entity/Constants/participantSelectedFromWaitlist/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select participants manually from waiting list', 'O', 'messages', '2011-01-13 17:47:57.061', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2373, 'Wiki/Constants/grantToAdminWarning', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'If you make another member admin, you will not be admin any more. Do you want to proceed?', 'O', 'messages', '2010-09-02 16:34:54.546', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2374, 'Entity/Constants/youHadNotAttended/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not participate', 'O', 'messages', '2011-01-13 17:47:57.604', NULL, '2010-08-06 17:21:35.716956');
INSERT INTO base_property VALUES (2375, 'Entity/Constants/youAreNotAttend/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You do not participate', 'O', 'messages', '2011-01-13 17:47:57.608', NULL, '2010-08-06 17:21:35.726931');
INSERT INTO base_property VALUES (2376, 'Entity/Constants/youHaveRequestToAttend/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request sent.', 'O', 'messages', '2011-01-13 17:47:57.615', NULL, '2010-08-06 17:21:35.749979');
INSERT INTO base_property VALUES (2377, 'Entity/Constants/youHadAttended/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated', 'O', 'messages', '2011-01-13 17:47:57.618', NULL, '2010-08-06 17:21:35.76693');
INSERT INTO base_property VALUES (2378, 'Entity/Constants/youAreUndecided/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are undecided', 'O', 'messages', '2011-01-13 17:47:58.948', NULL, '2010-08-06 17:21:41.737019');
INSERT INTO base_property VALUES (2379, 'Entity/Constants/myMemberStatusComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attending status', 'O', 'messages', '2011-01-13 17:47:55.669', NULL, '2010-08-06 17:21:32.097272');
INSERT INTO base_property VALUES (2380, 'Exception/Constants/serviceException', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The server reported an error.', 'O', 'messages', '2011-01-13 17:47:53.706', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2381, 'Entity/Constants/parentAppointments/Appointment', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent events', 'O', 'messages', '2010-12-14 13:22:23.492', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2382, 'Search/Constants/selectPublicationListOfNetwork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of projects', 'O', 'messages', '2011-01-13 17:47:52.981', NULL, '2010-08-06 17:21:21.251078');
INSERT INTO base_property VALUES (2383, 'Entity/Constants/parentWikis/Network', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent wiki pages', 'O', 'messages', '2010-12-14 13:22:04.173', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2385, 'Document/Constants/adminMayEditComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the admin may upload documents', 'O', 'messages', '2011-01-13 17:47:54.42', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2386, 'Document/Constants/document', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Documents', 'O', 'messages', '2011-01-13 17:47:54.444', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2387, 'WikiEditor/Messages/backupRestoreMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your changes from {0} {1} were not saved yet.', 'O', 'messages', '2011-01-13 17:47:54.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2388, 'Search/Constants/selectNetworkList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of places', 'O', 'messages', '2011-01-13 17:47:53.022', NULL, '2010-08-06 17:21:21.518804');
INSERT INTO base_property VALUES (2389, '/Basic/Constants/internetAddress', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Internet address', 'O', 'messages', '2011-01-13 17:47:54.991', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2390, 'Entity/Constants/createEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create place', 'O', 'messages', '2011-01-13 17:47:55.199', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2391, 'Entity/Constants/entityName/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Place name', 'O', 'messages', '2011-01-13 17:47:55.208', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2392, 'Basic/Constants/nonProfitGuaranteesPrivacy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'xxxasdf', 'O', 'messages', '2011-01-13 17:47:51.582', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2393, 'Entity/Constants/assignmentOnlyForAdminOrMember/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin or member', 'O', 'messages', '2011-01-13 17:47:55.481', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2394, 'Entity/Constants/participants/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:47:55.494', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2395, 'Entity/Constants/memberStatus/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:47:55.512', NULL, '2010-08-06 17:21:31.616971');
INSERT INTO base_property VALUES (2396, 'Entity/Constants/subBoxLinks/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Links', 'O', 'messages', '2011-01-13 17:47:55.783', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2397, 'Entity/Constants/entityNotVisibleText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The content of this entity is not visible for every user. You need to join this entity or get an invitation first.', 'O', 'messages', '2011-01-13 17:47:55.831', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2398, 'Entity/Constants/youHadAttended/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated', 'O', 'messages', '2011-01-13 17:47:56.048', NULL, '2010-08-06 17:21:33.126921');
INSERT INTO base_property VALUES (2399, 'Entity/Constants/participantStatusText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participate', 'O', 'messages', '2011-01-13 17:47:56.051', NULL, '2010-08-06 17:21:33.139357');
INSERT INTO base_property VALUES (2400, 'Entity/Messages/minimumBannerHeight/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The header graphic needs to be at least {0} px in height.', 'O', 'messages', '2011-01-13 17:47:56.334', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2401, 'Entity/Constants/widgetsShowSubEntitiesOption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:47:56.571', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2402, 'Entity/Constants/duration/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Time', 'O', 'messages', '2011-01-13 17:47:56.772', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2403, 'Entity/Constants/navigationSeparator/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:47:56.984', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2404, 'Entity/Constants/youAreUndecided/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are undecided', 'O', 'messages', '2011-01-13 17:47:57.611', NULL, '2010-08-06 17:21:35.737026');
INSERT INTO base_property VALUES (2405, 'Entity/Constants/statusOptionUndecidedStatus/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I am undecided', 'O', 'messages', '2011-01-13 17:47:57.646', NULL, '2010-08-06 17:21:35.826935');
INSERT INTO base_property VALUES (2406, 'Entity/Messages/mailSubjectWaitList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on waiting list', 'O', 'messages', '2011-01-13 17:47:57.93', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2407, 'Entity/Constants/admin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:49:55.782', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2408, 'Entity/Constants/componentsRightColumn/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in right column', 'O', 'messages', '2011-01-13 17:47:58.566', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2409, 'Entity/Constants/statusOptionNotAttend/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I do not participate', 'O', 'messages', '2011-01-13 17:47:57.639', NULL, '2010-08-06 17:21:35.799981');
INSERT INTO base_property VALUES (2410, 'Entity/Constants/email/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:49:57.356', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2411, 'Entity/Constants/parentWikis/Wiki', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent wiki pages', 'O', 'messages', '2010-12-14 13:22:43.26', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2412, 'Entity/Constants/invitingRule/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:49:57.413', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2413, 'Entity/Constants/memberStatus/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:49:57.49', NULL, '2010-08-06 17:21:36.947044');
INSERT INTO base_property VALUES (2414, 'Entity/Constants/showAddressData/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show', 'O', 'messages', '2011-01-13 17:49:57.577', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2415, 'Entity/Constants/myMemberStatusComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attending status', 'O', 'messages', '2011-01-13 17:49:57.725', NULL, '2010-08-06 17:21:37.416964');
INSERT INTO base_property VALUES (2416, 'Entity/Constants/statusOptionNotAttend/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I do not participate', 'O', 'messages', '2011-01-13 17:47:56.059', NULL, '2010-08-06 17:21:33.156919');
INSERT INTO base_property VALUES (2417, 'Entity/Constants/uploadIcon/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload icon', 'O', 'messages', '2011-01-13 17:49:57.811', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2418, 'Entity/Constants/participantStatusText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participate', 'O', 'messages', '2011-01-13 17:49:58.161', NULL, '2010-08-06 17:21:38.446908');
INSERT INTO base_property VALUES (2419, 'Entity/Constants/statusOptionWantToAttend/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I participate', 'O', 'messages', '2011-01-13 17:49:58.173', NULL, '2010-08-06 17:21:38.476914');
INSERT INTO base_property VALUES (2420, 'Entity/Constants/participantStatusText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participate', 'O', 'messages', '2011-01-13 17:47:57.622', NULL, '2010-08-06 17:21:35.776938');
INSERT INTO base_property VALUES (2421, '/Basic/Constants/setLinkTarget', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select target', 'O', 'messages', '2011-01-13 17:47:54.987', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2422, 'Entity/Constants/componentsRightColumn/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in right column', 'O', 'messages', '2011-01-13 17:49:57.753', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2423, 'Entity/Constants/youHaveRequestToAttend/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request sent.', 'O', 'messages', '2011-01-13 17:47:56.043', NULL, '2010-08-06 17:21:33.116923');
INSERT INTO base_property VALUES (2424, 'Entity/Messages/mailSubjectRejectorList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have declined your participation', 'O', 'messages', '2011-01-13 17:47:56.376', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2462, 'Entity/Constants/youHadAttended/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated', 'O', 'messages', '2011-01-13 17:49:58.157', NULL, '2010-08-06 17:21:38.43691');
INSERT INTO base_property VALUES (2425, 'Entity/Messages/youAreAtPositionXOfTheWaitlist/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are currently on position {0} of the waiting list', 'O', 'messages', '2011-01-13 17:47:57.991', NULL, '2010-08-06 17:21:36.076938');
INSERT INTO base_property VALUES (2426, 'Entity/Messages/youAreAtPositionXOfTheWaitlist/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are currently on position {0} of the waiting list', 'O', 'messages', '2011-01-13 17:47:56.447', NULL, '2010-08-06 17:21:33.448348');
INSERT INTO base_property VALUES (2427, 'Entity/Constants/uploadImage/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo & Icon', 'O', 'messages', '2011-01-13 17:47:57.175', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2428, 'Entity/Constants/toggleColorAdjustments/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Advanced settings (optional)', 'O', 'messages', '2011-01-13 17:47:57.289', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2429, 'Entity/Constants/outerBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background outside', 'O', 'messages', '2011-01-13 17:47:57.379', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2430, 'Entity/Constants/assignEntityToElements/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assign this event to other elements', 'O', 'messages', '2011-01-13 17:47:57.451', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2431, 'Entity/Constants/invitationPopupNoPersonsInserted/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No one added, everyone is already in your list.', 'O', 'messages', '2011-01-13 17:47:57.516', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2432, 'Entity/Constants/statusOptionWantToAttend/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I participate', 'O', 'messages', '2011-01-13 17:47:57.643', NULL, '2010-08-06 17:21:35.816936');
INSERT INTO base_property VALUES (2433, 'Entity/Constants/youHadNotAttended/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not participate', 'O', 'messages', '2011-01-13 17:47:58.93', NULL, '2010-08-06 17:21:41.718197');
INSERT INTO base_property VALUES (2434, 'Entity/Constants/statusOptionUndecidedStatus/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I am undecided', 'O', 'messages', '2011-01-13 17:47:58.974', NULL, '2010-08-06 17:21:41.80908');
INSERT INTO base_property VALUES (2435, 'Entity/Constants/youAreNotAttend/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You do not participate', 'O', 'messages', '2011-01-13 17:47:58.945', NULL, '2010-08-06 17:21:41.726555');
INSERT INTO base_property VALUES (2436, 'Entity/Constants/youHadAttended/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated', 'O', 'messages', '2011-01-13 17:47:58.956', NULL, '2010-08-06 17:21:41.759057');
INSERT INTO base_property VALUES (2437, 'Entity/Constants/participantStatusText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participate', 'O', 'messages', '2011-01-13 17:47:58.96', NULL, '2010-08-06 17:21:41.768214');
INSERT INTO base_property VALUES (2438, 'Entity/Constants/participantPopupMsgLosingWaitlistPosition/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will loose your position on the waiting list.', 'O', 'messages', '2011-01-13 17:47:58.963', NULL, '2010-08-06 17:21:41.776962');
INSERT INTO base_property VALUES (2439, 'Entity/Constants/statusOptionWantToAttend/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I participate', 'O', 'messages', '2011-01-13 17:47:58.97', NULL, '2010-08-06 17:21:41.796929');
INSERT INTO base_property VALUES (2440, 'Entity/Constants/parentEntityRequiredError/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please assign this group to at least one element', 'O', 'messages', '2011-01-13 17:49:58.015', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2441, 'Entity/Constants/youAreNotAttend/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You do not participate', 'O', 'messages', '2011-01-13 17:48:00.245', NULL, '2010-08-06 17:21:45.702144');
INSERT INTO base_property VALUES (2442, 'Entity/Constants/youHaveRequestToAttend/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request sent.', 'O', 'messages', '2011-01-13 17:48:00.252', NULL, '2010-08-06 17:21:45.727159');
INSERT INTO base_property VALUES (2443, 'Entity/Constants/statusOptionUndecidedStatus/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I am undecided', 'O', 'messages', '2011-01-13 17:48:00.274', NULL, '2010-08-06 17:21:45.786774');
INSERT INTO base_property VALUES (2444, 'Entity/Constants/memberStatus/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:47:59.647', NULL, '2010-08-06 17:21:43.256789');
INSERT INTO base_property VALUES (2445, 'Entity/Constants/mandatory/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:47:59.702', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2446, 'Entity/Messages/youAreAtPositionXOfTheWaitlist/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are currently on position {0} of the waiting list', 'O', 'messages', '2011-01-13 17:47:59.348', NULL, '2010-08-06 17:21:42.296846');
INSERT INTO base_property VALUES (2447, 'Entity/Constants/youAreUndecided/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are undecided', 'O', 'messages', '2011-01-13 17:48:00.249', NULL, '2010-08-06 17:21:45.71678');
INSERT INTO base_property VALUES (2448, 'Entity/Constants/entity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity', 'O', 'messages', '2011-01-13 17:49:55.717', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2449, 'Entity/Constants/componentsRightColumn/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in right column', 'O', 'messages', '2011-01-13 17:47:59.871', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2450, 'Entity/Mails/proposeWeltbeweger', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I would like to propose a Weltbeweger:

$PERSON

Reason:

$MESSAGE


My reference:

$PERSONAL_TITLE $FIRST_NAME $LAST_NAME
$EMAIL
$PHONE
', 'O', 'messages', '2011-01-13 17:48:02.618', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2451, 'Entity/Mails/entityDataChanged/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname modified project "$ENTITY.Name":

$ENTITY_OLD_DATA

changed to:

$ENTITY_NEW_DATA

Project:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.6', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2452, 'Entity/Constants/entities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entities', 'O', 'messages', '2011-01-13 17:49:55.681', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2453, 'Entity/Constants/country', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Country', 'O', 'messages', '2011-01-13 17:49:56.806', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2454, 'Entity/Mails/wallMessageReceived', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wrote a message on your wall:

$MESSAGE

Log in to reply:
$STARTPAGE_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.641', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2455, 'Entity/Constants/location', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:49:56.811', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2456, 'Entity/Constants/requests', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Requests', 'O', 'messages', '2011-01-13 17:49:56.814', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2457, 'Entity/Constants/youHadAttended/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated', 'O', 'messages', '2011-01-13 17:48:00.256', NULL, '2010-08-06 17:21:45.736866');
INSERT INTO base_property VALUES (2458, 'Entity/Constants/description', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Description', 'O', 'messages', '2011-01-13 17:49:56.818', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2459, 'Entity/Messages/entityJoinRequestCount', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity join requests ({0})', 'O', 'messages', '2011-01-13 17:49:57', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2460, 'Entity/Constants/youHadNotAttended/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not participate', 'O', 'messages', '2011-01-13 17:49:58.143', NULL, '2010-08-06 17:21:38.396969');
INSERT INTO base_property VALUES (2461, 'Entity/Constants/youHaveRequestToAttend/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request sent.', 'O', 'messages', '2011-01-13 17:49:58.154', NULL, '2010-08-06 17:21:38.426909');
INSERT INTO base_property VALUES (2463, 'Entity/Constants/entities/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Projects', 'O', 'messages', '2011-01-13 17:47:59.389', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2464, 'Entity/Constants/adminListComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins', 'O', 'messages', '2011-01-13 17:47:58.556', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2465, 'Entity/Constants/createEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create', 'O', 'messages', '2011-01-13 17:49:55.701', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2466, 'Entity/Constants/entityName/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Project name', 'O', 'messages', '2011-01-13 17:47:59.398', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2467, 'Entity/Constants/assignmentOnlyForAdminOrMember/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin or member', 'O', 'messages', '2011-01-13 17:47:59.621', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2468, 'Entity/Constants/myMemberStatusComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attending status', 'O', 'messages', '2011-01-13 17:47:59.85', NULL, '2010-08-06 17:21:44.006796');
INSERT INTO base_property VALUES (2469, 'Entity/Constants/youHadNotAttended/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not participate', 'O', 'messages', '2011-01-13 17:48:00.242', NULL, '2010-08-06 17:21:45.674713');
INSERT INTO base_property VALUES (2470, 'Entity/Constants/entityName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity name', 'O', 'messages', '2011-01-13 17:49:55.739', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2471, 'Entity/Constants/duplicateEntitySelectionErrorOccur/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:47:58.8', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2472, 'Entity/Constants/city/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City/town', 'O', 'messages', '2011-01-13 17:47:59.632', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2473, 'Entity/Constants/joiningRule/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:47:59.649', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2474, 'Entity/Constants/linksOnBackground/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Links', 'O', 'messages', '2011-01-13 17:49:57.938', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2475, 'Entity/Constants/memberStatus/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:47:58.342', NULL, '2010-08-06 17:21:39.536949');
INSERT INTO base_property VALUES (2476, 'Entity/Constants/duration', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Time', 'O', 'messages', '2011-01-13 17:49:55.706', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2477, 'Entity/Constants/timezone', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:49:55.709', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2478, 'Entity/Constants/subdomain', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subdomain', 'O', 'messages', '2011-01-13 17:49:55.747', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2479, 'Entity/Constants/inviteMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:49:55.751', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2480, 'Entity/Constants/email', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:49:55.754', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2481, 'Entity/Constants/assignEntityToElements', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assign this entity to other elements', 'O', 'messages', '2011-01-13 17:49:56.374', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2482, 'Entity/Constants/privacySettings', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:49:55.759', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2483, 'Entity/Constants/myMemberStatusComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attending status', 'O', 'messages', '2011-01-13 17:49:56.13', NULL, '2010-08-06 17:21:59.028151');
INSERT INTO base_property VALUES (2484, 'Basic/Constants/oldPassword', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Old password', 'O', 'messages', '2011-01-13 17:47:50.187', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2485, 'Entity/Messages/youAreAtPositionXOfTheWaitlist/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are currently on position {0} of the waiting list', 'O', 'messages', '2011-01-13 17:48:00.619', NULL, '2010-08-06 17:21:46.368061');
INSERT INTO base_property VALUES (2486, 'Entity/Constants/youHadNotAttended', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not participate', 'O', 'messages', '2011-01-13 17:49:56.571', NULL, '2010-08-06 17:22:00.46494');
INSERT INTO base_property VALUES (2487, 'Entity/Constants/memberStatus', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:49:55.912', NULL, '2010-08-06 17:21:58.419018');
INSERT INTO base_property VALUES (2488, 'Entity/Constants/statusOptionUndecidedStatus', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I am undecided', 'O', 'messages', '2011-01-13 17:49:56.618', NULL, '2010-08-06 17:22:00.578419');
INSERT INTO base_property VALUES (2489, 'Entity/Constants/header', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:49:56.798', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2490, 'Entity/Constants/statusOptionNotAttend/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I do not participate', 'O', 'messages', '2011-01-13 17:49:58.169', NULL, '2010-08-06 17:21:38.467516');
INSERT INTO base_property VALUES (2491, 'Entity/Constants/cancel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:49:56.822', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2492, 'Entity/Messages/youAreAtPositionXOfTheWaitlist/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are currently on position {0} of the waiting list', 'O', 'messages', '2011-01-13 17:49:58.548', NULL, '2010-08-06 17:21:38.746964');
INSERT INTO base_property VALUES (2493, 'Entity/Constants/googleMapAPIKey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Google Maps-API key', 'O', 'messages', '2011-01-13 17:49:55.994', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2494, 'Entity/Constants/noNotfiedParticipantSelected', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No persons for notification selected.', 'O', 'messages', '2011-01-13 17:49:56.164', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2495, 'Profile/Constants/email', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:47:45.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2496, 'Basic/Constants/hours', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'h', 'O', 'messages', '2011-01-13 17:47:51.742', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2497, 'Entity/Constants/statusOptionNotAttend/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I do not participate', 'O', 'messages', '2011-01-13 17:48:00.267', NULL, '2010-08-06 17:21:45.768866');
INSERT INTO base_property VALUES (2498, 'Entity/Constants/uploadIcon', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload icon', 'O', 'messages', '2011-01-13 17:49:56.192', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2499, 'Entity/Constants/horizontalNavigationBackground', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation', 'O', 'messages', '2011-01-13 17:49:56.256', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2500, 'Entity/Constants/youAreNotAttend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You do not participate', 'O', 'messages', '2011-01-13 17:49:56.574', NULL, '2010-08-06 17:22:00.47979');
INSERT INTO base_property VALUES (2501, 'Entity/Messages/userXWillBeRemoveAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified. The admin status will remain unchanged.', 'O', 'messages', '2011-01-13 17:49:58.481', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2502, 'Entity/Constants/statusOptionWantToAttend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I participate', 'O', 'messages', '2011-01-13 17:49:56.614', NULL, '2010-08-06 17:22:00.564742');
INSERT INTO base_property VALUES (2503, 'Entity/Messages/mailSubjectInvitedList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation for entity ''''{0}''''.', 'O', 'messages', '2011-01-13 17:49:56.927', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2504, 'Entity/Messages/mailSubjectRejectorList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have declined your participation', 'O', 'messages', '2011-01-13 17:49:58.506', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2505, 'Entity/Constants/statusOptionWantToAttend/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I participate', 'O', 'messages', '2011-01-13 17:48:00.27', NULL, '2010-08-06 17:21:45.777157');
INSERT INTO base_property VALUES (2506, 'Entity/Messages/mailSubjectParticipantList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on participant list', 'O', 'messages', '2011-01-13 17:48:00.564', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2507, 'Entity/Constants/uploadImage/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo & Icon', 'O', 'messages', '2011-01-13 17:47:55.634', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2508, 'Entity/Constants/navigationSeparator/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:47:58.335', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2509, 'Login/Constants/registerLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Sign up', 'O', 'messages', '2011-01-13 17:47:49.925', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2510, 'Entity/Constants/participantPopupMsgLosingWaitlistPosition', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will loose your position on the waiting list.', 'O', 'messages', '2011-01-13 17:49:56.606', NULL, '2010-08-06 17:22:00.543614');
INSERT INTO base_property VALUES (2511, 'Entity/Constants/statusOptionNotAttend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I do not participate', 'O', 'messages', '2011-01-13 17:49:56.61', NULL, '2010-08-06 17:22:00.554894');
INSERT INTO base_property VALUES (2512, 'Entity/Constants/members/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:55.193', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2513, 'Entity/Messages/youAreAtPositionXOfTheWaitlist', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are currently on position {0} of the waiting list', 'O', 'messages', '2011-01-13 17:49:57.012', NULL, '2010-08-06 17:22:00.937679');
INSERT INTO base_property VALUES (2514, 'Entity/Constants/assignEntityToElements/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assign this group to other elements', 'O', 'messages', '2011-01-13 17:49:57.24', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2515, 'Basic/Constants/newsfeedActivateQuestion', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'No function, will be removed soon', 'O', 'messages', '2010-10-04 14:38:55.574', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2516, 'Basic/Messages/addVideoLinkCommentx', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} comment(s) | View/add', 'O', 'messages', '2011-01-13 17:47:51.912', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2517, 'Basic/Constants/notActivated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Not activated', 'O', 'messages', '2011-01-13 17:47:50.912', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2518, 'Exception/Messages/startProfileActivatingException', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To activate the profiles for starting page exactly {0} profiles have to be selected for client language {1} and for other languages max. {0} profiles. Following client languages break against this rule: <br> {2}', 'O', 'messages', '2011-01-13 17:47:53.82', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2519, 'Document/Constants/uploadDocument', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload document', 'O', 'messages', '2011-01-13 17:47:54.373', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2520, '/Basic/Constants/readMore', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Read more', 'O', 'messages', '2011-01-13 17:47:54.917', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2521, 'Basic/Constants/profileCouldNotBeSaved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your profile changes have not been saved. For each field only 1000 characters are allowed.', 'O', 'messages', '2011-01-13 17:47:50.532', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2522, 'Basic/Constants/datumUhrzeit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Date, time', 'O', 'messages', '2011-01-13 17:47:51.662', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2523, 'Basic/Messages/xneueEinladungen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitations and requests ({0})', 'O', 'messages', '2011-01-13 17:47:51.842', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2524, 'Document/Constants/unsupportedMethodRequestCanceled', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unsupported method! Request canceled.', 'O', 'messages', '2011-01-13 17:47:54.343', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2525, 'Document/Constants/uploadVersion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Upload new version', 'O', 'messages', '2011-01-13 17:47:54.392', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2526, '/Basic/Constants/myProfil', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My profile', 'O', 'messages', '2011-01-13 17:47:55.012', NULL, '2010-08-10 18:57:29.037763');
INSERT INTO base_property VALUES (2527, 'Entity/Constants/createEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create wiki page', 'O', 'messages', '2011-01-13 17:47:58.165', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2528, 'Telltale/Messages/forumBeitragsVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in discussion forum -> "{0}" (post-ID:{1}, topic-ID:{2}) [author:"{3} {4}" ({5})]', 'O', 'messages', '2011-01-13 17:47:52.348', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2529, '/Comments/Constants/errorFetchingComments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'There was an error fetching the comments', 'O', 'messages', '2011-01-13 17:49:57.085', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2530, 'Entity/Constants/members/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:49:57.193', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2531, 'Entity/Constants/childEntities/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Groups', 'O', 'messages', '2011-01-13 17:49:57.221', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2532, 'Basic/Constants/wasBietetKaioo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'xxxasdf', 'O', 'messages', '2011-01-13 17:47:50.663', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2533, 'Basic/Constants/uploadFileTypeNotSupported', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The file format of your photo is not supported.', 'O', 'messages', '2011-01-13 17:47:51.397', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2534, 'Basic/Constants/actionOnlyForMember', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please log in first. If you are not a member yet, register first.', 'O', 'messages', '2011-01-13 17:47:50.277', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2535, 'Basic/Constants/uploadPhotoReminderTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please upload a profile photo.', 'O', 'messages', '2011-01-13 17:47:50.296', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2536, 'Basic/Constants/freundschaftBeendenFrage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove contact?', 'O', 'messages', '2011-01-13 17:47:51.55', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2537, 'Basic/Messages/sureYouWantToSendMsgWithout', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No {0} entered. Do you want to send this message?', 'O', 'messages', '2011-01-13 17:47:51.852', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2538, 'WikiEditor/Constants/selectPhoto', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select photo', 'O', 'messages', '2011-01-13 17:47:54.621', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2539, '/Basic/Constants/save', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:47:55.155', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2540, 'Basic/Constants/newsfeedActivateText', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'No function, will be removed soon', 'O', 'messages', '2010-10-04 14:39:12.034', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2541, 'Search/Constants/selectProfile', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Profile', 'O', 'messages', '2011-01-13 17:47:52.998', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2542, 'Basic/Constants/removeProfilePicture', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you remove your current photo, the standard photo will be displayed instead.', 'O', 'messages', '2011-01-13 17:47:50.676', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2543, 'Entity/Constants/acceptChanges/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept changes', 'O', 'messages', '2011-01-13 17:49:57.835', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2545, 'Entity/Constants/makeCoAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make co-admin', 'O', 'messages', '2011-01-13 17:49:57.393', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2546, 'Wiki/Constants/confirmDeleteMember', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Remove this member from wiki page?', 'O', 'messages', '2010-09-02 16:34:54.537', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2547, 'Entity/Constants/editEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic informations', 'O', 'messages', '2011-01-13 17:49:57.54', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2548, 'Entity/Constants/street/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:49:57.474', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2549, 'Entity/Constants/noNotfiedParticipantSelected/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No persons for notification selected.', 'O', 'messages', '2011-01-13 17:49:57.769', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2550, 'Entity/Constants/entityClosedNotAcceptingInvitationPossibleAnymore/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot take part any more.', 'O', 'messages', '2011-01-13 17:49:58.091', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2551, 'Entity/Constants/memberSettings/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member administration', 'O', 'messages', '2011-01-13 17:49:57.613', NULL, '2010-08-10 18:57:36.563124');
INSERT INTO base_property VALUES (2552, 'Entity/Constants/writeMessageToAllMembers/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to all members', 'O', 'messages', '2011-01-13 17:49:58.189', NULL, '2010-08-10 18:57:38.045389');
INSERT INTO base_property VALUES (2553, '/Basic/Constants/myMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My messages', 'O', 'messages', '2011-01-13 17:47:55.02', NULL, '2010-08-10 18:57:29.04706');
INSERT INTO base_property VALUES (2554, 'Telltale/Constants/meldeText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report violations of Terms of Use here.<br /><br /> All reports will be handled confidentially.', 'O', 'messages', '2011-01-13 17:47:52.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2555, 'Entity/Constants/entityNotVisibleText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The content of this entity is not visible for every user. You need to join this entity or get an invitation first.', 'O', 'messages', '2011-01-13 17:49:57.974', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2556, 'Entity/Messages/entityMessageSubject/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message from ''''{0}''''', 'O', 'messages', '2011-01-13 17:47:57.995', NULL, '2010-08-10 18:57:35.577968');
INSERT INTO base_property VALUES (2557, 'Album/Constants/realyWantToDeleteSelectedImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete selected photos?', 'O', 'messages', '2011-01-13 17:47:52.705', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2558, 'Entity/Constants/entityClosedNotAcceptingJoinRequestPossibleAnymore/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot accept this request anymore.', 'O', 'messages', '2011-01-13 17:47:55.965', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2559, 'Album/Constants/alreadyExistingAlbums', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add photos to an existing album', 'O', 'messages', '2011-01-13 17:47:52.803', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2560, 'Album/Constants/imageTitleTooLong', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The image title is too long', 'O', 'messages', '2011-01-13 17:47:52.822', NULL, '2010-08-10 18:57:19.428239');
INSERT INTO base_property VALUES (2561, 'Exception/Constants/accountNotExistOrAlreadyActivated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Either the account does not exist or the account has already been activated.', 'O', 'messages', '2011-01-13 17:47:53.71', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2562, 'WikiEditor/Messages/lockWarning', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make sure, that {0} finishes editing the wiki page first. Otherwise you would overwrite his changes.', 'O', 'messages', '2011-01-13 17:47:54.545', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2563, 'NewsBlog/Constants/selectArticleImagePopup', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select an image for the article', 'O', 'messages', '2011-01-13 17:47:54.787', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2564, 'Album/Constants/viewPhotoAlbums', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'View album', 'O', 'messages', '2011-01-13 17:47:52.579', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2565, '/Basic/Constants/enterInternetAddressHere', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enter URL here', 'O', 'messages', '2011-01-13 17:47:54.995', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2566, '/Basic/Constants/myContacts', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My contacts', 'O', 'messages', '2011-01-13 17:47:55.017', NULL, '2010-08-10 18:57:28.829211');
INSERT INTO base_property VALUES (2567, 'Album/Constants/albumView', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Album view', 'O', 'messages', '2011-01-13 17:47:52.7', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2568, '/Basic/Constants/myVideos', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My videos', 'O', 'messages', '2011-01-13 17:47:55.024', NULL, '2010-08-10 18:57:29.059363');
INSERT INTO base_property VALUES (2569, 'Entity/Constants/lineOnBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Separator line', 'O', 'messages', '2011-01-13 17:47:55.8', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2570, 'Entity/Constants/youHadNotAttended/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You did not participate', 'O', 'messages', '2011-01-13 17:47:56.032', NULL, '2010-08-06 17:21:33.088658');
INSERT INTO base_property VALUES (2571, 'Entity/Constants/sendNewsletter/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send newsletter', 'O', 'messages', '2011-01-13 17:47:56.085', NULL, '2010-08-10 18:57:31.763828');
INSERT INTO base_property VALUES (2572, 'Entity/Constants/realyWantToDeleteEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you realy want to delete this place?', 'O', 'messages', '2011-01-13 17:47:56.094', NULL, '2010-08-10 18:57:31.785476');
INSERT INTO base_property VALUES (2573, 'Entity/Constants/noRecipientsSelected/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No recipients selected.', 'O', 'messages', '2011-01-13 17:47:56.104', NULL, '2010-08-10 18:57:31.797116');
INSERT INTO base_property VALUES (2574, 'Entity/Constants/participantPopupMsgLosingWaitlistPosition/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will loose your position on the waiting list.', 'O', 'messages', '2011-01-13 17:47:56.055', NULL, '2010-08-06 17:21:33.14769');
INSERT INTO base_property VALUES (2575, 'Entity/Constants/entities/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Events', 'O', 'messages', '2011-01-13 17:47:56.505', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2576, 'Entity/Constants/street/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:47:56.963', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2577, 'Entity/Constants/sendInvites/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send invitation', 'O', 'messages', '2011-01-13 17:49:58.031', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2578, 'Entity/Constants/defaultLinkOverview', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To entity', 'O', 'messages', '2011-01-13 17:49:56.63', NULL, '2010-08-10 18:58:41.216757');
INSERT INTO base_property VALUES (2579, 'Entity/Constants/toPerticipantList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in participant list', 'O', 'messages', '2011-01-13 17:47:57.247', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2580, 'Entity/Messages/entityMessageText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The following message for ''''{0}'''' was sent to {1} people:

{2}', 'O', 'messages', '2011-01-13 17:47:57.9', NULL, '2010-08-10 18:57:35.369862');
INSERT INTO base_property VALUES (2581, 'Entity/Constants/entity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group', 'O', 'messages', '2011-01-13 17:49:57.201', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2582, 'Entity/Constants/leaveEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave', 'O', 'messages', '2011-01-13 17:49:57.402', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2583, 'Entity/Constants/sendNewsletter/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send newsletter', 'O', 'messages', '2011-01-13 17:49:58.192', NULL, '2010-08-10 18:57:38.053701');
INSERT INTO base_property VALUES (2584, 'Entity/Messages/entityMessageText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The following message for ''''{0}'''' was sent to {1} people:

{2}', 'O', 'messages', '2011-01-13 17:49:58.465', NULL, '2010-08-10 18:57:38.21309');
INSERT INTO base_property VALUES (2585, 'Entity/Messages/minimumBannerHeight/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The header graphic needs to be at least {0} px in height.', 'O', 'messages', '2011-01-13 17:47:57.905', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2586, 'Entity/Constants/state/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'State', 'O', 'messages', '2011-01-13 17:47:56.228', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2587, 'Entity/Constants/street/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:47:58.328', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2588, 'Entity/Constants/showAddressData/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show', 'O', 'messages', '2011-01-13 17:47:58.411', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2589, 'Entity/Constants/toWaitlist/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Put in waiting list', 'O', 'messages', '2011-01-13 17:47:58.574', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2590, 'Entity/Constants/innerBackground/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background inside', 'O', 'messages', '2011-01-13 17:47:58.714', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2591, 'Entity/Messages/entityMessageSubject/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message from ''''{0}''''', 'O', 'messages', '2011-01-13 17:49:58.552', NULL, '2010-08-10 18:57:38.37304');
INSERT INTO base_property VALUES (2592, 'Videolink/Constants/videolinkTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Title', 'O', 'messages', '2011-01-13 17:47:54.12', NULL, '2010-10-26 13:47:47.158817');
INSERT INTO base_property VALUES (2593, 'Videolink/Constants/addVideolinkButton', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add video link', 'O', 'messages', '2011-01-13 17:47:54.126', NULL, '2010-10-26 13:47:47.386744');
INSERT INTO base_property VALUES (2594, 'Videolink/Constants/notSupportedVideoHoster', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This video URL is not from a supported video hoster.', 'O', 'messages', '2011-01-13 17:47:54.133', NULL, '2010-10-26 13:47:47.593841');
INSERT INTO base_property VALUES (2595, '/Basic/Constants/myStartpage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My startpage', 'O', 'messages', '2011-01-13 17:47:55.009', NULL, '2010-08-10 18:57:29.02616');
INSERT INTO base_property VALUES (2596, 'Entity/Constants/parentNetworks/Wiki', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent places', 'O', 'messages', '2010-12-14 13:22:43.104', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2597, 'Entity/Constants/invitingRule/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:47:55.47', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2598, 'Entity/Constants/configComponents/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules', 'O', 'messages', '2011-01-13 17:47:55.639', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2599, 'Entity/Constants/horizontalNavigationLink/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation: Link', 'O', 'messages', '2011-01-13 17:47:55.766', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2600, 'Entity/Constants/memberSettings/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member administration', 'O', 'messages', '2011-01-13 17:47:57.116', NULL, '2010-08-10 18:57:33.477573');
INSERT INTO base_property VALUES (2601, 'Entity/Constants/errorAcceptingJoinRequest/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error accepting join request.', 'O', 'messages', '2011-01-13 17:47:55.977', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2602, 'Videolink/Constants/pleaseFillTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please fill the title.', 'O', 'messages', '2011-01-13 17:47:54.141', NULL, '2010-10-26 13:47:47.707708');
INSERT INTO base_property VALUES (2603, 'Entity/Constants/errorDecliningJoinRequest/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Error declining join request.', 'O', 'messages', '2011-01-13 17:47:55.981', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2604, 'Entity/Messages/entityMessageText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The following message for ''''{0}'''' was sent to {1} people:

{2}', 'O', 'messages', '2011-01-13 17:47:56.33', NULL, '2010-08-10 18:57:31.944008');
INSERT INTO base_property VALUES (2605, 'Entity/Messages/entityMessageSubject/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message from ''''{0}''''', 'O', 'messages', '2011-01-13 17:47:56.451', NULL, '2010-08-10 18:57:32.17379');
INSERT INTO base_property VALUES (2606, 'Entity/Constants/makeAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make admin', 'O', 'messages', '2011-01-13 17:47:56.879', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2607, 'Entity/Constants/editEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic informations', 'O', 'messages', '2011-01-13 17:47:57.048', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2608, 'Entity/Constants/visibleForWholePlatForm/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:57.129', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2609, 'Entity/Constants/defaultLinkOverview/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To event', 'O', 'messages', '2011-01-13 17:47:57.657', NULL, '2010-08-10 18:57:35.21693');
INSERT INTO base_property VALUES (2610, 'Entity/Constants/noRecipientsSelected/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No recipients selected.', 'O', 'messages', '2011-01-13 17:47:57.669', NULL, '2010-08-10 18:57:35.236923');
INSERT INTO base_property VALUES (2611, 'Entity/Constants/writeMessageToAllMembers/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to all members', 'O', 'messages', '2011-01-13 17:47:57.65', NULL, '2010-08-10 18:57:35.187243');
INSERT INTO base_property VALUES (2612, 'Entity/Constants/sendNewsletter/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send newsletter', 'O', 'messages', '2011-01-13 17:47:57.654', NULL, '2010-08-10 18:57:35.200134');
INSERT INTO base_property VALUES (2613, 'Entity/Constants/configComponents/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules', 'O', 'messages', '2011-01-13 17:47:57.179', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2614, 'Entity/Constants/realyWantToDeleteEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you realy want to delete this event?', 'O', 'messages', '2011-01-13 17:47:57.661', NULL, '2010-08-10 18:57:35.228045');
INSERT INTO base_property VALUES (2615, 'Entity/Constants/street/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:47:59.637', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2616, 'Entity/Constants/memberSettings/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member administration', 'O', 'messages', '2011-01-13 17:47:59.755', NULL, '2010-08-10 18:57:42.213322');
INSERT INTO base_property VALUES (2617, 'Entity/Constants/enterNameOfEntityHere/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of group', 'O', 'messages', '2011-01-13 17:49:57.235', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2618, 'Entity/Constants/infoWidgetComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:49:57.32', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2619, 'Entity/Constants/noRecipientsSelected/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No recipients selected.', 'O', 'messages', '2011-01-13 17:49:58.205', NULL, '2010-08-10 18:57:38.084153');
INSERT INTO base_property VALUES (2620, 'Videolink/Constants/videoAdded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Video added.', 'O', 'messages', '2011-01-13 17:47:54.129', NULL, '2010-10-26 13:47:47.490831');
INSERT INTO base_property VALUES (2621, 'Videolink/Constants/videoHosterError', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The video hoster had an error. Maybe you can try to add this video later.', 'O', 'messages', '2011-01-13 17:47:54.137', NULL, '2010-10-26 13:47:47.598068');
INSERT INTO base_property VALUES (2622, 'Entity/Constants/youHaveRequestToAttend/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Request sent.', 'O', 'messages', '2011-01-13 17:47:58.952', NULL, '2010-08-06 17:21:41.746928');
INSERT INTO base_property VALUES (2623, 'Entity/Constants/writeMessageToAllMembers/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to all members', 'O', 'messages', '2011-01-13 17:48:00.277', NULL, '2010-08-10 18:57:43.883102');
INSERT INTO base_property VALUES (2624, 'Entity/Constants/sendNewsletter/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send newsletter', 'O', 'messages', '2011-01-13 17:47:58.981', NULL, '2010-08-10 18:57:40.704509');
INSERT INTO base_property VALUES (2625, 'Entity/Constants/defaultLinkOverview/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To wiki page', 'O', 'messages', '2011-01-13 17:47:58.985', NULL, '2010-08-10 18:57:40.713159');
INSERT INTO base_property VALUES (2626, 'Entity/Constants/realyWantToDeleteEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you realy want to delete this wiki page?', 'O', 'messages', '2011-01-13 17:47:58.99', NULL, '2010-08-10 18:57:40.723086');
INSERT INTO base_property VALUES (2627, 'Entity/Constants/noRecipientsSelected/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No recipients selected.', 'O', 'messages', '2011-01-13 17:47:59.001', NULL, '2010-08-10 18:57:40.735119');
INSERT INTO base_property VALUES (2628, 'Entity/Constants/widgetsShowSubEntities/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Elements in teasers', 'O', 'messages', '2011-01-13 17:47:59.416', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2629, 'Entity/Messages/entityMessageSubject/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message from ''''{0}''''', 'O', 'messages', '2011-01-13 17:47:59.351', NULL, '2010-08-10 18:57:41.033093');
INSERT INTO base_property VALUES (2630, 'Entity/Constants/realyWantToDeleteEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you realy want to delete this project?', 'O', 'messages', '2011-01-13 17:48:00.289', NULL, '2010-08-10 18:57:43.913675');
INSERT INTO base_property VALUES (2631, 'Entity/Constants/editEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Basic informations', 'O', 'messages', '2011-01-13 17:47:59.679', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2632, 'Entity/Constants/horizontalNavigationLink/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation: Link', 'O', 'messages', '2011-01-13 17:47:59.972', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2633, 'Entity/Constants/entityNotVisibleText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The content of this entity is not visible for every user. You need to join this entity or get an invitation first.', 'O', 'messages', '2011-01-13 17:48:00.068', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2634, 'Entity/Constants/linkedEntityPrivacyAssignmentHeader/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who is allowed to assign other elements to this project?', 'O', 'messages', '2011-01-13 17:48:00.088', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2635, 'Entity/Constants/sendNewsletter/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send newsletter', 'O', 'messages', '2011-01-13 17:48:00.281', NULL, '2010-08-10 18:57:43.89437');
INSERT INTO base_property VALUES (2636, 'Entity/Constants/inviteViaEmail/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite via e-mail', 'O', 'messages', '2011-01-13 17:47:58.851', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2637, 'Entity/Constants/noRecipientsSelected/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No recipients selected.', 'O', 'messages', '2011-01-13 17:48:00.299', NULL, '2010-08-10 18:57:43.92304');
INSERT INTO base_property VALUES (2638, 'Entity/Constants/enterNameOfEntityHere/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name of projects', 'O', 'messages', '2011-01-13 17:47:59.424', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2639, 'Entity/Messages/entityMessageText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The following message for ''''{0}'''' was sent to {1} people:

{2}', 'O', 'messages', '2011-01-13 17:48:00.52', NULL, '2010-08-10 18:57:44.20535');
INSERT INTO base_property VALUES (2640, 'Entity/Messages/entityMessageSubject/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message from ''''{0}''''', 'O', 'messages', '2011-01-13 17:48:00.623', NULL, '2010-08-10 18:57:44.363032');
INSERT INTO base_property VALUES (2641, 'Entity/Mails/messageEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wrote a message to the members of wiki page "$ENTITY.Name":

$SUBJECT

$MESSAGE

Log in to reply:
$STARTPAGE_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.472', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2642, 'Videolink/Constants/addedAt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Added at', 'O', 'messages', '2011-01-13 17:47:54.145', NULL, '2010-10-26 13:47:47.81041');
INSERT INTO base_property VALUES (2643, 'Entity/Constants/uploadImage/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Logo & Icon', 'O', 'messages', '2011-01-13 17:47:59.81', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2644, 'Entity/Constants/buttonBackground/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Button', 'O', 'messages', '2011-01-13 17:48:00.033', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2645, 'Entity/Constants/linkedEntityPrivacyAssignmentHeader/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who is allowed to assign other elements to this wiki page?', 'O', 'messages', '2011-01-13 17:47:58.784', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2646, 'Entity/Constants/enterEmailHelpText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma, semicolon, space or return', 'O', 'messages', '2011-01-13 17:47:58.865', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2647, 'Entity/Constants/writeMessageToAllMembers/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to all members', 'O', 'messages', '2011-01-13 17:47:58.978', NULL, '2010-08-10 18:57:40.693468');
INSERT INTO base_property VALUES (2648, 'Entity/Constants/street', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:49:55.895', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2649, 'Entity/Messages/entityMessageText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The following message for ''''{0}'''' was sent to {1} people:

{2}', 'O', 'messages', '2011-01-13 17:49:56.887', NULL, '2010-08-10 18:58:41.316757');
INSERT INTO base_property VALUES (2650, 'Entity/Messages/mailSubjectRequesterList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have requested for participation', 'O', 'messages', '2011-01-13 17:49:56.934', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2651, 'Entity/Constants/googleMapAPIKeyHelpText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>If you enter an external place URL, Google Maps will not work any more, since the current global key only works for subdomains.</p><p>If you want use Google Maps with an external URL, you need to obtain a Google Maps-API key for your domain and enter it here.</p><p>See: <a href="http://code.google.com/intl/en-US/apis/maps/signup.html" target="_blank">http://code.google.com/intl/en-US/apis/maps/signup.html</a></p>', 'O', 'messages', '2011-01-13 17:49:56.003', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2652, 'NewsletterHtml/Messages/newPhotoComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photo: <a href="{0}">{1}</a> (new comment)', 'O', 'messages', '2011-01-13 17:47:49.603', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2653, 'Basic/Constants/notifications', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My news', 'O', 'messages', '2011-01-13 17:47:49.959', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2654, 'Basic/Constants/vorname', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Firstname', 'O', 'messages', '2011-01-13 17:47:50.084', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2655, 'Entity/Constants/writeMessageToAllMembers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to all members', 'O', 'messages', '2011-01-13 17:49:56.622', NULL, '2010-08-10 18:58:41.196826');
INSERT INTO base_property VALUES (2656, 'Basic/Constants/tooManyPeopleLoggedIn', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The server load is currently too high. Please try again later.', 'O', 'messages', '2011-01-13 17:47:50.006', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2657, 'Basic/Constants/geschlecht', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Gender', 'O', 'messages', '2011-01-13 17:47:50.093', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2658, 'Basic/Constants/passwort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Password', 'O', 'messages', '2011-01-13 17:47:50.127', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2659, 'Basic/Constants/passwordForgotten', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Forgot your password?', 'O', 'messages', '2011-01-13 17:47:50.267', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2695, 'Basic/Constants/hausnummer', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'street number', 'O', 'messages', '2011-01-13 17:47:51.522', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2773, 'Entity/Constants/navigation/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation', 'O', 'messages', '2011-01-13 17:47:55.753', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2660, 'Entity/Mails/entityDataChanged/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname modified group "$ENTITY.Name":

$ENTITY_OLD_DATA

Changed to:

$ENTITY_NEW_DATA

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.457', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2661, 'Entity/Mails/entityInvitation/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname invites you to event "$ENTITY.Name".

#if ( !$MESSAGE.empty )
$MESSAGE
#end

Pick up invitation:
$STARTPAGE_URI

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.557', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2662, 'Entity/Mails/registration', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '#if ( !$ENTITY )
You are registered now. Click this link to activate your account:
$REGISTRATION_URI

#else
You registered for "$ENTITY.Name". Click this link to activate your account:
$REGISTRATION_URI
#end


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.616', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2663, 'Entity/Constants/memberSettings', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member administration', 'O', 'messages', '2011-01-13 17:49:56.028', NULL, '2010-08-10 18:58:39.593235');
INSERT INTO base_property VALUES (2664, 'Entity/Constants/visibleForAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For the whole internet', 'O', 'messages', '2011-01-13 17:49:56.06', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2665, 'Entity/Constants/colorDesign', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design', 'O', 'messages', '2011-01-13 17:49:56.196', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2666, 'Entity/Constants/toggleColorAdjustments', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Advanced settings (optional)', 'O', 'messages', '2011-01-13 17:49:56.208', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2667, 'Entity/Constants/duplicateEntitySelectionErrorOccur', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:49:56.386', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2668, 'Basic/Constants/passwdNoLetter', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Password does not contain letters.', 'O', 'messages', '2011-01-13 17:47:50.142', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2669, 'Entity/Constants/entityClosedNotAcceptingInvitationPossibleAnymore', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot take part any more.', 'O', 'messages', '2011-01-13 17:49:56.488', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2670, 'Entity/Constants/sendNewsletter', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send newsletter', 'O', 'messages', '2011-01-13 17:49:56.626', NULL, '2010-08-10 18:58:41.206766');
INSERT INTO base_property VALUES (2671, 'Entity/Constants/realyWantToDeleteEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you realy want to delete this entity?', 'O', 'messages', '2011-01-13 17:49:56.634', NULL, '2010-08-10 18:58:41.228365');
INSERT INTO base_property VALUES (2672, 'Entity/Constants/parentWikis', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent wiki pages', 'O', 'messages', '2010-12-14 13:24:21.931', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2673, 'Basic/Constants/ablehnen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Reject', 'O', 'messages', '2011-01-13 17:47:50.463', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2674, 'Entity/Messages/needToDefineMinEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You have to define {0} entity(ies) as minimum.', 'O', 'messages', '2011-01-13 17:49:56.946', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2675, 'Entity/Messages/entityMessageSubject', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message from ''''{0}''''', 'O', 'messages', '2011-01-13 17:49:57.016', NULL, '2010-08-10 18:58:41.566833');
INSERT INTO base_property VALUES (2676, 'Newsletter/Messages/newEntityComment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (new comment)', 'O', 'messages', '2011-01-13 17:47:49.814', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2677, 'Login/Constants/loginButton', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Login', 'O', 'messages', '2011-01-13 17:47:49.937', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2678, 'Basic/Constants/additionalTermsAccepted', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'I accept the data transfer.', 'O', 'messages', '2010-10-22 17:52:25.004', NULL, '2010-08-12 15:12:00.603969');
INSERT INTO base_property VALUES (2679, 'Entity/Constants/defaultLinkOverview/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To group', 'O', 'messages', '2011-01-13 17:49:58.194', NULL, '2010-08-10 18:57:38.063054');
INSERT INTO base_property VALUES (2680, 'Basic/Constants/registrationSucceeded', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Registration successful. Your account is now active.', 'O', 'messages', '2010-10-22 17:52:25.009', NULL, '2010-08-12 15:12:00.613419');
INSERT INTO base_property VALUES (2681, 'Entity/Constants/defaultLinkOverview/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To place', 'O', 'messages', '2011-01-13 17:47:56.089', NULL, '2010-08-10 18:57:31.773217');
INSERT INTO base_property VALUES (2682, 'Album/Constants/uploadImageNow', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', ' Upload images now.', 'O', 'messages', '2011-01-13 17:47:52.763', NULL, '2010-08-12 15:14:48.299083');
INSERT INTO base_property VALUES (2683, 'Basic/Constants/yourContactDataVisibleForFriends', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your contact information is only visible for your contacts.', 'O', 'messages', '2011-01-13 17:47:50.469', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2684, 'Basic/Constants/repeatPassword', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Confirm new password', 'O', 'messages', '2011-01-13 17:47:50.513', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2685, 'Basic/Constants/leuteKennenlernen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Meet new people', 'O', 'messages', '2011-01-13 17:47:51.383', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2686, 'Basic/Constants/addNews', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add admin news', 'O', 'messages', '2011-01-13 17:47:50.523', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2687, 'Basic/Constants/friendsListOnlyVisibleForMember', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The list of contacts is visible for logged in members only.', 'O', 'messages', '2011-01-13 17:47:50.608', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2688, 'Basic/Constants/doNotShowThisMessageAgain', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do not show this message again', 'O', 'messages', '2011-01-13 17:47:50.964', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2689, 'Basic/Constants/pictureLimitSizeText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The file size is limited to 4 MB per photo. Use a smaller photo if the upload does not work.', 'O', 'messages', '2011-01-13 17:47:51.14', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2690, 'Groups/Constants/groupAdmin', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Group admin', 'O', 'messages', '2010-09-02 16:34:52.972', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2691, 'Groups/Constants/adminLeaveGroupNotPosible', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'You cannot leave this group while you are admin. To leave give your admin status to another group member first.', 'O', 'messages', '2010-09-02 16:34:52.995', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2692, 'Groups/Constants/grantToAdminWarning', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'If you give another group member the admin status, you will loose your admin status. Continue?', 'O', 'messages', '2010-09-02 16:34:52.999', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2693, 'Basic/Constants/whoSeesMyContactdata', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Who can view my contact information?', 'O', 'messages', '2011-01-13 17:47:51.502', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2694, 'Basic/Constants/gotoLogin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Goto login', 'O', 'messages', '2011-01-13 17:47:51.652', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2696, 'Basic/Messages/registErfolgreich', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'We sent an e-mail to <strong>{0}</strong><br ><br > <strong>Please look in your SPAM-folder if you do not find it in your inbox.</strong><br ><br > Click the confirmation link in the e-mail to activate your account.', 'O', 'messages', '2011-01-13 17:47:51.833', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2697, 'Basic/Messages/genetive', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0}''''s', 'O', 'messages', '2011-01-13 17:47:51.88', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2698, 'Basic/Messages/youAreNotAdminOfX', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This action is only allowed for admins and co-admins of "{0}".', 'O', 'messages', '2011-01-13 17:47:52.016', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2699, 'Telltale/Messages/bildVerstossMeldung', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violation in photo -> "{0}" ({1}) in album with ID {2}', 'O', 'messages', '2011-01-13 17:47:52.365', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2700, 'Album/Messages/uploadedBy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Uploaded by {0}', 'O', 'messages', '2011-01-13 17:47:52.9', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2701, 'Forum/Constants/youMayNotPost', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to post in this forum.', 'O', 'messages', '2011-01-13 17:47:52.293', NULL, '2010-08-12 15:14:46.446325');
INSERT INTO base_property VALUES (2702, 'Telltale/Constants/networkNewsReport', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Report place news', 'O', 'messages', '2011-01-13 17:47:52.488', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2703, 'Album/Constants/imageCount', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Photos', 'O', 'messages', '2011-01-13 17:47:52.534', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2704, 'Album/Constants/accessFriends', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contacts only', 'O', 'messages', '2011-01-13 17:47:52.551', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2705, 'Album/Constants/selectOrCreateAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add photos', 'O', 'messages', '2011-01-13 17:47:52.831', NULL, '2010-08-12 15:14:48.437102');
INSERT INTO base_property VALUES (2706, 'Album/Messages/groupMayOnlyContainNImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The upload of your photos failed. A group album may not carry more than {0} photos.', 'O', 'messages', '2011-01-13 17:47:52.908', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2707, 'Footerpages/Constants/agbTextPart7', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.529', NULL, '2010-08-12 15:14:50.303563');
INSERT INTO base_property VALUES (2708, 'Exception/Constants/stillAdminInEntites', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are still admin in the following elements', 'O', 'messages', '2011-01-13 17:47:53.784', NULL, '2010-08-10 18:57:21.513452');
INSERT INTO base_property VALUES (2709, 'Document/Constants/uploaded', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Uploaded', 'O', 'messages', '2011-01-13 17:47:54.32', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2710, 'Document/Constants/memberMayEditComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members may upload documents', 'O', 'messages', '2011-01-13 17:47:54.418', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2711, 'Document/Messages/documentAlreadyCheckedOut', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Document is already checked out by {0} {1}.', 'O', 'messages', '2011-01-13 17:47:54.456', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2712, 'Basic/Constants/pickColor', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Pick color', 'O', 'messages', '2011-01-13 17:47:50.575', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2713, 'Exception/Constants/accountAlreadyExists', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Account already exists.', 'O', 'messages', '2011-01-13 17:47:53.687', NULL, '2010-08-12 15:14:50.823228');
INSERT INTO base_property VALUES (2714, 'Entity/Constants/myEntities/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My groups', 'O', 'messages', '2011-01-13 17:49:57.23', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2715, 'Entity/Constants/entityInvitations/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Group invitations', 'O', 'messages', '2011-01-13 17:49:57.249', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2716, 'Entity/Messages/mailSubjectRequesterList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You have requested for participation', 'O', 'messages', '2011-01-13 17:47:57.941', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2717, 'Entity/Constants/assignedToEntites/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:47:56.108', NULL, '2010-08-12 15:15:04.403136');
INSERT INTO base_property VALUES (2718, 'NewsBlog/Constants/reallyWantToDeleteArticle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you really want to delete this article?', 'O', 'messages', '2011-01-13 17:47:54.793', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2719, 'Entity/Constants/invitationPopupPleaseSelectPersonToInvite/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No person selected, no one to invite.', 'O', 'messages', '2011-01-13 17:47:55.922', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2720, 'Entity/Messages/needToDefineMinEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You have to define {0} place(s) as minimum.', 'O', 'messages', '2011-01-13 17:47:56.392', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2721, 'Entity/Constants/inviteMessage/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:56.843', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2722, 'Entity/Constants/acceptJoinRequest/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:47:56.909', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2723, 'Entity/Constants/backToOverview/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To event', 'O', 'messages', '2011-01-13 17:47:57.064', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2724, 'Entity/Constants/invitationPopupMessage/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:57.498', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2725, 'Entity/Messages/needToDefineMinEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You have to define {0} event(s) as minimum.', 'O', 'messages', '2011-01-13 17:47:57.842', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2726, 'Entity/Messages/subjectTextExternalInvite/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invites you to event "{1}"!', 'O', 'messages', '2011-01-13 17:47:57.897', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2727, 'Entity/Constants/deleteCoAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:49:57.38', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2728, 'Exception/Constants/additionalTermsAcceptanceRequired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to accept the additional terms and conditions.', 'O', 'messages', '2011-01-13 17:47:53.696', NULL, '2010-08-12 15:14:50.843505');
INSERT INTO base_property VALUES (2729, 'Entity/Constants/acceptInvite/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:49:57.418', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2730, 'Entity/Constants/declineJoinRequest/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:49:57.43', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2731, 'Entity/Constants/configComponents/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules', 'O', 'messages', '2011-01-13 17:49:57.675', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2732, 'Entity/Constants/entityWasSelectedError/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This entity was already selected', 'O', 'messages', '2011-01-13 17:49:58.007', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2771, 'Entity/Constants/deleteIcon/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete icon', 'O', 'messages', '2011-01-13 17:47:58.251', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2772, 'Entity/Constants/visibleForMemberOfAssociatedEntities/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:59.781', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2733, 'Exception/Constants/registrationInvitationRequired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This invitation has either expired or the invitation link is invalid.

Please check if the link from your invitation email has been completely copied to your browser destination bar.', 'O', 'messages', '2011-01-13 17:47:53.68', NULL, '2010-08-12 15:14:50.793602');
INSERT INTO base_property VALUES (2734, 'Exception/Constants/termsAcceptanceRequired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to accept the terms and conditions.', 'O', 'messages', '2011-01-13 17:47:53.692', NULL, '2010-08-12 15:14:50.835113');
INSERT INTO base_property VALUES (2735, 'Exception/Messages/isInvalid', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} is invalid.', 'O', 'messages', '2011-01-13 17:47:53.792', NULL, '2010-08-12 15:14:51.057497');
INSERT INTO base_property VALUES (2736, 'Exception/Messages/joinNotPermitted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'It is not permitted to join this {0}', 'O', 'messages', '2011-01-13 17:47:53.796', NULL, '2010-08-12 15:14:51.103293');
INSERT INTO base_property VALUES (2737, 'Exception/Messages/isMandatory', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} is mandatory.', 'O', 'messages', '2011-01-13 17:47:53.8', NULL, '2010-08-12 15:14:51.123215');
INSERT INTO base_property VALUES (2738, 'WikiEditor/Messages/viewVersionHeadline', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'View of version {0} ({1} | {2}) from {3}', 'O', 'messages', '2011-01-13 17:47:54.539', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2739, 'NewsBlog/Constants/publish', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Publish', 'O', 'messages', '2011-01-13 17:47:54.814', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2740, 'Entity/Constants/noMemberOfAnyEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not member of any place.', 'O', 'messages', '2011-01-13 17:47:55.26', NULL, '2010-08-12 19:09:31.7097');
INSERT INTO base_property VALUES (2741, 'Wiki/Constants/adminLeaveGroupAlert', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'If you leave this wiki page, it will be deleted. Leave and delete wiki page?', 'O', 'messages', '2010-09-02 16:34:54.55', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2742, 'Entity/Constants/horizontalNavigationLink/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation: Link', 'O', 'messages', '2011-01-13 17:47:57.336', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2743, 'Entity/Constants/invitationPopupMessage/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:55.896', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2744, 'Entity/Constants/youAreNotAttend/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You do not participate', 'O', 'messages', '2011-01-13 17:47:56.036', NULL, '2010-08-06 17:21:33.097723');
INSERT INTO base_property VALUES (2745, 'Entity/Constants/assignedToEntites/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:47:57.672', NULL, '2010-08-12 15:15:07.694234');
INSERT INTO base_property VALUES (2746, 'Exception/Constants/stillAdminInEntitiesHint', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete these element first or assign a new admin to them.', 'O', 'messages', '2011-01-13 17:47:53.788', NULL, '2010-08-10 18:57:21.524296');
INSERT INTO base_property VALUES (2747, 'Entity/Constants/parentEntityRequiredError/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please assign this event to at least one wiki page', 'O', 'messages', '2011-01-13 17:47:58.804', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2748, 'Entity/Constants/subdomainInUse/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The subdomain is already in use', 'O', 'messages', '2011-01-13 17:47:59.727', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2749, 'Entity/Constants/myEntities/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My projects', 'O', 'messages', '2011-01-13 17:47:59.42', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2750, 'Entity/Constants/assignEntityToElements/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assign this project to other elements', 'O', 'messages', '2011-01-13 17:47:59.429', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2751, 'Entity/Constants/widgetsDontShowSubEntitiesOption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:47:59.464', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2752, '/Basic/Constants/noEntries', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No entries', 'O', 'messages', '2011-01-13 17:47:54.94', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2753, 'Entity/Constants/deleteIcon/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete icon', 'O', 'messages', '2011-01-13 17:47:59.591', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2754, 'Entity/Constants/recursiveAssigmentOccur/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning this element will cause a recursive assignment. Assigning this element is not possible.', 'O', 'messages', '2011-01-13 17:47:58.815', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2755, 'Entity/Messages/userXWillBeRemoveAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} will be removed and notified. The admin status will remain unchanged.', 'O', 'messages', '2011-01-13 17:47:57.916', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2756, 'Entity/Constants/notifcationMailsWasSentToSelectedParticipant', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Notifications sent.', 'O', 'messages', '2011-01-13 17:49:56.168', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2757, 'Entity/Constants/adjustColors/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Customize colors', 'O', 'messages', '2011-01-13 17:47:59.927', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2758, 'Entity/Constants/invitationPopupMessage/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:49:58.039', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2759, 'Entity/Constants/horizontalNavigationLink/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation: Link', 'O', 'messages', '2011-01-13 17:49:57.867', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2760, 'Entity/Messages/xInvitationSkiped/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people were skipped.', 'O', 'messages', '2011-01-13 17:49:58.53', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2761, 'Entity/Constants/makeAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make admin', 'O', 'messages', '2011-01-13 17:47:59.58', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2762, '/Basic/Constants/myNetworks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My places', 'O', 'messages', '2011-01-13 17:47:55.003', NULL, '2010-08-10 18:57:28.863263');
INSERT INTO base_property VALUES (2763, 'Entity/Constants/visibleForAll/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For the whole internet', 'O', 'messages', '2011-01-13 17:47:58.472', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2764, 'Entity/Constants/createOrSearchEntity1/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a new place ', 'O', 'messages', '2011-01-13 17:47:55.265', NULL, '2010-08-12 19:09:31.725643');
INSERT INTO base_property VALUES (2765, 'Entity/Constants/inviteMessage/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message', 'O', 'messages', '2011-01-13 17:47:55.435', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2766, 'Entity/Constants/invitePerson/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite person', 'O', 'messages', '2011-01-13 17:47:55.451', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2767, 'Entity/Constants/componentsLeftColumn/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in left column', 'O', 'messages', '2011-01-13 17:47:55.686', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2768, 'Entity/Constants/assignedToEntites/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:47:59.005', NULL, '2010-08-12 15:15:14.288513');
INSERT INTO base_property VALUES (2769, 'Entity/Constants/backToOverview/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To place', 'O', 'messages', '2011-01-13 17:47:55.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2770, 'Entity/Constants/externalDomainInUse/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External domain already in use', 'O', 'messages', '2011-01-13 17:47:55.597', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2774, 'Entity/Constants/horizontalNavigationBackground/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Horizontal navigation', 'O', 'messages', '2011-01-13 17:47:55.76', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2775, 'Entity/Constants/joiningOnlyForMembersOfPlatform/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:57.148', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2776, 'Entity/Constants/pageBorders/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation and site: Border', 'O', 'messages', '2011-01-13 17:47:57.325', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2777, 'Entity/Constants/visibleForAll/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For the whole internet', 'O', 'messages', '2011-01-13 17:47:55.614', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2778, '/Basic/Constants/moreNetworks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'More...', 'O', 'messages', '2011-01-13 17:47:55.029', NULL, '2010-08-12 15:15:00.123306');
INSERT INTO base_property VALUES (2779, 'Entity/Constants/linkedEntityPrivacyStatusAdminAndMembers/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admins and members', 'O', 'messages', '2011-01-13 17:47:58.765', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2780, 'Entity/Messages/entityMessageText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The following message for ''''{0}'''' was sent to {1} people:

{2}', 'O', 'messages', '2011-01-13 17:47:59.241', NULL, '2010-08-10 18:57:40.883103');
INSERT INTO base_property VALUES (2781, 'Entity/Messages/mailSubjectInvitedList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invitation for wiki page ''''{0}''''', 'O', 'messages', '2011-01-13 17:47:59.306', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2782, 'Entity/Constants/deleteIcon/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete icon', 'O', 'messages', '2011-01-13 17:47:55.466', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2783, 'Entity/Messages/attentionXWillBecomeAdminAndYouWillBecomeCoAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Warning: If you give {0} the admin status, you will become co-admin. Only {0} can give you an admin status again.', 'O', 'messages', '2011-01-13 17:49:58.477', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2784, 'Entity/Constants/closingDate', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Deadline', 'O', 'messages', '2011-01-13 17:49:55.73', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2785, 'Entity/Constants/acceptInvite', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:49:55.824', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2786, 'Entity/Constants/selectASuggestedEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection not found. Please select a suggested entity.', 'O', 'messages', '2011-01-13 17:49:56.407', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2787, 'Entity/Mails/entityMakeAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now admin of space "$ENTITY.Name".

Place:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.426', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2788, 'Entity/Constants/assignedToEntites', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:49:56.646', NULL, '2010-08-12 15:16:26.226016');
INSERT INTO base_property VALUES (2789, 'Entity/Constants/address', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:49:56.79', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2790, 'Videolink/Constants/brokenVideoUrl', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<br/>Could not load the video. Maybe the video link is broken.<br/><br/>', 'O', 'messages', '2011-01-13 17:47:54.149', NULL, '2010-10-26 13:47:47.814049');
INSERT INTO base_property VALUES (2791, 'Entity/Constants/headingBoxText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Text and links', 'O', 'messages', '2011-01-13 17:49:57.886', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2792, 'Videolink/Constants/videoInfo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Supported video hosters are YouTube and Vimeo.', 'O', 'messages', '2011-01-13 17:47:54.279', NULL, '2010-10-26 13:47:48.244756');
INSERT INTO base_property VALUES (2793, 'Entity/Constants/youAreNotAttend/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You do not participate', 'O', 'messages', '2011-01-13 17:49:58.146', NULL, '2010-08-06 17:21:38.40915');
INSERT INTO base_property VALUES (2794, 'NewsBlog/Constants/author', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Author', 'O', 'messages', '2011-01-13 17:47:54.738', NULL, '2010-10-26 13:48:02.837565');
INSERT INTO base_property VALUES (2795, 'Entity/Constants/headingBoxBorder/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Border', 'O', 'messages', '2011-01-13 17:49:57.891', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2796, 'Entity/Constants/statusOptionNotAttend/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I do not participate', 'O', 'messages', '2011-01-13 17:47:58.967', NULL, '2010-08-06 17:21:41.786911');
INSERT INTO base_property VALUES (2797, 'Videolink/Constants/mayNotDelete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You may not delete this video.', 'O', 'messages', '2011-01-13 17:47:54.156', NULL, '2010-10-26 13:47:48.03881');
INSERT INTO base_property VALUES (2798, 'Entity/Constants/entityNotVisibleTitle/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity privacy settings', 'O', 'messages', '2011-01-13 17:48:00.072', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2799, 'Entity/Messages/mailSubjectParticipantList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on participant list', 'O', 'messages', '2011-01-13 17:49:56.923', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2800, 'Entity/Constants/onlyEntitiesWhereYouAreAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You must be admin of this group', 'O', 'messages', '2011-01-13 17:49:57.244', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2801, 'Entity/Mails/entityRemoveMembershipStatus/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from wiki page "$ENTITY.Name".

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.485', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2802, 'Entity/Constants/defaultLinkOverview/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'To project', 'O', 'messages', '2011-01-13 17:48:00.284', NULL, '2010-08-10 18:57:43.90533');
INSERT INTO base_property VALUES (2803, 'Entity/Constants/assignedToEntites/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:49:58.211', NULL, '2010-08-12 15:15:11.013302');
INSERT INTO base_property VALUES (2804, 'Profile/Constants/registration', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Register', 'O', 'messages', '2011-01-13 17:47:45.519', NULL, '2010-10-26 13:48:04.973913');
INSERT INTO base_property VALUES (2805, 'Entity/Constants/memberSettings/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member administration', 'O', 'messages', '2011-01-13 17:47:58.444', NULL, '2010-08-10 18:57:39.363094');
INSERT INTO base_property VALUES (2806, 'Entity/Constants/participantPopupMsgLosingWaitlistPosition/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will loose your position on the waiting list.', 'O', 'messages', '2011-01-13 17:48:00.263', NULL, '2010-08-06 17:21:45.756779');
INSERT INTO base_property VALUES (2807, 'Entity/Constants/contactDataComponent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact data', 'O', 'messages', '2011-01-13 17:49:58.216', NULL, '2010-08-18 11:23:09.773186');
INSERT INTO base_property VALUES (2808, 'Entity/Constants/assignedToEntites/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:48:00.302', NULL, '2010-08-12 15:15:17.166848');
INSERT INTO base_property VALUES (2809, 'Entity/Constants/saveEntitySuccessfully/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:49:57.679', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2844, 'Document/Constants/uploadedBy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'by', 'O', 'messages', '2011-01-13 17:47:54.332', NULL, '2010-10-26 13:47:49.487429');
INSERT INTO base_property VALUES (2921, 'Entity/Constants/subBoxLinks/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Links', 'O', 'messages', '2011-01-13 17:49:57.902', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2810, 'Entity/Constants/ifNoHeader/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you do not upload any header, the group name will appear instead. Best are headers of exactly 783 pixels width and about 80 pixels height. If your header''s width is greater, it will be scaled to fit.', 'O', 'messages', '2011-01-13 17:49:57.842', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2811, 'Entity/Constants/entityClosedNotAcceptingJoinRequestPossibleAnymore/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot accept this request anymore.', 'O', 'messages', '2011-01-13 17:49:58.093', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2812, 'Entity/Mails/entityWaitList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now on waiting list of entity "$ENTITY.Name".

Entity:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.361', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2813, 'Entity/Constants/assignmentOnlyForAdminOrMember/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin or member', 'O', 'messages', '2011-01-13 17:47:56.924', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2814, 'Entity/Constants/assignedTypeNotAllowed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning element of this type is not allowed', 'O', 'messages', '2011-01-13 17:49:55.869', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2815, 'Videolink/Constants/breadcrumbVideos', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Videos', 'O', 'messages', '2011-01-13 17:47:54.282', NULL, '2010-10-26 13:47:48.357113');
INSERT INTO base_property VALUES (2816, 'Entity/Constants/contactName/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:49:57.506', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2817, 'Entity/Constants/createOrSearchEntity1', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a new entity ', 'O', 'messages', '2011-01-13 17:49:56.655', NULL, '2010-08-12 19:16:31.836982');
INSERT INTO base_property VALUES (2818, 'Entity/Constants/widgetsShowSubEntitiesOption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show elements of affiliate elements', 'O', 'messages', '2011-01-13 17:49:57.258', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2819, 'Entity/Mails/entityMoveFromWaitlistToParticipantList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You moved from waiting list to list of participants of wiki page "$ENTITY.Name".

Wiki page:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.475', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2820, 'Entity/Messages/xInvitationViaEmailAlreadyInvited/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people have already been invited by email earlier. Invitations were sent to these people again.', 'O', 'messages', '2011-01-13 17:49:58.531', NULL, '2010-08-17 17:02:09.953444');
INSERT INTO base_property VALUES (2821, 'Entity/Messages/xInvitesToEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} invited you to the following place', 'O', 'messages', '2011-01-13 17:47:56.433', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2822, 'Entity/Constants/createOrSearchEntity1/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a new event ', 'O', 'messages', '2011-01-13 17:47:56.701', NULL, '2010-08-12 19:09:35.403313');
INSERT INTO base_property VALUES (2823, 'Entity/Constants/createOrSearchEntity1/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a new wiki ', 'O', 'messages', '2011-01-13 17:47:58.147', NULL, '2010-08-12 19:09:42.555501');
INSERT INTO base_property VALUES (2824, 'Entity/Constants/createOrSearchEntity2/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or search for one.', 'O', 'messages', '2011-01-13 17:47:58.153', NULL, '2010-08-12 19:09:42.565498');
INSERT INTO base_property VALUES (2825, 'Entity/Constants/parentEntityRequiredError', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please assign this entity to at least one element', 'O', 'messages', '2011-01-13 17:49:56.403', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2826, 'Entity/Constants/createOrSearchEntity1/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a new group ', 'O', 'messages', '2011-01-13 17:49:57.282', NULL, '2010-08-12 19:09:38.974632');
INSERT INTO base_property VALUES (2827, 'Entity/Constants/createOrSearchEntity2/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or search for one.', 'O', 'messages', '2011-01-13 17:49:57.286', NULL, '2010-08-12 19:09:38.983232');
INSERT INTO base_property VALUES (2828, 'Entity/Constants/noMemberOfAnyEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not member of any wiki page.', 'O', 'messages', '2011-01-13 17:47:58.142', NULL, '2010-08-12 19:09:42.544682');
INSERT INTO base_property VALUES (2829, 'Entity/Constants/preview/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:49:57.823', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2830, 'Videolink/Constants/deleteVideo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:54.152', NULL, '2010-10-26 13:47:47.915635');
INSERT INTO base_property VALUES (2831, 'WikiEditor/Constants/content', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Content', 'O', 'messages', '2011-01-13 17:47:54.642', NULL, '2010-08-10 18:57:26.42591');
INSERT INTO base_property VALUES (2832, 'Entity/Constants/createOrSearchEntity2/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or search for one.', 'O', 'messages', '2011-01-13 17:47:56.721', NULL, '2010-08-12 19:09:35.413145');
INSERT INTO base_property VALUES (2833, 'Entity/Constants/statusSaved/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'saved', 'O', 'messages', '2011-01-13 17:47:58.373', NULL, '2010-08-17 17:02:11.154114');
INSERT INTO base_property VALUES (2834, 'Entity/Constants/visibleForWholePlatForm/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for users with an existing platform account', 'O', 'messages', '2011-01-13 17:49:57.629', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2835, 'Entity/Constants/joiningForAll/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Users with and without platform account', 'O', 'messages', '2011-01-13 17:49:57.645', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2836, 'Entity/Messages/externalURLPopupText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>You must set the so called "CNAME" (also called "canonical name") at your domain provider.</p><p>A corresponding function should exist in the maintenance-menu of your domain provider. Make the CNAME-entry point to the name of your group at {0}.</p><p>This should look like this:</p><p><b>www.mydomain.com >> CNAME >> www.{1}.{0}</b></p>', 'O', 'messages', '2011-01-13 17:49:58.473', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2837, 'Entity/Constants/noMemberOfAnyEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not member of any project.', 'O', 'messages', '2011-01-13 17:47:59.478', NULL, '2010-08-12 19:09:46.56503');
INSERT INTO base_property VALUES (2838, 'Entity/Constants/createOrSearchEntity2/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or search for one.', 'O', 'messages', '2011-01-13 17:47:55.27', NULL, '2010-08-12 19:09:31.745707');
INSERT INTO base_property VALUES (2839, 'Entity/Constants/noMemberOfAnyEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not member of any group.', 'O', 'messages', '2011-01-13 17:49:57.277', NULL, '2010-08-12 19:09:38.966286');
INSERT INTO base_property VALUES (2840, 'Entity/Constants/noMemberOfAnyEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not member of any event.', 'O', 'messages', '2011-01-13 17:47:56.683', NULL, '2010-08-12 19:09:35.393189');
INSERT INTO base_property VALUES (2841, 'Entity/Constants/createOrSearchEntity2', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or search for one.', 'O', 'messages', '2011-01-13 17:49:56.659', NULL, '2010-08-12 19:16:31.845632');
INSERT INTO base_property VALUES (2842, 'Entity/Constants/participantSelectedFromWaitlist/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select participants manually from waiting list', 'O', 'messages', '2011-01-13 17:49:57.552', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2843, 'Videolink/Constants/reallyWantToDeleteVideo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you really want do delete the video?', 'O', 'messages', '2011-01-13 17:47:54.276', NULL, '2010-10-26 13:47:48.141942');
INSERT INTO base_property VALUES (2845, 'Entity/Constants/noAssigmentPossible/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No assigments to this entity possible', 'O', 'messages', '2011-01-13 17:49:58.213', NULL, '2010-08-13 17:32:50.633261');
INSERT INTO base_property VALUES (2846, 'Entity/Constants/noMemberOfAnyEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not member of any entity.', 'O', 'messages', '2011-01-13 17:49:56.65', NULL, '2010-08-12 19:16:31.828667');
INSERT INTO base_property VALUES (2847, 'Entity/Constants/noAssigmentPossible', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No assigments to this entity possible', 'O', 'messages', '2011-01-13 17:49:56.663', NULL, '2010-08-13 17:35:32.985737');
INSERT INTO base_property VALUES (2848, 'NewsBlog/Constants/enterHeadlineHere', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enter headline here', 'O', 'messages', '2011-01-13 17:47:54.775', NULL, '2010-08-19 16:44:25.77352');
INSERT INTO base_property VALUES (2849, '/Basic/Constants/elementDoesNotExists', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Element does not exist', 'O', 'messages', '2011-01-13 17:47:54.904', NULL, '2010-08-17 17:02:00.11416');
INSERT INTO base_property VALUES (2850, 'Entity/Constants/assignedTypeNotAllowed/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning element of this type is not allowed', 'O', 'messages', '2011-01-13 17:47:55.485', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2851, 'Entity/Constants/statusSaved/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'saved', 'O', 'messages', '2011-01-13 17:47:55.547', NULL, '2010-08-17 17:02:01.29335');
INSERT INTO base_property VALUES (2852, 'Entity/Constants/membersNavigationDefaultLink/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:55.602', NULL, '2010-08-19 16:44:29.184087');
INSERT INTO base_property VALUES (2853, 'Entity/Constants/statusSaved/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'saved', 'O', 'messages', '2011-01-13 17:47:57.044', NULL, '2010-08-17 17:02:04.403186');
INSERT INTO base_property VALUES (2854, 'Entity/Constants/contactDataComponent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact data', 'O', 'messages', '2011-01-13 17:47:59.013', NULL, '2010-08-18 11:23:13.333145');
INSERT INTO base_property VALUES (2855, 'Entity/Constants/noAssigmentPossible/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No assigments to this entity possible', 'O', 'messages', '2011-01-13 17:47:56.112', NULL, '2010-08-13 17:32:43.490186');
INSERT INTO base_property VALUES (2856, 'Entity/Constants/ifNoHeader/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you do not upload any header, the project name will appear instead. Best are headers of exactly 783 pixels width and about 80 pixels height. If your header''s width is greater, it will be scaled to fit.', 'O', 'messages', '2011-01-13 17:47:59.949', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2857, 'Entity/Messages/mailSubjectMemberStatusRemoved/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed place "{0}"', 'O', 'messages', '2011-01-13 17:47:56.317', NULL, '2010-08-13 17:32:43.665495');
INSERT INTO base_property VALUES (2858, 'Entity/Messages/mailSubjectMemberStatusRemoved/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from event "{0}"', 'O', 'messages', '2011-01-13 17:47:57.884', NULL, '2010-08-13 17:32:47.078219');
INSERT INTO base_property VALUES (2859, 'Album/Constants/notPermittedToCreateAlbum', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not permitted to create albums.', 'O', 'messages', '2011-01-13 17:47:52.613', NULL, '2010-08-17 17:01:49.642055');
INSERT INTO base_property VALUES (2860, 'Entity/Constants/membersNavigationDefaultLink/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:58.44', NULL, '2010-08-19 16:44:40.79963');
INSERT INTO base_property VALUES (2861, 'Entity/Constants/createOrSearchEntity1/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a new project', 'O', 'messages', '2011-01-13 17:47:59.483', NULL, '2010-08-12 19:09:46.573456');
INSERT INTO base_property VALUES (2862, 'Entity/Constants/createOrSearchEntity2/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or search for one.', 'O', 'messages', '2011-01-13 17:47:59.488', NULL, '2010-08-12 19:09:46.58314');
INSERT INTO base_property VALUES (2863, 'Entity/Messages/mailSubjectMemberStatusRemoved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from ''''{0}''''', 'O', 'messages', '2011-01-13 17:49:56.875', NULL, '2010-08-13 17:35:33.065053');
INSERT INTO base_property VALUES (2864, 'Entity/Constants/noAssigmentPossible/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No assigments to this entity possible', 'O', 'messages', '2011-01-13 17:48:00.306', NULL, '2010-08-13 17:32:57.497388');
INSERT INTO base_property VALUES (2865, 'Entity/Messages/mailSubjectMemberStatusRemoved/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from publication "{0}"', 'O', 'messages', '2011-01-13 17:48:00.507', NULL, '2010-08-13 17:32:57.616767');
INSERT INTO base_property VALUES (2866, 'Entity/Messages/xInvitationViaEmailAlreadyInvited', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people have already been invited by email earlier. Invitations were sent to these people again.', 'O', 'messages', '2011-01-13 17:49:56.987', NULL, '2010-08-17 17:16:39.749745');
INSERT INTO base_property VALUES (2867, 'Entity/Constants/parents/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Parents', 'O', 'messages', '2011-01-13 17:49:57.29', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2868, 'Entity/Constants/fax/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:49:57.502', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2869, 'Document/Constants/notAllowedToUpload', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not permitted to upload documents.', 'O', 'messages', '2011-01-13 17:47:54.422', NULL, '2010-08-17 17:01:55.845923');
INSERT INTO base_property VALUES (2870, 'Entity/Messages/xInvitationViaEmailAlreadyInvited/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people have already been invited by email earlier. Invitations were sent to these people again.', 'O', 'messages', '2011-01-13 17:47:56.429', NULL, '2010-08-17 17:02:03.463961');
INSERT INTO base_property VALUES (2871, 'Entity/Constants/noAssigmentPossible/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No assigments to this entity possible', 'O', 'messages', '2011-01-13 17:47:59.01', NULL, '2010-08-13 17:32:54.093063');
INSERT INTO base_property VALUES (2872, 'Entity/Constants/noAssigmentPossible/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No assigments to this entity possible', 'O', 'messages', '2011-01-13 17:47:57.676', NULL, '2010-08-13 17:32:46.934682');
INSERT INTO base_property VALUES (2873, 'Entity/Messages/xInvitationViaEmailAlreadyInvited/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people have already been invited by email earlier. Invitations were sent to these people again.', 'O', 'messages', '2011-01-13 17:47:57.976', NULL, '2010-08-17 17:02:06.443102');
INSERT INTO base_property VALUES (2874, 'Entity/Messages/mailSubjectMemberStatusRemoved/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from wiki page "{0}"', 'O', 'messages', '2011-01-13 17:47:59.228', NULL, '2010-08-13 17:32:54.233048');
INSERT INTO base_property VALUES (2875, 'Entity/Constants/statusSaved/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'saved', 'O', 'messages', '2011-01-13 17:49:57.536', NULL, '2010-08-17 17:02:07.334781');
INSERT INTO base_property VALUES (2876, 'Entity/Messages/mailSubjectMemberStatusRemoved/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from group "{0}"', 'O', 'messages', '2011-01-13 17:49:58.44', NULL, '2010-08-13 17:32:50.92316');
INSERT INTO base_property VALUES (2877, 'Entity/Constants/statusSaved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'saved', 'O', 'messages', '2011-01-13 17:49:55.95', NULL, '2010-08-17 17:16:37.623335');
INSERT INTO base_property VALUES (2878, 'Entity/Constants/membersNavigationDefaultLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:49:56.024', NULL, '2010-08-19 16:45:00.235968');
INSERT INTO base_property VALUES (2879, 'NewsBlog/Constants/notPermittedToPostArticle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to post an article', 'O', 'messages', '2011-01-13 17:47:54.802', NULL, '2010-08-20 11:29:39.856488');
INSERT INTO base_property VALUES (2880, 'Entity/Constants/membersNavigationDefaultLink/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:57.111', NULL, '2010-08-19 16:44:32.673444');
INSERT INTO base_property VALUES (2881, 'Entity/Constants/joiningForAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Users with and without platform account', 'O', 'messages', '2011-01-13 17:49:56.072', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2882, 'Entity/Constants/notAllowedToEditInfoWidget', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit information', 'O', 'messages', '2011-01-13 17:49:56.338', NULL, '2010-08-20 15:18:04.063278');
INSERT INTO base_property VALUES (2883, 'Entity/Messages/xInvitationViaEmailAlreadyInvited/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people have already been invited by email earlier. Invitations were sent to these people again.', 'O', 'messages', '2011-01-13 17:48:00.602', NULL, '2010-08-17 17:02:18.673042');
INSERT INTO base_property VALUES (2884, 'Entity/Constants/horizontalNavigationSuccessfullySaved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation saved.', 'O', 'messages', '2011-01-13 17:49:56.563', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2885, 'Entity/Constants/contactDataComponent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact data', 'O', 'messages', '2011-01-13 17:49:56.667', NULL, '2010-08-18 11:28:53.803321');
INSERT INTO base_property VALUES (2886, 'Entity/Messages/entityInvitationsCount', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity invitations ({0})', 'O', 'messages', '2011-01-13 17:49:56.995', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2887, 'Entity/Constants/membersNavigationDefaultLink/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:49:57.61', NULL, '2010-08-19 16:44:36.485863');
INSERT INTO base_property VALUES (2888, 'Entity/Constants/notAllowedToEditInfoWidget/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit information', 'O', 'messages', '2011-01-13 17:49:57.97', NULL, '2010-08-20 15:16:21.963392');
INSERT INTO base_property VALUES (2889, 'Footerpages/Constants/uebertoroTextPart3', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.652', NULL, '2010-08-19 16:44:19.757187');
INSERT INTO base_property VALUES (2890, 'NewsletterHtml/Messages/groupJoined', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (joined group <a href="{2}">{3}</a>)', 'O', 'messages', '2011-01-13 17:47:49.556', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2891, 'NewsletterHtml/Messages/profileChanged', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (<a href="{0}">profile</a> modified)', 'O', 'messages', '2011-01-13 17:47:49.579', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2892, 'Newsletter/Messages/newEntityVersion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} (new version)', 'O', 'messages', '2011-01-13 17:47:49.809', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2893, 'Entity/Constants/invitationPopupSelection', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection', 'O', 'messages', '2011-01-13 17:49:56.427', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2894, 'Basic/Constants/lastFourWeeks', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Last 4 weeks', 'O', 'messages', '2010-10-22 17:52:23.658', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2895, 'Basic/Constants/suchen', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Search', 'O', 'messages', '2010-10-22 17:52:25.082', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2896, 'Basic/Constants/online', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Online!', 'O', 'messages', '2011-01-13 17:47:50.045', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2897, 'Basic/Constants/deleteAccountTitle', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete your account irrevocably.', 'O', 'messages', '2011-01-13 17:47:50.258', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2898, 'Basic/Constants/university', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'College/university', 'O', 'messages', '2011-01-13 17:47:50.055', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2899, 'Basic/Constants/activated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activated', 'O', 'messages', '2011-01-13 17:47:50.182', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2900, 'Basic/Constants/meldenFehlgeschlagen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Submission of report failed!', 'O', 'messages', '2011-01-13 17:47:50.253', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2901, 'Footerpages/Constants/uebertoroTextPart2', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '', 'O', 'messages', '2011-01-13 17:47:53.648', NULL, '2010-08-19 16:44:19.706783');
INSERT INTO base_property VALUES (2902, 'Entity/Constants/statusSaved/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'saved', 'O', 'messages', '2011-01-13 17:47:59.676', NULL, '2010-08-17 17:02:15.604936');
INSERT INTO base_property VALUES (2903, 'Document/Constants/commentIsReferringVersion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'referring version', 'O', 'messages', '2011-01-13 17:47:54.426', NULL, '2010-08-20 11:29:37.119988');
INSERT INTO base_property VALUES (2904, 'NewsletterHtml/Messages/newDocument', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<a href="{0}">{1}</a> (new)', 'O', 'messages', '2011-01-13 17:47:49.668', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2905, 'Entity/Constants/membersNavigationDefaultLink/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:47:59.751', NULL, '2010-08-19 16:44:45.375595');
INSERT INTO base_property VALUES (2906, 'Entity/Constants/notAllowedToEditInfoWidget/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit information', 'O', 'messages', '2011-01-13 17:47:55.827', NULL, '2010-08-20 15:16:13.462765');
INSERT INTO base_property VALUES (2907, 'Entity/Constants/contactDataComponent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact data', 'O', 'messages', '2011-01-13 17:47:56.116', NULL, '2010-08-18 11:23:03.584682');
INSERT INTO base_property VALUES (2908, 'Entity/Constants/notAllowedToEditInfoWidget/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit information', 'O', 'messages', '2011-01-13 17:47:57.419', NULL, '2010-08-20 15:16:18.057986');
INSERT INTO base_property VALUES (2909, 'Entity/Constants/contactDataComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact data', 'O', 'messages', '2011-01-13 17:47:57.68', NULL, '2010-08-18 11:23:06.704185');
INSERT INTO base_property VALUES (2910, 'Entity/Constants/notAllowedToEditInfoWidget/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit information', 'O', 'messages', '2011-01-13 17:47:58.75', NULL, '2010-08-20 15:16:25.475304');
INSERT INTO base_property VALUES (2911, 'Entity/Messages/xInvitationViaEmailAlreadyInvited/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} people have already been invited by email earlier. Invitations were sent to these people again.', 'O', 'messages', '2011-01-13 17:47:59.334', NULL, '2010-08-17 17:02:14.146468');
INSERT INTO base_property VALUES (2912, 'Entity/Constants/contactDataComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Contact data', 'O', 'messages', '2011-01-13 17:48:00.31', NULL, '2010-08-18 11:23:17.453182');
INSERT INTO base_property VALUES (2913, 'Entity/Constants/notAllowedToEditInfoWidget/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit information', 'O', 'messages', '2011-01-13 17:48:00.064', NULL, '2010-08-20 15:16:29.105166');
INSERT INTO base_property VALUES (2914, 'Entity/Constants/joiningOnlyForMembersOfLinkedEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:49:57.654', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2915, 'Basic/Constants/noProfilePictureUploadedText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please upload a profile photo.', 'O', 'messages', '2011-01-13 17:47:50.474', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2916, 'Basic/Constants/name', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:47:51.684', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2917, 'Basic/Constants/informFriendsYes', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Yes', 'O', 'messages', '2011-01-13 17:47:51.527', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2918, 'Telltale/Constants/gewalt', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Violent content', 'O', 'messages', '2011-01-13 17:47:52.459', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2959, 'Entity/Constants/invitePerson/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite person', 'O', 'messages', '2011-01-13 17:49:57.372', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2919, 'Album/Messages/albumMayOnlyContainNImages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This album may only carry {0} photos.', 'O', 'messages', '2011-01-13 17:47:52.905', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2920, 'Profile/Constants/zipcode', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:47:45.601', NULL, '2010-10-26 13:48:06.127685');
INSERT INTO base_property VALUES (2922, 'Telltale/Constants/whyDeleteNetwork', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', '<b>Why should the place be deleted?</b>', 'O', 'messages', '2010-10-08 11:37:45.106', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2923, 'Basic/Constants/freundeslisteZeigen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show contact list', 'O', 'messages', '2011-01-13 17:47:50.58', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2924, 'Basic/Constants/timezone', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:47:49.981', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2925, 'Profile/Constants/street', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:47:45.636', NULL, '2010-10-26 13:48:06.762738');
INSERT INTO base_property VALUES (2926, 'Entity/Constants/enterEmailHelpText/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma, semicolon, space or return', 'O', 'messages', '2011-01-13 17:49:58.081', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2927, 'Profile/Constants/firstName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Firstname', 'O', 'messages', '2011-01-13 17:47:45.54', NULL, '2010-10-26 13:48:05.078914');
INSERT INTO base_property VALUES (2928, 'Basic/Constants/nachname', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Lastname', 'O', 'messages', '2011-01-13 17:47:50.089', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2929, 'Basic/Constants/uploadfileNotSelected', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'You need to select a file to upload.', 'O', 'messages', '2010-10-22 17:52:24.286', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2930, 'Basic/Constants/passwdOnlyLetters', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please use upper and lower case or add a number or a special character for your password.', 'O', 'messages', '2011-01-13 17:47:50.148', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2931, 'Album/Constants/nextImage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Next', 'O', 'messages', '2011-01-13 17:47:52.865', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2932, 'Album/Constants/closePictureUploadDialog', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Close dialog', 'O', 'messages', '2011-01-13 17:47:52.794', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2933, 'Entity/Constants/configEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Settings', 'O', 'messages', '2011-01-13 17:49:57.691', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2934, 'Profile/Constants/lastName', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Lastname', 'O', 'messages', '2011-01-13 17:47:45.548', NULL, '2010-10-26 13:48:05.082838');
INSERT INTO base_property VALUES (2935, 'Profile/Constants/university', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'College/University', 'O', 'messages', '2011-01-13 17:47:45.56', NULL, '2010-10-26 13:48:05.294745');
INSERT INTO base_property VALUES (2936, 'Basic/Constants/passwdTooShort', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Password is shorter than 8 characters.', 'O', 'messages', '2011-01-13 17:47:50.137', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2937, 'Basic/Constants/showLastActionsInNetworks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My activities may be shown to other users', 'O', 'messages', '2011-01-13 17:47:50.873', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2938, 'Basic/Constants/fehlerNachrichtLoeschen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'An error occurred while deleting the message.', 'O', 'messages', '2011-01-13 17:47:51.121', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2939, 'Basic/Constants/hideOldMessages', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide messages', 'O', 'messages', '2011-01-13 17:47:51.233', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2940, 'Forum/Constants/neuesThemaAnlegen', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Start topic.', 'O', 'messages', '2011-01-13 17:47:52.262', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2941, 'Basic/Messages/enteredDateInvalid', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The date entered in field "{0}" is invalid.', 'O', 'messages', '2011-01-13 17:47:51.993', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2942, 'Basic/Constants/pagerZurueck', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<<', 'O', 'messages', '2011-01-13 17:47:50.479', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2943, 'Groups/Constants/inviteMemberToGroup', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Invite your contacts to join this group.', 'O', 'messages', '2010-09-02 16:34:52.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2944, 'Basic/Constants/passwdInsecure', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your password is unsafe.', 'O', 'messages', '2011-01-13 17:47:50.133', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2945, 'Basic/Constants/clickHereToLogin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Click here to get to login page.', 'O', 'messages', '2011-01-13 17:47:50.402', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2946, 'Basic/Constants/additionalOptions', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activities', 'O', 'messages', '2011-01-13 17:47:51.014', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2947, 'Profile/Constants/currentCity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current city', 'O', 'messages', '2011-01-13 17:47:45.647', NULL, '2010-10-26 13:48:06.999105');
INSERT INTO base_property VALUES (2948, 'Basic/Constants/savedAndMailSend', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved. You will receive a confirmation e-mail that contains a link to activate your new e-mail address.', 'O', 'messages', '2011-01-13 17:47:51.64', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2949, 'Forum/Constants/noTopicStarted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No topic.', 'O', 'messages', '2011-01-13 17:47:52.257', NULL, '2010-08-12 19:09:17.821778');
INSERT INTO base_property VALUES (2950, 'Basic/Messages/messageTextTooLong', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The text entered is too long. A maximum of {0} characters are allowed.', 'O', 'messages', '2011-01-13 17:47:51.906', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2951, 'Document/Messages/documentIsCheckedOut', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Document is checked out by {0} {1}. Upload a new version anyway?', 'O', 'messages', '2011-01-13 17:47:54.458', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2952, 'Entity/Constants/entityClosedNotAcceptingInvitationPossibleAnymore/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot take part any more.', 'O', 'messages', '2011-01-13 17:47:57.548', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2953, 'Entity/Constants/removeJoinEntityRequest/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove join request', 'O', 'messages', '2011-01-13 17:49:57.687', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2954, 'Entity/Constants/recursiveAssigmentOccur/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning this element will cause a recursive assignment. Assigning this element is not possible.', 'O', 'messages', '2011-01-13 17:47:57.487', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2955, 'Entity/Constants/subBox/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox', 'O', 'messages', '2011-01-13 17:47:57.361', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2956, 'Entity/Constants/invitationPopupNoPersonsFound/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No people found, nothing to insert.', 'O', 'messages', '2011-01-13 17:47:57.519', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2957, 'Entity/Constants/participantPopupMsgLosingWaitlistPosition/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will loose your position on the waiting list.', 'O', 'messages', '2011-01-13 17:47:57.626', NULL, '2010-08-06 17:21:35.786948');
INSERT INTO base_property VALUES (2958, 'Entity/Constants/closingDate/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline', 'O', 'messages', '2011-01-13 17:47:56.83', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2960, 'Entity/Constants/joiningByRequestOrInviteOnly/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only by request or invitation', 'O', 'messages', '2011-01-13 17:49:57.658', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2961, 'Entity/Constants/website/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:49:57.479', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2962, 'Entity/Constants/linksOnBackground/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Background: Links', 'O', 'messages', '2011-01-13 17:47:57.39', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2963, 'Document/Constants/documentMarkedAsCheckedOut', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Document was checked out. Click on the link below to download it.', 'O', 'messages', '2011-01-13 17:47:54.363', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2964, 'Document/Constants/checkIn', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Check in', 'O', 'messages', '2011-01-13 17:47:54.39', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2965, 'WikiEditor/Messages/reallyRestore', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Restore version {0}?', 'O', 'messages', '2011-01-13 17:47:54.533', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2966, '/Basic/Constants/seperateTagsWithComma', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Seperate tags with a comma', 'O', 'messages', '2011-01-13 17:47:54.983', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2967, 'Exception/Constants/superAdminOnly', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This function is only allowed for admins.', 'O', 'messages', '2011-01-13 17:47:53.66', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2968, '/Basic/Constants/cancel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:47:55.177', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2969, '/Basic/Constants/delete', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:47:55.158', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2970, 'Entity/Constants/visibleForMember/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members', 'O', 'messages', '2011-01-13 17:47:55.618', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2971, 'Entity/Constants/navigationSeparator/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation separator', 'O', 'messages', '2011-01-13 17:47:55.506', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2972, 'Entity/Constants/linkedEntityPrivacyStatusAdminOnly/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins', 'O', 'messages', '2011-01-13 17:47:55.847', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2973, 'Entity/Constants/visibleForWholePlatForm/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:55.612', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2974, 'Entity/Constants/street/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street', 'O', 'messages', '2011-01-13 17:47:55.499', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2975, 'Entity/Constants/participantSelectedFromWaitlist/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select participants manually from waiting list', 'O', 'messages', '2011-01-13 17:47:55.56', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2976, 'Entity/Constants/invitationPopupNoPersonsInserted/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No one added, everyone is already in your list.', 'O', 'messages', '2011-01-13 17:47:55.926', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2977, 'Entity/Messages/xWantJoinEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wants to join the following place.', 'O', 'messages', '2011-01-13 17:47:56.438', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2978, 'Entity/Constants/entityClosedNotAcceptingInvitationPossibleAnymore/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot take part any more.', 'O', 'messages', '2011-01-13 17:47:55.962', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2979, 'Entity/Constants/youAreUndecided/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are undecided', 'O', 'messages', '2011-01-13 17:47:56.04', NULL, '2010-08-06 17:21:33.106921');
INSERT INTO base_property VALUES (2980, 'Entity/Constants/horizontalNavigationEnterTitleAndLink/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter link name and link target', 'O', 'messages', '2011-01-13 17:47:56.02', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2981, 'Entity/Constants/myMemberStatusComponent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attending status', 'O', 'messages', '2011-01-13 17:47:57.215', NULL, '2010-08-06 17:21:34.686954');
INSERT INTO base_property VALUES (2982, 'Entity/Constants/website/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:47:56.979', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2983, 'Wiki/Constants/adminLeaveGroupNotPosible', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'As long as you are the wiki page admin, you cannot leave this wiki page. To leave this wiki page, make another member admin.', 'O', 'messages', '2010-09-02 16:34:54.544', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2984, 'Entity/Constants/saveEntitySuccessfully/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:47:57.182', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2985, 'Entity/Constants/componentsRightColumn/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modules in right column', 'O', 'messages', '2011-01-13 17:47:57.236', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2986, 'Entity/Constants/zipcode/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:47:55.496', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2987, 'Exception/Constants/captchaCodeCheckFailed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The security code entered was invalid. A new one is displayed. Please enter this one.', 'O', 'messages', '2011-01-13 17:47:53.684', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2988, 'Entity/Constants/location/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:48:00.436', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2989, 'Entity/Constants/subBoxBorder/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Border', 'O', 'messages', '2011-01-13 17:47:58.703', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2990, 'Entity/Constants/assignmentOnlyForAdminOrMember/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to be admin or member', 'O', 'messages', '2011-01-13 17:49:57.438', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2991, 'Entity/Constants/visibleForMemberOfAssociatedEntities/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:49:57.638', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2992, 'Entity/Constants/infoWidgetComponent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:47:59.548', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2993, 'Entity/Constants/visibleForMember/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members', 'O', 'messages', '2011-01-13 17:49:57.641', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2994, 'Entity/Constants/externalDomainInUse/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'External domain already in use', 'O', 'messages', '2011-01-13 17:47:59.73', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2995, 'Entity/Constants/headerBackground/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Header', 'O', 'messages', '2011-01-13 17:49:57.871', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2996, 'Entity/Constants/linkedEntityPrivacyStatusAdminOnly/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins', 'O', 'messages', '2011-01-13 17:49:57.99', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2997, 'Entity/Constants/subBoxBorder/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subbox: Border', 'O', 'messages', '2011-01-13 17:49:57.906', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2998, 'NewsBlog/Constants/memberMayEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members may post news', 'O', 'messages', '2011-01-13 17:47:54.754', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (2999, '/Basic/Constants/assignment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:47:54.925', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3000, 'Entity/Constants/onlyEntitiesWhereYouAreAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You must be admin of this wiki page', 'O', 'messages', '2011-01-13 17:47:58.092', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3001, 'Entity/Constants/deleteLogo/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete logo', 'O', 'messages', '2011-01-13 17:47:58.256', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3002, 'Entity/Constants/selectASuggestedEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection not found. Please select a suggested entity.', 'O', 'messages', '2011-01-13 17:47:58.808', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3003, 'Entity/Messages/mailSubjectParticipantList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on participant list', 'O', 'messages', '2011-01-13 17:47:59.303', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3004, 'Entity/Constants/entityInvitations/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Project invitations', 'O', 'messages', '2011-01-13 17:47:59.448', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3005, 'Entity/Constants/invitationPopupNoPersonsInserted/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No one added, everyone is already in your list.', 'O', 'messages', '2011-01-13 17:49:58.058', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3006, 'Entity/Constants/makeCoAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Make co-admin', 'O', 'messages', '2011-01-13 17:47:59.583', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3007, 'Profile/Constants/school', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'School', 'O', 'messages', '2011-01-13 17:47:45.554', NULL, '2010-10-26 13:48:05.185296');
INSERT INTO base_property VALUES (3008, 'Entity/Constants/visibleForWholePlatForm/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:59.772', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3009, 'Entity/Constants/preview/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Preview', 'O', 'messages', '2011-01-13 17:47:59.931', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3010, 'Entity/Mails/entityMoveFromWaitlistToParticipantList', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You moved from waiting list to list of participants of entity "$ENTITY.Name".

Entity:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.355', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3011, 'Entity/Constants/assignedTypeNotAllowed/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning element of this type is not allowed', 'O', 'messages', '2011-01-13 17:47:59.625', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3012, 'Profile/Constants/mobilePhone', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mobile', 'O', 'messages', '2011-01-13 17:47:45.631', NULL, '2010-10-26 13:48:06.646186');
INSERT INTO base_property VALUES (3013, 'WikiEditor/Constants/youMayNotEdit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to edit this wiki text.', 'O', 'messages', '2011-01-13 17:47:54.622', NULL, '2010-08-06 17:21:28.567158');
INSERT INTO base_property VALUES (3014, 'NewsBlog/Constants/pleaseFillHeadline', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please fill headline', 'O', 'messages', '2011-01-13 17:47:54.766', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3015, 'NewsBlog/Constants/editDraft', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit draft', 'O', 'messages', '2011-01-13 17:47:54.808', NULL, '2010-08-20 11:29:39.868732');
INSERT INTO base_property VALUES (3016, 'Entity/Constants/pageBorders/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Navigation and site: Border', 'O', 'messages', '2011-01-13 17:47:55.756', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3017, 'Entity/Constants/joiningOnlyForMembersOfLinkedEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:58.491', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3018, 'Entity/Constants/thisEntityAndSubItems/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This project and subitems', 'O', 'messages', '2011-01-13 17:47:59.469', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3019, 'Entity/Constants/entityName/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki page name', 'O', 'messages', '2011-01-13 17:47:58.049', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3020, 'Entity/Messages/mailSubjectWaitList/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': You are listed on waiting list', 'O', 'messages', '2011-01-13 17:47:59.27', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3021, 'Entity/Constants/zipcode', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:49:55.891', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3022, 'Entity/Constants/participantLimitedTo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Limit participants to', 'O', 'messages', '2011-01-13 17:49:55.962', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3023, 'Entity/Constants/addEmails/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:49:58.085', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3024, 'Entity/Constants/headingBoxText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Text and links', 'O', 'messages', '2011-01-13 17:49:56.271', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3025, 'Entity/Constants/entityClosedNotAcceptingJoinRequestPossibleAnymore', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot accept this request anymore.', 'O', 'messages', '2011-01-13 17:49:56.492', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3026, 'Entity/Constants/joiningOnlyForMembersOfPlatform/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only users with an existing platform account', 'O', 'messages', '2011-01-13 17:49:57.649', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3027, 'Entity/Constants/selectASuggestedEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Selection not found. Please select a suggested entity.', 'O', 'messages', '2011-01-13 17:49:58.02', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3028, 'Entity/Mails/entityParticipantList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Now you are member of group "$ENTITY.Name".

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.447', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3029, 'Entity/Constants/recursiveAssigmentOccur/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigning this element will cause a recursive assignment. Assigning this element is not possible.', 'O', 'messages', '2011-01-13 17:49:58.027', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3030, 'Entity/Constants/invitationPopupNoPersonsFound/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No people found, nothing to insert.', 'O', 'messages', '2011-01-13 17:49:58.062', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3031, 'Profile/Constants/landLine', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Land line', 'O', 'messages', '2011-01-13 17:47:45.652', NULL, '2010-10-26 13:48:07.108219');
INSERT INTO base_property VALUES (3032, 'Entity/Mails/entityDataChanged/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname modified event "$ENTITY.Name":

$ENTITY_OLD_DATA

Changed to:

$ENTITY_NEW_DATA

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.559', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3033, 'Telltale/Messages/netzwerkLoeschBeantragungMailHeader', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Deletion request for place "{0}" (ID: {1}) has been submitted.', 'O', 'messages', '2010-10-08 11:37:45.038', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3034, 'Entity/Mails/entityRemoveMembershipStatus/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You were removed from project "$ENTITY.Name".

Project:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.592', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3035, 'Entity/Constants/youAreUndecided/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are undecided', 'O', 'messages', '2011-01-13 17:49:58.15', NULL, '2010-08-06 17:21:38.417475');
INSERT INTO base_property VALUES (3036, 'Entity/Constants/realyWantToDeleteEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Do you realy want to delete this group?', 'O', 'messages', '2011-01-13 17:49:58.197', NULL, '2010-08-10 18:57:38.073063');
INSERT INTO base_property VALUES (3037, 'Profile/Constants/favouriteMusic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favourite music', 'O', 'messages', '2011-01-13 17:47:45.687', NULL, '2010-10-26 13:48:07.422755');
INSERT INTO base_property VALUES (3038, 'Profile/Constants/favouriteSeries', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favourite series', 'O', 'messages', '2011-01-13 17:47:45.695', NULL, '2010-10-26 13:48:07.626868');
INSERT INTO base_property VALUES (3039, 'Profile/Constants/interests', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Interests', 'O', 'messages', '2011-01-13 17:47:45.735', NULL, '2010-10-26 13:48:07.942831');
INSERT INTO base_property VALUES (3040, 'Basic/Constants/kaiooNewMailSubject', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Confirmation of your new e-mail address', 'O', 'messages', '2011-01-13 17:47:50.028', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3041, 'Entity/Constants/participantSelectedFromWaitlist/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select participants manually from waiting list', 'O', 'messages', '2011-01-13 17:47:58.388', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3042, 'Entity/Constants/joiningOnlyForMembersOfLinkedEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members of directly associated elements', 'O', 'messages', '2011-01-13 17:47:59.795', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3043, 'Entity/Mails/entityParticipantList/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Now you are member of the place "$ENTITY.Name".

Place:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.394', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3044, 'Entity/Constants/entityClosedNotAcceptingInvitationPossibleAnymore/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot take part any more.', 'O', 'messages', '2011-01-13 17:47:58.876', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3045, 'Entity/Mails/entityDataChanged', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname modified entity "$ENTITY.Name":

$ENTITY_OLD_DATA

Changed to:

$ENTITY_NEW_DATA

Entity:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.37', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3046, 'Entity/Mails/entityMoveFromWaitlistToParticipantList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You moved from waiting list to list of participants of event "$ENTITY.Name".

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.55', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3047, 'Profile/Constants/aktivities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activities', 'O', 'messages', '2011-01-13 17:47:45.987', NULL, '2010-10-26 13:48:12.230618');
INSERT INTO base_property VALUES (3048, 'Entity/Mails/entityDeleted/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname deleted the event "$ENTITY.Name".


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.561', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3049, 'Exception/Constants/registrationEntityIdRequired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For registration an element is required.', 'O', 'messages', '2011-01-13 17:47:53.676', NULL, '2010-08-12 15:14:50.803303');
INSERT INTO base_property VALUES (3050, 'Entity/Constants/ifNoHeader/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you do not upload any header, the place name will appear instead. Best are headers of exactly 783 pixels width and about 80 pixels height. If your header''s width is greater, it will be scaled to fit.', 'O', 'messages', '2011-01-13 17:47:55.75', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3051, 'Entity/Messages/externalURLPopupText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>You must set the so called "CNAME" (also called "canonical name") at your domain provider.</p><p>A corresponding function should exist in the maintenance-menu of your domain provider. Make the CNAME-entry point to the name of your entity at {0}.</p><p>This should look like this:</p><p><b>www.mydomain.com >> CNAME >> www.{1}.{0}</b></p>', 'O', 'messages', '2011-01-13 17:49:56.895', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3052, 'Profile/Constants/favouriteQuotes', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favourite quotes', 'O', 'messages', '2011-01-13 17:47:45.691', NULL, '2010-10-26 13:48:07.525886');
INSERT INTO base_property VALUES (3053, '/Comments/Messages/commentTextTooLong', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Comment text has more than {0} characters.', 'O', 'messages', '2011-01-13 17:49:57.1', NULL, '2010-08-23 13:16:25.462239');
INSERT INTO base_property VALUES (3054, 'Profile/Constants/male', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'male', 'O', 'messages', '2011-01-13 17:47:45.96', NULL, '2010-10-26 13:48:11.821653');
INSERT INTO base_property VALUES (3055, 'Entity/Constants/invitationPopupNoPersonsFound/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No people found, nothing to insert.', 'O', 'messages', '2011-01-13 17:47:55.93', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3056, 'Entity/Messages/externalURLPopupText/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>You must set the so called "CNAME" (also called "canonical name") at your domain provider.</p><p>A corresponding function should exist in the maintenance-menu of your domain provider. Make the CNAME-entry point to the name of your place at {0}.</p><p>This should look like this:</p><p><b>www.mydomain.com >> CNAME >> www.{1}.{0}</b></p>', 'O', 'messages', '2011-01-13 17:47:56.338', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3057, 'Entity/Constants/googleMapAPIKeyHelpText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>If you enter an external place URL, Google Maps will not work any more, since the current global key only works for subdomains.</p><p>If you want use Google Maps with an external URL, you need to obtain a Google Maps-API key for your domain and enter it here.</p><p>See: <a href="http://code.google.com/intl/en-US/apis/maps/signup.html" target="_blank">http://code.google.com/intl/en-US/apis/maps/signup.html</a></p>', 'O', 'messages', '2011-01-13 17:47:58.422', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3058, 'Profile/Constants/title', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Title', 'O', 'messages', '2011-01-13 17:47:46.075', NULL, '2010-10-26 13:48:12.756126');
INSERT INTO base_property VALUES (3059, 'Profile/Constants/currentCountry', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Current country', 'O', 'messages', '2011-01-13 17:47:45.681', NULL, '2010-10-26 13:48:07.209699');
INSERT INTO base_property VALUES (3060, 'Profile/Constants/universityDegree', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Degree', 'O', 'messages', '2011-01-13 17:47:45.756', NULL, '2010-10-26 13:48:08.380684');
INSERT INTO base_property VALUES (3061, 'Profile/Constants/additionalTermsAccepted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I accept the data transfer.', 'O', 'messages', '2011-01-13 17:47:45.972', NULL, '2010-10-26 13:48:12.028644');
INSERT INTO base_property VALUES (3062, 'Entity/Constants/joiningOnlyForMembersOfPlatform/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only users with an existing platform account', 'O', 'messages', '2011-01-13 17:47:59.792', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3063, 'Profile/Constants/favouriteBooks', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Favourite books', 'O', 'messages', '2011-01-13 17:47:45.685', NULL, '2010-10-26 13:48:07.311669');
INSERT INTO base_property VALUES (3064, 'Profile/Constants/completeRegistrationHeading', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Security question to complete registration', 'O', 'messages', '2011-01-13 17:47:45.949', NULL, '2010-10-26 13:48:11.603702');
INSERT INTO base_property VALUES (3065, 'Profile/Constants/aboutMe', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'About me', 'O', 'messages', '2011-01-13 17:47:45.983', NULL, '2010-10-26 13:48:09.197502');
INSERT INTO base_property VALUES (3066, 'Network/Messages/navigationSeparatorExtraText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The recommended grapic dimensions are {0} pixels width and {1} pixels height. If the height is less or more than {1} pixels the graphic will be scaled to a height of {1} pixels. If after scaling the width is more than {0} pixels, the graphic will be cropped at its right end. If after scaling the width is less than {0} pixels, the graphic will be tiled to fill {0} pixels.', 'O', 'messages', '2011-01-13 17:47:52.196', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3067, 'Entity/Messages/mailSubjectEntityDataChanged/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': Some important data changed ', 'O', 'messages', '2011-01-13 17:47:57.948', NULL, '2010-09-23 01:57:46.038148');
INSERT INTO base_property VALUES (3068, 'Entity/Constants/dontAggregateWorkstreamOption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:47:58.905', NULL, '2010-09-23 01:57:46.832947');
INSERT INTO base_property VALUES (3069, 'Entity/Constants/notifyEntityAboutDataChange/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You changed time or place. Notify about changes by email?', 'O', 'messages', '2011-01-13 17:47:59.018', NULL, '2010-09-23 01:57:46.895066');
INSERT INTO base_property VALUES (3070, '/Basic/Constants/hide', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:47:55.167', NULL, '2010-09-23 01:57:44.272916');
INSERT INTO base_property VALUES (3071, 'Entity/Messages/feedNewMembership/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} joined the appointment {1}', 'O', 'messages', '2011-01-13 17:47:57.825', NULL, '2010-09-23 01:57:45.933389');
INSERT INTO base_property VALUES (3072, 'Entity/Constants/exportEntityMemberAndChildEntitiesToCSV/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list (also including assigned elements where you are Admin of)', 'O', 'messages', '2011-01-13 17:47:56.157', NULL, '2010-09-23 01:57:44.971684');
INSERT INTO base_property VALUES (3073, 'Entity/Messages/feedOrigin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'in wiki page {0}', 'O', 'messages', '2011-01-13 17:47:59.18', NULL, '2010-09-23 01:57:46.947331');
INSERT INTO base_property VALUES (3074, 'Entity/Constants/alsoAttendTo/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also attend to:', 'O', 'messages', '2011-01-13 17:47:57.701', NULL, '2010-09-23 01:57:45.799141');
INSERT INTO base_property VALUES (3075, 'Entity/Constants/attendToEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to entity', 'O', 'messages', '2011-01-13 17:47:59.039', NULL, '2010-09-23 01:57:46.911483');
INSERT INTO base_property VALUES (3076, 'Entity/Constants/exportEntityMemberToCSV/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list', 'O', 'messages', '2011-01-13 17:47:59.048', NULL, '2010-09-23 01:57:46.918525');
INSERT INTO base_property VALUES (3077, 'Entity/Constants/aggregateWorkstream/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Microblog and activities', 'O', 'messages', '2011-01-13 17:47:57.029', NULL, '2010-09-23 01:57:45.376553');
INSERT INTO base_property VALUES (3078, 'Entity/Constants/youdidntParticipate/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You didn''t participate.', 'O', 'messages', '2011-01-13 17:47:57.694', NULL, '2010-09-23 01:57:45.781378');
INSERT INTO base_property VALUES (3079, '/Basic/Constants/removeQuestion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your data will be removed. Do you want to continue?', 'O', 'messages', '2011-01-13 17:47:55.075', NULL, '2010-09-23 01:57:44.247414');
INSERT INTO base_property VALUES (3080, '/Basic/Constants/tillToday', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'till today', 'O', 'messages', '2011-01-13 17:47:55.082', NULL, '2010-09-23 01:57:44.25259');
INSERT INTO base_property VALUES (3081, 'Entity/Constants/alsoAttendTo/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also attend to:', 'O', 'messages', '2011-01-13 17:47:56.14', NULL, '2010-09-23 01:57:44.959396');
INSERT INTO base_property VALUES (3082, 'Entity/Constants/participateToAssignedEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Become member of assigned places', 'O', 'messages', '2011-01-13 17:47:56.147', NULL, '2010-09-23 01:57:44.966258');
INSERT INTO base_property VALUES (3083, 'Entity/Messages/feedNewMembership/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} joined the place {1}', 'O', 'messages', '2011-01-13 17:47:56.27', NULL, '2010-09-23 01:57:45.010339');
INSERT INTO base_property VALUES (3084, 'Entity/Messages/feedNewWikiVersion/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created version {1} in the wiki editor', 'O', 'messages', '2011-01-13 17:47:56.301', NULL, '2010-09-23 01:57:45.032506');
INSERT INTO base_property VALUES (3085, 'Entity/Constants/ifNoHeader/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'If you do not upload any header, the wiki page name will appear instead. Best are headers of exactly 783 pixels width and about 80 pixels height. If your header''s width is greater, it will be scaled to fit.', 'O', 'messages', '2011-01-13 17:47:58.645', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3086, 'Entity/Messages/mailSubjectEntityDataChanged/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': Some important data changed ', 'O', 'messages', '2011-01-13 17:47:56.388', NULL, '2010-09-23 01:57:45.081318');
INSERT INTO base_property VALUES (3087, 'Entity/Constants/notAllowedToAddEntityHere/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to add something here.', 'O', 'messages', '2011-01-13 17:47:59.025', NULL, '2010-09-23 01:57:46.900836');
INSERT INTO base_property VALUES (3088, 'Entity/Constants/dontAggregateWorkstreamOption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:47:57.579', NULL, '2010-09-23 01:57:45.713491');
INSERT INTO base_property VALUES (3089, 'Entity/Constants/joinRequestWasSent/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join request sent.', 'O', 'messages', '2011-01-13 17:47:57.687', NULL, '2010-09-23 01:57:45.775867');
INSERT INTO base_property VALUES (3090, 'Entity/Constants/dontAggregateWorkstreamOption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show microblog and activities of affiliate places', 'O', 'messages', '2011-01-13 17:47:56.004', NULL, '2010-09-23 01:57:44.870498');
INSERT INTO base_property VALUES (3091, '/Basic/Constants/timeFormatFixedWidthWithSeconds', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'hh:mm:ss a', 'O', 'messages', '2011-01-13 17:47:54.949', NULL, '2010-08-23 14:38:26.219978');
INSERT INTO base_property VALUES (3092, 'Entity/Constants/participateToAssignedEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participate in assigned appointments', 'O', 'messages', '2011-01-13 17:47:57.708', NULL, '2010-09-23 01:57:45.803773');
INSERT INTO base_property VALUES (3093, 'Entity/Constants/exportEntityMemberAndChildEntitiesToCSV/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list (also including assigned elements where you are Admin of)', 'O', 'messages', '2011-01-13 17:47:57.715', NULL, '2010-09-23 01:57:45.809132');
INSERT INTO base_property VALUES (3094, 'Entity/Constants/attendTo/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to:', 'O', 'messages', '2011-01-13 17:47:59.032', NULL, '2010-09-23 01:57:46.906225');
INSERT INTO base_property VALUES (3095, 'Entity/Messages/mailSubjectCoAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Co-Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:47:56.314', NULL, '2010-09-23 01:57:45.043171');
INSERT INTO base_property VALUES (3096, '/Basic/Constants/close', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Close', 'O', 'messages', '2011-01-13 17:47:55.152', NULL, '2010-09-23 01:57:44.260797');
INSERT INTO base_property VALUES (3097, '/Basic/Constants/till', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'till', 'O', 'messages', '2011-01-13 17:47:55.069', NULL, '2010-09-23 01:57:44.24311');
INSERT INTO base_property VALUES (3098, 'Entity/Constants/youdidntParticipate/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not a member.', 'O', 'messages', '2011-01-13 17:47:56.132', NULL, '2010-09-23 01:57:44.95237');
INSERT INTO base_property VALUES (3099, 'Entity/Constants/joinRequestWasSent/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join request sent.', 'O', 'messages', '2011-01-13 17:47:56.124', NULL, '2010-09-23 01:57:44.945813');
INSERT INTO base_property VALUES (3100, 'Entity/Messages/noChildEntitiesCreateOne/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No events. <a href="{0}">Create an event.</a>', 'O', 'messages', '2011-01-13 17:47:57.862', NULL, '2010-09-23 01:57:45.96135');
INSERT INTO base_property VALUES (3101, 'Entity/Messages/mailSubjectAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:47:57.878', NULL, '2010-09-23 01:57:45.971137');
INSERT INTO base_property VALUES (3102, 'Entity/Messages/attentionXWillBecomeAdminAndYouWillBecomeCoAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Warning: If you give {0} the admin status, you will become co-admin. Only {0} can give you an admin status again.', 'O', 'messages', '2011-01-13 17:48:00.542', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3103, 'Entity/Mails/entityWaitList/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now on waiting list of group "$ENTITY.Name".

Group:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.452', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3104, 'Profile/Constants/universityCourse', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Course of studies', 'O', 'messages', '2011-01-13 17:47:45.752', NULL, '2010-10-26 13:48:08.375798');
INSERT INTO base_property VALUES (3105, 'Profile/Constants/houseNumber', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Street number', 'O', 'messages', '2011-01-13 17:47:45.993', NULL, '2010-10-26 13:48:12.332263');
INSERT INTO base_property VALUES (3106, 'Profile/Constants/division', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Division', 'O', 'messages', '2011-01-13 17:47:45.758', NULL, '2010-10-26 13:48:08.447915');
INSERT INTO base_property VALUES (3107, 'Videolink/Messages/feedVideoNew', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', '{0} posted a <a href="{1}">video</a>', 'O', 'messages', '2010-10-01 17:32:05.372', NULL, '2010-09-23 01:57:43.337328');
INSERT INTO base_property VALUES (3108, 'Basic/Constants/registrationHelpText', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', '<strong>Registration Information</strong><p>Please enter your registration data below.</p>', 'O', 'messages', '2010-10-22 17:52:25.105', NULL, '2010-09-23 01:57:41.976516');
INSERT INTO base_property VALUES (3109, 'Basic/Messages/registrationSucceededAndEmailSent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Dear {0} {1}, <br/>we sent an email to <strong>{2}</strong><br ><br > <strong>Please look in your SPAM-Folder if you do not find it in your Inbox.</strong><br ><br > Click the confirmation link in theemail to activate your account.', 'O', 'messages', '2011-01-13 17:47:52.07', NULL, '2010-09-23 01:57:42.248203');
INSERT INTO base_property VALUES (3110, 'Entity/Constants/assignEntityToElements/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assign this wiki page to other elements', 'O', 'messages', '2011-01-13 17:47:58.086', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3111, 'Entity/Constants/entityClosedNotAcceptingJoinRequestPossibleAnymore/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline expired. You cannot accept this request anymore.', 'O', 'messages', '2011-01-13 17:48:00.182', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3114, 'Album/Messages/feedNamedImageCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} commented the photo {2} in the album {1}.', 'O', 'messages', '2011-01-13 17:47:52.876', NULL, '2010-09-23 01:57:42.854225');
INSERT INTO base_property VALUES (3115, 'ExternalInvitation/Constants/proposeWeltbewegerExplanation', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>Please be so kind and fill out the following form.</p><p>Do not forget to include your phone number if you like to get a call.</p><p>Please include a short description of the proposed Weltbeweger, if possible with contact information.</p>', 'O', 'messages', '2011-01-13 17:47:53.835', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3116, 'Album/Messages/feedNamedImageCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} uploaded the photo {2} in the album {1}.', 'O', 'messages', '2011-01-13 17:47:52.891', NULL, '2010-09-23 01:57:42.849163');
INSERT INTO base_property VALUES (3117, 'DateAndTime/Constants/years', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'years', 'O', 'messages', '2011-01-13 17:47:53.845', NULL, '2010-09-23 01:57:43.217348');
INSERT INTO base_property VALUES (3118, 'DateAndTime/Constants/periodFormatPattern', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'MMM y', 'O', 'messages', '2011-01-13 17:47:53.858', NULL, '2010-09-23 01:57:43.232092');
INSERT INTO base_property VALUES (3119, '/Basic/Constants/invalidVideolink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invalid YouTube link', 'O', 'messages', '2011-01-13 17:47:55.119', NULL, '2010-10-26 13:48:18.819724');
INSERT INTO base_property VALUES (3120, 'Entity/Constants/memberSettings/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Member administration', 'O', 'messages', '2011-01-13 17:47:55.603', NULL, '2010-08-10 18:57:30.323837');
INSERT INTO base_property VALUES (3121, 'Profile/Constants/newEmail', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'New email address', 'O', 'messages', '2011-01-13 17:47:45.745', NULL, '2010-10-26 13:48:08.159656');
INSERT INTO base_property VALUES (3122, 'Profile/Constants/registrationHelpText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<strong>Registration Information</strong><p>Please enter your registration data below.</p>', 'O', 'messages', '2011-01-13 17:47:45.966', NULL, '2010-10-26 13:48:11.926636');
INSERT INTO base_property VALUES (3123, 'Profile/Constants/readedAndAcceptTerms', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I have read the <A href="#info.terms">Terms of Use</A> and the <A href="#info.data_protection">Data Protection Guidelines and accept them.</A>', 'O', 'messages', '2011-01-13 17:47:45.979', NULL, '2010-10-26 13:48:12.129795');
INSERT INTO base_property VALUES (3124, 'DateAndTime/Constants/year', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'year', 'O', 'messages', '2011-01-13 17:47:53.944', NULL, '2010-09-23 01:57:43.238276');
INSERT INTO base_property VALUES (3125, '/Basic/Constants/oder', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'or', 'O', 'messages', '2011-01-13 17:47:55.113', NULL, '2010-10-26 13:48:18.696962');
INSERT INTO base_property VALUES (3126, 'Entity/Mails/entityMakeCoadmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are now co-admin of entity "$ENTITY.Name".

Entity:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.373', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3127, 'Forum/Messages/feedArticleCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} wrote a comment in the topic {1}', 'O', 'messages', '2011-01-13 17:47:52.309', NULL, '2010-09-23 01:57:42.395434');
INSERT INTO base_property VALUES (3128, 'Profile/Constants/female', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'female', 'O', 'messages', '2011-01-13 17:47:45.955', NULL, '2010-10-26 13:48:11.711671');
INSERT INTO base_property VALUES (3129, 'Entity/Constants/colorDesign/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Design', 'O', 'messages', '2011-01-13 17:47:57.279', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3130, 'Exception/Messages/yourAreNotAllowedToSaveThis', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to save "{0}".', 'O', 'messages', '2011-01-13 17:47:53.809', NULL, '2010-09-23 01:57:43.191082');
INSERT INTO base_property VALUES (3131, 'Entity/Constants/parentEntities', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entities', 'O', 'messages', '2011-01-13 17:49:55.779', NULL, '2010-12-07 00:20:47.038258');
INSERT INTO base_property VALUES (3276, 'Entity/Messages/xOfYParticipant/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} of {1} members', 'O', 'messages', '2011-01-13 17:47:59.353', NULL, '2010-09-23 01:57:47.017305');
INSERT INTO base_property VALUES (3132, 'Entity/Mails/entityParticipantList/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Now you are member of event "$ENTITY.Name".

Event:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.552', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3133, 'Basic/Constants/info', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:47:51.715', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3134, 'Entity/Constants/parentEntities/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Wiki pages', 'O', 'messages', '2011-01-13 17:47:58.061', NULL, '2010-12-07 00:18:31.091813');
INSERT INTO base_property VALUES (3135, 'Entity/Messages/externalURLPopupText/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>You must set the so called "CNAME" (also called "canonical name") at your domain provider.</p><p>A corresponding function should exist in the maintenance-menu of your domain provider. Make the CNAME-entry point to the name of your wiki page at {0}.</p><p>This should look like this:</p><p><b>www.mydomain.com >> CNAME >> www.{1}.{0}</b></p>', 'O', 'messages', '2011-01-13 17:47:59.249', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3136, 'Entity/Mails/entityRemoveMembershipStatus', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You was removed from entity "$ENTITY.Name".

Entity:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.
', 'O', 'messages', '2011-01-13 17:48:02.359', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3137, 'Entity/Mails/entityMoveFromWaitlistToParticipantList/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You moved from the waiting list to the list of participants of project "$ENTITY.Name".

Project:
$ENTITY_URI


--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.575', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3138, 'Basic/Constants/ja', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Yes', 'O', 'messages', '2011-01-13 17:47:51.759', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3139, 'Basic/Messages/xeineNachrichtSchreiben', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to {0}', 'O', 'messages', '2011-01-13 17:47:51.829', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3140, 'Search/Constants/selectTopicsListOfNetwork', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'List of topics in this space', 'O', 'messages', '2011-01-13 17:47:53.324', NULL, '2010-12-01 21:05:42.480577');
INSERT INTO base_property VALUES (3141, 'Entity/Mails/entityGotJoinRequest', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '$SENDER.Firstname $SENDER.Surname wants to participate in entity "$ENTITY.Name".

Confirm or decline:
$STARTPAGE_URI

Entity:
$ENTITY_URI

--
You receive this message since you are registered on $DOMAIN_URI. To change your notification settings, log in and go to the "Settings" menu. If you do not want further notifications, please go to the "Settings" menu.', 'O', 'messages', '2011-01-13 17:48:02.377', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3143, 'Entity/Constants/statusOptionUndecidedStatus/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I am undecided', 'O', 'messages', '2011-01-13 17:47:56.068', NULL, '2010-08-06 17:21:33.176933');
INSERT INTO base_property VALUES (3144, 'Entity/Constants/googleMapAPIKeyHelpText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>If you enter an external place URL, Google Maps will not work any more, since the current global key only works for subdomains.</p><p>If you want use Google Maps with an external URL, you need to obtain a Google Maps-API key for your domain and enter it here.</p><p>See: <a href="http://code.google.com/intl/en-US/apis/maps/signup.html" target="_blank">http://code.google.com/intl/en-US/apis/maps/signup.html</a></p>', 'O', 'messages', '2011-01-13 17:47:57.093', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3145, 'Footerpages/Constants/agbTextPart6', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h2>Erhaltungsklausel </h2> <p>Sollten einzelne oder mehrere Bestimmungen dieser Nutzungsbedingungen ganz oder teilweise unwirksam oder undurchführbar sein oder werden oder sollten sich diese Nutzungsbedingungen als lückenhaft erweisen, so wird hierdurch die Gültigkeit der übrigen Regelungen dieser Nutzungsbedingungen nicht berührt. Anstelle der unwirksamen oder undurchführbaren Bestimmung gilt diejenige wirksame und durchführbare Bestimmung als vereinbart, die dem Zweck der unwirksamen Regelung am nächsten kommt. In Falle einer Lücke gilt diejenige Bestimmung als vereinbart, die dem entspricht, was nach dem Zweck dieser Nutzungsbedingungen vereinbart worden wäre, hätten die Vertragsparteien die Angelegenheit von vornherein bedacht.</p> <h2>Gerichtsstand und anwendbares Recht</h2> <p>Der Gerichtsstand für alle Streitigkeiten, die in Zusammenhang mit diesen Nutzungsbedingungen stehen ist Hamburg, Deutschland.<br >Die Nutzungsbedingungen unterliegen dem Recht der Bundesrepublik Deutschland unter Ausschluss des UN-Kaufrechts.</p> <h2>Schlussbestimmungen </h2> <p>Es bestehen keinerlei Nebenabreden.</p> <h2>Datenschutz</h2> <p>Durch die Registrierung bei OpenNetworX bestätigt das Mitglied, dass es die Informationen zum Datenschutz zur Kenntnis genommen hat. Es erklärt sich mit der Verarbeitung der über ihn erhobenen Daten einverstanden. </p> <p>Hamburg, den 05.11.2007</p>', 'O', 'messages', '2011-01-13 17:47:53.522', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3146, 'Workstream/Messages/sendMessageTo', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Send a private message to {0}.', 'O', 'messages', '2011-01-13 17:47:54.651', NULL, '2010-09-29 17:20:46.076355');
INSERT INTO base_property VALUES (3147, 'Workstream/Messages/errorYouAreIgnoredBy', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are ignored by {0} and can not send a message.', 'O', 'messages', '2011-01-13 17:47:54.653', NULL, '2010-09-29 17:20:46.085455');
INSERT INTO base_property VALUES (3148, '/Basic/Constants/dateFormatNoYear', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'M/d', 'O', 'messages', '2011-01-13 17:47:55.094', NULL, '2010-09-29 17:20:46.468227');
INSERT INTO base_property VALUES (3149, 'Profile/Constants/icq', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'ICQ', 'O', 'messages', '2011-01-13 17:47:45.71', NULL, '2010-09-23 01:57:44.074256');
INSERT INTO base_property VALUES (3150, 'Profile/Constants/genderHintLink', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Why do I need to provide this?', 'O', 'messages', '2011-01-13 17:47:45.828', NULL, '2010-09-29 17:20:46.221384');
INSERT INTO base_property VALUES (3151, 'NewsBlog/Messages/feedArticleCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} commented the article {1}', 'O', 'messages', '2011-01-13 17:47:54.73', NULL, '2010-09-23 01:57:43.984244');
INSERT INTO base_property VALUES (3152, 'DateAndTime/Constants/month', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'month', 'O', 'messages', '2011-01-13 17:47:53.943', NULL, '2010-09-23 01:57:43.235986');
INSERT INTO base_property VALUES (3153, 'Workstream/Constants/filterAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All', 'O', 'messages', '2011-01-13 17:47:54.693', NULL, '2010-09-29 17:20:46.120444');
INSERT INTO base_property VALUES (3154, 'Workstream/Constants/feedOriginStartpageMale', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'on his personal startpage', 'O', 'messages', '2011-01-13 17:47:54.672', NULL, '2010-09-23 01:57:43.96419');
INSERT INTO base_property VALUES (3155, 'Videolink/Messages/feedVideoCommented', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', '{0} commented a <a href="{1}">video</a>', 'O', 'messages', '2010-10-01 17:32:05.377', NULL, '2010-09-23 01:57:43.343833');
INSERT INTO base_property VALUES (3156, 'Exception/Messages/yourAreNotAllowedToRemoveThis', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to remove "{0}".', 'O', 'messages', '2011-01-13 17:47:53.813', NULL, '2010-09-23 01:57:43.194571');
INSERT INTO base_property VALUES (3157, 'Workstream/Constants/showMoreEntries', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show more entries', 'O', 'messages', '2011-01-13 17:47:54.69', NULL, '2010-09-23 01:57:43.976331');
INSERT INTO base_property VALUES (3158, '/Basic/Constants/today', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Today', 'O', 'messages', '2011-01-13 17:47:54.887', NULL, '2010-09-23 01:57:44.106254');
INSERT INTO base_property VALUES (3159, 'Entity/Constants/youHadAttended/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated', 'O', 'messages', '2011-01-13 17:48:01.599', NULL, '2010-10-26 13:50:41.093415');
INSERT INTO base_property VALUES (3160, 'Profile/Constants/birthdayHint', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You can modify the visibility of your birthday later on in your profile settings.', 'O', 'messages', '2011-01-13 17:47:45.819', NULL, '2010-09-29 17:20:46.215731');
INSERT INTO base_property VALUES (3161, 'Profile/Constants/zipcodeSuccessive', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zip code behind city/town', 'O', 'messages', '2011-01-13 17:47:45.8', NULL, '2010-09-23 01:57:44.085902');
INSERT INTO base_property VALUES (3162, 'Document/Messages/feedNewDocumentInEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} has uploaded the document {1}.', 'O', 'messages', '2011-01-13 17:47:54.448', NULL, '2010-09-23 01:57:43.664081');
INSERT INTO base_property VALUES (3163, '/Basic/Constants/noPermission', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You do not have permission for this action.', 'O', 'messages', '2011-01-13 17:47:54.91', NULL, '2010-10-26 13:48:14.3271');
INSERT INTO base_property VALUES (3164, 'Entity/Constants/participantStatusText/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participate', 'O', 'messages', '2011-01-13 17:48:01.794', NULL, '2010-10-26 13:50:41.195048');
INSERT INTO base_property VALUES (3165, '/Basic/Constants/noFileSelectedToUpload', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You need to select a file to upload.', 'O', 'messages', '2011-01-13 17:47:55.116', NULL, '2010-10-26 13:48:18.816116');
INSERT INTO base_property VALUES (3166, 'Profile/Messages/feedUpdatedProfile', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', '{0} updated the profile', 'O', 'messages', '2010-10-04 15:06:23.173', NULL, '2010-09-23 01:57:44.056669');
INSERT INTO base_property VALUES (3167, 'Profile/Constants/city', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City', 'O', 'messages', '2011-01-13 17:47:45.565', NULL, '2010-09-23 01:57:44.081912');
INSERT INTO base_property VALUES (3168, 'Workstream/Constants/membersMayPost', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'All members may post into the microbolg', 'O', 'messages', '2011-01-13 17:47:54.684', NULL, '2010-09-23 01:57:43.97262');
INSERT INTO base_property VALUES (3169, 'Workstream/Constants/filterFeed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activities', 'O', 'messages', '2011-01-13 17:47:54.699', NULL, '2010-09-29 17:20:46.125419');
INSERT INTO base_property VALUES (3170, '/Basic/Constants/visibleForOthers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show on profile', 'O', 'messages', '2011-01-13 17:47:55.088', NULL, '2010-09-29 17:20:46.464427');
INSERT INTO base_property VALUES (3171, 'DateAndTime/Constants/months', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'months', 'O', 'messages', '2011-01-13 17:47:53.947', NULL, '2010-09-23 01:57:43.240483');
INSERT INTO base_property VALUES (3172, 'Entity/Constants/headingBoxText/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading box: Text and links', 'O', 'messages', '2011-01-13 17:47:57.354', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3173, 'Workstream/Constants/filterHide', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide filter', 'O', 'messages', '2011-01-13 17:47:54.703', NULL, '2010-09-29 17:20:46.132257');
INSERT INTO base_property VALUES (3174, 'Exception/Constants/endDateBeforeStartDate', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'End date must not be before start date', 'O', 'messages', '2011-01-13 17:47:53.702', NULL, '2010-09-23 01:57:43.108694');
INSERT INTO base_property VALUES (3175, 'Workstream/Constants/feedOriginProfileMale', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'on his profile', 'O', 'messages', '2011-01-13 17:47:54.667', NULL, '2010-09-23 01:57:43.954443');
INSERT INTO base_property VALUES (3176, 'Profile/Constants/profileStatusUnknown', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unknown', 'O', 'messages', '2011-01-13 17:47:45.784', NULL, '2010-09-29 17:20:46.225671');
INSERT INTO base_property VALUES (3177, 'Profile/Constants/employment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Employment', 'O', 'messages', '2011-01-13 17:47:45.571', NULL, '2010-09-23 01:57:44.123923');
INSERT INTO base_property VALUES (3178, 'Profile/Constants/privateContactData', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Private contact data', 'O', 'messages', '2011-01-13 17:47:45.589', NULL, '2010-09-23 01:57:44.130353');
INSERT INTO base_property VALUES (3179, 'Profile/Constants/telefax', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Fax', 'O', 'messages', '2011-01-13 17:47:45.626', NULL, '2010-09-23 01:57:44.087578');
INSERT INTO base_property VALUES (3180, '/Basic/Constants/decimalCharacter', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '.', 'O', 'messages', '2011-01-13 17:47:55.122', NULL, '2010-10-26 13:48:18.921528');
INSERT INTO base_property VALUES (3181, 'Workstream/Messages/messageSubject', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Re: {0}', 'O', 'messages', '2011-01-13 17:47:54.654', NULL, '2010-09-29 17:20:46.088641');
INSERT INTO base_property VALUES (3182, 'Profile/Constants/skype', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Skype', 'O', 'messages', '2011-01-13 17:47:45.75', NULL, '2010-09-23 01:57:44.077881');
INSERT INTO base_property VALUES (3183, 'Workstream/Constants/workstreamModule', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Activities and Microblog', 'O', 'messages', '2011-01-13 17:47:54.664', NULL, '2010-09-23 01:57:43.968022');
INSERT INTO base_property VALUES (3184, '/Basic/Constants/pagerLater', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Later', 'O', 'messages', '2011-01-13 17:47:55.1', NULL, '2010-09-29 17:20:46.472932');
INSERT INTO base_property VALUES (3185, 'Document/Messages/feedDocumentCommented', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} has commented the document {1}.', 'O', 'messages', '2011-01-13 17:47:54.452', NULL, '2010-09-23 01:57:43.669906');
INSERT INTO base_property VALUES (3186, 'Entity/Messages/mailSubjectEntityDeleted/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''' was deleted', 'O', 'messages', '2011-01-13 17:47:57.945', NULL, '2010-09-23 01:57:46.034275');
INSERT INTO base_property VALUES (3187, 'Entity/Messages/feedEntityCreated/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the place {1}', 'O', 'messages', '2011-01-13 17:47:56.275', NULL, '2010-09-23 01:57:45.01262');
INSERT INTO base_property VALUES (3188, 'Entity/Constants/exportEntityMemberToCSV/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list', 'O', 'messages', '2011-01-13 17:47:57.712', NULL, '2010-09-23 01:57:45.80552');
INSERT INTO base_property VALUES (3189, '/Basic/Constants/show', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show', 'O', 'messages', '2011-01-13 17:47:55.17', NULL, '2010-09-23 01:57:44.274869');
INSERT INTO base_property VALUES (3190, 'Entity/Constants/attendTo/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to:', 'O', 'messages', '2011-01-13 17:47:56.136', NULL, '2010-09-23 01:57:44.95535');
INSERT INTO base_property VALUES (3191, 'Entity/Constants/notifyEntityAboutDataChange/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You changed time or place. Notify about changes by email?', 'O', 'messages', '2011-01-13 17:47:57.683', NULL, '2010-09-23 01:57:45.773589');
INSERT INTO base_property VALUES (3192, 'Entity/Messages/feedNewMembership/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} joined the wiki page {1}', 'O', 'messages', '2011-01-13 17:47:59.169', NULL, '2010-09-23 01:57:46.948943');
INSERT INTO base_property VALUES (3193, 'Entity/Constants/exportEntityMemberToCSV/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list', 'O', 'messages', '2011-01-13 17:47:56.153', NULL, '2010-09-23 01:57:44.969873');
INSERT INTO base_property VALUES (3194, 'Entity/Messages/feedOrigin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'in place {0}', 'O', 'messages', '2011-01-13 17:47:56.278', NULL, '2010-09-23 01:57:45.008444');
INSERT INTO base_property VALUES (3195, 'Entity/Messages/noChildEntitiesCreateOne/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No places. <a href="{0}">Create a place.</a>', 'O', 'messages', '2011-01-13 17:47:56.298', NULL, '2010-09-23 01:57:45.029316');
INSERT INTO base_property VALUES (3196, 'Entity/Messages/mailSubjectAdmin/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:47:56.309', NULL, '2010-09-23 01:57:45.038855');
INSERT INTO base_property VALUES (3197, 'Entity/Messages/mailSubjectEntityDeleted/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''' was deleted', 'O', 'messages', '2011-01-13 17:47:56.384', NULL, '2010-09-23 01:57:45.079549');
INSERT INTO base_property VALUES (3198, 'Entity/Messages/xOfYParticipant/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} of {1} members', 'O', 'messages', '2011-01-13 17:47:56.455', NULL, '2010-09-23 01:57:45.125877');
INSERT INTO base_property VALUES (3199, 'Entity/Constants/aggregateWorkstreamOption/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:47:57.575', NULL, '2010-09-23 01:57:45.711649');
INSERT INTO base_property VALUES (3200, 'Entity/Constants/notifyEntityAboutDataChange/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You changed time or place. Notify about changes by email?', 'O', 'messages', '2011-01-13 17:47:56.121', NULL, '2010-09-23 01:57:44.943898');
INSERT INTO base_property VALUES (3201, 'Entity/Constants/notAllowedToAddEntityHere/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to add something here.', 'O', 'messages', '2011-01-13 17:47:57.69', NULL, '2010-09-23 01:57:45.777859');
INSERT INTO base_property VALUES (3202, 'Entity/Constants/attendTo/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to:', 'O', 'messages', '2011-01-13 17:47:57.698', NULL, '2010-09-23 01:57:45.785306');
INSERT INTO base_property VALUES (3203, 'Entity/Messages/feedOrigin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'in event {0}', 'O', 'messages', '2011-01-13 17:47:57.836', NULL, '2010-09-23 01:57:45.925582');
INSERT INTO base_property VALUES (3204, 'Entity/Messages/mailSubjectCoAdmin/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Co-Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:47:57.88', NULL, '2010-09-23 01:57:45.976206');
INSERT INTO base_property VALUES (3205, 'Entity/Messages/xOfYParticipant/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} of {1} participants', 'O', 'messages', '2011-01-13 17:47:57.998', NULL, '2010-09-23 01:57:46.076168');
INSERT INTO base_property VALUES (3206, 'Entity/Constants/aggregateWorkstream/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Microblog and activities', 'O', 'messages', '2011-01-13 17:47:58.359', NULL, '2010-09-23 01:57:46.324345');
INSERT INTO base_property VALUES (3207, 'Entity/Constants/aggregateWorkstreamOption/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:47:58.901', NULL, '2010-09-23 01:57:46.830169');
INSERT INTO base_property VALUES (3208, 'Entity/Constants/participateToAssignedEntity/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Become member of assigned wiki pages', 'O', 'messages', '2011-01-13 17:47:59.043', NULL, '2010-09-23 01:57:46.914004');
INSERT INTO base_property VALUES (3209, 'Profile/Constants/position', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Position', 'O', 'messages', '2011-01-13 17:47:46.044', NULL, '2010-09-23 01:57:44.258981');
INSERT INTO base_property VALUES (3210, 'Entity/Constants/youdidntParticipate/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not a member.', 'O', 'messages', '2011-01-13 17:47:59.029', NULL, '2010-09-23 01:57:46.903555');
INSERT INTO base_property VALUES (3211, 'Entity/Constants/alsoAttendTo/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also attend to:', 'O', 'messages', '2011-01-13 17:47:59.035', NULL, '2010-09-23 01:57:46.908789');
INSERT INTO base_property VALUES (3212, 'Entity/Constants/attendToEntity/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to entity', 'O', 'messages', '2011-01-13 17:47:56.144', NULL, '2010-09-23 01:57:44.963197');
INSERT INTO base_property VALUES (3213, '/Basic/Constants/cancelQuestion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your data will not be saved. Do you want to continue?', 'O', 'messages', '2011-01-13 17:47:55.072', NULL, '2010-09-23 01:57:44.244806');
INSERT INTO base_property VALUES (3214, 'Profile/Constants/location', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Location', 'O', 'messages', '2011-01-13 17:47:46.058', NULL, '2010-09-23 01:57:44.269758');
INSERT INTO base_property VALUES (3215, 'Entity/Constants/aggregateWorkstream/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Microblog and activities', 'O', 'messages', '2011-01-13 17:47:55.535', NULL, '2010-09-23 01:57:44.494224');
INSERT INTO base_property VALUES (3216, '/Basic/Constants/notAValidNumber', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please enter a valid number', 'O', 'messages', '2011-01-13 17:47:55.079', NULL, '2010-09-23 01:57:44.250906');
INSERT INTO base_property VALUES (3217, 'Entity/Constants/joinRequestWasSent/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join request sent.', 'O', 'messages', '2011-01-13 17:47:59.021', NULL, '2010-09-23 01:57:46.898015');
INSERT INTO base_property VALUES (3218, 'Entity/Constants/attendToEntity/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to entity', 'O', 'messages', '2011-01-13 17:47:57.705', NULL, '2010-09-23 01:57:45.80197');
INSERT INTO base_property VALUES (3219, 'Entity/Constants/notAllowedToAddEntityHere/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to add something here.', 'O', 'messages', '2011-01-13 17:47:56.128', NULL, '2010-09-23 01:57:44.948403');
INSERT INTO base_property VALUES (3220, 'Entity/Constants/aggregateWorkstreamOption/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show microblog and activities of affiliate places', 'O', 'messages', '2011-01-13 17:47:55.999', NULL, '2010-09-23 01:57:44.868207');
INSERT INTO base_property VALUES (3221, 'Entity/Messages/feedNewWikiVersion/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created version {1} in the wiki editor', 'O', 'messages', '2011-01-13 17:47:57.866', NULL, '2010-09-23 01:57:45.964217');
INSERT INTO base_property VALUES (3222, 'Entity/Constants/exportEntityMemberAndChildEntitiesToCSV/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list (also including assigned elements where you are Admin of)', 'O', 'messages', '2011-01-13 17:48:00.346', NULL, '2010-09-23 01:57:47.597575');
INSERT INTO base_property VALUES (3223, 'Entity/Constants/alsoAttendTo/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also attend to:', 'O', 'messages', '2011-01-13 17:48:00.331', NULL, '2010-09-23 01:57:47.58662');
INSERT INTO base_property VALUES (3224, 'Entity/Messages/feedEntityCreated/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the project {1}', 'O', 'messages', '2011-01-13 17:48:00.46', NULL, '2010-09-23 01:57:47.645127');
INSERT INTO base_property VALUES (3225, 'Entity/Constants/aggregateWorkstreamOption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:48:00.203', NULL, '2010-09-23 01:57:47.494086');
INSERT INTO base_property VALUES (3226, 'Entity/Messages/mailSubjectEntityDeleted/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''' was deleted', 'O', 'messages', '2011-01-13 17:48:00.58', NULL, '2010-09-23 01:57:47.713034');
INSERT INTO base_property VALUES (3227, 'Entity/Constants/joinRequestWasSent/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join request sent.', 'O', 'messages', '2011-01-13 17:48:00.317', NULL, '2010-09-23 01:57:47.577601');
INSERT INTO base_property VALUES (3228, 'Survey/Constants/named', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'by name', 'O', 'messages', '2011-01-13 17:48:02.646', NULL, '2010-09-23 01:57:48.050548');
INSERT INTO base_property VALUES (3229, 'Survey/Constants/createSurveyBreadCrumpLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create survey', 'O', 'messages', '2011-01-13 17:48:02.651', NULL, '2010-09-23 01:57:48.058573');
INSERT INTO base_property VALUES (3230, 'Entity/Messages/xOfYParticipant/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} of {1} members', 'O', 'messages', '2011-01-13 17:48:00.626', NULL, '2010-09-23 01:57:47.745585');
INSERT INTO base_property VALUES (3231, 'Survey/Constants/excactlyOneAnsers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Exactly one answer', 'O', 'messages', '2011-01-13 17:48:02.714', NULL, '2010-09-23 01:57:48.130521');
INSERT INTO base_property VALUES (3232, 'Survey/Constants/addNewQuestion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add another question', 'O', 'messages', '2011-01-13 17:48:02.696', NULL, '2010-09-23 01:57:48.113551');
INSERT INTO base_property VALUES (3233, 'Survey/Constants/answerRequired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Answer required', 'O', 'messages', '2011-01-13 17:48:02.732', NULL, '2010-09-23 01:57:48.146573');
INSERT INTO base_property VALUES (3234, 'Survey/Constants/minBiggerThanMaxErrorMsg', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Min. number of answers must not be higher than max. number of answers.', 'O', 'messages', '2011-01-13 17:48:02.722', NULL, '2010-09-23 01:57:48.13798');
INSERT INTO base_property VALUES (3235, 'Survey/Constants/backToQuestionConfigLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Back', 'O', 'messages', '2011-01-13 17:48:02.744', NULL, '2010-09-23 01:57:48.174931');
INSERT INTO base_property VALUES (3236, 'Entity/Messages/noChildEntitiesCreateOne/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No wiki pages. <a href="{0}">Create a wiki page.</a>', 'O', 'messages', '2011-01-13 17:47:59.21', NULL, '2010-09-23 01:57:46.961602');
INSERT INTO base_property VALUES (3237, 'Survey/Constants/surveyTypeLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Type', 'O', 'messages', '2011-01-13 17:48:02.669', NULL, '2010-09-23 01:57:48.083667');
INSERT INTO base_property VALUES (3238, 'Survey/Constants/minAnswersLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Min.', 'O', 'messages', '2011-01-13 17:48:02.718', NULL, '2010-09-23 01:57:48.134508');
INSERT INTO base_property VALUES (3239, 'Survey/Constants/possibleAnswerLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Answer', 'O', 'messages', '2011-01-13 17:48:02.709', NULL, '2010-09-23 01:57:48.125606');
INSERT INTO base_property VALUES (3240, 'Survey/Constants/participantDoNotChangeAnswers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants may not modify their answers afterwards', 'O', 'messages', '2011-01-13 17:48:02.682', NULL, '2010-09-23 01:57:48.093864');
INSERT INTO base_property VALUES (3241, 'Survey/Constants/typeOfAnswerLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Answer type', 'O', 'messages', '2011-01-13 17:48:02.701', NULL, '2010-09-23 01:57:48.117775');
INSERT INTO base_property VALUES (3242, 'Survey/Constants/multipleChoice', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Multiple choice', 'O', 'messages', '2011-01-13 17:48:02.705', NULL, '2010-09-23 01:57:48.122512');
INSERT INTO base_property VALUES (3243, 'Survey/Constants/cancelLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Cancel', 'O', 'messages', '2011-01-13 17:48:02.689', NULL, '2010-09-23 01:57:48.10376');
INSERT INTO base_property VALUES (3244, 'Entity/Messages/feedEntityCreated/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the wiki page {1}', 'O', 'messages', '2011-01-13 17:47:59.175', NULL, '2010-09-23 01:57:46.950506');
INSERT INTO base_property VALUES (3245, 'Entity/Messages/mailSubjectEntityDataChanged/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': Some important data changed ', 'O', 'messages', '2011-01-13 17:47:59.319', NULL, '2010-09-23 01:57:46.998356');
INSERT INTO base_property VALUES (3246, 'Survey/Constants/resultVisibilityLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Result visibility', 'O', 'messages', '2011-01-13 17:48:02.662', NULL, '2010-09-23 01:57:48.073843');
INSERT INTO base_property VALUES (3247, 'Survey/Constants/minValueOutOfRange', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Min. number of answers is out of range', 'O', 'messages', '2011-01-13 17:48:02.726', NULL, '2010-09-23 01:57:48.143542');
INSERT INTO base_property VALUES (3248, 'Survey/Constants/surveyChangesLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Modifications', 'O', 'messages', '2011-01-13 17:48:02.678', NULL, '2010-09-23 01:57:48.087468');
INSERT INTO base_property VALUES (3249, 'Survey/Constants/saveQuestionsFailed', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saving questions failed.', 'O', 'messages', '2011-01-13 17:48:02.735', NULL, '2010-09-23 01:57:48.151874');
INSERT INTO base_property VALUES (3250, 'Entity/Messages/mailSubjectAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:47:59.22', NULL, '2010-09-23 01:57:46.96491');
INSERT INTO base_property VALUES (3251, 'Survey/Constants/visibilityParticipant', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for participants', 'O', 'messages', '2011-01-13 17:48:02.666', NULL, '2010-09-23 01:57:48.078633');
INSERT INTO base_property VALUES (3252, 'Survey/Constants/surveySaved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Gespeichert.', 'O', 'messages', '2011-01-13 17:48:02.693', NULL, '2010-09-23 01:57:48.108751');
INSERT INTO base_property VALUES (3253, 'Survey/Constants/deleteAnswersIfParticipantQuit', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete answers if participant quit', 'O', 'messages', '2011-01-13 17:48:02.685', NULL, '2010-09-23 01:57:48.097983');
INSERT INTO base_property VALUES (3254, 'Entity/Messages/mailSubjectAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:48:00.5', NULL, '2010-09-23 01:57:47.670193');
INSERT INTO base_property VALUES (3255, 'Entity/Constants/aggregateWorkstream/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Microblog and activities', 'O', 'messages', '2011-01-13 17:47:59.662', NULL, '2010-09-23 01:57:47.147231');
INSERT INTO base_property VALUES (3256, 'Survey/Constants/expiredDateLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Expiration date', 'O', 'messages', '2011-01-13 17:48:02.658', NULL, '2010-09-23 01:57:48.067983');
INSERT INTO base_property VALUES (3257, 'Entity/Constants/youdidntParticipate/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not a member.', 'O', 'messages', '2011-01-13 17:48:00.324', NULL, '2010-09-23 01:57:47.581309');
INSERT INTO base_property VALUES (3258, 'Survey/Constants/surveyQuestionsTab', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Questions', 'O', 'messages', '2011-01-13 17:48:02.655', NULL, '2010-09-23 01:57:48.062986');
INSERT INTO base_property VALUES (3259, 'Entity/Messages/feedNewWikiVersion/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created version {1} in the wiki editor', 'O', 'messages', '2011-01-13 17:48:00.451', NULL, '2010-09-23 01:57:47.639939');
INSERT INTO base_property VALUES (3260, 'Entity/Messages/feedNewMembership/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} joined the project {1}', 'O', 'messages', '2011-01-13 17:48:00.455', NULL, '2010-09-23 01:57:47.643572');
INSERT INTO base_property VALUES (3261, 'Entity/Messages/noChildEntitiesCreateOne/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No projects. <a href="{0}">Create a project.</a>', 'O', 'messages', '2011-01-13 17:48:00.495', NULL, '2010-09-23 01:57:47.665703');
INSERT INTO base_property VALUES (3262, 'Entity/Messages/mailSubjectCoAdmin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Co-Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:48:00.503', NULL, '2010-09-23 01:57:47.672884');
INSERT INTO base_property VALUES (3263, 'Entity/Messages/mailSubjectEntityDataChanged/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': Some important data changed ', 'O', 'messages', '2011-01-13 17:48:00.583', NULL, '2010-09-23 01:57:47.715825');
INSERT INTO base_property VALUES (3264, 'Entity/Constants/attendToEntity/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to entity', 'O', 'messages', '2011-01-13 17:48:00.335', NULL, '2010-09-23 01:57:47.59009');
INSERT INTO base_property VALUES (3265, 'Entity/Constants/notAllowedToAddEntityHere/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to add something here.', 'O', 'messages', '2011-01-13 17:48:00.321', NULL, '2010-09-23 01:57:47.579654');
INSERT INTO base_property VALUES (3266, 'Survey/Constants/errorOcursSeeRedMarkedFields', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Please review marked fields above', 'O', 'messages', '2011-01-13 17:48:02.737', NULL, '2010-09-23 01:57:48.165201');
INSERT INTO base_property VALUES (3267, 'Survey/Constants/surveyNotExpired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Does not expire', 'O', 'messages', '2011-01-13 17:48:02.66', NULL, '2010-09-23 01:57:48.071762');
INSERT INTO base_property VALUES (3268, 'Survey/Constants/visibilityParticipantAndAfterExpiratationForAll', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for participants and after expiration for others', 'O', 'messages', '2011-01-13 17:48:02.664', NULL, '2010-09-23 01:57:48.076682');
INSERT INTO base_property VALUES (3269, 'Survey/Constants/visibilityAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for admins', 'O', 'messages', '2011-01-13 17:48:02.667', NULL, '2010-09-23 01:57:48.080577');
INSERT INTO base_property VALUES (3270, 'Survey/Constants/notAbleToChangeValueLater', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will not be able to change this setting later', 'O', 'messages', '2011-01-13 17:48:02.671', NULL, '2010-09-23 01:57:48.085559');
INSERT INTO base_property VALUES (3271, 'Survey/Constants/surveyCreated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:48:02.691', NULL, '2010-09-23 01:57:48.105865');
INSERT INTO base_property VALUES (3272, 'Survey/Constants/saveLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:48:02.687', NULL, '2010-09-23 01:57:48.100765');
INSERT INTO base_property VALUES (3273, 'Entity/Messages/mailSubjectCoAdmin/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Co-Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:47:59.224', NULL, '2010-09-23 01:57:46.966505');
INSERT INTO base_property VALUES (3274, 'Entity/Constants/dontAggregateWorkstreamOption/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:48:00.207', NULL, '2010-09-23 01:57:47.495688');
INSERT INTO base_property VALUES (3275, 'Survey/Constants/maxValueOutOfRange', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Max. number of answers is out of range', 'O', 'messages', '2011-01-13 17:48:02.729', NULL, '2010-09-23 01:57:48.145088');
INSERT INTO base_property VALUES (3277, 'Survey/Constants/freeText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Free text', 'O', 'messages', '2011-01-13 17:48:02.703', NULL, '2010-09-23 01:57:48.119945');
INSERT INTO base_property VALUES (3278, 'Survey/Constants/answerLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Answer', 'O', 'messages', '2011-01-13 17:48:02.707', NULL, '2010-09-23 01:57:48.124071');
INSERT INTO base_property VALUES (3279, 'Survey/Constants/automaticalDeletetionLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Auto delete', 'O', 'messages', '2011-01-13 17:48:02.683', NULL, '2010-09-23 01:57:48.096049');
INSERT INTO base_property VALUES (3280, 'Survey/Constants/answersRequirementCustomized', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Customized', 'O', 'messages', '2011-01-13 17:48:02.716', NULL, '2010-09-23 01:57:48.13201');
INSERT INTO base_property VALUES (3281, 'Entity/Messages/mailSubjectEntityDeleted/Wiki', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''' was deleted', 'O', 'messages', '2011-01-13 17:47:59.316', NULL, '2010-09-23 01:57:46.996656');
INSERT INTO base_property VALUES (3282, 'Survey/Constants/minMaxValueRequiredErrorMsg', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Min. and max. must not be empty', 'O', 'messages', '2011-01-13 17:48:02.724', NULL, '2010-09-23 01:57:48.140452');
INSERT INTO base_property VALUES (3283, 'Survey/Constants/questionSaved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved.', 'O', 'messages', '2011-01-13 17:48:02.734', NULL, '2010-09-23 01:57:48.148984');
INSERT INTO base_property VALUES (3284, 'Survey/Constants/deleteThisQuestion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete this question', 'O', 'messages', '2011-01-13 17:48:02.699', NULL, '2010-09-23 01:57:48.115138');
INSERT INTO base_property VALUES (3285, 'Survey/Constants/maxAnswersLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Max.', 'O', 'messages', '2011-01-13 17:48:02.72', NULL, '2010-09-23 01:57:48.136012');
INSERT INTO base_property VALUES (3286, 'Survey/Constants/questionLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Question', 'O', 'messages', '2011-01-13 17:48:02.695', NULL, '2010-09-23 01:57:48.110928');
INSERT INTO base_property VALUES (3287, 'Entity/Constants/notifyEntityAboutDataChange/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You changed time or place. Notify about changes by email?', 'O', 'messages', '2011-01-13 17:48:00.314', NULL, '2010-09-23 01:57:47.574391');
INSERT INTO base_property VALUES (3288, 'Survey/Constants/noAnswersRequired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Optional', 'O', 'messages', '2011-01-13 17:48:02.711', NULL, '2010-09-23 01:57:48.127925');
INSERT INTO base_property VALUES (3289, 'Survey/Constants/participantMayChangesAnswers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants may modify their answers afterwards', 'O', 'messages', '2011-01-13 17:48:02.68', NULL, '2010-09-23 01:57:48.090033');
INSERT INTO base_property VALUES (3290, 'Survey/Constants/mandatory', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mandatory', 'O', 'messages', '2011-01-13 17:48:02.649', NULL, '2010-09-23 01:57:48.055228');
INSERT INTO base_property VALUES (3291, 'Survey/Constants/surveyTitleLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Title', 'O', 'messages', '2011-01-13 17:48:02.657', NULL, '2010-09-23 01:57:48.065466');
INSERT INTO base_property VALUES (3292, 'Entity/Constants/attendTo/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to:', 'O', 'messages', '2011-01-13 17:48:00.328', NULL, '2010-09-23 01:57:47.584028');
INSERT INTO base_property VALUES (3293, 'Survey/Constants/surveyBaseDataTab', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:48:02.653', NULL, '2010-09-23 01:57:48.060113');
INSERT INTO base_property VALUES (3294, 'Entity/Constants/exportEntityMemberToCSV/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list', 'O', 'messages', '2011-01-13 17:48:00.342', NULL, '2010-09-23 01:57:47.594759');
INSERT INTO base_property VALUES (3295, 'Entity/Constants/aggregateWorkstream', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Microblog and activities', 'O', 'messages', '2011-01-13 17:49:55.934', NULL, '2010-09-23 01:58:32.820454');
INSERT INTO base_property VALUES (3296, 'Entity/Constants/dontAggregateWorkstreamOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:49:56.535', NULL, '2010-09-23 01:58:33.788442');
INSERT INTO base_property VALUES (3297, 'Entity/Constants/notifyEntityAboutDataChange', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You changed time or place. Send email notification?', 'O', 'messages', '2011-01-13 17:49:56.671', NULL, '2010-09-23 01:58:33.88602');
INSERT INTO base_property VALUES (3298, 'Entity/Constants/attendToEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to entity', 'O', 'messages', '2011-01-13 17:49:56.695', NULL, '2010-09-23 01:58:33.903197');
INSERT INTO base_property VALUES (3299, 'Survey/Messages/questionSavedXAnswersOfParticipantDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved. Answers of {0} participants were removed.', 'O', 'messages', '2011-01-13 17:48:02.853', NULL, '2010-09-23 01:57:48.295759');
INSERT INTO base_property VALUES (3300, 'Entity/Constants/dontAggregateWorkstreamOption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Don''t show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:49:58.125', NULL, '2010-09-23 01:58:35.810593');
INSERT INTO base_property VALUES (3301, 'Survey/Messages/selectMinXAndMaxYAnswers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select a minimum of {0} and a maximum of {1} answers(s).', 'O', 'messages', '2011-01-13 17:48:02.862', NULL, '2010-09-23 01:57:48.299941');
INSERT INTO base_property VALUES (3302, 'Survey/Constants/resultOfSurveyLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Survey results', 'O', 'messages', '2011-01-13 17:48:02.809', NULL, '2010-09-23 01:57:48.24549');
INSERT INTO base_property VALUES (3303, 'Survey/Constants/viewSurveyDetailsLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'View details', 'O', 'messages', '2011-01-13 17:48:02.802', NULL, '2010-09-23 01:57:48.236988');
INSERT INTO base_property VALUES (3304, 'Survey/Constants/noAnswersForThisSurvey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No answers in this survey. No results available.', 'O', 'messages', '2011-01-13 17:48:02.83', NULL, '2010-09-23 01:57:48.270297');
INSERT INTO base_property VALUES (3305, 'Survey/Messages/surveyResultQuestionAndParticipantCount', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} ({1})', 'O', 'messages', '2011-01-13 17:48:02.869', NULL, '2010-09-23 01:57:48.30552');
INSERT INTO base_property VALUES (3306, 'Survey/Constants/hideMoreParticipantLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:48:02.837', NULL, '2010-09-23 01:57:48.287562');
INSERT INTO base_property VALUES (3307, 'Entity/Constants/exportEntityMemberToCSV', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list', 'O', 'messages', '2011-01-13 17:49:56.703', NULL, '2010-09-23 01:58:33.909081');
INSERT INTO base_property VALUES (3308, 'Survey/Constants/removeAnsersTooltip', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove/delete answer', 'O', 'messages', '2011-01-13 17:48:02.791', NULL, '2010-09-23 01:57:48.228613');
INSERT INTO base_property VALUES (3309, 'Survey/Constants/youDontHaveParticipated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You didn''t participate', 'O', 'messages', '2011-01-13 17:48:02.813', NULL, '2010-09-23 01:57:48.24895');
INSERT INTO base_property VALUES (3310, 'Survey/Constants/onlyAdminMayCreateSurvey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only admins may create surveys', 'O', 'messages', '2011-01-13 17:48:02.77', NULL, '2010-09-23 01:57:48.200392');
INSERT INTO base_property VALUES (3311, 'Entity/Messages/mailSubjectAdmin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:49:56.867', NULL, '2010-09-23 01:58:34.129632');
INSERT INTO base_property VALUES (3312, 'Survey/Constants/displayResultLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show results', 'O', 'messages', '2011-01-13 17:48:02.818', NULL, '2010-09-23 01:57:48.254961');
INSERT INTO base_property VALUES (3313, 'Survey/Constants/displayMyAnswersLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My answers', 'O', 'messages', '2011-01-13 17:48:02.822', NULL, '2010-09-23 01:57:48.260892');
INSERT INTO base_property VALUES (3314, 'Entity/Messages/mailSubjectEntityDataChanged', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': Some important data changed ', 'O', 'messages', '2011-01-13 17:49:56.942', NULL, '2010-09-23 01:58:34.167074');
INSERT INTO base_property VALUES (3315, 'Survey/Constants/hideMoreFreetextAnswersLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Hide', 'O', 'messages', '2011-01-13 17:48:02.841', NULL, '2010-09-23 01:57:48.291524');
INSERT INTO base_property VALUES (3316, 'Entity/Messages/noChildEntitiesCreateOne', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No entities. <a href="{0}">Create an entity.</a>', 'O', 'messages', '2011-01-13 17:49:57.024', NULL, '2010-09-23 01:58:34.219555');
INSERT INTO base_property VALUES (3317, 'Entity/Constants/joinRequestWasSent/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join request sent.', 'O', 'messages', '2011-01-13 17:49:58.22', NULL, '2010-09-23 01:58:36.111137');
INSERT INTO base_property VALUES (3318, 'Entity/Constants/youdidntParticipate/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not a member.', 'O', 'messages', '2011-01-13 17:49:58.225', NULL, '2010-09-23 01:58:36.114547');
INSERT INTO base_property VALUES (3319, 'Entity/Constants/alsoAttendTo/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also attend to:', 'O', 'messages', '2011-01-13 17:49:58.23', NULL, '2010-09-23 01:58:36.1179');
INSERT INTO base_property VALUES (3320, 'Survey/Constants/surveyComponentLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Survey', 'O', 'messages', '2011-01-13 17:48:02.746', NULL, '2010-09-23 01:57:48.178919');
INSERT INTO base_property VALUES (3321, 'Survey/Constants/surveyDoNotExpired', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Does not expire', 'O', 'messages', '2011-01-13 17:48:02.774', NULL, '2010-09-23 01:57:48.206576');
INSERT INTO base_property VALUES (3322, 'Survey/Constants/adminLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:48:02.782', NULL, '2010-09-23 01:57:48.215927');
INSERT INTO base_property VALUES (3323, 'Survey/Constants/changingLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Changes', 'O', 'messages', '2011-01-13 17:48:02.786', NULL, '2010-09-23 01:57:48.222889');
INSERT INTO base_property VALUES (3324, 'Survey/Constants/surveyNotPublished', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Survey has not been published', 'O', 'messages', '2011-01-13 17:48:02.797', NULL, '2010-09-23 01:57:48.23333');
INSERT INTO base_property VALUES (3325, 'Survey/Constants/createASurvey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create a survey.', 'O', 'messages', '2011-01-13 17:48:02.749', NULL, '2010-09-23 01:57:48.184469');
INSERT INTO base_property VALUES (3326, 'Survey/Constants/pleaseEnterAFreetextAnswerValidationErrorMsg', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Enter a free text answer.', 'O', 'messages', '2011-01-13 17:48:02.805', NULL, '2010-09-23 01:57:48.241481');
INSERT INTO base_property VALUES (3327, 'Survey/Constants/editSurveyOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:48:02.754', NULL, '2010-09-23 01:57:48.189029');
INSERT INTO base_property VALUES (3328, 'Survey/Constants/realyWantDeleteSurvey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete this survey?', 'O', 'messages', '2011-01-13 17:48:02.759', NULL, '2010-09-23 01:57:48.194404');
INSERT INTO base_property VALUES (3329, 'Survey/Constants/assignedToLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigned to', 'O', 'messages', '2011-01-13 17:48:02.778', NULL, '2010-09-23 01:57:48.209711');
INSERT INTO base_property VALUES (3330, 'Survey/Constants/surveyQuestionsLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Survey questions', 'O', 'messages', '2011-01-13 17:48:02.795', NULL, '2010-09-23 01:57:48.231791');
INSERT INTO base_property VALUES (3331, 'Entity/Constants/aggregateWorkstreamOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:49:56.532', NULL, '2010-09-23 01:58:33.7855');
INSERT INTO base_property VALUES (3332, 'Entity/Constants/joinRequestWasSent', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join request sent.', 'O', 'messages', '2011-01-13 17:49:56.675', NULL, '2010-09-23 01:58:33.888499');
INSERT INTO base_property VALUES (3333, 'Entity/Constants/participateToAssignedEntity', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Become member of assigned entities.', 'O', 'messages', '2011-01-13 17:49:56.699', NULL, '2010-09-23 01:58:33.906187');
INSERT INTO base_property VALUES (3334, 'Entity/Constants/exportEntityMemberAndChildEntitiesToCSV', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list (also including assigned elements where you are Admin of)', 'O', 'messages', '2011-01-13 17:49:56.709', NULL, '2010-09-23 01:58:33.911999');
INSERT INTO base_property VALUES (3335, 'Entity/Messages/feedNewWikiVersion', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created version {1} in the wiki editor', 'O', 'messages', '2011-01-13 17:49:56.85', NULL, '2010-09-23 01:58:34.122174');
INSERT INTO base_property VALUES (3336, 'Entity/Messages/feedNewMembership', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} joined the entity {1}', 'O', 'messages', '2011-01-13 17:49:56.854', NULL, '2010-09-23 01:58:34.125746');
INSERT INTO base_property VALUES (3337, 'Entity/Messages/feedOrigin', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'in entity {0}', 'O', 'messages', '2011-01-13 17:49:56.863', NULL, '2010-09-23 01:58:34.124028');
INSERT INTO base_property VALUES (3338, 'Entity/Constants/aggregateWorkstream/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Microblog and activities', 'O', 'messages', '2011-01-13 17:49:57.51', NULL, '2010-09-23 01:58:34.795424');
INSERT INTO base_property VALUES (3339, 'Entity/Messages/mailSubjectEntityDeleted', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''' was deleted', 'O', 'messages', '2011-01-13 17:49:56.939', NULL, '2010-09-23 01:58:34.165303');
INSERT INTO base_property VALUES (3340, 'Survey/Constants/noAnswersAvailable', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No answers available.', 'O', 'messages', '2011-01-13 17:48:02.832', NULL, '2010-09-23 01:57:48.272916');
INSERT INTO base_property VALUES (3341, 'Entity/Messages/xOfYParticipant', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} of {1} participants', 'O', 'messages', '2011-01-13 17:49:57.02', NULL, '2010-09-23 01:58:34.217024');
INSERT INTO base_property VALUES (3342, 'Survey/Constants/anonymous', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Anonymous', 'O', 'messages', '2011-01-13 17:48:02.85', NULL, '2010-09-23 01:57:48.29298');
INSERT INTO base_property VALUES (3343, 'Entity/Constants/attendTo/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to:', 'O', 'messages', '2011-01-13 17:49:58.227', NULL, '2010-09-23 01:58:36.116236');
INSERT INTO base_property VALUES (3344, 'Survey/Messages/selectExactlyXAnswers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select exactly {0} answer(s).', 'O', 'messages', '2011-01-13 17:48:02.866', NULL, '2010-09-23 01:57:48.302564');
INSERT INTO base_property VALUES (3345, 'Survey/Constants/addSurveyOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add', 'O', 'messages', '2011-01-13 17:48:02.752', NULL, '2010-09-23 01:57:48.187535');
INSERT INTO base_property VALUES (3346, 'Entity/Constants/aggregateWorkstreamOption/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Also show microblog and activities of affiliate elements', 'O', 'messages', '2011-01-13 17:49:58.123', NULL, '2010-09-23 01:58:35.80885');
INSERT INTO base_property VALUES (3347, 'Survey/Constants/createAtLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Created', 'O', 'messages', '2011-01-13 17:48:02.772', NULL, '2010-09-23 01:57:48.203971');
INSERT INTO base_property VALUES (3348, 'Survey/Constants/addAnswersTooltip', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Add answers', 'O', 'messages', '2011-01-13 17:48:02.789', NULL, '2010-09-23 01:57:48.22546');
INSERT INTO base_property VALUES (3349, 'Entity/Constants/notifyEntityAboutDataChange/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You changed time or place. Notify about changes by email?', 'O', 'messages', '2011-01-13 17:49:58.218', NULL, '2010-09-23 01:58:36.109377');
INSERT INTO base_property VALUES (3350, 'Entity/Constants/notAllowedToAddEntityHere/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed to add something here.', 'O', 'messages', '2011-01-13 17:49:58.223', NULL, '2010-09-23 01:58:36.112843');
INSERT INTO base_property VALUES (3351, 'Survey/Constants/answersSaved', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved.', 'O', 'messages', '2011-01-13 17:48:02.808', NULL, '2010-09-23 01:57:48.243011');
INSERT INTO base_property VALUES (3352, 'Survey/Constants/youHaveParticipated', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You participated.', 'O', 'messages', '2011-01-13 17:48:02.812', NULL, '2010-09-23 01:57:48.246992');
INSERT INTO base_property VALUES (3353, 'Survey/Constants/displaySurveyQuestions', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show survey questions', 'O', 'messages', '2011-01-13 17:48:02.819', NULL, '2010-09-23 01:57:48.25743');
INSERT INTO base_property VALUES (3354, 'Survey/Constants/deleteMyAnswersOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete my Answers', 'O', 'messages', '2011-01-13 17:48:02.823', NULL, '2010-09-23 01:57:48.26332');
INSERT INTO base_property VALUES (3355, 'Survey/Constants/dispalyMoreParticipantLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'More', 'O', 'messages', '2011-01-13 17:48:02.835', NULL, '2010-09-23 01:57:48.28213');
INSERT INTO base_property VALUES (3356, 'Survey/Constants/deleteSurveyOption', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete survey', 'O', 'messages', '2011-01-13 17:48:02.757', NULL, '2010-09-23 01:57:48.191934');
INSERT INTO base_property VALUES (3357, 'Survey/Constants/optionHeaderLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Option', 'O', 'messages', '2011-01-13 17:48:02.78', NULL, '2010-09-23 01:57:48.212931');
INSERT INTO base_property VALUES (3358, 'Survey/Constants/resultOnlyForAdminVisible', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Result only for admins visible.', 'O', 'messages', '2011-01-13 17:48:02.816', NULL, '2010-09-23 01:57:48.251377');
INSERT INTO base_property VALUES (3359, 'Survey/Constants/submitAnswers', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Submit', 'O', 'messages', '2011-01-13 17:48:02.793', NULL, '2010-09-23 01:57:48.230256');
INSERT INTO base_property VALUES (3360, 'Survey/Constants/dispalyMoreFreetextAnswersLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'More', 'O', 'messages', '2011-01-13 17:48:02.839', NULL, '2010-09-23 01:57:48.289081');
INSERT INTO base_property VALUES (3361, 'Survey/Messages/relayWantToSaveQuestionIfAnswersWillGetLost', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save your changes? Saving will remove the answers of {0} participants that already took part in the survey.', 'O', 'messages', '2011-01-13 17:48:02.857', NULL, '2010-09-23 01:57:48.297333');
INSERT INTO base_property VALUES (3362, 'Survey/Constants/memberMayCreateSurvey', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members may create surveys', 'O', 'messages', '2011-01-13 17:48:02.761', NULL, '2010-09-23 01:57:48.197922');
INSERT INTO base_property VALUES (3363, 'Survey/Constants/privacyLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:48:02.784', NULL, '2010-09-23 01:57:48.218996');
INSERT INTO base_property VALUES (3364, 'Survey/Constants/optionalLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Optional', 'O', 'messages', '2011-01-13 17:48:02.8', NULL, '2010-09-23 01:57:48.234724');
INSERT INTO base_property VALUES (3365, 'Survey/Constants/participantCountLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participants', 'O', 'messages', '2011-01-13 17:48:02.828', NULL, '2010-09-23 01:57:48.268114');
INSERT INTO base_property VALUES (3366, 'Entity/Constants/parents/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Parents', 'O', 'messages', '2011-01-13 17:48:00.753', NULL, '2010-10-26 13:50:21.34756');
INSERT INTO base_property VALUES (3367, 'Entity/Constants/entity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entity', 'O', 'messages', '2011-01-13 17:48:00.668', NULL, '2010-10-26 13:50:21.776067');
INSERT INTO base_property VALUES (3368, 'Workstream/Constants/filterMicroblog', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Microblog', 'O', 'messages', '2011-01-13 17:47:54.696', NULL, '2010-09-29 17:20:46.123461');
INSERT INTO base_property VALUES (3369, 'Entity/Constants/makeAdmin/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'make Admin', 'O', 'messages', '2011-01-13 17:48:00.844', NULL, '2010-10-26 13:50:23.35021');
INSERT INTO base_property VALUES (3370, '/Basic/Constants/youAlsoLeaveEventsConfirmText', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You will also cancel participation in the following events. Continue?', 'O', 'messages', '2011-01-13 17:47:55.085', NULL, '2010-09-29 17:20:46.460843');
INSERT INTO base_property VALUES (3371, 'Entity/Constants/joinEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Join', 'O', 'messages', '2011-01-13 17:48:00.85', NULL, '2010-10-26 13:50:23.464825');
INSERT INTO base_property VALUES (3372, 'Entity/Messages/feedNewWikiVersion/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created version {1} in the wiki editor', 'O', 'messages', '2011-01-13 17:49:58.424', NULL, '2010-09-23 01:58:36.230008');
INSERT INTO base_property VALUES (3373, 'Entity/Constants/attendToEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to entity', 'O', 'messages', '2011-01-13 17:49:58.232', NULL, '2010-09-23 01:58:36.119658');
INSERT INTO base_property VALUES (3374, 'Survey/Constants/publishSurveyWarning', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'This will publish the survey. Note: If you change the questions after publishing them, all survey results will be deleted.', 'O', 'messages', '2011-01-13 17:48:02.739', NULL, '2010-09-23 01:57:48.16903');
INSERT INTO base_property VALUES (3375, 'Entity/Constants/phone/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Phone', 'O', 'messages', '2011-01-13 17:48:00.829', NULL, '2010-10-26 13:50:22.722756');
INSERT INTO base_property VALUES (3376, 'Entity/Messages/xOfYParticipant/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} of {1} participants', 'O', 'messages', '2011-01-13 17:49:58.555', NULL, '2010-09-23 01:58:36.321129');
INSERT INTO base_property VALUES (3377, 'Entity/Constants/exportEntityMemberToCSV/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list', 'O', 'messages', '2011-01-13 17:49:58.239', NULL, '2010-09-23 01:58:36.123331');
INSERT INTO base_property VALUES (3378, 'Entity/Messages/feedNewMembership/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} joined the group {1}', 'O', 'messages', '2011-01-13 17:49:58.379', NULL, '2010-09-23 01:58:36.156145');
INSERT INTO base_property VALUES (3379, 'Entity/Messages/mailSubjectCoAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Co-Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:49:58.435', NULL, '2010-09-23 01:58:36.235235');
INSERT INTO base_property VALUES (3380, 'Entity/Constants/deleteIcon/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete Icon', 'O', 'messages', '2011-01-13 17:48:00.853', NULL, '2010-10-26 13:50:23.569374');
INSERT INTO base_property VALUES (3381, 'Entity/Messages/mailSubjectEntityDeleted/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''' was deleted', 'O', 'messages', '2011-01-13 17:49:58.513', NULL, '2010-09-23 01:58:36.283492');
INSERT INTO base_property VALUES (3382, 'Profile/Constants/genderHint', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Your gender is needed to address you correctly.', 'O', 'messages', '2011-01-13 17:47:45.823', NULL, '2010-09-29 17:20:46.219383');
INSERT INTO base_property VALUES (3383, 'Profile/Constants/profileStatusLabel', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:47:45.833', NULL, '2010-09-29 17:20:46.223174');
INSERT INTO base_property VALUES (3384, 'Workstream/Messages/messageBody', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Original microblog posting:
{0}', 'O', 'messages', '2011-01-13 17:47:54.656', NULL, '2010-09-29 17:20:46.091412');
INSERT INTO base_property VALUES (3385, 'Workstream/Constants/filterShow', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Show filter', 'O', 'messages', '2011-01-13 17:47:54.702', NULL, '2010-09-29 17:20:46.128992');
INSERT INTO base_property VALUES (3386, '/Basic/Constants/yearOfBirth', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Year of birth', 'O', 'messages', '2011-01-13 17:47:55.091', NULL, '2010-09-29 17:20:46.466436');
INSERT INTO base_property VALUES (3387, 'Entity/Constants/writeMessageToAllMembers/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Message to all members', 'O', 'messages', '2011-01-13 17:47:56.079', NULL, '2010-08-10 18:57:31.755466');
INSERT INTO base_property VALUES (3388, 'Entity/Constants/googleMapAPIKeyHelpText/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<p>If you enter an external place URL, Google Maps will not work any more, since the current global key only works for subdomains.</p><p>If you want use Google Maps with an external URL, you need to obtain a Google Maps-API key for your domain and enter it here.</p><p>See: <a href="http://code.google.com/intl/en-US/apis/maps/signup.html" target="_blank">http://code.google.com/intl/en-US/apis/maps/signup.html</a></p>', 'O', 'messages', '2011-01-13 17:47:59.723', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3389, 'Workstream/Constants/refresh', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Refresh', 'O', 'messages', '2011-01-13 17:47:54.715', NULL, '2010-09-29 17:20:46.136808');
INSERT INTO base_property VALUES (3390, 'Entity/Constants/allEntityMembers/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'all entity members', 'O', 'messages', '2011-01-13 17:48:00.672', NULL, '2010-10-26 13:50:22.925487');
INSERT INTO base_property VALUES (3391, 'Entity/Constants/statusOptionWantToAttend/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'I participate', 'O', 'messages', '2011-01-13 17:47:56.064', NULL, '2010-08-06 17:21:33.166934');
INSERT INTO base_property VALUES (3392, 'Entity/Constants/members/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Mitglieder', 'O', 'messages', '2011-01-13 17:48:00.75', NULL, '2010-10-26 13:50:21.133853');
INSERT INTO base_property VALUES (3393, 'Entity/Constants/duration/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Time', 'O', 'messages', '2011-01-13 17:48:00.765', NULL, '2010-10-26 13:50:21.574154');
INSERT INTO base_property VALUES (3394, 'Entity/Constants/myEntities/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'My Topics', 'O', 'messages', '2011-01-13 17:48:00.686', NULL, '2010-10-26 13:50:21.110116');
INSERT INTO base_property VALUES (3395, '/Basic/Constants/pagerEarlier', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Earlier', 'O', 'messages', '2011-01-13 17:47:55.097', NULL, '2010-09-29 17:20:46.47024');
INSERT INTO base_property VALUES (3396, 'Entity/Constants/infoWidgetComponent/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Information', 'O', 'messages', '2011-01-13 17:48:00.8', NULL, '2010-10-26 13:50:21.990811');
INSERT INTO base_property VALUES (3397, 'Entity/Constants/deleteCoAdmin/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:48:00.838', NULL, '2010-10-26 13:50:23.137881');
INSERT INTO base_property VALUES (3398, 'Entity/Constants/deleteEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete', 'O', 'messages', '2011-01-13 17:48:00.812', NULL, '2010-10-26 13:50:22.094561');
INSERT INTO base_property VALUES (3399, 'Entity/Constants/privacySettings/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:48:00.823', NULL, '2010-10-26 13:50:22.512649');
INSERT INTO base_property VALUES (3400, 'Entity/Constants/invitingRule/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:48:00.861', NULL, '2010-10-26 13:50:23.673478');
INSERT INTO base_property VALUES (3401, 'Entity/Constants/inviteMessage/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite Message', 'O', 'messages', '2011-01-13 17:48:00.817', NULL, '2010-10-26 13:50:22.307098');
INSERT INTO base_property VALUES (3402, 'Entity/Constants/participateToAssignedEntity/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Become member of assigned groups', 'O', 'messages', '2011-01-13 17:49:58.234', NULL, '2010-09-23 01:58:36.121514');
INSERT INTO base_property VALUES (3403, 'Entity/Constants/exportEntityMemberAndChildEntitiesToCSV/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Export member list (also including assigned elements where you are Admin of)', 'O', 'messages', '2011-01-13 17:49:58.241', NULL, '2010-09-23 01:58:36.12552');
INSERT INTO base_property VALUES (3404, 'Entity/Messages/feedEntityCreated/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the group {1}', 'O', 'messages', '2011-01-13 17:49:58.388', NULL, '2010-09-23 01:58:36.162951');
INSERT INTO base_property VALUES (3405, 'Entity/Messages/feedEntityCreated/Appointment', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '{0} created the appointment {1}', 'O', 'messages', '2011-01-13 17:47:57.833', NULL, '2010-09-23 01:57:45.936334');
INSERT INTO base_property VALUES (3406, 'Entity/Messages/feedOrigin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'in group {0}', 'O', 'messages', '2011-01-13 17:49:58.393', NULL, '2010-09-23 01:58:36.152849');
INSERT INTO base_property VALUES (3407, 'Entity/Messages/feedOrigin/Publication', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'in project {0}', 'O', 'messages', '2011-01-13 17:48:00.466', NULL, '2010-09-23 01:57:47.641584');
INSERT INTO base_property VALUES (3408, 'Entity/Messages/noChildEntitiesCreateOne/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'No groups. <a href="{0}">Create a group.</a>', 'O', 'messages', '2011-01-13 17:49:58.42', NULL, '2010-09-23 01:58:36.228155');
INSERT INTO base_property VALUES (3409, 'Entity/Messages/mailSubjectAdmin/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are Admin of ''''{0}'''' ', 'O', 'messages', '2011-01-13 17:49:58.43', NULL, '2010-09-23 01:58:36.232702');
INSERT INTO base_property VALUES (3410, 'Entity/Messages/mailSubjectEntityDataChanged/Group', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '''''{0}'''': Some important data changed ', 'O', 'messages', '2011-01-13 17:49:58.516', NULL, '2010-09-23 01:58:36.286404');
INSERT INTO base_property VALUES (3411, 'Entity/Constants/entities/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Entities', 'O', 'messages', '2011-01-13 17:48:00.663', NULL, '2010-10-26 13:50:21.234684');
INSERT INTO base_property VALUES (3412, 'Entity/Constants/childEntities/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Child Topics', 'O', 'messages', '2011-01-13 17:48:00.681', NULL, '2010-10-26 13:50:21.011676');
INSERT INTO base_property VALUES (3413, 'Entity/Constants/createEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Create', 'O', 'messages', '2011-01-13 17:48:00.76', NULL, '2010-10-26 13:50:21.448712');
INSERT INTO base_property VALUES (3414, 'Entity/Constants/timezone/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Timezone', 'O', 'messages', '2011-01-13 17:48:00.768', NULL, '2010-10-26 13:50:21.676076');
INSERT INTO base_property VALUES (3415, 'Entity/Constants/tags/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Tags', 'O', 'messages', '2011-01-13 17:48:00.797', NULL, '2010-10-26 13:50:21.888773');
INSERT INTO base_property VALUES (3416, 'Entity/Constants/closingDate/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Registration deadline', 'O', 'messages', '2011-01-13 17:48:00.803', NULL, '2010-10-26 13:50:22.091689');
INSERT INTO base_property VALUES (3417, 'Entity/Constants/subdomain/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subdomain', 'O', 'messages', '2011-01-13 17:48:00.815', NULL, '2010-10-26 13:50:22.18483');
INSERT INTO base_property VALUES (3418, 'Entity/Constants/email/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Email', 'O', 'messages', '2011-01-13 17:48:00.82', NULL, '2010-10-26 13:50:22.43721');
INSERT INTO base_property VALUES (3419, 'Entity/Constants/invited/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invited', 'O', 'messages', '2011-01-13 17:48:00.826', NULL, '2010-10-26 13:50:22.613746');
INSERT INTO base_property VALUES (3420, 'Entity/Constants/invitePerson/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite platform member', 'O', 'messages', '2011-01-13 17:48:00.832', NULL, '2010-10-26 13:50:22.824475');
INSERT INTO base_property VALUES (3421, 'Entity/Constants/admin/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Admin', 'O', 'messages', '2011-01-13 17:48:00.835', NULL, '2010-10-26 13:50:23.036027');
INSERT INTO base_property VALUES (3422, 'Entity/Constants/city/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'City/Town', 'O', 'messages', '2011-01-13 17:48:00.882', NULL, '2010-10-26 13:50:24.418966');
INSERT INTO base_property VALUES (3423, 'Entity/Constants/visibleForMember/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only for members', 'O', 'messages', '2011-01-13 17:48:01.029', NULL, '2010-10-26 13:50:28.614684');
INSERT INTO base_property VALUES (3424, 'Entity/Constants/joiningOnlyForMembersOfPlatform/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only users with an existing platform account', 'O', 'messages', '2011-01-13 17:48:01.035', NULL, '2010-10-26 13:50:28.817026');
INSERT INTO base_property VALUES (3425, 'Entity/Constants/visibleForAll/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'For the whole internet', 'O', 'messages', '2011-01-13 17:48:01.023', NULL, '2010-10-26 13:50:28.406141');
INSERT INTO base_property VALUES (3426, 'Entity/Constants/leaveEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Leave', 'O', 'messages', '2011-01-13 17:48:00.852', NULL, '2010-10-26 13:50:23.467645');
INSERT INTO base_property VALUES (3427, 'Entity/Constants/invitingByAdminOnly/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only the Administrator/Co-Administrator', 'O', 'messages', '2011-01-13 17:48:01.049', NULL, '2010-10-26 13:50:29.242156');
INSERT INTO base_property VALUES (3428, 'Entity/Constants/makeCoAdmin/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'make Co-Admin', 'O', 'messages', '2011-01-13 17:48:00.847', NULL, '2010-10-26 13:50:23.451059');
INSERT INTO base_property VALUES (3429, 'Entity/Constants/removeJoinEntityRequest/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Remove join request', 'O', 'messages', '2011-01-13 17:48:01.068', NULL, '2010-10-26 13:50:29.765105');
INSERT INTO base_property VALUES (3430, 'Entity/Constants/deleteLogo/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Delete Logo', 'O', 'messages', '2011-01-13 17:48:00.855', NULL, '2010-10-26 13:50:23.670413');
INSERT INTO base_property VALUES (3431, 'Entity/Constants/acceptInvite/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept', 'O', 'messages', '2011-01-13 17:48:00.863', NULL, '2010-10-26 13:50:23.78629');
INSERT INTO base_property VALUES (3432, 'Entity/Constants/declineInvite/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Decline', 'O', 'messages', '2011-01-13 17:48:00.866', NULL, '2010-10-26 13:50:23.890825');
INSERT INTO base_property VALUES (3433, 'Entity/Constants/contactName/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Name', 'O', 'messages', '2011-01-13 17:48:00.912', NULL, '2010-10-26 13:50:25.390291');
INSERT INTO base_property VALUES (3434, 'Entity/Constants/assignmentOnlyForAdmin/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Assigment only for admins', 'O', 'messages', '2011-01-13 17:48:00.873', NULL, '2010-10-26 13:50:24.300532');
INSERT INTO base_property VALUES (3435, 'Entity/Constants/headingBox/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Heading boxes', 'O', 'messages', '2011-01-13 17:48:00.878', NULL, '2010-10-26 13:50:24.944378');
INSERT INTO base_property VALUES (3436, 'Entity/Constants/waitlist/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Waiting list', 'O', 'messages', '2011-01-13 17:48:01.078', NULL, '2010-10-26 13:50:30.189957');
INSERT INTO base_property VALUES (3437, 'Entity/Constants/saveEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Save', 'O', 'messages', '2011-01-13 17:48:00.947', NULL, '2010-10-26 13:50:26.6967');
INSERT INTO base_property VALUES (3438, 'Entity/Constants/website/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Website', 'O', 'messages', '2011-01-13 17:48:00.893', NULL, '2010-10-26 13:50:24.741478');
INSERT INTO base_property VALUES (3439, 'Entity/Constants/memberStatus/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Status', 'O', 'messages', '2011-01-13 17:48:00.902', NULL, '2010-10-26 13:50:25.058774');
INSERT INTO base_property VALUES (3440, 'Entity/Constants/zipcode/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Zipcode', 'O', 'messages', '2011-01-13 17:48:00.888', NULL, '2010-10-26 13:50:24.523361');
INSERT INTO base_property VALUES (3441, 'Entity/Constants/participantSelectedFromWaitlist/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Select participants manually from waiting list', 'O', 'messages', '2011-01-13 17:48:00.94', NULL, '2010-10-26 13:50:26.471831');
INSERT INTO base_property VALUES (3442, 'Entity/Constants/subdomainInUse/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'The subdomain is already in use', 'O', 'messages', '2011-01-13 17:48:00.985', NULL, '2010-10-26 13:50:27.46065');
INSERT INTO base_property VALUES (3443, 'Entity/Constants/office/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Office', 'O', 'messages', '2011-01-13 17:48:00.907', NULL, '2010-10-26 13:50:25.261646');
INSERT INTO base_property VALUES (3444, 'Entity/Constants/membersNavigationDefaultLink/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Members', 'O', 'messages', '2011-01-13 17:48:00.999', NULL, '2010-10-26 13:50:27.878868');
INSERT INTO base_property VALUES (3445, 'Entity/Constants/editEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Edit', 'O', 'messages', '2011-01-13 17:48:00.931', NULL, '2010-10-26 13:50:25.723476');
INSERT INTO base_property VALUES (3446, 'Entity/Constants/participantUnlimited/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Unlimited number of participants', 'O', 'messages', '2011-01-13 17:48:00.934', NULL, '2010-10-26 13:50:26.366779');
INSERT INTO base_property VALUES (3447, 'Entity/Constants/coAdmins/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Co-Admins', 'O', 'messages', '2011-01-13 17:48:00.87', NULL, '2010-10-26 13:50:24.098396');
INSERT INTO base_property VALUES (3448, 'Entity/Constants/tagsSeparatorHint/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Separated by comma', 'O', 'messages', '2011-01-13 17:48:00.955', NULL, '2010-10-26 13:50:26.805689');
INSERT INTO base_property VALUES (3449, 'Entity/Constants/showAddressData/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'show', 'O', 'messages', '2011-01-13 17:48:00.961', NULL, '2010-10-26 13:50:27.027767');
INSERT INTO base_property VALUES (3450, 'Entity/Constants/subdomainHelpLink/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'How does this work?', 'O', 'messages', '2011-01-13 17:48:00.992', NULL, '2010-10-26 13:50:27.677988');
INSERT INTO base_property VALUES (3451, 'Entity/Constants/googleMapAPIKeyHelpLink/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Help', 'O', 'messages', '2011-01-13 17:48:00.969', NULL, '2010-10-26 13:50:27.234734');
INSERT INTO base_property VALUES (3452, 'Entity/Constants/parentGroups/Topic', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent Groups', 'O', 'messages', '2010-12-14 13:23:33.458', NULL, '2010-10-26 13:50:25.927812');
INSERT INTO base_property VALUES (3453, 'Entity/Constants/parentWikis/Topic', 'com.freiheit.superoperty.converter.TextareaRegexCheckConverter', '.*', '', 'Parent Wiki-Pages', 'O', 'messages', '2010-12-14 13:23:33.578', NULL, '2010-10-26 13:50:26.138709');
INSERT INTO base_property VALUES (3454, 'Entity/Constants/privacyRules/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privatsphäre', 'O', 'messages', '2011-01-13 17:48:01.007', NULL, '2010-10-26 13:50:28.088596');
INSERT INTO base_property VALUES (3455, 'Entity/Constants/visibilityRule/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Visibility of content', 'O', 'messages', '2011-01-13 17:48:01.013', NULL, '2010-10-26 13:50:28.301751');
INSERT INTO base_property VALUES (3456, 'Entity/Constants/saveEntitySuccessfully/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Saved', 'O', 'messages', '2011-01-13 17:48:01.06', NULL, '2010-10-26 13:50:29.543669');
INSERT INTO base_property VALUES (3457, 'Entity/Constants/joiningByRequestOrInviteOnly/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Only by request or invitation', 'O', 'messages', '2011-01-13 17:48:01.042', NULL, '2010-10-26 13:50:29.029095');
INSERT INTO base_property VALUES (3458, 'Entity/Constants/inviteToEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Invite', 'O', 'messages', '2011-01-13 17:48:01.075', NULL, '2010-10-26 13:50:29.977846');
INSERT INTO base_property VALUES (3459, 'Footerpages/Constants/datenschutzTextPart2', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', '<h2>1.2 Freiwillige Angaben zu Ihrer Person</h2><p>Darüber hinaus haben Sie die Möglichkeit, freiwillig weitere Angaben zu Ihrer Person auf Ihrem Profil zu machen. Dazu gehören insbesondere folgende Angaben: Ihre Basisdaten (Heimatstadt, Heimatland, Beziehungsstatus, Angaben zu der Kategorien "Interessiert an Männern / Frauen" sowie "Auf der Suche nach"), Kontaktdaten (E-Mail, AIM, ICQ, Skype, Jabber, Handy, Festnetz, Straße & Hausnummer, PLZ, Homepage), persönliche Daten (politische Ausrichtung, religiöse Ausrichtung, Angaben zu Trink- und Rauchgewohnheiten, Interessen, Aktivitäten, Lieblingsmusik, Lieblingsfilme und –serien, Lieblingsbücher, Lieblingszitate, und sonstige Angaben unter der Rubrik "Über mich"), Daten zu Ihrer Ausbildung (Schule inkl. Abschlussjahr, Universität / FH inkl. Studiengang, Abschluss, und Abschlussjahr), sowie Daten zu Ihrem Beruf (Beruf / Job, Arbeitgeber, Position, Stadt, Zeitraum).</p> <p>Weiterhin haben Sie die Möglichkeit, Bilder und Video-Links auf Ihrem Profil, in Diskussionsgruppen und Netzwerken einzustellen, Nachrichten in Gästebüchern anderer Nutzer zu hinterlassen, sich an Diskussionen in Gruppen oder Netzwerken zu beteiligen oder Informationen darüber bereitzustellen, wer Ihre Kontakte sind. Ihre Bilder und Video-Links auf Ihrem Profil können abhängig von Ihren Einstellungen zur Privatsphäre von anderen Nutzern kommentiert werden. Die Bilder und Video-Links, die Sie in ein Netzwerk oder eine Gruppen einstellen, können von jedem anderen Mitglied des Netzwerks/der Gruppe kommentiert werden.</p><h2>1.3 Art, Umfang und Zweck der Verarbeitung und Nutzung Ihrer Daten</h2><p>Wie bereits erwähnt haben Sie über die Privatsphäreneinstellung die Möglichkeit auszuwählen, welchem Personenkreis die unter 1.1 und 1.2 genannten Informationen zugänglich gemacht werden sollen. Grundsätzlich sind für Ihre Kontakte alle Profilinformationen (inkl. Videos, Fotos und Gruppen) inkl. Ihrer Kontaktdaten sichtbar. Wenn Sie auswählen, dass nur Ihre Kontakte Ihr Profil sehen dürfen, können fremde Nutzer lediglich Ihren Vornamen und Nachnamen, Ihr Regionalnetzwerk (Bundesstaat / Provinz / Region), Ihren Status (Schüler, Student, Angestellter etc.), und Ihre Stadt sehen. </p> <p>Darüber hinaus können Sie in den Einstellungen zur Privatsphäre festlegen <ul><li>ob andere Nutzer darüber informiert werden sollen, wenn Sie sich Ihre Profilseite angesehen haben,</li><li>ob andere Nutzer sehen dürfen wer Ihre Kontakte sind und, </li> <li>ob Ihre Kontakte automatisch Neuigkeiten über Sie erhalten dürfen. Zu diesen Neuigkeiten zählt, wenn Sie Bilder oder Video-Links auf Ihrem Profil, in Gruppen oder in Diskussionsforen einstellen, wenn Sie die Angaben zu Ihrer Person aktualisieren, wenn Sie Gruppen oder Netzwerken beitreten oder wenn Sie sich an Diskussionen in Gruppen oder Netzwerken beteiligen, die von einem Ihrer Kontakte geleitet werden. Ihre Kontakte (und natürlich auch andere Nutzer) werden niemals darüber informiert, wenn Sie ein Match haben, eine private Nachricht empfangen / senden oder ein Lächeln von einem anderen Nutzer erhalten.</li></ul></p>', 'O', 'messages', '2011-01-13 17:47:53.568', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3460, 'Workstream/Constants/submitMicroblogMessage', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Share', 'O', 'messages', '2011-01-13 17:47:54.713', NULL, '2010-10-14 16:29:15.365846');
INSERT INTO base_property VALUES (3461, 'Entity/Constants/subdomain/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Subdomain', 'O', 'messages', '2011-01-13 17:47:55.433', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3462, 'Entity/Constants/privacySettings/Network', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Privacy', 'O', 'messages', '2011-01-13 17:47:55.442', NULL, '2010-08-06 14:31:29.939059');
INSERT INTO base_property VALUES (3478, 'Entity/Constants/acceptInvitationOption/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Accept Invitation', 'O', 'messages', '2011-01-13 17:48:02.02', NULL, '2010-10-26 13:50:43.893674');
INSERT INTO base_property VALUES (3479, 'Entity/Constants/address/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Address', 'O', 'messages', '2011-01-13 17:48:02.083', NULL, '2010-10-26 13:50:44.097686');
INSERT INTO base_property VALUES (3480, 'Entity/Constants/notAllowedToAddEntityHere/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'You are not allowed, to add an entity here.', 'O', 'messages', '2011-01-13 17:48:01.96', NULL, '2010-10-26 13:50:43.003283');
INSERT INTO base_property VALUES (3481, 'Entity/Constants/attendTo/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to:', 'O', 'messages', '2011-01-13 17:48:01.971', NULL, '2010-10-26 13:50:43.107856');
INSERT INTO base_property VALUES (3482, 'Entity/Constants/attendToEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Attend to entity', 'O', 'messages', '2011-01-13 17:48:01.975', NULL, '2010-10-26 13:50:43.325095');
INSERT INTO base_property VALUES (3483, 'Entity/Constants/participateToAssignedEntity/Topic', 'com.freiheit.superoperty.container.UnlimitedStringConverter', NULL, '', 'Participate to assigned entity', 'O', 'messages', '2011-01-13 17:48:01.985', NULL, '2010-10-26