/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.commandline;

import org.dbmaintain.util.DbMaintainException;

public class CommandLineArguments {
    private String dbMaintainOperation;
    private String firstExtraArgument;
    private String secondExtraArgument;
    private String configFile;

    public CommandLineArguments(String[] commandLineArgs) {
        this.parseArguments(commandLineArgs);
    }

    protected void parseArguments(String[] commandLineArgs) {
        boolean nextArgumentIsConfigFile = false;
        for (String commandLineArg : commandLineArgs) {
            if (nextArgumentIsConfigFile) {
                this.configFile = commandLineArg;
                continue;
            }
            if ("-config".equals(commandLineArg)) {
                nextArgumentIsConfigFile = true;
                continue;
            }
            if (commandLineArg.startsWith("-")) {
                throw new DbMaintainException("Invalid command line option " + commandLineArg);
            }
            if (this.dbMaintainOperation == null) {
                this.dbMaintainOperation = commandLineArg;
                continue;
            }
            if (this.firstExtraArgument == null) {
                this.firstExtraArgument = commandLineArg;
                continue;
            }
            if (this.secondExtraArgument != null) continue;
            this.secondExtraArgument = commandLineArg;
        }
        if (this.dbMaintainOperation == null) {
            throw new DbMaintainException("No operation was specified");
        }
    }

    public String getDbMaintainOperation() {
        return this.dbMaintainOperation;
    }

    public String getFirstExtraArgument() {
        return this.firstExtraArgument;
    }

    public String getSecondExtraArgument() {
        return this.secondExtraArgument;
    }

    public String getConfigFile() {
        return this.configFile;
    }
}

