/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.ant;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dbmaintain.launch.task.DbMaintainTask;
import thirdparty.org.apache.commons.lang.StringUtils;

public abstract class BaseAntTask
extends Task {
    private String configFile;

    public void execute() throws BuildException {
        File customConfigFile = this.getCustomConfigFile();
        Properties environmentProperties = this.getAntProperties();
        DbMaintainTask dbMaintainTask = this.createDbMaintainTask();
        dbMaintainTask.setConfigFile(customConfigFile);
        dbMaintainTask.setEnvironmentProperties(environmentProperties);
        try {
            dbMaintainTask.execute();
        }
        catch (Exception e) {
            String messages = this.getAllMessages(e);
            throw new BuildException("Unable to perform db maintain task.\n" + messages, (Throwable)e);
        }
    }

    protected abstract DbMaintainTask createDbMaintainTask();

    protected File getCustomConfigFile() {
        if (StringUtils.isBlank(this.configFile)) {
            return null;
        }
        return new File(this.configFile);
    }

    protected Properties getAntProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getProject().getProperties());
        return properties;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    private String getAllMessages(Throwable t) {
        StringBuilder stringBuilder = new StringBuilder();
        while (t != null) {
            String message = t.getMessage();
            if (message != null) {
                stringBuilder.append(message);
                stringBuilder.append("\n");
            }
            t = t.getCause();
        }
        return stringBuilder.toString();
    }
}

