/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.IdentifierProcessor;
import thirdparty.org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabase
extends Database {
    private Integer oracleMajorVersionNumber;

    public OracleDatabase(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        super(databaseConnection, identifierProcessor);
    }

    @Override
    public String getSupportedDatabaseDialect() {
        return "oracle";
    }

    @Override
    public Set<String> getTableNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from ALL_TABLES where OWNER = '" + schemaName + "' and TABLE_NAME not like 'BIN$%' minus select MVIEW_NAME from ALL_MVIEWS where OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from ALL_TAB_COLUMNS where TABLE_NAME = '" + tableName + "' and OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select VIEW_NAME from ALL_VIEWS where OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getMaterializedViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select MVIEW_NAME from ALL_MVIEWS where OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getSynonymNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select SYNONYM_NAME from ALL_SYNONYMS where OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getSequenceNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select SEQUENCE_NAME from ALL_SEQUENCES where SEQUENCE_OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getTriggerNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select TRIGGER_NAME from ALL_TRIGGERS where OWNER = '" + schemaName + "' and TRIGGER_NAME not like 'BIN$%'", this.getDataSource());
    }

    @Override
    public Set<String> getTypeNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select TYPE_NAME from ALL_TYPES where OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void dropTable(String schemaName, String tableName) {
        this.getSQLHandler().execute("drop table " + this.qualified(schemaName, tableName) + " cascade constraints" + (this.supportsPurge() ? " purge" : ""), this.getDataSource());
    }

    @Override
    public void dropView(String schemaName, String viewName) {
        this.getSQLHandler().execute("drop view " + this.qualified(schemaName, viewName) + " cascade constraints", this.getDataSource());
    }

    @Override
    public void dropMaterializedView(String schemaName, String materializedViewName) {
        this.getSQLHandler().execute("drop materialized view " + this.qualified(schemaName, materializedViewName), this.getDataSource());
    }

    @Override
    public void dropType(String schemaName, String typeName) {
        this.getSQLHandler().execute("drop type " + this.qualified(schemaName, typeName) + " force", this.getDataSource());
    }

    @Override
    public void disableReferentialConstraints(String schemaName) {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from ALL_CONSTRAINTS where CONSTRAINT_TYPE = 'R' and OWNER = '" + schemaName + "' and CONSTRAINT_NAME not like 'BIN$%' and STATUS <> 'DISABLED'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(schemaName, tableName) + " disable constraint " + this.quoted(constraintName));
            }
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to disable referential constraints for schema name: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public void disableValueConstraints(String schemaName) {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from ALL_CONSTRAINTS where CONSTRAINT_TYPE in ('U', 'C', 'V') and OWNER = '" + schemaName + "' and CONSTRAINT_NAME not like 'BIN$%' and STATUS <> 'DISABLED'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(schemaName, tableName) + " disable constraint " + this.quoted(constraintName));
            }
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to disable value constraints for schema name: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public long getSequenceValue(String schemaName, String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select LAST_NUMBER from ALL_SEQUENCES where SEQUENCE_NAME = '" + sequenceName + "' and SEQUENCE_OWNER = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void incrementSequenceToValue(String schemaName, String sequenceName, long newSequenceValue) {
        Connection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            connection = this.getDataSource().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select LAST_NUMBER, INCREMENT_BY from ALL_SEQUENCES where SEQUENCE_NAME = '" + sequenceName + "' and SEQUENCE_OWNER = '" + schemaName + "'");
            while (resultSet.next()) {
                long lastNumber = resultSet.getLong("LAST_NUMBER");
                long incrementBy = resultSet.getLong("INCREMENT_BY");
                this.getSQLHandler().execute("alter sequence " + this.qualified(schemaName, sequenceName) + " increment by " + (newSequenceValue - lastNumber), this.getDataSource());
                this.getSQLHandler().execute("select " + this.qualified(schemaName, sequenceName) + ".NEXTVAL from DUAL", this.getDataSource());
                this.getSQLHandler().execute("alter sequence " + this.qualified(schemaName, sequenceName) + " increment by " + incrementBy, this.getDataSource());
            }
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to increment sequence to value " + newSequenceValue + " for schema name: " + schemaName + ", sequence name: " + sequenceName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
    }

    @Override
    public void setDatabaseDefaultSchema() {
        this.getSQLHandler().execute("alter session set current_schema=" + this.getDefaultSchemaName(), this.getDataSource());
    }

    @Override
    public String getLongDataType() {
        return "INTEGER";
    }

    @Override
    public String getTextDataType(int length) {
        return "VARCHAR2(" + length + ")";
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }

    @Override
    public boolean supportsMaterializedViews() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }

    @Override
    public boolean supportsSetDatabaseDefaultSchema() {
        return true;
    }

    protected boolean supportsPurge() {
        return this.getOracleMajorVersionNumber() >= 10;
    }

    protected Integer getOracleMajorVersionNumber() {
        if (this.oracleMajorVersionNumber == null) {
            Connection connection = null;
            try {
                connection = this.getDataSource().getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                this.oracleMajorVersionNumber = metaData.getDatabaseMajorVersion();
            }
            catch (SQLException e) {
                throw new DatabaseException("Unable to determine database major version", e);
            }
            finally {
                DbUtils.closeQuietly(connection);
            }
        }
        return this.oracleMajorVersionNumber;
    }
}

