/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain;

import org.dbmaintain.DbMaintainer;
import org.dbmaintain.DefaultDbMaintainer;
import org.dbmaintain.MainFactory;
import org.dbmaintain.config.FactoryWithDatabase;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.script.analyzer.ScriptUpdatesFormatter;
import org.dbmaintain.script.executedscriptinfo.ExecutedScriptInfoSource;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.repository.ScriptRepository;
import org.dbmaintain.script.runner.ScriptRunner;
import org.dbmaintain.structure.clean.DBCleaner;
import org.dbmaintain.structure.clear.DBClearer;
import org.dbmaintain.structure.constraint.ConstraintsDisabler;
import org.dbmaintain.structure.sequence.SequenceUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMaintainerFactory
extends FactoryWithDatabase<DbMaintainer> {
    @Override
    public DbMaintainer createInstance() {
        ScriptRepository scriptRepository = this.factoryWithDatabaseContext.createScriptRepository();
        boolean cleanDbEnabled = PropertyUtils.getBoolean("dbMaintainer.cleanDb", this.getConfiguration());
        boolean fromScratchEnabled = PropertyUtils.getBoolean("dbMaintainer.fromScratch.enabled", this.getConfiguration());
        boolean useScriptFileLastModificationDates = PropertyUtils.getBoolean("dbMaintainer.useScriptFileLastModificationDates", this.getConfiguration());
        boolean allowOutOfSequenceExecutionOfPatchScripts = PropertyUtils.getBoolean("dbMaintainer.allowOutOfSequenceExecutionOfPatches", this.getConfiguration());
        boolean disableConstraintsEnabled = PropertyUtils.getBoolean("dbMaintainer.disableConstraints", this.getConfiguration());
        boolean updateSequencesEnabled = PropertyUtils.getBoolean("dbMaintainer.updateSequences", this.getConfiguration());
        long maxNrOfCharsWhenLoggingScriptContent = PropertyUtils.getLong("dbMaintainer.maxNrOfCharsWhenLoggingScriptContent", this.getConfiguration());
        ScriptIndexes baseLineRevision = this.factoryWithDatabaseContext.getBaselineRevision();
        MainFactory mainFactory = this.factoryWithDatabaseContext.getMainFactory();
        DBCleaner dbCleaner = mainFactory.createDBCleaner();
        DBClearer dbClearer = mainFactory.createDBClearer();
        ConstraintsDisabler constraintsDisabler = mainFactory.createConstraintsDisabler();
        SequenceUpdater sequenceUpdater = mainFactory.createSequenceUpdater();
        ScriptRunner scriptRunner = mainFactory.createScriptRunner();
        ScriptUpdatesFormatter scriptUpdatesFormatter = this.createScriptUpdatesFormatter();
        ExecutedScriptInfoSource executedScriptInfoSource = mainFactory.createExecutedScriptInfoSource();
        return new DefaultDbMaintainer(scriptRunner, scriptRepository, executedScriptInfoSource, fromScratchEnabled, useScriptFileLastModificationDates, allowOutOfSequenceExecutionOfPatchScripts, cleanDbEnabled, disableConstraintsEnabled, updateSequencesEnabled, dbClearer, dbCleaner, constraintsDisabler, sequenceUpdater, scriptUpdatesFormatter, this.getSqlHandler(), maxNrOfCharsWhenLoggingScriptContent, baseLineRevision);
    }

    protected ScriptUpdatesFormatter createScriptUpdatesFormatter() {
        return new ScriptUpdatesFormatter();
    }
}

